/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.locking;

import com.iscobol.io.LockManager;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.KeyValue;

public class BaseLockManager
implements LockManager {
    public static final String TID_PROP = ".lock.tid";
    private DynamicFile theFile;
    private int oMode;
    private int lMode;
    private int tid;
    private LockManagerHandler.FileUnique fileId;
    private KeyDescription pKey;
    private boolean lockMulti;
    private boolean exclLock;

    @Override
    public final void init(DynamicFile tf) {
        this.theFile = tf;
        Thread ct = Thread.currentThread();
        this.tid = ct instanceof IsThread ? ((IsThread)ct).getSessionId() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] keys, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        int Return2;
        this.oMode = openType;
        this.lMode = lockType;
        if (keys != null && keys.length > 0) {
            this.pKey = keys[0];
        }
        switch (lockType & 0xF) {
            default: {
                if ((lockType & 0x100) == 0) break;
                this.lockMulti = true;
                break;
            }
            case 1: 
            case 6: {
                this.exclLock = true;
            }
        }
        LockManagerHandler.FileUnique fileUnique = this.fileId = LockManagerHandler.getFileUnique(path, assignExt);
        synchronized (fileUnique) {
            Return2 = this.theFile.open(path, openType, lockType, keys, maxRec, minRec, nKeys, accessMode, optional, assignExt);
            if (Return2 != 0) {
                if (this.exclLock) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, NULL_KV, 1);
                } else if (this.pKey == null) {
                    this.pKey = this.theFile.getKey(0);
                }
            }
        }
        return Return2;
    }

    @Override
    public final boolean isOpen() {
        return this.theFile.isOpen();
    }

    @Override
    public final String getDescription() {
        return this.theFile.getDescription();
    }

    @Override
    public final int getCobErrno() {
        return this.theFile.getCobErrno();
    }

    @Override
    public final String getSysErrno() {
        return this.theFile.getSysErrno();
    }

    @Override
    public final String getErrMsg() {
        return this.theFile.getErrMsg();
    }

    @Override
    public int close() {
        if (!this.fileId.unlockExcl(this.theFile)) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.close();
    }

    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        return this.theFile.build(path, comment, blockingFactor, preAllocate, extensionFactor, compressionFactor, ecryptionFlag, maxRecordSize, minRecordSize, keys, collating, assignExt);
    }

    @Override
    public final int getNumKeys() {
        return this.theFile.getNumKeys();
    }

    @Override
    public final int getMaxRecordSize() {
        return this.theFile.getMaxRecordSize();
    }

    @Override
    public final int getMinRecordSize() {
        return this.theFile.getMinRecordSize();
    }

    @Override
    public final KeyDescription getKey(int keyNum) {
        return this.theFile.getKey(keyNum);
    }

    @Override
    public final byte[] getSequence() {
        return this.theFile.getSequence();
    }

    @Override
    public final long getNumRecords() {
        return this.theFile.getNumRecords();
    }

    @Override
    public final void setCurrentRecord(long nRec) {
        this.theFile.setCurrentRecord(nRec);
    }

    @Override
    public final long getCurrentRecord() {
        return this.theFile.getCurrentRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            Return2 = this.theFile.read(record, offs, keyNum, lock);
            if (!this.exclLock && lock > 0) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (Return2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                }
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            Return2 = this.theFile.read(record, offs, key, lock);
            if (!this.exclLock && lock > 0) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (Return2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                }
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int offs, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            Return2 = this.theFile.next(record, offs, lock);
            if (!this.exclLock && lock > 0) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (Return2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                }
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int offs, int lock) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            if (!this.exclLock && !this.lockMulti) {
                this.fileId.release(this.theFile);
            }
            Return2 = this.theFile.previous(record, offs, lock);
            if (!this.exclLock && lock > 0) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (Return2 != 0L) {
                    this.fileId.lock(this.tid, this.theFile, this.oMode, this.lMode, kv, lock);
                }
            }
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, int keyNum, int keySize, int mode) {
        return this.theFile.start(record, offs, keyNum, keySize, mode);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription key, int keySize, int mode) {
        return this.theFile.start(record, offs, key, keySize, mode);
    }

    @Override
    public long write(byte[] record, int offs, int size, boolean lock) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.write(record, offs, size, lock);
    }

    @Override
    public long rewrite(byte[] record, int offs, int size, boolean lock) {
        if (!this.exclLock && !this.lockMulti) {
            this.fileId.release(this.theFile);
        }
        return this.theFile.rewrite(record, offs, size, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(byte[] record, int offs) {
        long Return2;
        LockManagerHandler.FileUnique fileUnique = this.fileId;
        synchronized (fileUnique) {
            Return2 = this.theFile.delete(record, offs);
            if (!this.exclLock) {
                KeyValue kv = new KeyValue(this.pKey, record, offs);
                if (Return2 != 0L) {
                    if (this.lockMulti) {
                        this.fileId.release(this.theFile, kv);
                    } else {
                        this.fileId.release(this.theFile);
                    }
                }
            }
        }
        return Return2;
    }

    @Override
    public int unlock() {
        this.fileId.release(this.theFile);
        return this.theFile.unlock();
    }

    @Override
    public final int remove(String name) {
        return this.theFile.remove(name);
    }

    @Override
    public final int rename(String src, String dst) {
        return this.theFile.rename(src, dst);
    }

    @Override
    public final void sync(int mode) {
        this.theFile.sync(mode);
    }

    @Override
    public final int begin() {
        return this.theFile.begin();
    }

    @Override
    public final int commit(int ctx) {
        return this.theFile.commit(ctx);
    }

    @Override
    public final int rollback() {
        return this.theFile.rollback();
    }

    @Override
    public final int recover() {
        return this.theFile.recover();
    }

    @Override
    public final String getVersion() {
        return this.theFile.getVersion();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return this.theFile.isKeySelectedByNum();
    }
}

