/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.turborun;

import com.iscobol.as.TRServerIntf;
import com.iscobol.as.turborun.TRThread;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rts.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;

public class TRServer
implements TRServerIntf {
    private static final String NULL_STR = "<null>";
    public static final byte OUT = 79;
    public static final byte ERR = 69;
    public static final byte EXIT = 88;
    public static final byte CLOSE = 67;
    public static final byte IN = 73;

    @Override
    public void start(int port, boolean reuseAddress) throws Exception {
        Config.markNoIscobolRuntimeThread();
        ServerSocket ss = new ServerSocket(port);
        ss.setReuseAddress(reuseAddress);
        String remoteConf = null;
        String programName = null;
        String[] programArgs = null;
        String[] env = null;
        while (true) {
            Socket s = ss.accept();
            OutputStream out = null;
            InputStream r = s.getInputStream();
            out = s.getOutputStream();
            try {
                programName = TRServer.readLine(r, true);
                int nArgs = Integer.parseInt(TRServer.readLine(r, true));
                programArgs = new String[nArgs];
                for (int i = 0; i < nArgs; ++i) {
                    programArgs[i] = TRServer.readLine(r, false);
                }
                remoteConf = TRServer.readLine(r, true);
                int nEnv = Integer.parseInt(TRServer.readLine(r, true));
                env = new String[nEnv];
                for (int i = 0; i < nEnv; ++i) {
                    env[i] = TRServer.readLine(r, false);
                }
                TRThread trt = new TRThread(RemoteRegistry.skipProg(), s, r, out, port, programName, programArgs, remoteConf, env);
                trt.start();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    static void writeString(OutputStream out, String str, byte type) throws IOException {
        byte[] b;
        try {
            b = str.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            b = str.getBytes();
        }
        byte[] b2 = new byte[b.length + 5];
        b2[0] = type;
        b2[4] = (byte)(b.length & 0xFF);
        b2[3] = (byte)((b.length & 0xFF00) >>> 8);
        b2[2] = (byte)((b.length & 0xFF0000) >>> 16);
        b2[1] = (byte)((b.length & 0xFF000000) >>> 24);
        System.arraycopy(b, 0, b2, 5, b.length);
        out.write(b2);
        out.flush();
    }

    static String readLine(InputStream r, boolean checkNullStr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c = r.read();
            while (c >= 0 && c != 10) {
                baos.write(c);
                c = r.read();
            }
            if (c < 0) {
                return null;
            }
            String Return2 = new String(baos.toByteArray());
            if (checkNullStr && NULL_STR.equals(Return2)) {
                return null;
            }
            return Return2;
        }
        catch (IOException e) {
            return null;
        }
    }
}

