/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.IAlphabet;
import com.iscobol.interfaces.compiler.IAlphabetItem;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Alphabet
implements CobolToken,
ErrorsNumbers,
IAlphabet {
    private static final int[] ALPHABET_EBCDIC_I = new int[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 20, 36, 4, 21, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 74, 224, 90, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 106, 208, 161, 7, 6, 8, 9, 10, 17, 18, 19, 23, 26, 27, 32, 33, 34, 35, 40, 41, 42, 43, 44, 48, 49, 51, 52, 53, 54, 56, 57, 58, 59, 60, 62, 65, 66, 67, 68, 69, 70, 71, 72, 73, 81, 82, 83, 84, 85, 86, 87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117, 118, 119, 120, 128, 138, 139, 140, 141, 142, 143, 144, 154, 155, 156, 157, 158, 159, 160, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 202, 203, 204, 205, 206, 207, 218, 219, 220, 221, 222, 223, 225, 234, 235, 236, 237, 238, 239, 250, 251, 252, 253, 254, 255};
    private int[] collSeq = new int[256];
    private int highValue;
    private int lowValue = -1;
    private Token name;
    private String predefinedAlphabetName;
    private List items;
    private final String charsetName = Alphabet.getCharsetName();

    public Alphabet(Pcc pc, TokenManager tm, Errors error) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        boolean addItems;
        int curPos = 0;
        Arrays.fill(this.collSeq, -1);
        boolean bl = addItems = !pc.getRoot().getGenerateCode();
        if (addItems) {
            this.items = new ArrayList();
        }
        if ((tk = tm.getToken()).getToknum() == 10009) {
            int i;
            this.name = tk;
            tk = tm.getToken();
            if (tk.getToknum() == 495) {
                tk = tm.getToken();
            }
            if (tk.getToknum() == 269) {
                tk = tm.getToken();
            }
            if (tk.getToknum() == 546) {
                tk = tm.getToken();
            }
            if (tk.getToknum() == 10009 || tk.getToknum() == 741) {
                if (tk.getWord().equals("EBCDIC") || tk.getWord().equals("ASCII") || tk.getWord().equals("STANDARD-1") || tk.getWord().equals("STANDARD-2") || tk.getWord().equals("NATIVE")) {
                    this.predefinedAlphabetName = tk.getWord();
                    if (tk.getWord().equals("EBCDIC")) {
                        for (int i2 = 0; i2 < this.collSeq.length; ++i2) {
                            this.collSeq[i2] = ALPHABET_EBCDIC_I[i2];
                        }
                    } else {
                        for (int i3 = 0; i3 < this.collSeq.length; ++i3) {
                            this.collSeq[i3] = i3;
                        }
                    }
                } else {
                    throw new GeneralErrorException(15, 4, tk, tk.getWord(), error);
                }
                this.highValue = 255;
                this.lowValue = 0;
                return;
            }
            if (tk.getToknum() != 10002 && tk.getToknum() != 10001) {
                throw new GeneralErrorException(15, 4, tk, tk.getWord(), error);
            }
            ArrayList<Object> values = new ArrayList<Object>();
            while (tk.getToknum() == 10002 || tk.getToknum() == 10001) {
                int ch1;
                Token tk1 = tm.getToken();
                if (tk1.getToknum() == 769 || tk1.getToknum() == 768 || tk1.getToknum() == 271) {
                    Token tk2 = tm.getToken();
                    if (tk2.getToknum() == 10002 || tk2.getToknum() == 10001) {
                        int ch2;
                        byte[] mem;
                        if (tk.getToknum() == 10001) {
                            mem = this.getBytes(tk);
                            if (mem.length > 1) {
                                throw new GeneralErrorException(15, 4, tk, tk.getWord(), error);
                            }
                            ch1 = mem[0] & 0xFF;
                        } else {
                            ch1 = Integer.parseInt(tk.getWord()) - 1;
                        }
                        if (ch1 < 0 || ch1 >= this.collSeq.length) {
                            throw new GeneralErrorException(30, 4, tk, tk.getWord(), error);
                        }
                        if (this.collSeq[ch1] != -1) {
                            throw new GeneralErrorException(143, 4, tk, "" + ch1, error);
                        }
                        this.setPos(ch1, curPos);
                        if (addItems) {
                            values.add(this.getValue(tk));
                        }
                        if (tk2.getToknum() == 10001) {
                            mem = this.getBytes(tk2);
                            if (mem.length > 1) {
                                throw new GeneralErrorException(15, 4, tk2, tk2.getWord(), error);
                            }
                            ch2 = mem[0] & 0xFF;
                        } else {
                            ch2 = Integer.parseInt(tk2.getWord()) - 1;
                        }
                        if (ch2 < 0 || ch2 >= this.collSeq.length) {
                            throw new GeneralErrorException(30, 4, tk2, tk2.getWord(), error);
                        }
                        if (tk1.getToknum() == 271) {
                            if (this.collSeq[ch2] != -1) {
                                throw new GeneralErrorException(143, 4, tk2, "" + ch2, error);
                            }
                            this.setPos(ch2, curPos);
                            if (addItems) {
                                values.add(this.getValue(tk2));
                            }
                            int nChars = curPos + 2;
                            while (tm.getToken().getToknum() == 271) {
                                tk2 = tm.getToken();
                                if (tk2.getToknum() == 10001) {
                                    byte[] mem2 = this.getBytes(tk2);
                                    if (mem2.length > 1) {
                                        throw new GeneralErrorException(15, 4, tk2, tk2.getWord(), error);
                                    }
                                    ch2 = mem2[0] & 0xFF;
                                } else {
                                    ch2 = Integer.parseInt(tk2.getWord()) - 1;
                                }
                                if (ch2 < 0 || ch2 >= this.collSeq.length) {
                                    throw new GeneralErrorException(30, 4, tk2, tk2.getWord(), error);
                                }
                                if (this.collSeq[ch2] != -1) {
                                    throw new GeneralErrorException(143, 4, tk2, "" + ch2, error);
                                }
                                this.setPos(ch2, curPos);
                                if (addItems) {
                                    values.add(this.getValue(tk2));
                                }
                                ++nChars;
                            }
                            if (addItems) {
                                this.items.add(new Item(1, values));
                                values = new ArrayList();
                            }
                            curPos = nChars;
                            tm.ungetToken();
                        } else {
                            this.collSeq[ch1] = -1;
                            if (ch1 > ch2) {
                                for (i = ch1; i >= ch2 && curPos < this.collSeq.length; ++curPos, --i) {
                                    if (this.collSeq[i] != -1) {
                                        throw new GeneralErrorException(143, 4, tk2, "" + i, error);
                                    }
                                    this.setPos(i, curPos);
                                }
                            } else {
                                for (i = ch1; i <= ch2 && curPos < this.collSeq.length; ++curPos, ++i) {
                                    if (this.collSeq[i] != -1) {
                                        throw new GeneralErrorException(143, 4, tk2, "" + i, error);
                                    }
                                    this.setPos(i, curPos);
                                }
                            }
                            if (addItems) {
                                values.add(this.getValue(tk2));
                                this.items.add(new Item(2, values));
                                values = new ArrayList();
                            }
                        }
                        tk = tm.getToken();
                        continue;
                    }
                    throw new GeneralErrorException(15, 4, tk2, tk2.getWord(), error);
                }
                if (tk.getToknum() == 10001) {
                    byte[] mem = this.getBytes(tk);
                    for (i = 0; i < mem.length; ++i) {
                        if (this.collSeq[mem[i] & 0xFF] != -1) {
                            throw new GeneralErrorException(143, 4, tk, "" + (mem[i] & 0xFF), error);
                        }
                        this.setPos(mem[i] & 0xFF, curPos++);
                    }
                } else {
                    ch1 = Integer.parseInt(tk.getWord()) - 1;
                    if (ch1 < 0 || ch1 >= this.collSeq.length) {
                        throw new GeneralErrorException(30, 4, tk, tk.getWord(), error);
                    }
                    if (this.collSeq[ch1] != -1) {
                        throw new GeneralErrorException(143, 4, tk, "" + ch1, error);
                    }
                    this.setPos(ch1, curPos++);
                }
                if (addItems) {
                    values.add(this.getValue(tk));
                    this.items.add(new Item(0, values));
                    values = new ArrayList();
                }
                tk = tk1;
            }
            tm.ungetToken();
            if (curPos > this.collSeq.length) {
                throw new GeneralErrorException(30, 4, this.name, this.name.getWord(), error);
            }
            for (i = 0; i < this.collSeq.length; ++i) {
                if (this.collSeq[i] != -1) continue;
                this.setPos(i, curPos++);
            }
        } else {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), error);
        }
    }

    private static String getCharsetName() {
        try {
            return Charset.forName(System.getProperty("file.encoding")).name();
        }
        catch (Exception ex) {
            return Charset.defaultCharset().name();
        }
    }

    private byte[] getBytes(Token tk) {
        String word = tk.getWord();
        word = word.substring(1, word.length() - 1);
        if (tk.isFigurative()) {
            return new byte[]{(byte)word.toCharArray()[0]};
        }
        try {
            return word.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return word.getBytes();
        }
    }

    private Object getValue(Token tk) {
        if (tk.getToknum() == 10001) {
            return tk.getWord().substring(1, tk.getWord().length() - 1);
        }
        return new Integer(Integer.parseInt(tk.getWord()));
    }

    private void setPos(int idx, int pos) {
        this.collSeq[idx] = pos;
        if (this.lowValue == -1) {
            this.lowValue = idx;
        }
        this.highValue = idx;
    }

    @Override
    public Token getName() {
        return this.name;
    }

    protected String getDeclUnivoqueName() {
        String n = "___ALPH_" + this.name.getWord();
        return n.replace('-', Pcc.hyphenRepl);
    }

    protected String getDeclUnivoqueNameBytes() {
        String n = "___ALPH_" + this.name.getWord() + "_bytes";
        return n.replace('-', Pcc.hyphenRepl);
    }

    protected int getLowValue() {
        return this.lowValue;
    }

    protected int getHighValue() {
        return this.highValue;
    }

    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("new int[] {");
        Return2.append(this.collSeq[0]);
        for (int i = 1; i < this.collSeq.length; ++i) {
            Return2.append(',');
            Return2.append(this.collSeq[i]);
        }
        Return2.append("}");
        return Return2.toString();
    }

    public String getCodeBytes() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("new byte[] {");
        Return2.append((byte)this.collSeq[0]);
        for (int i = 1; i < this.collSeq.length; ++i) {
            Return2.append(',');
            Return2.append((byte)this.collSeq[i]);
        }
        Return2.append("}");
        return Return2.toString();
    }

    @Override
    public int[] getCollatingSequence() {
        return this.collSeq;
    }

    @Override
    public String getPredefinedAlphabetName() {
        return this.predefinedAlphabetName;
    }

    @Override
    public List getItems() {
        return this.items;
    }

    public static class Item
    implements IAlphabetItem {
        public static final int SINGLE = 0;
        public static final int ALSO = 1;
        public static final int THROUGH = 2;
        private int type;
        private List values;

        Item(int type, List values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public List getValues() {
            return this.values;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            switch (this.type) {
                case 0: {
                    sb.append("SINGLE: ");
                    break;
                }
                case 1: {
                    sb.append("ALSO: ");
                    break;
                }
                case 2: {
                    sb.append("THROUGH: ");
                }
            }
            sb.append(this.values.get(0));
            for (int i = 1; i < this.values.size(); ++i) {
                sb.append(",").append(this.values.get(i));
            }
            return sb.toString();
        }
    }
}

