/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CopyGen {
    private static boolean overwriteAll;
    private static boolean overwriteNone;

    public static void main(String[] args) {
        try {
            Class.forName("javafx.embed.swing.JFXPanel").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CopyGen._main(args);
        }
        finally {
            System.exit(0);
        }
    }

    private static void _main(String[] args) {
        File outdir;
        overwriteAll = false;
        overwriteNone = false;
        String usage = "usage: java CopyGen [-p package] cls1 [ cls2 ... clsN] [-d outputDir]";
        Config.markNoIscobolRuntimeThread();
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        String dirname = ".";
        boolean dirnameSet = false;
        if (args.length >= 3 && args[args.length - 2].equalsIgnoreCase("-d")) {
            dirname = args[args.length - 1];
            dirnameSet = true;
        }
        if (!(outdir = new File(dirname)).exists() || !outdir.isDirectory()) {
            System.err.println("ERROR: directory " + dirname + " does not exist!");
            System.exit(-2);
        }
        String packagename = "";
        boolean packagenameSet = false;
        if (args.length >= 3 && args[0].equalsIgnoreCase("-p")) {
            if (dirnameSet && args.length < 5) {
                System.err.println(usage);
                System.exit(-1);
            }
            packagename = args[1];
            packagenameSet = true;
        }
        Hashtable<Class, Class> foundClasses = new Hashtable<Class, Class>();
        int i = 0;
        if (packagenameSet) {
            i = 2;
        }
        int end = args.length;
        if (dirnameSet) {
            end = args.length - 2;
        }
        while (i < end) {
            String className = "";
            if (packagenameSet) {
                className = className + packagename + ".";
            }
            className = className + args[i];
            try {
                Class<?> cls = Class.forName(className);
                Vector v = new Vector();
                Class<?> superCls = cls.getSuperclass();
                while (superCls != null) {
                    v.add(0, cls);
                    cls = superCls;
                    superCls = cls.getSuperclass();
                }
                v.add(0, cls);
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Class cl = (Class)e.nextElement();
                    if (foundClasses.containsKey(cl)) continue;
                    foundClasses.put(cl, cl);
                    CopyGen.printInfo(cl, dirname);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static void printInfo(Class cls, String dirname) throws Exception {
        Class stopCls = cls.getSuperclass();
        BeanInfo bInfo = stopCls != null ? Introspector.getBeanInfo(cls, stopCls) : Introspector.getBeanInfo(cls);
        String beanName = bInfo.getBeanDescriptor().getName();
        String filename = dirname + File.separator + beanName.toLowerCase() + ".def";
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (new File(filename).exists()) {
            if (overwriteNone) {
                return;
            }
            if (!overwriteAll) {
                String line;
                while (true) {
                    System.out.print("File '" + filename + "' already exists. Overwrite it? [y]es [n]o [A]ll [N]one ");
                    try {
                        line = in.readLine();
                        if (!"yes".startsWith(line) && !"no".startsWith(line) && !"All".startsWith(line) && !"None".startsWith(line)) continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
                if ("no".startsWith(line)) {
                    return;
                }
                if ("None".startsWith(line)) {
                    overwriteNone = true;
                    return;
                }
                if ("All".startsWith(line)) {
                    overwriteAll = true;
                }
            }
        }
        System.out.println("Generating file '" + filename + "' ...");
        PrintStream out = new PrintStream(new FileOutputStream(filename));
        out.println("       >>SOURCE FORMAT FREE");
        out.println();
        out.println("*>   Class " + beanName.toUpperCase());
        CopyGen.printSuperclassRef(cls, out);
        out.println();
        out.println();
        EventSetDescriptor[] events = bInfo.getEventSetDescriptors();
        for (int i = 0; i < events.length; ++i) {
            CopyGen.printEventInfo(beanName, events[i], out);
        }
        PropertyDescriptor[] properties = bInfo.getPropertyDescriptors();
        if (properties != null && properties.length > 0) {
            out.println();
            out.println("*>   Control Properties.");
            out.println();
            for (int i = 0; i < properties.length; ++i) {
                CopyGen.printPropertyInfo(properties[i], out);
            }
        }
        MethodDescriptor[] methods = bInfo.getMethodDescriptors();
        Arrays.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MethodDescriptor)o1).getMethod().getName().compareTo(((MethodDescriptor)o2).getMethod().getName());
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        out.println();
        out.println();
        out.println("*>   Control Methods.");
        out.println();
        for (int i = 0; i < methods.length; ++i) {
            CopyGen.printMethodInfo(methods[i].getMethod(), out);
        }
        out.println();
        out.println("       >>SOURCE FORMAT PREVIOUS");
        out.close();
        System.out.println("Done.");
    }

    private static void printEventInfo(String beanName, EventSetDescriptor e, PrintStream out) throws Exception {
        String name = e.getName();
        MethodDescriptor[] methods = e.getListenerMethodDescriptors();
        if (methods != null && methods.length > 0) {
            Class<?>[] parameterTypes = methods[0].getMethod().getParameterTypes();
            out.println("*>   " + name.toUpperCase() + " event definitions, Class: " + parameterTypes[0].getName() + ".");
            out.println();
            for (int i = 0; i < methods.length; ++i) {
                String methName = methods[i].getName();
                int id = Factory.getHashcode(methName.toUpperCase());
                out.print("78 " + beanName + "-" + methName + " value " + id + ".");
                ParameterDescriptor[] params = methods[i].getParameterDescriptors();
                if (params != null && params.length > 0) {
                    out.print(" | (" + params[0].getShortDescription());
                    for (int j = 1; j < params.length; ++j) {
                        out.print("," + params[j].getShortDescription());
                    }
                    out.print(")");
                }
                out.println();
            }
            out.println();
            out.println();
        }
    }

    private static void printPropertyInfo(PropertyDescriptor p, PrintStream out) {
        Class<Serializable> propertyType = p.getPropertyType();
        if (propertyType == null) {
            return;
        }
        out.print("*> name: " + p.getName() + " , type: ");
        if (propertyType.isAssignableFrom(Integer.TYPE) || propertyType.isAssignableFrom(Byte.TYPE) || propertyType.isAssignableFrom(Long.TYPE) || propertyType.isAssignableFrom(Short.TYPE)) {
            out.print("numeric integer");
        } else if (propertyType.isAssignableFrom(Boolean.TYPE)) {
            out.print("numeric integer [values 0/1]");
        } else if (propertyType.isAssignableFrom(Double.TYPE) || propertyType.isAssignableFrom(Float.TYPE)) {
            out.print("numeric not integer");
        } else if (propertyType.isAssignableFrom(Character.TYPE) || propertyType.getName().equals("java.lang.String")) {
            out.print("alphanumeric");
        } else if (propertyType.getName().equals("java.awt.Image") || propertyType.getName().equals("javax.swing.Icon")) {
            out.print("numeric integer or object reference");
        } else {
            out.print("object reference");
        }
        out.print(" (" + propertyType.getName() + ")");
        if (p.getReadMethod() != null) {
            if (p.getWriteMethod() != null) {
                out.println(" r/w");
            } else {
                out.println(" r");
            }
        } else {
            out.println(" w");
        }
    }

    private static void printSuperclassRef(Class cls, PrintStream out) throws Exception {
        if (cls.getSuperclass() == null) {
            return;
        }
        out.print("*>   see also ");
        for (Class sc = cls.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            out.print(Introspector.getBeanInfo(sc).getBeanDescriptor().getName().toLowerCase() + ".def ");
        }
        out.println();
    }

    private static void printMethodInfo(Method m, PrintStream out) throws Exception {
        out.print("*> ");
        out.print(CopyGen.typeToString(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length > 0) {
            out.print(CopyGen.typeToString(pt[0]));
            for (int i = 1; i < pt.length; ++i) {
                out.print("," + CopyGen.typeToString(pt[i]));
            }
        }
        out.println(")");
    }

    private static String typeToString(Class c) throws Exception {
        int dimensions = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++dimensions;
        }
        String Return2 = c.getName();
        for (int i = 0; i < dimensions; ++i) {
            Return2 = Return2 + "[]";
        }
        return Return2;
    }
}

