/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class GenericValue
implements CobolToken,
ErrorsNumbers {
    private VariableName variable;
    private Token literal;
    TokenManager tm;

    private GenericValue(TokenManager tm) {
        this.tm = tm;
    }

    public static GenericValue get(Pcc pc, TokenManager tm, Errors error) throws GeneralErrorException, EndOfProgramException {
        GenericValue Return2;
        Token tk = tm.getToken();
        switch (tk.getToknum()) {
            case 10001: 
            case 10002: 
            case 10017: {
                Return2 = new GenericValue(tm);
                new GenericValue(tm).literal = tk;
                break;
            }
            case 10009: {
                tm.ungetToken();
                VariableName vn = VariableName.get(tm, error, pc);
                if (vn != null) {
                    Return2 = new GenericValue(tm);
                    new GenericValue(tm).variable = vn;
                    break;
                }
                Return2 = null;
                break;
            }
            default: {
                tm.ungetToken();
                Return2 = null;
            }
        }
        return Return2;
    }

    public String getLiteralContent() {
        String Return2;
        Return2 = this.literal != null ? ((Return2 = this.literal.getWord()).length() > 2 ? Return2.substring(1, Return2.length() - 1) : "") : null;
        return Return2;
    }

    public boolean isNumeric() {
        if (this.literal != null) {
            return this.literal.getToknum() != 10001;
        }
        return this.variable.isNumeric();
    }

    public VariableName getVariable() {
        return this.variable;
    }

    public String getCode() {
        if (this.literal != null) {
            return this.tm.getCodeLiteral(this.literal);
        }
        if (this.variable != null) {
            return this.variable.getCode();
        }
        return null;
    }

    public String toString() {
        if (this.literal != null) {
            return this.literal.getWord();
        }
        if (this.variable != null) {
            return this.variable.getName();
        }
        return null;
    }
}

