/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Inspect
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int I_ALL = 1;
    public static final int I_LEADING = 2;
    public static final int I_FIRST = 3;
    public static final int I_CHARACTERS = 4;
    private VariableName source;
    private InspectDelimPhrase globDelimPhrase;
    private boolean tallying;
    private boolean replacing;
    private boolean converting;
    private boolean globTrailing;
    private boolean hasNational;
    private VerbList tallyingCounterPhrases = new VerbList();
    private VerbList replacingPhrases = new VerbList();
    private Token tk_target;
    private Token tk_replace;
    private boolean isTkReplFigZero;
    private VariableName vn_target;
    private VariableName vn_replace;
    private Token tk_comp_chars;
    private Token tk_conv_chars;
    private boolean isTkConvCharsFigZero;
    private VariableName vn_comp_chars;
    private VariableName vn_conv_chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inspect(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.allowAllLitGen = false;
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!Inspect.isUsageDisplay(this.source)) {
            throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
        }
        this.setHasNational(this.source);
        tk = this.tm.getToken();
        boolean ka = this.tm.setKeepAll(true);
        try {
            switch (tk.getToknum()) {
                case 758: {
                    this.inspectTallying(this.tm.getToken());
                    break;
                }
                case 684: {
                    if (this.source.isSetGetProperty()) {
                        throw new GeneralErrorException(68, 4, this.source.getNameToken(), this.source.getName(), this.error);
                    }
                    this.inspectReplacing(this.tm.getToken());
                    break;
                }
                case 378: {
                    this.inspectConverting(this.tm.getToken());
                    break;
                }
                default: {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 684) {
                if (!this.tallying) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
                this.inspectReplacing(tk);
            } else {
                this.tm.ungetToken();
            }
        }
        finally {
            this.tm.setKeepAll(ka);
        }
    }

    static Token cloneToken(Token tk, int toknum, String word) {
        Token Return2 = new Token(tk);
        Return2.setToknum(toknum);
        Return2.setWord(word);
        Return2.setAll(tk.isAll());
        return Return2;
    }

    void inspectTallying(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.tallying = true;
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        do {
            this.tm.ungetToken();
            this.tallyingCounterPhrases.addItem(new InspectTallyingCounterPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, tk));
        } while ((tk = this.tm.getToken()).getToknum() == 10009);
        this.tm.ungetToken();
    }

    void inspectReplacing(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.replacing = true;
        if (tk.getToknum() == 777) {
            this.inspectReplacingTrailing(this.tm.getToken());
            return;
        }
        int lastToknum = -1;
        int i = 0;
        block5: while (true) {
            switch (tk.getToknum()) {
                case 10002: {
                    if (tk.isFigurativeZero()) {
                        tk = Inspect.cloneToken(tk, 10001, "'0'");
                    }
                }
                case 10001: 
                case 10009: {
                    if (tk.isAll()) {
                        lastToknum = 262;
                        break;
                    }
                    if (i != 0) break;
                    throw new ExpectedFoundException(tk, this.error, "'ALL'");
                }
                case 324: 
                case 490: 
                case 557: {
                    lastToknum = tk.getToknum();
                    tk = this.tm.getToken();
                    break;
                }
                default: {
                    if (i != 0) break block5;
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            this.replacingPhrases.addItem(new InspectReplacingPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, tk, lastToknum));
            tk = this.tm.getToken();
            ++i;
        }
        this.tm.ungetToken();
    }

    void inspectReplacingTrailing(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.globTrailing = true;
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                this.vn_target = VariableName.get(this.tm, this.error, this.pc);
                if (this.vn_target.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                }
                if (this.vn_target.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                }
                this.setHasNational(this.vn_target);
                break;
            }
            case 10001: {
                this.tk_target = tk;
                if (tk.getRealLength() <= 1) break;
                throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
            }
            default: {
                if (tk.isFigurativeZero()) {
                    this.tk_target = Inspect.cloneToken(tk, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 312) {
            throw new ExpectedFoundException(tk, this.error, "'BY'");
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                this.vn_replace = VariableName.get(this.tm, this.error, this.pc);
                if (this.vn_replace.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                }
                if (this.vn_replace.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                }
                this.setHasNational(this.vn_replace);
                break;
            }
            case 10001: {
                this.tk_replace = tk;
                if (this.tk_replace.getRealLength() <= 1) break;
                throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
            }
            default: {
                if (tk.isFigurativeZero()) {
                    this.tk_replace = Inspect.cloneToken(tk, 10001, "'0'");
                    this.isTkReplFigZero = true;
                    break;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        this.globDelimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
    }

    void inspectConverting(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.converting = true;
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.vn_comp_chars = VariableName.get(this.tm, this.error, this.pc);
            if (!Inspect.isUsageDisplay(this.vn_comp_chars)) {
                throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
            }
            this.setHasNational(this.vn_comp_chars);
        } else if (tk.getToknum() == 10001) {
            this.tk_comp_chars = tk;
        } else if (tk.isFigurativeZero()) {
            this.tk_comp_chars = Inspect.cloneToken(tk, 10001, "'0'");
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 774) {
            throw new ExpectedFoundException(tk, this.error, "'TO'");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.vn_conv_chars = VariableName.get(this.tm, this.error, this.pc);
            if (!Inspect.isUsageDisplay(this.vn_conv_chars)) {
                throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
            }
            this.setHasNational(this.vn_conv_chars);
        } else if (tk.getToknum() == 10001) {
            this.tk_conv_chars = tk;
        } else if (tk.isFigurativeZero()) {
            this.tk_conv_chars = Inspect.cloneToken(tk, 10001, "'0'");
            this.isTkConvCharsFigZero = true;
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (this.tk_comp_chars != null) {
            if (this.tk_conv_chars != null) {
                if (!(this.isTkConvCharsFigZero || this.tk_conv_chars.isFigurative() || this.tk_conv_chars.isAll() || this.tk_comp_chars.getRealLength() == this.tk_conv_chars.getRealLength())) {
                    throw new GeneralErrorException(70, 4, this.tk_conv_chars, this.tk_conv_chars.getWord(), this.error);
                }
            } else {
                int convLen = this.vn_conv_chars.getVariableLength();
                if (convLen != -1 && this.tk_comp_chars.getRealLength() != convLen) {
                    throw new GeneralErrorException(70, 4, this.vn_conv_chars.getNameToken(), this.vn_conv_chars.getName(), this.error);
                }
            }
        } else if (this.tk_conv_chars != null) {
            int compLen;
            if (!(this.isTkConvCharsFigZero || this.tk_conv_chars.isFigurative() || this.tk_conv_chars.isAll() || (compLen = this.vn_comp_chars.getVariableLength()) == -1 || compLen == this.tk_conv_chars.getRealLength())) {
                throw new GeneralErrorException(70, 4, this.tk_conv_chars, this.tk_conv_chars.getWord(), this.error);
            }
        } else {
            int convLen;
            int compLen = this.vn_comp_chars.getVariableLength();
            if (compLen != -1 && (convLen = this.vn_conv_chars.getVariableLength()) != -1 && compLen != convLen) {
                throw new GeneralErrorException(70, 4, this.vn_conv_chars.getNameToken(), this.vn_conv_chars.getName(), this.error);
            }
        }
        this.globDelimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getHeader(boolean trailing) {
        StringBuffer head = new StringBuffer();
        head.append(this.source.getCode());
        head.append(".inspect");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            head.append("Byte");
        }
        if (trailing) {
            head.append("Trailing");
        }
        head.append("(");
        return head.toString();
    }

    private boolean isOptimizable() {
        if (this.hasNational || this.pc.getOption("-b") == null) {
            return false;
        }
        if (this.globTrailing) {
            return false;
        }
        if (this.tallying) {
            InspectTallyingCounterPhrase itcp;
            if (!this.replacing && this.tallyingCounterPhrases.getItemNum() == 1 && !(itcp = (InspectTallyingCounterPhrase)this.tallyingCounterPhrases.getFirst()).isTrailing() && itcp.tallyingPhrases.getItemNum() == 1) {
                InspectTallyingPhrase itp = (InspectTallyingPhrase)itcp.tallyingPhrases.getFirst();
                if (itp.delimPhrase == null || itp.delimPhrase.isEmpty()) {
                    return true;
                }
            }
        } else if (this.replacing) {
            if (!this.tallying && this.replacingPhrases.getItemNum() == 1) {
                InspectReplacingPhrase irp = (InspectReplacingPhrase)this.replacingPhrases.getFirst();
                if (irp.delimPhrase == null || irp.delimPhrase.isEmpty()) {
                    return true;
                }
            }
        } else if (this.converting && (this.globDelimPhrase == null || this.globDelimPhrase.isEmpty())) {
            return true;
        }
        return false;
    }

    private void getCodeOptimized(StringBuffer Return2) {
        Return2.append(this.source.getCode());
        Return2.append(".inspect");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            Return2.append("Byte");
        }
        Return2.append("Opt(");
        if (this.tallying) {
            InspectTallyingCounterPhrase itcp = (InspectTallyingCounterPhrase)this.tallyingCounterPhrases.getFirst();
            InspectTallyingPhrase itp = (InspectTallyingPhrase)itcp.tallyingPhrases.getFirst();
            Return2.append(itcp.counter.getCode());
            Return2.append(", ");
            Return2.append(itp.getCodeType());
            Return2.append(", ");
            Return2.append(itp.getCodeCV());
            Return2.append(");");
        } else if (this.replacing) {
            InspectReplacingPhrase irp = (InspectReplacingPhrase)this.replacingPhrases.getFirst();
            Return2.append(irp.getCodeType());
            Return2.append(", ");
            Return2.append(irp.getCodeTarg());
            Return2.append(", ");
            Return2.append(irp.getCodeRepl());
            Return2.append(");");
        } else {
            if (this.tk_comp_chars != null) {
                Return2.append(this.getCodeLiteral(this.tk_comp_chars));
            } else {
                Return2.append(this.vn_comp_chars.getCode());
            }
            Return2.append(", ");
            if (this.tk_conv_chars != null) {
                Return2.append(this.getCodeLiteral(this.tk_conv_chars));
            } else {
                Return2.append(this.vn_conv_chars.getCode());
            }
            Return2.append(");");
        }
        Return2.append(eol);
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.isOptimizable()) {
            this.getCodeOptimized(Return2);
            this.getCodeDebugEnd(Return2);
            return Return2.toString();
        }
        if (this.tallying) {
            InspectTallyingCounterPhrase phrase;
            boolean trailing = false;
            Enumeration en = this.tallyingCounterPhrases.elements();
            while (en.hasMoreElements()) {
                phrase = (InspectTallyingCounterPhrase)en.nextElement();
                if (!phrase.isTrailing()) continue;
                trailing = true;
                break;
            }
            if (trailing || this.pc.getOption("-ca") != null) {
                en = this.tallyingCounterPhrases.elements();
                while (en.hasMoreElements()) {
                    phrase = (InspectTallyingCounterPhrase)en.nextElement();
                    Return2.append(this.getHeader(phrase.isTrailing()));
                    if (phrase.isTrailing()) {
                        Return2.append(phrase.getCodeTallyingTrailing());
                    } else {
                        StringBuffer cnt = new StringBuffer();
                        StringBuffer type = new StringBuffer();
                        StringBuffer comp_val = new StringBuffer();
                        StringBuffer bef_dlm = new StringBuffer();
                        StringBuffer aft_dlm = new StringBuffer();
                        StringBuffer trail_dlm = new StringBuffer();
                        cnt.append("new NumericVar[] {");
                        type.append("new int[] {");
                        comp_val.append("new CobolVar[] {");
                        bef_dlm.append("new CobolVar[] {");
                        aft_dlm.append("new CobolVar[] {");
                        trail_dlm.append("new boolean[] {");
                        phrase.getCode(cnt, type, comp_val, bef_dlm, aft_dlm, trail_dlm);
                        cnt.append(" }");
                        type.append(" }");
                        comp_val.append(" }");
                        bef_dlm.append(" }");
                        aft_dlm.append(" }");
                        trail_dlm.append("}");
                        Return2.append(cnt.toString());
                        Return2.append(", ");
                        Return2.append(type.toString());
                        Return2.append(", ");
                        Return2.append(comp_val.toString());
                        Return2.append(", ");
                        Return2.append(bef_dlm.toString());
                        Return2.append(", ");
                        Return2.append(aft_dlm.toString());
                        Return2.append(", ");
                        Return2.append(trail_dlm.toString());
                    }
                    if (!en.hasMoreElements()) continue;
                    Return2.append(");");
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                }
            } else {
                StringBuffer cnt = new StringBuffer();
                StringBuffer type = new StringBuffer();
                StringBuffer comp_val = new StringBuffer();
                StringBuffer bef_dlm = new StringBuffer();
                StringBuffer aft_dlm = new StringBuffer();
                StringBuffer trail_dlm = new StringBuffer();
                cnt.append("new NumericVar[] {");
                type.append("new int[] {");
                comp_val.append("new CobolVar[] {");
                bef_dlm.append("new CobolVar[] {");
                aft_dlm.append("new CobolVar[] {");
                trail_dlm.append("new boolean[] {");
                Enumeration en2 = this.tallyingCounterPhrases.elements();
                while (en2.hasMoreElements()) {
                    InspectTallyingCounterPhrase phrase2 = (InspectTallyingCounterPhrase)en2.nextElement();
                    phrase2.getCode(cnt, type, comp_val, bef_dlm, aft_dlm, trail_dlm);
                    if (!en2.hasMoreElements()) continue;
                    cnt.append(",");
                    type.append(",");
                    comp_val.append(",");
                    bef_dlm.append(",");
                    aft_dlm.append(",");
                    trail_dlm.append(",");
                }
                cnt.append(" }");
                type.append(" }");
                comp_val.append(" }");
                bef_dlm.append(" }");
                aft_dlm.append(" }");
                trail_dlm.append("}");
                Return2.append(this.getHeader(false));
                Return2.append(cnt.toString());
                Return2.append(", ");
                Return2.append(type.toString());
                Return2.append(", ");
                Return2.append(comp_val.toString());
                Return2.append(", ");
                Return2.append(bef_dlm.toString());
                Return2.append(", ");
                Return2.append(aft_dlm.toString());
                Return2.append(", ");
                Return2.append(trail_dlm.toString());
            }
        } else if (this.replacing) {
            Return2.append(this.getHeader(this.globTrailing));
            if (this.globTrailing) {
                Return2.append(this.getCodeReplacingTrailing());
            } else {
                Return2.append(this.getCodeReplacing());
            }
        } else if (this.converting) {
            Return2.append(this.getHeader(false));
            Return2.append(this.getCodeConverting());
        }
        Return2.append(");");
        if (this.tallying && this.replacing) {
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append(this.getHeader(this.globTrailing));
            if (this.globTrailing) {
                Return2.append(this.getCodeReplacingTrailing());
            } else {
                Return2.append(this.getCodeReplacing());
            }
            Return2.append(");");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private String getCodeReplacing() {
        StringBuffer Return2 = new StringBuffer();
        StringBuffer type = new StringBuffer();
        StringBuffer targ = new StringBuffer();
        StringBuffer repl = new StringBuffer();
        StringBuffer bef_dlm = new StringBuffer();
        StringBuffer aft_dlm = new StringBuffer();
        StringBuffer trail_dlm = new StringBuffer();
        type.append("new int[] {");
        targ.append("new CobolVar[] {");
        repl.append("new CobolVar[] {");
        bef_dlm.append("new CobolVar[] {");
        aft_dlm.append("new CobolVar[] {");
        trail_dlm.append("new boolean[] {");
        Enumeration r_phrases = this.replacingPhrases.elements();
        while (r_phrases.hasMoreElements()) {
            InspectReplacingPhrase rp = (InspectReplacingPhrase)r_phrases.nextElement();
            type.append(rp.getCodeType());
            targ.append(rp.getCodeTarg());
            repl.append(rp.getCodeRepl());
            bef_dlm.append(rp.delimPhrase.getCodeBef());
            aft_dlm.append(rp.delimPhrase.getCodeAft());
            trail_dlm.append(rp.delimPhrase.isTrailing);
            if (!r_phrases.hasMoreElements()) continue;
            type.append(",");
            targ.append(",");
            repl.append(",");
            bef_dlm.append(",");
            aft_dlm.append(",");
            trail_dlm.append(",");
        }
        type.append(" }");
        targ.append(" }");
        repl.append(" }");
        bef_dlm.append(" }");
        aft_dlm.append(" }");
        trail_dlm.append("}");
        Return2.append(type.toString());
        Return2.append(", ");
        Return2.append(targ.toString());
        Return2.append(", ");
        Return2.append(repl.toString());
        Return2.append(", ");
        Return2.append(bef_dlm.toString());
        Return2.append(", ");
        Return2.append(aft_dlm.toString());
        Return2.append(", ");
        Return2.append(trail_dlm.toString());
        return Return2.toString();
    }

    private String getCodeReplacingTrailing() {
        StringBuffer Return2 = new StringBuffer();
        if (this.tk_target != null) {
            Return2.append(this.getCodeLiteral(this.tk_target));
        } else {
            Return2.append(this.vn_target.getCode());
        }
        Return2.append(", ");
        if (this.tk_replace != null) {
            Return2.append(this.getCodeLiteral(this.tk_replace));
        } else {
            Return2.append(this.vn_replace.getCode());
        }
        this.globDelimPhrase.getDelimPhraseCode(Return2);
        return Return2.toString();
    }

    private String getCodeConverting() {
        StringBuffer Return2 = new StringBuffer();
        if (this.tk_comp_chars != null) {
            Return2.append(this.getCodeLiteral(this.tk_comp_chars));
        } else {
            Return2.append(this.vn_comp_chars.getCode());
        }
        Return2.append(", ");
        if (this.tk_conv_chars != null) {
            Return2.append(this.getCodeLiteral(this.tk_conv_chars));
        } else {
            Return2.append(this.vn_conv_chars.getCode());
        }
        this.globDelimPhrase.getDelimPhraseCode(Return2);
        return Return2.toString();
    }

    private void setHasNational(VariableName vn) {
        if (!this.hasNational) {
            VariableDeclaration vd = vn.getVarDecl();
            this.hasNational = vd != null && (vd.isNational() || vd.isPicG());
        }
    }

    private static boolean isUsageDisplay(VariableName vn) {
        return vn.hasSubValue() || vn.getVarDecl().isUsageDisplay() || vn.getVarDecl().hasRealChildren();
    }

    public class InspectDelimPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        boolean after;
        boolean before;
        boolean isTrailing;
        private final List aft_delims;
        private final List bef_delims;

        public InspectDelimPhrase(Token kw, Block par, Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.allowAllLitGen = false;
            this.aft_delims = new ArrayList();
            this.bef_delims = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                boolean isBef = false;
                if (tk.getToknum() != 299 && tk.getToknum() != 261) break;
                if (tk.getToknum() == 261) {
                    if (this.after) {
                        throw new SyntaxErrorException(tk, "Duplicate AFTER phrase", this.error);
                    }
                    this.after = true;
                } else {
                    if (this.before) {
                        throw new SyntaxErrorException(tk, "Duplicate BEFORE phrase", this.error);
                    }
                    this.before = true;
                    isBef = true;
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 532) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 777) {
                    if (this.after) {
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    this.isTrailing = true;
                }
                tk = isBef ? this.getDelimiter(this.tm, this.bef_delims) : this.getDelimiter(this.tm, this.aft_delims);
            }
            this.tm.ungetToken();
        }

        void getDelimPhraseCode(StringBuffer Return2) {
            Return2.append(", ");
            Return2.append(this.getCodeBef());
            Return2.append(", ");
            Return2.append(this.getCodeAft());
            Return2.append(", ");
            Return2.append(this.isTrailing);
        }

        private Token getDelimiter(TokenManager tm, List target) throws EndOfProgramException, GeneralErrorException {
            tm.ungetToken();
            Token tk = tm.getToken();
            if (tk.getToknum() == 10009) {
                tm.ungetToken();
                VariableName vn = VariableName.get(tm, this.error, this.pc);
                if (!Inspect.isUsageDisplay(vn)) {
                    throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                }
                Inspect.this.setHasNational(vn);
                target.add(vn);
            } else if (tk.getToknum() == 10001) {
                target.add(tk);
            } else if (tk.isFigurativeZero()) {
                tk = Inspect.cloneToken(tk, 10001, "'0'");
                target.add(tk);
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = tm.getToken();
            if (tk.getToknum() == 618) {
                throw new GeneralErrorException(19, 4, tk, "", this.error);
            }
            return tk;
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeBef() {
            if (!this.before) {
                return "null";
            }
            Object o = this.bef_delims.get(0);
            if (o instanceof VariableName) {
                return ((VariableName)o).getCode();
            }
            return this.getCodeLiteral((Token)o);
        }

        public String getCodeAft() {
            if (!this.after) {
                return "null";
            }
            Object o = this.aft_delims.get(0);
            if (o instanceof VariableName) {
                return ((VariableName)o).getCode();
            }
            return this.getCodeLiteral((Token)o);
        }

        @Override
        public String getCode() {
            return "";
        }

        public boolean isEmpty() {
            return this.bef_delims.isEmpty() && this.aft_delims.isEmpty();
        }
    }

    public class InspectReplacingPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        int type;
        Token tk_repl;
        VariableName vn_repl;
        Token tk_targ;
        VariableName vn_targ;
        InspectDelimPhrase delimPhrase;

        public InspectReplacingPhrase(Token kw, Block par, Pcc p, TokenManager t, Errors err, Token tk, int toknum) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.tk_repl = null;
            this.vn_repl = null;
            this.tk_targ = null;
            this.vn_targ = null;
            this.allowAllLitGen = false;
            switch (toknum) {
                case 262: {
                    this.type = 1;
                    break;
                }
                case 557: {
                    this.type = 2;
                    break;
                }
                case 490: {
                    this.type = 3;
                    break;
                }
                case 324: {
                    this.type = 4;
                }
            }
            if (this.type != 4) {
                if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_targ = VariableName.get(this.tm, this.error, this.pc);
                    if (!Inspect.isUsageDisplay(this.vn_targ)) {
                        throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.vn_targ);
                } else if (tk.getToknum() == 10001) {
                    this.tk_targ = tk;
                } else if (tk.isFigurativeZero()) {
                    this.tk_targ = Inspect.cloneToken(tk, 10001, "'0'");
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 312) {
                throw new ExpectedFoundException(tk, this.error, "'BY'");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.vn_repl = VariableName.get(this.tm, this.error, this.pc);
                if (!Inspect.isUsageDisplay(this.vn_repl)) {
                    throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                }
                if (this.type == 4 && this.vn_repl.getVariableLength() > 1) {
                    throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                }
                Inspect.this.setHasNational(this.vn_repl);
            } else if (tk.getToknum() == 10001) {
                if (this.type == 4 && tk.getRealLength() > 1) {
                    throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                }
                this.tk_repl = tk;
            } else if (tk.isFigurativeZero()) {
                this.tk_repl = Inspect.cloneToken(tk, 10001, "'0'");
                Inspect.this.isTkReplFigZero = true;
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (this.type != 4) {
                if (this.tk_targ != null) {
                    if (this.tk_repl != null) {
                        if (!Inspect.this.isTkReplFigZero && !this.tk_repl.isFigurative() && this.tk_targ.getRealLength() != this.tk_repl.getRealLength()) {
                            throw new GeneralErrorException(70, 4, this.tk_repl, this.tk_repl.getWord(), this.error);
                        }
                    } else {
                        int repLen = this.vn_repl.getVariableLength();
                        if (repLen != -1 && this.tk_targ.getRealLength() != repLen) {
                            throw new GeneralErrorException(70, 4, this.vn_repl.getNameToken(), this.vn_repl.getName(), this.error);
                        }
                    }
                } else if (this.tk_repl != null) {
                    int targLen;
                    if (!Inspect.this.isTkReplFigZero && !this.tk_repl.isFigurative() && (targLen = this.vn_targ.getVariableLength()) != -1 && targLen != this.tk_repl.getRealLength()) {
                        throw new GeneralErrorException(70, 4, this.tk_repl, this.tk_repl.getWord(), this.error);
                    }
                } else {
                    int repLen;
                    int targLen = this.vn_targ.getVariableLength();
                    if (targLen != -1 && (repLen = this.vn_repl.getVariableLength()) != -1 && targLen != repLen) {
                        throw new GeneralErrorException(70, 4, this.vn_repl.getNameToken(), this.vn_repl.getName(), this.error);
                    }
                }
            }
            this.delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeType() {
            return Integer.toString(this.type);
        }

        public String getCodeTarg() {
            if (this.type == 4) {
                return "null";
            }
            if (this.tk_targ != null) {
                return this.getCodeLiteral(this.tk_targ);
            }
            return this.vn_targ.getCode();
        }

        public String getCodeRepl() {
            if (this.tk_repl != null) {
                return this.getCodeLiteral(this.tk_repl);
            }
            return this.vn_repl.getCode();
        }

        @Override
        public String getCode() {
            return "";
        }
    }

    public class InspectTallyingPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        int type;
        Token tk_comp_val;
        VariableName vn_comp_val;
        InspectDelimPhrase delimPhrase;

        public InspectTallyingPhrase(Token kw, Block par, Pcc p, TokenManager t, Errors err, Token tk, int lastType) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.tk_comp_val = null;
            this.vn_comp_val = null;
            this.allowAllLitGen = false;
            switch (tk.getToknum()) {
                case 10002: {
                    if (tk.isFigurativeZero()) {
                        tk = Inspect.cloneToken(tk, 10001, "'0'");
                    }
                }
                case 10001: 
                case 10009: {
                    if (tk.isAll()) {
                        this.type = 1;
                        tk.setAll(false);
                    } else if (lastType != -1 && lastType != 4) {
                        this.type = lastType;
                    } else {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    this.tm.ungetToken();
                    break;
                }
                case 557: {
                    this.type = 2;
                    break;
                }
                case 324: {
                    this.type = 4;
                }
            }
            if (this.type != 4) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_comp_val = VariableName.get(this.tm, this.error, this.pc);
                    if (!Inspect.isUsageDisplay(this.vn_comp_val)) {
                        throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.vn_comp_val);
                } else if (tk.getToknum() == 10001) {
                    this.tk_comp_val = tk;
                } else if (tk.isFigurativeZero()) {
                    this.tk_comp_val = Inspect.cloneToken(tk, 10001, "'0'");
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            this.delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        public String getCodeType() {
            return Integer.toString(this.type);
        }

        public String getCodeCV() {
            if (this.type == 4) {
                return "null";
            }
            if (this.tk_comp_val != null) {
                return this.getCodeLiteral(this.tk_comp_val);
            }
            return this.vn_comp_val.getCode();
        }

        @Override
        public String getCode() {
            return "";
        }
    }

    public class InspectTallyingCounterPhrase
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VerbList tallyingPhrases;
        VariableName counter;
        Token trail_tk_comp_value;
        VariableName trail_vn_comp_value;
        InspectDelimPhrase trail_delimPhrase;

        public InspectTallyingCounterPhrase(Token kw, Block par, Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            this.tallyingPhrases = new VerbList();
            this.allowAllLitGen = false;
            this.counter = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(Inspect.this, 1));
            if (!this.counter.getVarDecl().isNumeric() || this.counter.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 495) {
                throw new ExpectedFoundException(tk, this.error, "'FOR'");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 777) {
                if (Inspect.this.tallyingCounterPhrases.getItemNum() > 0) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.inspectTallyingTrailing(this.tm.getToken());
                return;
            }
            int lastType = -1;
            int i = 0;
            block7: while (true) {
                switch (tk.getToknum()) {
                    case 10002: {
                        if (tk.isFigurativeZero()) {
                            tk = Inspect.cloneToken(tk, 10001, "'0'");
                        }
                        if (!tk.isAll()) break;
                        lastType = 1;
                        break;
                    }
                    case 10009: {
                        if (tk.isAll()) {
                            lastType = 1;
                            break;
                        }
                        TokenManager.Marker mk = this.tm.getMarker();
                        this.tm.setMarker(mk);
                        this.tm.ungetToken();
                        VariableName.get(this.tm, this.error, this.pc);
                        boolean isCounter = this.tm.getToken().getToknum() == 495;
                        this.tm.rewindToMarker(mk);
                        if (!isCounter) break;
                        this.tm.ungetToken();
                        return;
                    }
                    case 10001: {
                        if (!tk.isAll()) break;
                        lastType = 1;
                        break;
                    }
                    case 557: {
                        lastType = 2;
                        break;
                    }
                    case 324: {
                        lastType = 4;
                        break;
                    }
                    default: {
                        if (i != 0) break block7;
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                }
                this.tallyingPhrases.addItem(new InspectTallyingPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, tk, lastType));
                tk = this.tm.getToken();
                ++i;
            }
            this.tm.ungetToken();
        }

        String getCodeTallyingTrailing() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append(this.counter.getCode());
            Return2.append(", ");
            if (this.trail_tk_comp_value != null) {
                Return2.append(this.getCodeLiteral(this.trail_tk_comp_value));
            } else {
                Return2.append(this.trail_vn_comp_value.getCode());
            }
            this.trail_delimPhrase.getDelimPhraseCode(Return2);
            return Return2.toString();
        }

        boolean isTrailing() {
            return this.trail_tk_comp_value != null || this.trail_vn_comp_value != null;
        }

        void inspectTallyingTrailing(Token tk) throws GeneralErrorException, EndOfProgramException {
            switch (tk.getToknum()) {
                case 10009: {
                    this.tm.ungetToken();
                    this.trail_vn_comp_value = VariableName.get(this.tm, this.error, this.pc);
                    if (this.trail_vn_comp_value.getVarDecl().isNumeric()) {
                        throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                    }
                    if (this.trail_vn_comp_value.getVariableLength() > 1) {
                        throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                    }
                    Inspect.this.setHasNational(this.trail_vn_comp_value);
                    break;
                }
                case 10001: {
                    if (tk.getRealLength() > 1) {
                        throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                    }
                    this.trail_tk_comp_value = tk;
                    break;
                }
                default: {
                    if (tk.isFigurativeZero()) {
                        this.trail_tk_comp_value = Inspect.cloneToken(tk, 10001, "'0'");
                        break;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            this.trail_delimPhrase = new InspectDelimPhrase(this.keyWord, this.parent, this.pc, this.tm, this.error, this.tm.getToken());
        }

        public void getCode(StringBuffer cnt, StringBuffer type, StringBuffer comp_val, StringBuffer bef_dlm, StringBuffer aft_dlm, StringBuffer trail_dlm) {
            Enumeration en = this.tallyingPhrases.elements();
            while (en.hasMoreElements()) {
                InspectTallyingPhrase tfp = (InspectTallyingPhrase)en.nextElement();
                cnt.append(this.counter.getCode());
                type.append(tfp.getCodeType());
                comp_val.append(tfp.getCodeCV());
                bef_dlm.append(tfp.delimPhrase.getCodeBef());
                aft_dlm.append(tfp.delimPhrase.getCodeAft());
                trail_dlm.append(tfp.delimPhrase.isTrailing);
                if (!en.hasMoreElements()) continue;
                cnt.append(",");
                type.append(",");
                comp_val.append(",");
                bef_dlm.append(",");
                aft_dlm.append(",");
                trail_dlm.append(",");
            }
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        @Override
        public String getCode() {
            return null;
        }
    }
}

