/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.As;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.lang.reflect.Modifier;

public class Invoke
extends Verb
implements CobolToken,
ErrorsNumbers,
GenericObject {
    public static final String prefix = "invoke$";
    public static final String _self = "this";
    public static final String _super = "super";
    private GenericObject nameObj;
    boolean lambdaExpr;
    private Invoke next;
    private String className;
    private int dimension;
    private Token methodToken;
    private VariableName methodVar;
    private VerbList usings = new VerbList();
    private VariableName returning;
    private As returningAs;
    private MyClass[] exceptions;
    private BlockException onException;
    private Block notOnException;
    private MyClass retType;
    private boolean not;
    private boolean isField;
    private boolean isInline;
    private boolean isStatic;
    private boolean isCall;
    private boolean universal;
    private boolean printEOL = true;
    private static final MyField CLASS_FIELD = new MyField("class", MyClass.getInstance(Class.class), 25);

    public Invoke(GenericObject vn, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.nameObj = vn;
        boolean bl = this.lambdaExpr = this.nameObj instanceof VariableName && ((VariableName)this.nameObj).isLambdaExpression();
        if (this.nameObj.isFactory()) {
            this.className = this.nameObj.getCType().getName();
            this.isStatic = true;
        }
        this.parseMethodName();
        this.parseInlineArgs();
        boolean b = this.tm.findConcat;
        this.tm.findConcat = false;
        Token tk = this.tm.getToken();
        this.tm.findConcat = b;
        if (tk.getToknum() == 10018) {
            if (this.lambdaExpr) {
                throw new GeneralErrorException(274, 4, this.getKeyWord(), tk.getWord(), this.error);
            }
            this.next = new Invoke(tk, tk, this.parent, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        this.isInline = true;
        this.endStmt = true;
    }

    public Invoke(Token tk, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        if (tk.getToknum() == 10001) {
            this.className = tk.getCode();
            this.isStatic = true;
        } else if ("SELF".equals(tk.getWord())) {
            this.className = _self;
        } else if ("SUPER".equals(tk.getWord())) {
            this.className = _super;
        } else if (tk.getToknum() == 10018) {
            this.className = "";
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        this.parseMethodName();
        this.parseInlineArgs();
        tk = this.tm.getToken();
        if (tk.getToknum() == 10018) {
            this.next = new Invoke(tk, tk, this.parent, this.pc, this.tm, this.error);
        } else {
            this.tm.ungetToken();
        }
        this.isInline = true;
        this.endStmt = true;
    }

    public Invoke(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        boolean direct = false;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            if ("SELF".equals(tk.getWord())) {
                if (this.tm.getToken().getToknum() == 10018) {
                    this.nameObj = new Invoke(tk, tk, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    this.className = _self;
                }
            } else if ("SUPER".equals(tk.getWord())) {
                if (this.tm.getToken().getToknum() == 10018) {
                    this.nameObj = new Invoke(tk, tk, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    this.className = _super;
                }
            } else {
                this.tm.ungetToken();
                this.nameObj = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
                direct = this.nameObj instanceof VariableName && ((VariableName)this.nameObj).getVarDecl() instanceof InlineInvoke;
                tk = this.tm.getToken();
                if (tk.getToknum() == 10018) {
                    this.nameObj = new Invoke((VariableName)this.nameObj, tk, this.parent, this.pc, this.tm, this.error);
                } else {
                    this.tm.ungetToken();
                    if (this.nameObj.isFactory()) {
                        this.className = this.nameObj.getCType().getName();
                        this.isStatic = true;
                    }
                }
            }
        } else if (tk.getToknum() == 10001) {
            if (this.tm.getToken().getToknum() == 10018) {
                this.nameObj = new Invoke(tk, tk, this.parent, this.pc, this.tm, this.error);
            } else {
                this.tm.ungetToken();
                this.className = tk.getCode();
                this.isStatic = true;
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (!direct) {
            this.parseMethodName();
        }
        boolean[] byCntnt = new boolean[]{false};
        boolean[] byValue = new boolean[]{false};
        tk = this.tm.getToken();
        if (tk.getToknum() == 803) {
            while ((tk = this.tm.getToken()).getToknum() == 312 || tk.getToknum() == 371 || tk.getToknum() == 804 || tk.getToknum() == 677 || tk.getToknum() == 10009 || tk.getToknum() == 10001 || tk.getToknum() == 10002 || tk.getToknum() == 781 || tk.getToknum() == 481 || tk.getToknum() == 613 || tk.getToknum() == 10017) {
                this.tm.ungetToken();
                this.usings.addItem(new Using(kw, par, p, t, err, byCntnt, byValue, true));
            }
        }
        if (tk.getToknum() == 695 || tk.getToknum() == 506) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
            if (tk.getToknum() == 280) {
                this.returningAs = new As(kw, par, p, t, err, this.returning);
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 599 || tk.getToknum() == 614 || tk.getToknum() == 473 || tk.getToknum() == 625) {
            Token overExcp;
            boolean on = false;
            if (tk.getToknum() == 599) {
                this.not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 614) {
                on = true;
                tk = this.tm.getToken();
            }
            if ((overExcp = tk).getToknum() == 473 || overExcp.getToknum() == 625) {
                if (this.not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(Exception.class));
                }
                tk = this.tm.getToken();
                if (!this.not && tk.getToknum() == 599) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != overExcp.getToknum()) {
                        throw new ExpectedFoundException(tk, this.error, "'" + overExcp.getWord() + "'");
                    }
                    this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 435) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    public Invoke getNext() {
        return this.next;
    }

    private void parseMethodName() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10001) {
            this.methodToken = tk;
        } else if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.methodVar = VariableName.getAny(this.tm, this.error, this.parent, this.pc, GetVarOpts.NO_OPTS);
            if (this.methodVar == null) {
                throw new GeneralErrorException(130, 4, this.keyWord, "", this.error);
            }
        } else {
            throw new GeneralErrorException(130, 4, this.keyWord, "", this.error);
        }
    }

    private void parseInlineArgs() throws GeneralErrorException, EndOfProgramException {
        boolean[] byCntnt = new boolean[]{false};
        boolean[] byValue = new boolean[]{false};
        if (this.tm.getToken().getToknum() == 40) {
            Token tk;
            while ((tk = this.tm.getToken()).getToknum() != 41) {
                if (this.lambdaExpr) {
                    throw new GeneralErrorException(274, 4, this.getKeyWord(), tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.usings.addItem(new Using(this.keyWord, this.parent, this.pc, this.tm, this.error, byCntnt, byValue, true));
            }
        } else {
            this.tm.ungetToken();
        }
    }

    private void adjustArgs(MyClass[] params) throws GeneralErrorException {
        Using u = (Using)this.usings.getFirst();
        for (int i = 0; u != null && i < params.length; ++i) {
            try {
                if (u.isCobolVarClass()) {
                    Token tk;
                    if (params[i].isPrimitive() || params[i].isClass(String.class)) {
                        u.setAs(params[i]);
                    } else if (u.getAs() == null && (tk = u.getNameToken()) != null && tk.getToknum() == 10001 && !tk.isHexdecimal() && !tk.isNational() && !tk.isResource() && params[i].isClass(Object.class)) {
                        u.setAs(MyClass.getInstance(String.class));
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            u = (Using)this.usings.getNext();
        }
    }

    private int checkCallArgs(MyClass[] params) throws GeneralErrorException {
        int Return2 = -1;
        if (this.usings.getItemNum() != 1) {
            return Return2;
        }
        if (params.length == 1 && params[0].isAssignableFrom(Object[].class)) {
            Return2 += 5;
        }
        return Return2;
    }

    private int _checkArgs(MyClass[] params) throws GeneralErrorException {
        int i;
        int Return2 = -1;
        if (this.usings.getItemNum() != params.length) {
            return Return2;
        }
        Return2 = 0;
        Using u = (Using)this.usings.getFirst();
        for (i = 0; i < params.length; ++i) {
            block21: {
                try {
                    if (u.isAssignableTo(params[i])) {
                        MyClass t = u.getType();
                        if (t != null && t.equals(params[i])) {
                            Return2 += 1000;
                        } else if (u.isTypeCobolVar() && !params[i].isCobolVar()) {
                            Return2 = u.isTypeNumericVar() ? (params[i].isString() ? (Return2 += 400) : (Return2 += 800)) : (params[i].isString() ? (Return2 += 800) : (Return2 += 400));
                        } else if (u.isPlainLiteral()) {
                            Return2 = u.isPlainStrLiteral() ? (params[i].isString() ? (Return2 += 800) : (Return2 += 400)) : (params[i].isString() ? (Return2 += 400) : (Return2 += 800));
                        } else if (t == null) {
                            Return2 += 900;
                        } else {
                            Return2 += 1000;
                            if (!t.equals(params[i])) {
                                Return2 -= 10;
                                if (t.isStrictPrimitive()) {
                                    if (params[i].isPrimitiveWrapper() && !t.equals(params[i].getWrappedType())) {
                                        Return2 -= 10;
                                    }
                                } else if (params[i].isStrictPrimitive()) {
                                    if (t.isPrimitiveWrapper() && !t.getWrappedType().equals(params[i])) {
                                        Return2 -= 10;
                                    }
                                } else {
                                    for (MyClass sc = t.getSuperclass(); sc != null && !sc.equals(params[i]); sc = sc.getSuperclass()) {
                                        Return2 -= 10;
                                    }
                                }
                            }
                        }
                        break block21;
                    }
                    if (!u.isAssignableTo(MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar")) || !params[i].isPrimitive() && !params[i].isClass(String.class)) break;
                    Return2 += 100;
                    throw new InternalErrorException("Unexpected behaviour Invoke.java line ~307");
                }
                catch (ClassNotFoundException e) {
                    throw new MissingClassException(e, this.keyWord, this.error);
                }
            }
            u = (Using)this.usings.getNext();
        }
        return i == params.length ? Return2 : -1;
    }

    private int checkArgs(MyClass[][] a_params, boolean isVarArgs) throws GeneralErrorException {
        MyClass[] params = a_params[0];
        int Return2 = this._checkArgs(params);
        if (Return2 == -1 && isVarArgs) {
            MyClass lastParam = params[params.length - 1];
            int usingLen = this.usings.getItemNum();
            if (usingLen >= params.length - 1 && lastParam.isArray()) {
                MyClass[] varParams = new MyClass[usingLen];
                if (usingLen == 0) {
                    Return2 = 400;
                } else {
                    int i;
                    for (i = 0; i < params.length - 1; ++i) {
                        varParams[i] = params[i];
                    }
                    while (i < usingLen) {
                        varParams[i] = params[params.length - 1].getComponentType();
                        ++i;
                    }
                    Return2 = this._checkArgs(varParams);
                }
                if (usingLen == params.length - 1) {
                    Return2 -= 10;
                }
                a_params[0] = varParams;
            }
        }
        return Return2;
    }

    private void checkType() throws GeneralErrorException {
        MyClass thisExtend;
        MyClass c = null;
        MyClass returningType = null;
        this.exceptions = new MyClass[0];
        String inhClass = this.pc.getInheritsClass();
        if (inhClass != null) {
            try {
                thisExtend = MyClass.getInstance(inhClass, this.pc);
            }
            catch (ClassNotFoundException e) {
                System.out.println("!ASSERT Invoke #1 " + inhClass);
                thisExtend = MyClass.getInstance(Object.class);
            }
        } else {
            thisExtend = MyClass.getInstance(Object.class);
        }
        if (this.returningAs != null) {
            this.returningAs.check();
        }
        if (this.nameObj != null) {
            if (this.nameObj.isSuper()) {
                this.className = _super;
                this.nameObj = null;
            } else if (this.nameObj.isSelf()) {
                if (this.pc.isFactory()) {
                    throw new GeneralErrorException(84, 4, this.keyWord, "SELF", this.error);
                }
                this.className = _self;
                this.nameObj = null;
            } else {
                this.nameObj.check();
                if (this.nameObj.getCType() == null) {
                    return;
                }
            }
        }
        if (this.className != null) {
            try {
                c = this.pc.existsClass(this.className);
                if (this.className.charAt(0) == '[') {
                    while (this.className.charAt(this.dimension) == '[') {
                        ++this.dimension;
                    }
                    if (this.className.length() - this.dimension == 1) {
                        switch (this.className.charAt(this.dimension)) {
                            case 'B': {
                                this.className = "byte";
                                break;
                            }
                            case 'C': {
                                this.className = "char";
                                break;
                            }
                            case 'S': {
                                this.className = "short";
                                break;
                            }
                            case 'I': {
                                this.className = "int";
                                break;
                            }
                            case 'J': {
                                this.className = "long";
                                break;
                            }
                            case 'F': {
                                this.className = "float";
                                break;
                            }
                            case 'D': {
                                this.className = "double";
                                break;
                            }
                            case 'Z': {
                                this.className = "boolean";
                            }
                        }
                    } else {
                        this.className = this.className.substring(this.dimension + 1, this.className.length() - 1);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new MissingClassException(this.className, this.keyWord, this.error);
            }
        }
        if (this.returning != null) {
            try {
                int idxCount;
                returningType = this.returning.getVarDecl().getType();
                int n = idxCount = this.returning.getIndexes() != null ? this.returning.getIndexes().getItemNum() : 0;
                if (idxCount > 0) {
                    returningType = MyClass.removeDimension(returningType, idxCount);
                }
            }
            catch (ClassNotFoundException e) {
                throw new MissingClassException(this.returning.getVarDecl().getTypeName(), this.keyWord, this.error);
            }
        }
        if (this.methodToken != null) {
            if ("new".equals(this.methodToken.getCode())) {
                MyClass mc;
                if (this.lambdaExpr) {
                    throw new GeneralErrorException(274, 4, this.keyWord, "new", this.error);
                }
                if (this.className != _super && c.isAbstract() && !c.isArray()) {
                    throw new GeneralErrorException(298, 4, this.keyWord, c.getName(), this.error);
                }
                if (this.className == _self) {
                    this.className = c.getName();
                }
                MyMethod ctorOk = null;
                MyClass[] ctorOkParams = null;
                MyClass[][] a_params = new MyClass[1][];
                int maxScore = -1;
                int found = 0;
                if (this.nameObj != null && !this.nameObj.isFactory() || this.className == null) {
                    throw new GeneralErrorException(76, 4, this.keyWord, "new", this.error);
                }
                this.retType = c;
                MyMethod[] ctor = c.getConstructors();
                for (int i = 0; i < ctor.length; ++i) {
                    a_params[0] = ctor[i].getParameterTypes();
                    int score = this.checkArgs(a_params, ctor[i].isVarArgs());
                    if (score > maxScore) {
                        ctorOk = ctor[i];
                        maxScore = score;
                        ctorOkParams = a_params[0];
                        found = 1;
                        continue;
                    }
                    if (score != maxScore) continue;
                    ++found;
                }
                if (ctorOk == null) {
                    throw new GeneralErrorException(80, 4, this.keyWord, this.toString(), this.error);
                }
                if (found > 1) {
                    this.error.print(222, 2, this.keyWord, this.methodToken.getCode());
                }
                if (!(this.returning == null || this.returning.getVarDecl().isObjectReference() && returningType.isAssignableFrom(c) || this.returningAs != null && (mc = this.returningAs.getType()) != null && returningType.isAssignableFrom(mc) && c.isAssignableFrom(mc))) {
                    throw new GeneralErrorException(79, 4, this.keyWord, "new", this.error);
                }
                this.exceptions = ctorOk.getExceptionTypes();
                this.adjustArgs(ctorOkParams);
                if (this.className == _super) {
                    Verb first;
                    if (!(this.pc instanceof CobolMethod)) {
                        throw new GeneralErrorException(88, 4, this.keyWord, "", this.error);
                    }
                    if (this.keyWord.getToknum() != 545) {
                        throw new GeneralErrorException(88, 4, this.keyWord, "", this.error);
                    }
                    boolean superInvoke = true;
                    if (this.parent != null && (this.parent.nesting != 0 || (first = this.parent.verbs.getFirst()) != null && first != this)) {
                        superInvoke = false;
                    }
                    if (!((CobolMethod)this.pc).isConstructor()) {
                        superInvoke = false;
                    }
                    if (superInvoke) {
                        ((CobolMethod)this.pc).setSuperInvoke(this);
                    } else {
                        this.className = c.getName();
                    }
                }
            } else {
                int score;
                int i;
                MyMethod[] mthd;
                MyField fld;
                MyMethod mthdOk = null;
                MyClass[] mthdOkParams = null;
                MyClass[][] a_params = new MyClass[1][];
                MyClass fldType = null;
                int maxScore = -1;
                int found = 0;
                boolean mnameFound = false;
                if (this.isStatic) {
                    if (!this.lambdaExpr && this.usings.getItemNum() == 0) {
                        try {
                            String methName = this.methodToken.getCode();
                            fld = this.isSelf() || this.isSuper() ? c.getField(methName, true) : (methName.equals("class") ? CLASS_FIELD : c.getField(methName, false));
                            if (Modifier.isStatic(fld.getModifiers())) {
                                fldType = fld.getType();
                            }
                        }
                        catch (NoSuchFieldException methName) {
                            // empty catch block
                        }
                    }
                    if (fldType != null) {
                        this.isField = true;
                    } else {
                        mthd = c.getMethods(false);
                        for (i = 0; i < mthd.length; ++i) {
                            if (!mthd[i].getName().equals(this.methodToken.getCode()) || !Modifier.isStatic(mthd[i].getModifiers())) continue;
                            mnameFound = true;
                            if (this.lambdaExpr) {
                                mthdOk = mthd[i];
                                mthdOkParams = mthd[i].getParameterTypes();
                                ++found;
                                continue;
                            }
                            a_params[0] = mthd[i].getParameterTypes();
                            score = this.checkArgs(a_params, mthd[i].isVarArgs());
                            if (score > maxScore) {
                                maxScore = score;
                                mthdOk = mthd[i];
                                mthdOkParams = a_params[0];
                                found = 1;
                                continue;
                            }
                            if (score != maxScore) continue;
                            ++found;
                        }
                    }
                } else {
                    if (c == null) {
                        c = this.nameObj.getCType();
                    }
                    if (!this.lambdaExpr && this.usings.getItemNum() == 0) {
                        if (c.isArray() && "length".equals(this.methodToken.getCode())) {
                            this.isField = true;
                            fldType = MyClass.getInstance(Integer.TYPE);
                        } else {
                            try {
                                if (this.isSuper()) {
                                    fld = thisExtend.getField(this.methodToken.getCode(), true);
                                } else {
                                    boolean self = this.isSelf();
                                    fld = c.getField(this.methodToken.getCode(), self);
                                    if (self) {
                                        fld.setUsed();
                                    }
                                }
                                fldType = fld.getType();
                            }
                            catch (NoSuchFieldException self) {
                                // empty catch block
                            }
                        }
                    }
                    if (fldType != null) {
                        this.isField = true;
                    } else {
                        mthd = c.getMethods(this.isSelf() || this.isSuper());
                        for (i = 0; i < mthd.length; ++i) {
                            if (!mthd[i].getName().equals(this.methodToken.getCode())) continue;
                            mnameFound = true;
                            if (this.lambdaExpr) {
                                ++found;
                                mthdOk = mthd[i];
                                mthdOkParams = mthd[i].getParameterTypes();
                                continue;
                            }
                            a_params[0] = mthd[i].getParameterTypes();
                            score = this.checkArgs(a_params, mthd[i].isVarArgs());
                            if (score > maxScore) {
                                maxScore = score;
                                mthdOk = mthd[i];
                                mthdOkParams = a_params[0];
                                this.isCall = false;
                                found = 1;
                                continue;
                            }
                            if ("call".equals(this.methodToken.getCode())) {
                                score = this.checkCallArgs(mthd[i].getParameterTypes());
                                if (score <= maxScore) continue;
                                maxScore = score;
                                mthdOk = mthd[i];
                                mthdOkParams = mthd[i].getParameterTypes();
                                this.isCall = true;
                                continue;
                            }
                            if (score != maxScore) continue;
                            ++found;
                        }
                    }
                }
                if (fldType == null && mthdOk == null) {
                    if (this.nameObj != null && this.nameObj.isUniversal()) {
                        this.universal = true;
                    } else {
                        if (mnameFound) {
                            throw new GeneralErrorException(80, 4, this.keyWord, this.toString(), this.error);
                        }
                        throw new GeneralErrorException(77, 4, this.keyWord, this.toString(true), this.error);
                    }
                }
                this.retType = fldType != null ? fldType : (mthdOk != null ? (this.lambdaExpr ? MyClass.getInstance(mthdOk) : mthdOk.getReturnType()) : MyClass.getInstance(Object.class));
                if (!this.isUniversal()) {
                    if (this.isField) {
                        if (this.returning != null && !Invoke.isReturningOk(this.returning, returningType, this.returningAs, fldType)) {
                            throw new GeneralErrorException(79, 4, this.keyWord, this.methodToken.getCode(), this.error);
                        }
                    } else {
                        boolean[] genPars;
                        if (found == 1 && mthdOk != null && mthdOk.isStatic() && (genPars = mthdOk.genericParameters()) != null) {
                            for (int i0 = 0; i0 < genPars.length && i0 < this.usings.getItemNum(); ++i0) {
                                if (!genPars[i0]) continue;
                                ((Using)this.usings.getAt(i0)).forceCast();
                            }
                        }
                        if (found > 1) {
                            if (this.lambdaExpr) {
                                throw new GeneralErrorException(275, 4, this.keyWord, this.methodToken.getCode(), this.error);
                            }
                            this.error.print(222, 2, this.keyWord, this.methodToken.getCode());
                        }
                        this.exceptions = mthdOk.getExceptionTypes();
                        if (!this.lambdaExpr) {
                            this.adjustArgs(mthdOkParams);
                            if (this.returning != null && !Invoke.isReturningOk(this.returning, returningType, this.returningAs, mthdOk.getReturnType())) {
                                throw new GeneralErrorException(79, 4, this.keyWord, this.methodToken.getCode(), this.error);
                            }
                        }
                    }
                }
            }
        }
        if (this.next != null) {
            this.next.className = this.retType.getName();
            this.next.checkType();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb u = this.usings.getFirst();
        while (u != null) {
            u.check();
            u = this.usings.getNext();
        }
        if (this.exceptions == null) {
            this.checkType();
        }
        if (this.onException == null && !this.lambdaExpr) {
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i].isAssignableTo(RuntimeException.class) || this.exceptions[i].isAssignableTo(Error.class) || this.parent == null || this.parent.isCaughtExcpt(this.exceptions[i])) continue;
                throw new GeneralErrorException(78, 4, this.keyWord, this.exceptions[i].getName(), this.error);
            }
        }
        if (this.next != null) {
            this.next.check();
        }
    }

    static boolean isReturningOk(VariableName returning, MyClass returningType, As returningAs, MyClass fldType) {
        MyClass mc;
        if (returningType.isAssignableFrom(fldType)) {
            return true;
        }
        if (!returning.getVarDecl().isObjectReference() && fldType.isPrimitive() || fldType.isAssignableTo(String.class)) {
            return true;
        }
        if (returningType != null && returningAs != null && (mc = returningAs.getType()) != null && returningType.isAssignableFrom(mc) && fldType.isAssignableFrom(mc)) {
            return true;
        }
        return fldType.isAssignableFrom(returningType);
    }

    String getConstructor(StringBuffer buf) {
        if (this.returning != null) {
            buf.append(this.returning.getCode());
            buf.append("=");
        }
        if (this.returningAs != null) {
            buf.append(this.returningAs.getCode());
        }
        buf.append(" new ");
        buf.append(this.className);
        if (this.dimension > 0) {
            int i = 0;
            if (this.usings.getItemNum() > 0) {
                Using u = (Using)this.usings.getFirst();
                while (u != null) {
                    buf.append('[');
                    buf.append(u.getCode());
                    buf.append(']');
                    u = (Using)this.usings.getNext();
                    ++i;
                }
            }
            while (i < this.dimension) {
                buf.append("[]");
                ++i;
            }
        } else {
            buf.append("(");
            if (this.usings.getItemNum() > 0) {
                Using u = (Using)this.usings.getFirst();
                while (true) {
                    buf.append(u.getCode());
                    u = (Using)this.usings.getNext();
                    if (u == null) break;
                    buf.append(",");
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    void unsetInLine() {
        this.isInline = false;
    }

    @Override
    public MyClass getCType() throws GeneralErrorException {
        return this.getType();
    }

    public MyClass getType() throws GeneralErrorException {
        if (this.exceptions == null) {
            this.checkType();
        }
        if (this.next != null) {
            return this.next.getType();
        }
        return this.retType;
    }

    @Override
    public String getCode() {
        if (this.isSuperConstructor()) {
            return "";
        }
        Pcc rootPcc = this.pc.getRoot();
        if (this.retType instanceof LambdaExpression) {
            String obj;
            if (this.isStatic && this.className != null) {
                obj = MyClass.getClassNameCode(this.className) + ".";
            } else if (this.nameObj != null) {
                obj = this.nameObj.getVariableName().getName() + ".";
            } else if (this.className == _super) {
                if (this.pc.isFactory()) {
                    obj = this.pc.getInheritsClass() + ".";
                } else {
                    obj = "";
                    if (rootPcc != this.pc) {
                        obj = obj + rootPcc.getFullClassName() + ".";
                    }
                    obj = obj + "super.";
                }
            } else {
                obj = this.className == _self ? (this.pc.isFactory() ? this.pc.getClassName() + "." : (rootPcc != this.pc ? (this.pc.isDefault() ? "$This$." : rootPcc.getFullClassName() + ".this.") : "")) : "";
            }
            return ((LambdaExpression)this.retType).getCode(obj);
        }
        String myIndent = this.parent == null ? "" : this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        if (this.keyWord.getToknum() == 545) {
            Return2.append(myIndent);
            if (!this.isInline) {
                this.getCodeDebug(Return2);
            }
            if (this.onException != null || this.notOnException != null) {
                Return2.append("try {");
                Return2.append(eol);
                myIndent = myIndent + "   ";
                Return2.append(myIndent);
            }
        }
        if (this.methodToken != null && "new".equals(this.methodToken.getCode())) {
            this.getConstructor(Return2);
        } else {
            if (this.returning != null) {
                if (this.returning.getVarDecl().isObjectReference()) {
                    Return2.append(this.returning.getVarDecl().getUnivoqueName());
                    Return2.append("=((");
                    Return2.append(this.returning.getVarDecl().getTypeName());
                    Return2.append(")");
                } else {
                    Return2.append(this.returning.getCode());
                    Return2.append(".set(");
                }
            }
            if (this.isUniversal()) {
                Return2.append("Factory.univInvoke (");
                Return2.append(this.nameObj.getCode());
                Return2.append(",\"");
                Return2.append(this.methodToken.getCode());
                Return2.append("\",");
                if (this.usings.getItemNum() > 0) {
                    Return2.append("new Object[] {");
                    Using u = (Using)this.usings.getFirst();
                    while (true) {
                        Return2.append(u.getCode());
                        u = (Using)this.usings.getNext();
                        if (u == null) break;
                        Return2.append(",");
                    }
                    Return2.append("}");
                } else {
                    Return2.append("null");
                }
                Return2.append(")");
            } else if (this.methodToken != null) {
                if (this.isStatic && this.className != null) {
                    Return2.append(MyClass.getClassNameCode(this.className));
                } else if (this.nameObj != null) {
                    Return2.append(this.nameObj.getCode());
                } else if (this.className == _super) {
                    if (this.pc.isFactory()) {
                        Return2.append(this.pc.getInheritsClass());
                    } else {
                        if (rootPcc != this.pc) {
                            Return2.append(rootPcc.getFullClassName() + ".");
                        }
                        Return2.append(_super);
                    }
                } else if (this.className == _self) {
                    if (this.pc.isFactory()) {
                        Return2.append(this.pc.getClassName() + ".");
                    } else if (rootPcc != this.pc) {
                        if (this.pc.isDefault()) {
                            Return2.append("$This$.");
                        } else {
                            Return2.append(rootPcc.getFullClassName() + ".this.");
                        }
                    }
                }
                if (this.className != _self) {
                    Return2.append(".");
                }
                Return2.append(this.methodToken.getCode());
                if (!this.isField) {
                    Return2.append("(");
                    if (this.usings.getItemNum() > 0) {
                        if (this.isCall) {
                            Return2.append("new Object[] {");
                            Using u = (Using)this.usings.getFirst();
                            while (true) {
                                Return2.append(u.getCode());
                                u = (Using)this.usings.getNext();
                                if (u == null) break;
                                Return2.append(",");
                            }
                            Return2.append("}");
                        } else {
                            Using u = (Using)this.usings.getFirst();
                            while (true) {
                                Return2.append(u.getCode());
                                u = (Using)this.usings.getNext();
                                if (u == null) break;
                                Return2.append(",");
                            }
                        }
                    }
                    Return2.append(")");
                }
            } else if (this.methodVar == null && this.nameObj != null) {
                Return2.append(this.nameObj.getCode());
            } else {
                Return2.append("Factory.univInvoke (");
                Return2.append(this.nameObj.getCode());
                Return2.append(",");
                Return2.append(this.methodVar.getCode());
                Return2.append(".toString().trim(),");
                if (this.usings.getItemNum() > 0) {
                    Return2.append("new Object[] {");
                    Using u = (Using)this.usings.getFirst();
                    while (true) {
                        Return2.append(u.getCode());
                        u = (Using)this.usings.getNext();
                        if (u == null) break;
                        Return2.append(",");
                    }
                    Return2.append("}");
                } else {
                    Return2.append("null");
                }
                Return2.append(")");
            }
            if (this.returning != null) {
                Return2.append(")");
            }
        }
        if (this.next != null) {
            Return2.append(this.next.getCode());
        }
        if (!this.isInline) {
            Return2.append(";");
        }
        if (this.printEOL) {
            Return2.append(eol);
        }
        if (this.keyWord.getToknum() == 545) {
            if (this.notOnException != null) {
                Return2.append(this.notOnException.getCode());
            }
            if (this.onException != null || this.notOnException != null) {
                Return2.append(this.parent.getIndent());
                Return2.append("} catch (Exception ");
                Return2.append(this.parent.getExceptName());
                Return2.append(")");
                if (this.onException != null) {
                    Return2.append(this.onException.getCode());
                } else {
                    Return2.append("{ }");
                }
            }
        }
        if (this.keyWord.getToknum() == 545 && !this.isInline) {
            this.getCodeDebugEnd(Return2);
        }
        return Return2.toString();
    }

    private static VariableDeclaration getRootVarDecl(VariableName v) {
        VariableDeclaration Return2 = v.getVarDecl();
        if (Return2 instanceof InlineInvoke) {
            VariableName vn = ((InlineInvoke)Return2).getInvoke().getVariableName();
            Return2 = vn != null ? vn.getVarDecl() : null;
        }
        return Return2;
    }

    public String getCode(VariableNameList args) {
        StringBuffer Return2 = new StringBuffer();
        String myIndent = this.parent == null ? "" : this.parent.getIndent();
        Return2.append(myIndent);
        if (!this.isSuperConstructor()) {
            this.getCodeDebug(Return2);
        }
        if (this.onException != null || this.notOnException != null) {
            Return2.append("try {");
            Return2.append(eol);
            myIndent = myIndent + "   ";
            Return2.append(myIndent);
        }
        Return2.append("super (");
        if (this.usings.getItemNum() > 0) {
            Using u = (Using)this.usings.getFirst();
            while (true) {
                VariableName vn1;
                if ((vn1 = u.getVariableName()) != null) {
                    VariableName vn2 = args.getFirst();
                    while (vn2 != null && Invoke.getRootVarDecl(vn1) != Invoke.getRootVarDecl(vn2)) {
                        vn2 = args.getNext();
                    }
                    if (vn2 != null) {
                        Return2.append(u.getCode());
                    } else {
                        Return2.append(u.getCode());
                    }
                } else {
                    Return2.append(u.getCode());
                }
                u = (Using)this.usings.getNext();
                if (u == null) break;
                Return2.append(",");
            }
        }
        Return2.append(");");
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("} catch (Exception ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            if (this.onException != null) {
                Return2.append(this.onException.getCode());
            } else {
                Return2.append("{ }");
            }
        }
        Return2.append(eol);
        if (!this.isSuperConstructor()) {
            this.getCodeDebugEnd(Return2);
        }
        return Return2.toString();
    }

    public boolean isField() {
        return this.isField;
    }

    @Override
    public boolean isPrimitive() {
        return this.retType.isPrimitive();
    }

    @Override
    public boolean isObjectReference() {
        return !this.retType.isPrimitive();
    }

    @Override
    public boolean isUniversal() {
        return this.universal;
    }

    @Override
    public boolean isCobolVar() {
        return this.retType.isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        return this.retType.isNumericVar();
    }

    @Override
    public boolean isFactory() {
        return false;
    }

    public boolean isSuperConstructor() {
        return this.className == _super && "new".equals(this.methodToken.getCode());
    }

    @Override
    public boolean isSelf() {
        return this.className == _self || this.nameObj != null && this.nameObj.isSelf();
    }

    @Override
    public boolean isSuper() {
        return this.className == _super || this.nameObj != null && this.nameObj.isSuper();
    }

    @Override
    public VariableName getVariableName() {
        return this.nameObj != null ? this.nameObj.getVariableName() : null;
    }

    boolean getPrintEOL() {
        return this.printEOL;
    }

    void setPrintEOL(boolean b) {
        this.printEOL = b;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean checkAs) {
        Using u;
        VariableName vn;
        StringBuffer Return2 = new StringBuffer();
        if (this.className != null) {
            Return2.append(this.className);
            Return2.append("::");
        } else if (this.nameObj != null && (vn = this.nameObj.getVariableName()) != null) {
            MyClass mc = vn.getType();
            if (mc != null) {
                Return2.append(mc.getName());
            } else {
                Return2.append(vn.getName());
            }
            Return2.append("::");
        }
        if (this.methodToken != null) {
            Return2.append(this.methodToken.getWord());
        }
        if (this.usings != null && (u = (Using)this.usings.getFirst()) != null) {
            Return2.append("(");
            while (true) {
                if (checkAs && u.getAs() != null) {
                    Return2.append(u.getAs().as);
                } else {
                    Return2.append(u.toString());
                }
                u = (Using)this.usings.getNext();
                if (u == null) break;
                Return2.append(",");
            }
            Return2.append(")");
        }
        return Return2.toString();
    }
}

