/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.interfaces.compiler.ILinkageSection;
import java.util.HashMap;

public class LinkageSection
implements CobolToken,
ErrorsNumbers,
ILinkageSection {
    static final Token lnkNull = new Token(10009, "$lnknull$", 0, 0, "");
    TokenManager tm;
    Errors error;
    Pcc pc;
    VariableDeclarationList vars = new VariableDeclarationList();
    private Token firstToken;
    private Token lastToken;
    private String serviceBridgeDecoration = "DEFAULT";
    private Token elkToken;
    HashMap<VariableDeclaration, Token> varargsItems = new HashMap();

    public LinkageSection() {
    }

    public LinkageSection(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, null);
    }

    public LinkageSection(Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, tk, null);
    }

    public LinkageSection(Pcc p, TokenManager t, Errors err, Token tk, WorkingStorageSection wsSec) throws GeneralErrorException, EndOfProgramException {
        this.init(p, t, err);
        this.firstToken = tk;
        TokenList xtlK = t.delExtraInfo("ELK");
        if (xtlK != null) {
            this.elkToken = xtlK.getFirst();
            if ("DECORATION".equalsIgnoreCase(xtlK.getNext().getWord())) {
                if (xtlK.getNext().getToknum() == 61) {
                    this.serviceBridgeDecoration = xtlK.getNext().getWord();
                    if (!this.serviceBridgeDecoration.equalsIgnoreCase("DEFAULT") && !this.serviceBridgeDecoration.equalsIgnoreCase("NONE")) {
                        this.error.print(226, 4, this.elkToken, this.serviceBridgeDecoration);
                    }
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        if ((tk = this.tm.getToken()).getToknum() == 710) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            while ((tk = this.tm.getToken()).getToknum() == 10002 || tk.getToknum() == 475 && wsSec != null) {
                if (tk.getToknum() == 10002) {
                    this.tm.ungetToken();
                    try {
                        VariableDeclaration vd = new VariableDeclaration(this, 0);
                        this.vars.addItem(vd);
                        this.pc.loadVariable(vd);
                        vd.calcOffset(this.pc, 0);
                        continue;
                    }
                    catch (GeneralErrorException e) {
                        this.tm.ungetToken();
                        while ((tk = this.tm.getToken()).getToknum() != 10006 && tk.getWord().length() > 1) {
                        }
                        continue;
                    }
                }
                wsSec.exec(tk);
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
        this.lastToken = tk;
        this.tm.ungetToken();
    }

    void init(Pcc p, TokenManager t, Errors err) {
        this.error = err;
        this.tm = t;
        this.pc = p;
    }

    void checkVarargsItems() {
        if (this.pc.procedure != null) {
            if (this.pc.procedure.usingVarargs != null) {
                this.varargsItems.remove(this.pc.procedure.usingVarargs);
            }
            for (Entry en : this.pc.entryPoints) {
                if (en.usingVarargs == null) continue;
                this.varargsItems.remove(en.usingVarargs);
            }
        }
        for (VariableDeclaration k : this.varargsItems.keySet()) {
            Token tk0 = this.varargsItems.get(k);
            String w = tk0.getWord();
            this.error.print(300, 3, tk0, w.substring(1, w.length() - 4) + "[]");
        }
    }

    VariableDeclaration checkUsingVarargs(VariableNameList using) throws GeneralErrorException {
        boolean last = true;
        VariableDeclaration usingVarargs = null;
        VariableName u = using.getLast();
        while (u != null) {
            if (this.varargsItems.containsKey(u.getVarDecl())) {
                if (last) {
                    usingVarargs = u.getVarDecl();
                } else {
                    throw new GeneralErrorException(301, 4, u.getNameToken(), u.getName(), this.error);
                }
            }
            last = false;
            u = using.getPrevious();
        }
        return usingVarargs;
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.tm.getCommentCode(this.firstToken, "   "));
        VariableDeclaration v = this.vars.getFirst();
        while (v != null) {
            Return2.append(v.getCode(true, dynPart));
            v = this.vars.getNext();
        }
        return Return2.toString();
    }

    @Override
    public String getServiceBridgeDecoration() {
        return this.serviceBridgeDecoration;
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

