/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;

public class NextSentenceBlock
extends Verb
implements CobolToken {
    private final String NAME_PREFIX = "$NextSentence$";
    private String name = "$NextSentence$" + prog++;
    private End end;
    private static int prog;
    private boolean alreadyPrinted;

    public NextSentenceBlock(Token kw, Block par, Pcc p, TokenManager t, Errors err) {
        super(kw, par, p, t, err);
        this.end = new End(this.name, kw, par, p, t, err);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    public End getEnd() {
        return this.end;
    }

    public static void resetCounters() {
        prog = 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        if (this.alreadyPrinted) {
            return "/* next sentence " + this.name + " */" + eol;
        }
        StringBuffer Return2 = new StringBuffer();
        if (this.getEnd().getDeferredMethodId() == this.getDeferredMethodId()) {
            Return2.append(this.parent.getIndent());
            Return2.append(this.name);
            Return2.append(": {");
            Return2.append(eol);
        } else {
            Return2.append("/* next sentence {start} " + this.name + " */" + eol);
        }
        this.getParent().getParent().setActNextSentence(this);
        this.alreadyPrinted = true;
        return Return2.toString();
    }

    public static class End
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        private String name;

        public End(String name, Token kw, Block par, Pcc p, TokenManager t, Errors err) {
            super(kw, par, p, t, err);
            this.name = name;
        }

        @Override
        public void check() throws GeneralErrorException {
        }

        @Override
        public String getCode() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append(this.parent.getIndent());
            Return2.append("} // ");
            Return2.append(this.name);
            Return2.append(" {end}");
            Return2.append(eol);
            this.getParent().getParent().setActNextSentence(null);
            return Return2.toString();
        }
    }
}

