/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.DuplicateParagraph;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MethodProcedure;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.ParagraphList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.SectionList;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.Stop;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IProcedureDivision;
import com.iscobol.rts.Config;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ProcedureDivision
implements CobolToken,
ErrorsNumbers,
IProcedureDivision {
    TokenManager tm;
    Errors error;
    Pcc parent;
    private HashSet byValueVars = new HashSet();
    VariableNameList using = new VariableNameList();
    VariableDeclaration usingVarargs;
    VariableNameList chaining = new VariableNameList();
    ParagraphList pList = new ParagraphList();
    ParagraphList dList = new ParagraphList();
    SectionList sList = new SectionList();
    SectionList dsList = new SectionList();
    VariableName returning;
    VariableNameList raising;
    private Token firstToken;
    private int fileNumber;
    private Token startDeclaratives;
    private Token endDeclaratives;
    private Token elkToken;
    private String serviceBridgeOperation = null;

    public ProcedureDivision(Pcc pc, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        this(pc, t, err, tk, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProcedureDivision(Pcc pc, TokenManager t, Errors err, Token tk, boolean shortSignature, boolean shortSignatureRet) throws GeneralErrorException, EndOfProgramException {
        Paragraph p;
        VariableName vn;
        boolean isInterface;
        pc.inProcedure = true;
        this.error = err;
        t.findConcat = true;
        TokenList xtlK = t.delExtraInfo("ELK");
        if (xtlK != null) {
            this.elkToken = xtlK.getFirst();
            if ("OPERATION".equalsIgnoreCase(xtlK.getNext().getWord())) {
                if (xtlK.getNext().getToknum() == 61) {
                    this.serviceBridgeOperation = xtlK.getNext().getWord();
                } else {
                    this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
                }
            } else {
                this.error.print(226, 4, this.elkToken, this.elkToken.getWord());
            }
        }
        this.firstToken = tk;
        this.parent = pc;
        this.tm = t;
        tk = this.tm.getToken();
        this.fileNumber = tk.getFileIndex();
        boolean bl = isInterface = pc.getRoot().isInterface() && !((CobolMethod)pc).isDefault() && !((CobolMethod)pc).isStatic();
        if (tk.getToknum() != 411) {
            throw new ExpectedFoundException(tk, this.error, "DIVISION");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 803 || tk.getToknum() == 10009) {
            if (shortSignature) {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            if (tk.getToknum() == 10009) {
                this.error.print(31, 2, tk, "expected . found " + tk.getWord());
                this.tm.ungetToken();
            }
            boolean byValue = false;
            while ((tk = this.tm.getToken()).getToknum() == 10009 || tk.getToknum() == 312 || tk.getToknum() == 804 || tk.getToknum() == 677) {
                if (tk.getToknum() == 312) {
                    this.isByValueAllowed(tk);
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 804) {
                        byValue = true;
                    } else {
                        if (tk.getToknum() != 677) throw new ExpectedFoundException(tk, this.error, "VALUE|REFERENCE");
                        byValue = false;
                    }
                } else if (tk.getToknum() == 804) {
                    this.isByValueAllowed(tk);
                    byValue = true;
                } else if (tk.getToknum() == 677) {
                    this.isByValueAllowed(tk);
                    byValue = false;
                } else {
                    this.tm.ungetToken();
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                vn = VariableName.getAnyUsing(this.tm, this.error, null, pc);
                if (!this.isInLinkage(vn.getVarDecl())) throw new GeneralErrorException(139, 4, vn.getNameToken(), vn.getName(), this.error);
                if (vn.getDimension() > 0) {
                    throw new GeneralErrorException(55, 4, vn.getNameToken(), vn.getName(), this.error);
                }
                if (this instanceof MethodProcedure && vn.getVarDecl().getRedefines() != null) {
                    throw new GeneralErrorException(19, 4, vn.getNameToken(), "REDEFINES " + vn.getName(), this.error);
                }
                this.using.addItem(vn);
                if (byValue) {
                    this.byValueVars.add(vn);
                }
                if (vn.getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
            }
        } else if (tk.getToknum() == 322) {
            if (shortSignature) {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            if (isInterface) {
                throw new GeneralErrorException(246, 4, tk, tk.getWord(), this.error);
            }
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.getAnyUsing(this.tm, this.error, null, pc);
                int vnDim = vn.getDimension();
                VariableDeclaration vd = vn.getVarDecl();
                int vdDim = vd.getDimension() + vd.getDyDimension();
                int d = vdDim - vnDim;
                if (d < 0) {
                    throw new GeneralErrorException(41, 4, vn.getNameToken(), vn.getNameToken().getWord(), this.error);
                }
                if (d > 0 && !vd.isObjectReference()) {
                    SubscriptList sl = vn.getIndexes();
                    if (sl == null) {
                        sl = new SubscriptList();
                    }
                    for (int i = 0; i < d; ++i) {
                        sl.addItem(Subscript.get("1"));
                    }
                    vn.setIndexes(sl);
                }
                this.chaining.addItem(vn);
                if (vn.getVarDecl().parent == null) continue;
                throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
            }
        }
        if (this.parent.data != null && this.parent.data.linkSec != null) {
            this.usingVarargs = this.parent.data.linkSec.checkUsingVarargs(this.using);
        }
        if (this.tm.getOptionList().getOption("-wlu") != null) {
            this.checkUsingWithLinkage();
        }
        if (tk.getToknum() == 695) {
            if (shortSignatureRet) {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.returning = VariableName.getAny(this.tm, this.error, null, pc, GetVarOpts.DYN_GRP_ALLOW);
            tk = this.tm.getToken();
        }
        if (this instanceof MethodProcedure && tk.getToknum() == 664) {
            this.raising = new VariableNameList();
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.getObject(this.tm, this.error, null, pc);
                if (vn == null) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                if (!vn.getType().isAssignableTo(Throwable.class) || !vn.getVarDecl().isFactory) {
                    throw new GeneralErrorException(75, 4, tk, vn.getType().getName(), this.error);
                }
                this.raising.addItem(vn);
            }
            if (this.raising.getItemNum() == 0) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
        }
        if (tk.getToknum() != 10006) {
            throw new ExpectedFoundException(tk, this.error, "'.'");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 395) {
            pc.inDeclaratives = true;
            this.startDeclaratives = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006) {
                throw new ExpectedFoundException(tk, this.error, ".");
            }
        } else {
            this.tm.ungetToken();
        }
        boolean goOn = true;
        block12: while (goOn) {
            try {
                tk = this.tm.getToken();
            }
            catch (EndOfProgramException e) {
                break;
            }
            if (tk.isConst()) {
                tk = tk.constToUsername();
            }
            switch (tk.getToknum()) {
                case 395: {
                    if (isInterface) {
                        throw new GeneralErrorException(248, 4, tk, tk.getWord(), this.error);
                    }
                    pc.inDeclaratives = false;
                    this.endDeclaratives = tk;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10006) continue block12;
                    throw new ExpectedFoundException(tk, this.error, ".");
                }
                case 10002: 
                case 10009: {
                    if (isInterface) {
                        throw new GeneralErrorException(248, 4, tk, tk.getWord(), this.error);
                    }
                    if (pc.inDeclaratives) {
                        p = this.getParagraph(tk.getWord(), true);
                        if (p != null) {
                            p.setIsDup();
                            Paragraph p1 = new Paragraph(pc, tk, this.tm, this.error, true, this);
                            this.dList.addItem(p1);
                            if (!p.isSection && !p1.isSection) continue block12;
                            this.error.print(67, 4, tk, tk.getWord());
                            continue block12;
                        }
                        this.dList.addItem(new Paragraph(pc, tk, this.tm, this.error, false, this));
                        continue block12;
                    }
                    p = this.getParagraph(tk.getWord(), false);
                    if (p != null) {
                        p.setIsDup();
                        this.pList.addItem(new Paragraph(pc, tk, this.tm, this.error, true, this));
                        continue block12;
                    }
                    this.pList.addItem(new Paragraph(pc, tk, this.tm, this.error, false, this));
                    continue block12;
                }
                case 423: {
                    Token tk2 = this.tm.getToken();
                    if (tk2.getToknum() == 395) {
                        if (isInterface) {
                            throw new GeneralErrorException(248, 4, tk, tk.getWord(), this.error);
                        }
                        if (!pc.inDeclaratives) throw new UnexpectedTokenException(tk, this.error);
                        pc.inDeclaratives = false;
                        this.endDeclaratives = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 10006) continue block12;
                        throw new ExpectedFoundException(tk, this.error, ".");
                    }
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                    goOn = false;
                    continue block12;
                }
                case 501: 
                case 522: 
                case 523: 
                case 655: {
                    this.tm.ungetToken();
                    goOn = false;
                    continue block12;
                }
            }
            this.tm.ungetToken();
            Token parTk = new Token(10009, "PROCEDURE", tk.getFLN(), 0, tk.getFileName());
            parTk.setFileIndex(tk.getFileIndex());
            Paragraph par = new Paragraph(pc, parTk, this.tm, this.error, this);
            if (isInterface && par.getBlock().getVerbs().getItemNum() > 0) {
                Verb v = par.getBlock().getVerbs().getFirst();
                throw new GeneralErrorException(248, 4, v.getKeyWord(), v.getKeyWord().getWord(), this.error);
            }
            par.setParagraphCodeLimit();
            this.pList.addItem(par);
        }
        Section sect = null;
        int i = 1;
        p = this.pList.getFirst();
        while (p != null) {
            p.setIdNumber(i);
            if (p.isSection) {
                if (sect != null) {
                    sect.check();
                }
                sect = new Section(p.getName());
                this.sList.addItem(sect);
            }
            if (sect != null) {
                sect.addParagraph(p);
                p.setSection(sect);
            }
            ++i;
            p = this.pList.getNext();
        }
        if (sect != null) {
            sect.check();
            sect = null;
        }
        i = 1;
        p = this.dList.getFirst();
        while (p != null) {
            p.setIdNumber(i);
            if (p.isSection) {
                if (sect != null) {
                    sect.check();
                }
                sect = new Section(p.getName());
                this.dsList.addItem(sect);
            }
            if (sect != null) {
                sect.addParagraph(p);
                p.setSection(sect);
            }
            ++i;
            p = this.dList.getNext();
        }
        if (sect != null) {
            sect.check();
        }
        if (!pc.inDeclaratives) return;
        throw new GeneralErrorException(12, 4, tk, "in DECLARATIVE", this.error);
    }

    protected void isByValueAllowed(Token tk) throws GeneralErrorException {
    }

    private boolean isInLinkage(VariableDeclaration vd) {
        return this.parent.data != null && this.parent.data.linkSec != null && this.parent.data.linkSec.vars != null && this.parent.data.linkSec.vars.exists(vd);
    }

    private void checkUsingWithLinkage() {
        if (this.parent.data != null && this.parent.data.linkSec != null && this.parent.data.linkSec.vars != null) {
            VariableName vnu = null;
            String mess = null;
            VariableDeclarationList undList = new VariableDeclarationList();
            undList.addListObject(this.parent.data.linkSec.vars);
            VariableDeclaration vdl = this.parent.data.linkSec.vars.getFirst();
            while (vdl != null) {
                if (this.using != null) {
                    vnu = this.using.getFirst();
                    while (vnu != null) {
                        if (vnu.getVarDecl() == vdl) {
                            if (vdl.getRedefinesVar() != null) {
                                while ((vdl = vdl.getRedefinesVar()) != null) {
                                    undList.deleteObject(vdl);
                                }
                            } else {
                                undList.deleteObject(vdl);
                            }
                        }
                        vnu = this.using.getNext();
                    }
                }
                vdl = this.parent.data.linkSec.vars.getNext();
            }
            vdl = undList.getFirst();
            while (vdl != null) {
                if (vdl.getRedefinesVar() == null) {
                    mess = mess == null ? vdl.getName() : mess + "," + vdl.getName();
                }
                vdl = undList.getNext();
            }
            if (mess != null) {
                this.error.print(211, 2, this.firstToken, mess);
            }
        }
    }

    public int getParCount() {
        return this.pList.getItemNum();
    }

    public void check() throws GeneralErrorException {
        Paragraph p = this.pList.getFirst();
        while (p != null) {
            p.check();
            p = this.pList.getNext();
        }
    }

    private void entryPointCode(StringBuffer Return2) {
        if (this.parent.entryPoints.size() == 0) {
            return;
        }
        Return2.append("   ");
        if (!this.parent.getSplitFlag()) {
            Return2.append("private ");
        }
        Return2.append("String $entryPoints[] = {");
        Iterator<Entry> el = this.parent.entryPoints.iterator();
        while (true) {
            Return2.append(el.next().getName());
            if (!el.hasNext()) break;
            Return2.append("," + eol);
        }
        Return2.append(eol);
        Return2.append("   };" + eol);
        Return2.append("   public String[] getEntryPoints () {" + eol);
        Return2.append("      return $entryPoints;" + eol);
        Return2.append("   }" + eol);
        Return2.append("   public Object call (int ep, Object[] argv) {" + eol);
        Return2.append("      " + this.getSwitchesCode());
        Return2.append(eol);
        Return2.append("      int go;" + eol);
        Return2.append("      com.iscobol.rts.Version.checkVersion (");
        if (this.parent.getSplitFlag()) {
            Return2.append(this.parent.getClassName() + ".");
        }
        Return2.append("this);" + eol);
        Return2.append("      final int argl=(argv==null)?0:argv.length;");
        Return2.append(eol);
        Return2.append("      switch(ep) {" + eol);
        int parCount = this.getParCount();
        Object[] epa = this.parent.entryPoints.toArray();
        boolean clk0 = this.parent.getOption("-clk0") != null;
        for (int i = 0; i < this.parent.entryPoints.size(); ++i) {
            Entry en = (Entry)epa[i];
            Return2.append("      case " + i + ":" + eol);
            if (en.using.getItemNum() > 0) {
                ProcedureDivision.usingCode(en.using, null, en.usingVarargs, clk0, false, Return2);
            }
            this.prePutPerform(Return2, "   ");
            Paragraph par = en.getParent().parent;
            if (this.tm.getOptionList().getOption("-d") != null) {
                Return2.append("         ");
                par.getDebugEnterCode(Return2, en.getName());
                Return2.append(eol);
            }
            Return2.append("            if ((go=");
            Return2.append(en.getMethodName());
            Return2.append(") > 0) perform (go,");
            Return2.append(parCount);
            Return2.append(");");
            int parNum = par.getIdNumber() + 1;
            if (parNum <= parCount) {
                Return2.append(eol);
                Return2.append("            else perform (");
                Return2.append(parNum);
                Return2.append(",");
                Return2.append(parCount);
                Return2.append(");");
            }
            Return2.append(eol);
            Return2.append("         } catch (GotoException ex$) { ");
            Return2.append(eol);
            Return2.append("           perform (ex$.parNum,");
            Return2.append(parCount);
            Return2.append(");");
            Return2.append(eol);
            this.postPutPerform(Return2, "   ");
            Return2.append("         break;" + eol);
        }
        Return2.append("      }" + eol);
        Return2.append("      return ");
        if (this.returning != null) {
            Return2.append(this.returning.getCode());
        } else {
            Return2.append(Verb.getReturnCode(this.parent.capitalizeNames));
        }
        Return2.append(";" + eol);
        Return2.append("   }" + eol);
    }

    private static void usingCode(VariableNameList usng, HashSet bValVar, VariableDeclaration usingVarargs, boolean optClk0, boolean isFunc, StringBuffer Return2) {
        VariableDeclaration vdr;
        VariableDeclaration vd;
        int i;
        Return2.append(eol);
        String varargsType = null;
        if (usingVarargs != null) {
            Return2.append("      ");
            Return2.append(usingVarargs.getUnivoqueName());
            Return2.append("= new ");
            varargsType = usingVarargs.getTypeName();
            varargsType = varargsType.substring(0, varargsType.length() - 2);
            Return2.append(varargsType);
            Return2.append("[0];");
            Return2.append(eol);
        }
        Return2.append("      switch (argl) {");
        Return2.append(eol);
        Return2.append("      default:" + eol);
        int n = usng.getItemNum();
        if (usingVarargs != null) {
            Return2.append("      ");
            Return2.append(usingVarargs.getUnivoqueName());
            Return2.append("= new ");
            Return2.append(varargsType);
            Return2.append("[argv.length - ");
            Return2.append(n - 1);
            Return2.append("];");
            Return2.append(eol);
            Return2.append("      for(int i = ");
            Return2.append(n - 1);
            Return2.append(", j = 0; i < argv.length; i++, j++)");
            Return2.append(eol);
            Return2.append("         ");
            Return2.append(usingVarargs.getUnivoqueName());
            Return2.append("[j] = (");
            Return2.append(varargsType);
            Return2.append(") argv[i];");
            Return2.append(eol);
            --n;
        }
        for (i = n; i > 0; --i) {
            Return2.append("      case ");
            Return2.append(i);
            Return2.append(": ");
            VariableName vn = usng.getAt(i - 1);
            vd = vn.getVarDecl();
            while ((vdr = vd.getRedefinesVar()) != null) {
                vd = vdr;
            }
            if (isFunc) {
                if (vd.isObjectReference()) {
                    Return2.append(vd.getUnivoqueName());
                    Return2.append("=(");
                    Return2.append(vd.getTypeName());
                    Return2.append(")argv[");
                    Return2.append(i - 1);
                    Return2.append("];" + eol);
                    continue;
                }
                Return2.append(eol + "         if(argv[");
                Return2.append(i - 1);
                Return2.append("] instanceof CobolVar) {" + eol);
                Return2.append("            ");
                Return2.append(vd.getUnivoqueName());
                Return2.append(".link((CobolVar)argv[");
                Return2.append(i - 1);
                Return2.append("]);" + eol);
                Return2.append("         } else {" + eol);
                Return2.append("            ");
                Return2.append(vd.getUnivoqueName());
                Return2.append(".set(argv[");
                Return2.append(i - 1);
                Return2.append("]);" + eol);
                Return2.append("         }" + eol);
                continue;
            }
            Return2.append(vd.getUnivoqueName());
            if (vd.isObjectReference()) {
                Return2.append("=(");
                Return2.append(vd.getTypeName());
                Return2.append(")argv[");
                Return2.append(i - 1);
                Return2.append("];");
            } else {
                Return2.append(".link((CobolVar)argv[");
                Return2.append(i - 1);
                Return2.append("]);");
            }
            Return2.append(eol);
        }
        Return2.append("      case 0: break;");
        Return2.append(eol);
        Return2.append("      }" + eol);
        if (optClk0) {
            Return2.append("      switch (argl) {");
            Return2.append(eol);
            for (i = 0; i < n; ++i) {
                Return2.append("      case ");
                Return2.append(i);
                Return2.append(": ");
                vd = usng.getAt(i).getVarDecl();
                while ((vdr = vd.getRedefinesVar()) != null) {
                    vd = vdr;
                }
                Return2.append(vd.getUnivoqueName());
                if (vd.isObjectReference()) {
                    String cn = vd.getClassName();
                    if ("boolean".equals(cn)) {
                        Return2.append(" = false;");
                    } else if ("byte".equals(cn)) {
                        Return2.append(" = (byte) 0;");
                    } else if ("char".equals(cn)) {
                        Return2.append(" = (char) 0;");
                    } else if ("short".equals(cn) || "int".equals(cn) || "long".equals(cn) || "float".equals(cn) || "double".equals(cn)) {
                        Return2.append(" = 0;");
                    } else {
                        Return2.append(" = null;");
                    }
                } else {
                    Return2.append(".link(");
                    Return2.append(LinkageSection.lnkNull.getCode());
                    Return2.append(");");
                }
                Return2.append(eol);
            }
            Return2.append("      }" + eol);
        }
    }

    private void prePutPerform(StringBuffer Return2, String indent) {
        Use atProgramStart;
        boolean debug;
        Return2.append(indent + "      try {" + eol);
        boolean bl = debug = this.tm.getOptionList().getOption("-d") != null;
        if (debug) {
            Return2.append(indent);
            this.getDebugEnterCode(Return2);
            Return2.append(eol);
        }
        if ((atProgramStart = this.parent.getAtProgramStart()) != null) {
            Return2.append(indent + "         if (atProgramStart) {" + eol);
            Return2.append(indent + "            try {" + eol);
            Return2.append(indent + "               declaratives(" + atProgramStart.parag.getIdNumber() + "," + atProgramStart.parag.getLastParagraphInSameSection().getIdNumber() + ");" + eol);
            Return2.append(indent + "            } catch (GotoException e) {" + eol);
            Return2.append(indent + "               perform (e.parNum, " + this.getParCount() + ");" + eol);
            Return2.append(indent + "           }" + eol);
            Return2.append(indent + "           atProgramStart = false;" + eol);
            Return2.append(indent + "         }" + eol);
        }
    }

    private void putPerform(StringBuffer Return2, int start, int end) {
        this.prePutPerform(Return2, "");
        Return2.append("         perform (" + start + "," + end + ");" + eol);
        this.postPutPerform(Return2, "");
    }

    boolean isFunction() {
        return this.parent instanceof CobolProgram && ((CobolProgram)this.parent).isFunction();
    }

    private void postPutPerform(StringBuffer Return2, String indent) {
        boolean debug = this.tm.getOptionList().getOption("-d") != null;
        Return2.append(indent + "      } catch (GobackException ex$) { " + eol);
        if (!this.isFunction()) {
            Return2.append(indent + "         if(ex$.getReturnValue()!=null) {" + eol);
            Return2.append(indent + "            return ex$.getReturnValue();" + eol);
            Return2.append(indent + "         }" + eol);
        }
        Return2.append(indent + "      } finally { " + eol);
        if (debug) {
            Return2.append(indent + "      ");
            ProcedureDivision.getDebugExitCode(Return2);
            Return2.append(eol);
        }
        CobolProgram cp = (CobolProgram)this.parent;
        if (this.isFunction()) {
            Return2.append(this.parent.getFinalizeCode());
        } else if (this.tm.getOptionList().getOption("-coe") != null || this.tm.getOptionList().getOption("-zi") != null || cp.getProgramIdentificationDivision().getProgramType() == 532) {
            Return2.append(indent + "         myFinalize();" + eol);
        }
        Return2.append(indent + "      }" + eol);
        if (this.parent.data != null && this.parent.data.screenSec != null || this.parent.useScreen) {
            Return2.append(eol);
        }
    }

    private String getSwitchesCode() {
        EnvironmentDivision e = this.parent.getEnvironmentDivision();
        if (e != null) {
            ConfigurationSection c = e.getConfigurationSection();
            if (c != null) {
                SpecialNames sn = c.getSpecialNames();
                if (sn != null) {
                    return sn.getSwitchesCode(new StringBuffer());
                }
                return "";
            }
            return "";
        }
        return "";
    }

    private void callCode(StringBuffer Return2) {
        boolean isFunc = this.isFunction();
        if (isFunc) {
            Return2.append("   @Override" + eol);
            Return2.append("   public ");
            if (this.returning != null) {
                Return2.append(this.returning.getType().getName());
            } else {
                Return2.append("NumericVar");
            }
            Return2.append(" apply(Object argv[]) {" + eol);
        } else {
            Return2.append("   public Object call(Object argv[]) {" + eol);
        }
        if (this.parent.getEnclosingProgram() == null) {
            Return2.append("      com.iscobol.rts.Version.checkVersion (");
            if (this.parent.getSplitFlag()) {
                Return2.append(this.parent.getClassName() + ".");
            }
            Return2.append("this);" + eol);
        }
        Return2.append("      " + this.getSwitchesCode());
        if (this.using.getItemNum() > 0) {
            Return2.append("final int argl=(argv==null)?0:argv.length;");
            Return2.append(eol);
            ProcedureDivision.usingCode(this.using, this.byValueVars, this.usingVarargs, this.parent.getOption("-clk0") != null, isFunc, Return2);
        } else if (!isFunc && this.chaining.getItemNum() > 0) {
            Return2.append("      if (argv != null) {" + eol);
            Return2.append("         switch (argv.length - 1) {" + eol);
            Return2.append("         default:" + eol);
            VariableName vn = this.chaining.getLast();
            int i = this.chaining.getItemNum() - 1;
            while (vn != null) {
                Return2.append("         case ");
                Return2.append(i);
                Return2.append(": if (argv[");
                Return2.append(i);
                Return2.append("] instanceof CobolVar)");
                Return2.append(eol);
                Return2.append("               ");
                Return2.append(vn.getCode());
                Return2.append(".set((CobolVar)argv[");
                Return2.append(i);
                Return2.append("]);");
                Return2.append(eol);
                Return2.append("            else");
                Return2.append(eol);
                Return2.append("               ");
                Return2.append(vn.getCode());
                Return2.append(".set(argv[");
                Return2.append(i);
                Return2.append("]);" + eol);
                vn = this.chaining.getPrevious();
                --i;
            }
            Return2.append("         case -1:" + eol);
            Return2.append("         }" + eol);
            Return2.append("      }" + eol);
        } else if (!isFunc) {
            boolean genCmdlineCode;
            boolean bl = genCmdlineCode = !this.parent.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_cmdline_code", false);
            if (genCmdlineCode && this.parent.getEnclosingProgram() == null) {
                Return2.append("if (gArgs == null && argv != null) {" + eol);
                Return2.append("         gArgs = new String[argv.length];" + eol);
                Return2.append("         for (int i = 0; i < argv.length; i++) {" + eol);
                Return2.append("            if (argv[i] != null) {" + eol);
                Return2.append("               gArgs[i] = argv[i].toString();" + eol);
                Return2.append("            }" + eol);
                Return2.append("         }" + eol);
                Return2.append("         Factory.get().gArgs = gArgs;" + eol);
                Return2.append("      }" + eol);
            }
        }
        this.putPerform(Return2, 1, this.getParCount());
        Return2.append("      return ");
        if (this.returning != null) {
            Return2.append(this.returning.getCode());
        } else {
            Return2.append(Verb.getReturnCode(this.parent.capitalizeNames));
        }
        Return2.append(";" + eol);
        Return2.append("   }" + eol);
    }

    private void performCode(StringBuffer Return2, int begin, int end) {
        boolean isFirst = begin == 1;
        boolean isLast = end == this.pList.getItemNum();
        int index = begin / 1500 + 1;
        if (isFirst) {
            Return2.append("   public void perform (int begin, int end) {" + eol);
        } else {
            Return2.append("   private int perform$" + index + " (int begin, int end) throws GotoException, ExitSectionException {" + eol);
        }
        if (end > 0) {
            if (isFirst) {
                Return2.append("      boolean goOn = true;" + eol);
                Return2.append("      while (goOn) {" + eol);
                Return2.append("         try {" + eol);
            }
            Return2.append("            switch (begin) {" + eol);
            for (int i = begin; i <= end; ++i) {
                Paragraph p = this.pList.getAt(i - 1);
                Return2.append("            case " + i + ":" + eol);
                if (p.hasGoto()) {
                    Return2.append("               if ((begin = ");
                    Return2.append(p.getJavaName());
                    if (isFirst) {
                        Return2.append("()) > 0) break;");
                    } else {
                        Return2.append("()) > 0) return begin;");
                    }
                } else {
                    Return2.append("               begin = ");
                    Return2.append(p.getJavaName());
                    Return2.append("();");
                }
                Return2.append(eol);
                Return2.append("               if (end == " + i + ") {" + eol);
                if (isFirst) {
                    Return2.append("                  goOn = false;" + eol);
                }
                Return2.append("                  break;" + eol);
                Return2.append("               }" + eol);
                if (isLast || i != end) continue;
                Return2.append("               begin = " + (end + 1) + ";" + eol);
            }
            Return2.append("            default:" + eol);
            if (!isLast) {
                Return2.append("               if ((begin = perform$");
                Return2.append(index + 1);
                if (isFirst) {
                    Return2.append("(begin, end)) > 0) break;");
                } else {
                    Return2.append("(begin, end)) > 0) return begin;");
                }
                Return2.append(eol);
            }
            if (isFirst) {
                Return2.append("               goOn = false;" + eol);
            }
            Return2.append("               break;" + eol);
            Return2.append("            }" + eol);
            if (isFirst) {
                Return2.append("         } catch (GotoException e) {" + eol);
                Return2.append("            begin = e.parNum;" + eol);
                Return2.append("         } catch (ExitSectionException e) {" + eol);
                Return2.append("            goOn = false;" + eol);
                Return2.append("         }" + eol);
                Return2.append("      }" + eol);
            } else {
                Return2.append("         return 0;" + eol);
            }
        }
        Return2.append("   }" + eol);
    }

    public int getCode(StringBuffer Return2, int innerClassCount) {
        boolean pt2;
        Paragraph p;
        int i = 0;
        Return2.append(this.tm.getCommentCode(this.firstToken, "   "));
        if (innerClassCount > 0) {
            Return2.append(eol + "      public class " + "inner_" + innerClassCount + " extends " + "inner_" + (innerClassCount - 1));
            Return2.append(" {" + eol);
            Return2.append("   public inner_" + innerClassCount + "() {}" + eol);
            ++innerClassCount;
            p = this.dList.getFirst();
            while (p != null) {
                if (i > 0 && i % Pcc.MAX_PARAGRAPHS == 0) {
                    Return2.append("      }");
                    Return2.append(eol + "      public class " + "inner_" + innerClassCount + " extends " + "inner_" + (innerClassCount - 1));
                    Return2.append(" {" + eol);
                    Return2.append("   public inner_" + innerClassCount + "() {}" + eol);
                    ++innerClassCount;
                }
                Return2.append(p.getCode());
                p = this.dList.getNext();
                ++i;
            }
            p = this.pList.getFirst();
            while (p != null) {
                if (i > 0 && i % Pcc.MAX_PARAGRAPHS == 0) {
                    Return2.append("      }");
                    Return2.append(eol + "      public class " + "inner_" + innerClassCount + " extends " + "inner_" + (innerClassCount - 1));
                    Return2.append(" {" + eol);
                    Return2.append("   public inner_" + innerClassCount + "() {}" + eol);
                    ++innerClassCount;
                }
                Return2.append(p.getCode());
                p = this.pList.getNext();
                ++i;
            }
            int idx = 0;
            while (idx < this.parent.sqlCursorMethodsCode.size()) {
                if (i > 0 && i % Pcc.MAX_PARAGRAPHS == 0) {
                    Return2.append("      }");
                    Return2.append(eol + "      public class " + "inner_" + innerClassCount + " extends " + "inner_" + (innerClassCount - 1));
                    Return2.append(" {" + eol);
                    Return2.append("   public inner_" + innerClassCount + "() {}" + eol);
                    ++innerClassCount;
                }
                Return2.append(this.parent.sqlCursorMethodsCode.get(idx));
                ++idx;
                ++i;
            }
            this.parent.sqlCursorMethodsCode.clear();
            Return2.append("      }");
            Return2.append(eol + "      public class " + "inner_" + innerClassCount + " extends " + "inner_" + (innerClassCount - 1));
            Return2.append(" {" + eol);
            Return2.append("   public inner_" + innerClassCount + "() {}" + eol);
            ++innerClassCount;
            Return2.append("      public void myFinalize() {" + eol);
            Return2.append(this.parent.getFinalizeCode() + eol);
            Return2.append("      }" + eol);
        }
        this.callCode(Return2);
        this.entryPointCode(Return2);
        int n = this.pList.getItemNum();
        if (n > 0) {
            for (i = 1; i <= n; i += 1500) {
                this.performCode(Return2, i, Math.min(n, i + 1500 - 1));
            }
        } else {
            this.performCode(Return2, 1, 0);
        }
        boolean pt0 = this.parent.getOption("-pt0") != null;
        boolean bl = pt2 = this.parent.getOption("-pt2") != null;
        if (pt0 || pt2) {
            this.getPT0_2HandlingCode(Return2, "perform", pt2);
        }
        if (this.dList.getItemNum() > 0) {
            Return2.append("   public void declaratives (int begin, int end)");
            Return2.append(" throws GotoException {" + eol);
            Return2.append("      boolean goOn = true;" + eol);
            Return2.append("      while (goOn) {" + eol);
            Return2.append("         try {" + eol);
            Return2.append("            switch (begin) {" + eol);
            i = 1;
            p = this.dList.getFirst();
            while (p != null) {
                Return2.append("            case " + i + ":" + eol);
                if (p.hasGoto()) {
                    Return2.append("               if ((begin = ");
                    Return2.append(p.getJavaName());
                    Return2.append("()) > 0) break;");
                } else {
                    Return2.append("               begin = ");
                    Return2.append(p.getJavaName());
                    Return2.append("();");
                }
                Return2.append(eol);
                Return2.append("               if (end == " + i + ") {" + eol);
                Return2.append("                  goOn = false;" + eol);
                Return2.append("                  break;" + eol);
                Return2.append("               }" + eol);
                p = this.dList.getNext();
                ++i;
            }
            Return2.append("            default:" + eol);
            Return2.append("               ");
            Stop.getStopRunCode(Return2, this.parent.capitalizeNames, null, null);
            Return2.append("               break;" + eol);
            Return2.append("            }" + eol);
            Return2.append("         } catch (ExitSectionException e) {" + eol);
            Return2.append("            goOn = false;" + eol);
            Return2.append("         }" + eol);
            Return2.append("      }" + eol);
            Return2.append("   }" + eol);
            if (pt0 || pt2) {
                this.getPT0_2HandlingCode(Return2, "declaratives", pt2);
            }
        }
        if (innerClassCount > 0) {
            Return2.append("      }");
        } else {
            p = this.dList.getFirst();
            while (p != null) {
                Return2.append(p.getCode());
                p = this.dList.getNext();
            }
            p = this.pList.getFirst();
            while (p != null) {
                Return2.append(p.getCode());
                p = this.pList.getNext();
            }
            for (int idx = 0; idx < this.parent.sqlCursorMethodsCode.size(); ++idx) {
                Return2.append(this.parent.sqlCursorMethodsCode.get(idx));
            }
            this.parent.sqlCursorMethodsCode.clear();
        }
        return innerClassCount;
    }

    private void getPT0_2HandlingCode(StringBuffer Return2, String methodName, boolean pt2) {
        int parCount;
        String EXT_MTD;
        String EXT_PNT_EX;
        String EXT_PNT_AR;
        boolean declaratives = "declaratives".equals(methodName);
        if (declaratives) {
            EXT_PNT_AR = "$dexitPoint$";
            EXT_PNT_EX = "$depe$";
            EXT_MTD = "dexit";
            parCount = this.dList.getItemNum();
        } else {
            EXT_PNT_AR = "$exitPoint$";
            EXT_PNT_EX = "$epe$";
            EXT_MTD = "exit";
            parCount = this.pList.getItemNum();
        }
        Return2.append("   ");
        boolean split = this.parent.getSplitFlag();
        if (!split) {
            Return2.append("private ");
        }
        Return2.append("final ExitPointException ");
        Return2.append(EXT_PNT_EX);
        Return2.append(" = new ExitPointException();");
        Return2.append(eol);
        Return2.append("   ");
        if (!split) {
            Return2.append("private ");
        }
        Return2.append("final int ");
        Return2.append(EXT_PNT_AR);
        Return2.append("[] = new int[");
        Return2.append(parCount + 1);
        Return2.append("];");
        Return2.append(eol);
        Return2.append("   private void ");
        Return2.append(methodName);
        Return2.append(" (int begin,int end,int id) ");
        if (declaratives) {
            Return2.append("throws GotoException ");
        }
        Return2.append("{");
        Return2.append(eol);
        Return2.append("      ");
        Return2.append(EXT_PNT_AR);
        if (pt2) {
            Return2.append("[end]++;");
        } else {
            Return2.append("[end] = id;");
        }
        Return2.append(eol);
        Return2.append("      try {");
        Return2.append(eol);
        Return2.append("         ");
        Return2.append(methodName);
        Return2.append(" (begin, 0);");
        Return2.append(eol);
        Return2.append("      } catch (ExitPointException _ex) {");
        Return2.append(eol);
        Return2.append("         ");
        Return2.append(EXT_PNT_AR);
        if (pt2) {
            Return2.append("[end]--;");
        } else {
            Return2.append("[end] = 0;");
        }
        Return2.append(eol);
        if (pt2) {
            Return2.append("         if (end != _ex.num) {");
        } else {
            Return2.append("         if (id != _ex.num) {");
        }
        Return2.append(eol);
        Return2.append("            throw _ex;");
        Return2.append(eol);
        Return2.append("         }");
        Return2.append(eol);
        Return2.append("      }");
        Return2.append(eol);
        Return2.append("   }");
        Return2.append(eol);
        Return2.append("   private void ");
        Return2.append(EXT_MTD);
        Return2.append(" (int id) {");
        Return2.append(eol);
        Return2.append("      ");
        Return2.append(EXT_PNT_EX);
        Return2.append(".num = ");
        if (pt2) {
            Return2.append("id;");
        } else {
            Return2.append(EXT_PNT_AR);
            Return2.append("[id];");
        }
        Return2.append(eol);
        if (!pt2) {
            Return2.append("      ");
            Return2.append(EXT_PNT_AR);
            Return2.append("[id] = 0;");
            Return2.append(eol);
        }
        Return2.append("      throw ");
        Return2.append(EXT_PNT_EX);
        Return2.append(";");
        Return2.append(eol);
        Return2.append("   }");
        Return2.append(eol);
    }

    public Paragraph[] getParagraphs(boolean declaratives) {
        ParagraphList list = declaratives ? this.dList : this.pList;
        Object[] Return2 = new Paragraph[list.getItemNum()];
        list.toArray(Return2);
        return Return2;
    }

    public Paragraph[] getParagraphs() {
        Paragraph[] dPars = this.getParagraphs(true);
        Paragraph[] pPars = this.getParagraphs(false);
        Paragraph[] Return2 = new Paragraph[dPars.length + pPars.length];
        System.arraycopy(dPars, 0, Return2, 0, dPars.length);
        System.arraycopy(pPars, 0, Return2, dPars.length, pPars.length);
        return Return2;
    }

    public Section[] getSections(boolean declaratives) {
        SectionList list = declaratives ? this.dsList : this.sList;
        Object[] Return2 = new Section[list.getItemNum()];
        list.toArray(Return2);
        return Return2;
    }

    public Section[] getSections() {
        Section[] dSecs = this.getSections(true);
        Section[] pSecs = this.getSections(false);
        Section[] Return2 = new Section[dSecs.length + pSecs.length];
        System.arraycopy(dSecs, 0, Return2, 0, dSecs.length);
        System.arraycopy(pSecs, 0, Return2, dSecs.length, pSecs.length);
        return Return2;
    }

    @Override
    public Token getDeclarativesStart() {
        return this.startDeclaratives;
    }

    @Override
    public Token getDeclarativesEnd() {
        return this.endDeclaratives;
    }

    public Paragraph getParagraphById(int id, boolean declarat) {
        if (declarat) {
            return this.dList.elementAt(id - 1);
        }
        return this.pList.elementAt(id - 1);
    }

    public Paragraph getParagraph(String name, String section, boolean declarat) {
        Paragraph Return2 = null;
        Enumeration e = declarat ? this.dsList.elements() : this.sList.elements();
        while (e.hasMoreElements()) {
            Paragraph p;
            Section sect = (Section)e.nextElement();
            if (!sect.getName().equals(section) || (p = sect.getParagraph(name)) == null) continue;
            if (Return2 == null) {
                Return2 = p;
                continue;
            }
            return new DuplicateParagraph();
        }
        return Return2;
    }

    public Paragraph getParagraph(String name, boolean declarat) {
        return this.getParagraph(name, (Paragraph)null, declarat);
    }

    public Paragraph getParagraph(String name, Paragraph p, boolean declarat) {
        Paragraph Return2 = p != null ? p.getParagraphInSameSection(name) : null;
        if (Return2 == null && (Return2 = declarat ? this.dList.getByName(name) : this.pList.getByName(name)) != null && Return2.isDuplicate()) {
            return new DuplicateParagraph();
        }
        return Return2;
    }

    public void getDebugEnterCode(StringBuffer buff) {
        buff.append(ProcedureDivision.getDebugEnterCode(this.parent, this.tm.getFileName()));
    }

    public static String getDebugEnterCode(Pcc parent, String fileName) {
        StringBuffer buff = new StringBuffer();
        buff.append("         Debugger.enterProgram (\"");
        String fn = fileName;
        if (File.separatorChar != '/') {
            fn = fn.replace(File.separatorChar, '/');
        }
        buff.append(Pcc.escapeString(fn));
        buff.append("\", ");
        if (parent.getSplitFlag()) {
            buff.append(parent.getClassName() + ".");
        }
        buff.append("this );");
        return buff.toString();
    }

    public static void getDebugExitCode(StringBuffer buff) {
        buff.append(ProcedureDivision.getDebugExitCode());
    }

    public static String getDebugExitCode() {
        return "   Debugger.exitProgram ();";
    }

    void getThrows(StringBuffer s) {
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public VariableName getReturning() {
        return this.returning;
    }

    @Override
    public VariableNameList getUsing() {
        return this.using;
    }

    @Override
    public String getServiceBridgeOperation() {
        return this.serviceBridgeOperation;
    }

    @Override
    public Token getElkToken() {
        return this.elkToken;
    }

    @Override
    public int getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public Set getByValueParameters() {
        return this.byValueVars;
    }

    @Override
    public VariableNameList getChaining() {
        return this.chaining;
    }
}

