/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class SMAPGenerator {
    static final String nameSDE = "isCOBOLSourceDebugExtension7";
    private static byte[] scramble = new byte[]{75, -88, 62, 51, 44, 81, 46, -123, 114, 0, -56, -117, -16, -81, 106, 47, 64, 40, -86, -43, 16, 91, -18, 14, 27, 50, 19, 84, 37, -99, -119, 56, -23, -60, -31, -5, 1, 8, -58, -85, 105, 66, 94, -108, 90, -97, 82, 13, 59, -92, 87, -59, 55, 35, -80, 18, -17, 60, -67, 93, -30, 95, -89, 86, 96, 69, 11, -76, -28, -116, -126, -24, 101, 4, 72, -26, -57, -113, -125, 125, -103, 42, 38, 80, 111, -74, 112, 71, -35, 41, 63, -14, 2, 26, -8, 54, -42, 39, -83, -53, 123, -96, -109, 61, -107, 52, 3, 36, -124, 121, -115, 70, 89, 118, 24, -98, 32, -51, -79, 113, 21, -41, 73, -50, -4, 102, 117, 49, -91, 68, 124, 57, -114, -111, -40, -13, 31, -54, -34, -49, 65, -62, 108, -21, 34, -69, 76, -1, -110, -47, -66, -78, -120, -2, -46, -48, 83, 126, -25, -65, -36, 110, 22, 58, 9, -73, -100, -45, -55, 67, -15, 20, -72, -9, -102, -22, 122, -112, 115, -75, 5, -90, -37, 17, -87, -82, -128, -44, -104, 30, -84, -11, 15, -121, 12, -118, -94, 109, -10, -101, -19, 33, 77, 7, -32, 116, -64, 79, -71, 98, -95, -70, 48, 119, 97, 88, -106, 10, 92, 107, 100, -27, -20, 23, 74, 78, -63, 53, -38, 29, 43, 45, -3, -52, -122, 104, 6, 25, -39, -68, -61, -77, -12, -6, -29, 127, 85, 28, -127, 120, -33, -7, 103, -105, -93, 99};
    private String name;
    private Vector lines;
    private byte[] origClass;
    private int origPos;
    private byte[] newClass;
    private int newPos;
    private int sdeIndex;
    private CopyBookDesc[] copyFiles;
    private String encoding;
    private String[] sourceFileNames;
    private String sourceFileName;
    private String[] copyResources;
    private boolean debugReplSrc;
    private boolean ok;
    private static final String tmpdir = System.getProperty("java.io.tmpdir");

    public static void main(String[] args) throws IOException {
        if (args.length >= 1) {
            for (int i = 0; i < args.length; ++i) {
                new SMAPGenerator(args[i]);
            }
        } else {
            System.err.println("Usage: <command> <input java file> ");
        }
    }

    public SMAPGenerator(String n) throws IOException {
        this.name = n;
        this.lines = new Vector();
        LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.name + ".java"), System.getProperty("file.encoding")));
        int c = in.read();
        while (c >= 0) {
            if (c == 47 && (c = in.read()) == 42 && (c = in.read()) == 33 && (c = in.read()) == 35) {
                c = in.read();
                switch (c) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        String num = "";
                        String file = "";
                        while (c >= 48 && c <= 57) {
                            num = num + (char)c;
                            c = in.read();
                        }
                        if (c == 44) {
                            while ((c = in.read()) >= 48 && c <= 57) {
                                file = file + (char)c;
                            }
                        }
                        if (c < 0) break;
                        this.findCommand(in);
                        SmapLine sl = new SmapLine(in.getLineNumber(), num, Integer.parseInt(file));
                        if (!sl.isOk()) break;
                        this.lines.addElement(sl);
                        this.ok = true;
                        break;
                    }
                    case 78: {
                        c = in.read();
                        this.debugReplSrc = c == 49;
                        this.ok = true;
                        break;
                    }
                    case 70: {
                        String s1 = "";
                        while ((c = in.read()) >= 0 && c != 42) {
                            s1 = s1 + (char)c;
                        }
                        this.encoding = s1;
                        this.ok = true;
                        break;
                    }
                    case 83: {
                        String s1;
                        ArrayList<String> sfn = new ArrayList<String>();
                        block19: while ((c = in.read()) >= 0 && c != 42) {
                            s1 = "";
                            while (c != 59) {
                                s1 = s1 + (char)c;
                                c = in.read();
                                if (c >= 0) continue;
                                break block19;
                            }
                            sfn.add(s1);
                        }
                        this.sourceFileNames = sfn.toArray(new String[sfn.size()]);
                        this.ok = true;
                        break;
                    }
                    case 67: {
                        String s1;
                        ArrayList<CopyBookDesc> cps = new ArrayList<CopyBookDesc>();
                        String parentName = null;
                        int line = 0;
                        String name = null;
                        short parentIndex = 0;
                        short index = 0;
                        block21: while ((c = in.read()) >= 0 && c != 42) {
                            s1 = "";
                            while (c != 44) {
                                s1 = s1 + (char)c;
                                c = in.read();
                                if (c >= 0) continue;
                                break block21;
                            }
                            parentName = s1;
                            s1 = "";
                            while ((c = in.read()) != 44) {
                                if (c < 0) break block21;
                                s1 = s1 + (char)c;
                            }
                            try {
                                line = Integer.parseInt(s1);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            s1 = "";
                            while ((c = in.read()) != 44) {
                                if (c < 0) break block21;
                                s1 = s1 + (char)c;
                            }
                            name = s1;
                            s1 = "";
                            while ((c = in.read()) != 44) {
                                if (c < 0) break block21;
                                s1 = s1 + (char)c;
                            }
                            try {
                                parentIndex = Short.parseShort(s1);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            s1 = "";
                            while ((c = in.read()) != 59) {
                                if (c < 0) break block21;
                                s1 = s1 + (char)c;
                            }
                            try {
                                index = Short.parseShort(s1);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            cps.add(new CopyBookDesc(name, parentName, line, parentIndex, index));
                        }
                        this.copyFiles = cps.toArray(new CopyBookDesc[cps.size()]);
                        this.ok = true;
                        break;
                    }
                    case 69: {
                        String s1;
                        ArrayList<String> cr = new ArrayList<String>();
                        block27: while ((c = in.read()) >= 0 && c != 42) {
                            s1 = "";
                            while (c != 59) {
                                s1 = s1 + (char)c;
                                c = in.read();
                                if (c >= 0) continue;
                                break block27;
                            }
                            cr.add(s1);
                        }
                        this.copyResources = cr.toArray(new String[cr.size()]);
                        this.ok = true;
                        break;
                    }
                    case 77: {
                        String s1 = "";
                        while ((c = in.read()) >= 0 && c != 42) {
                            s1 = s1 + (char)c;
                        }
                        this.sourceFileName = s1;
                    }
                }
            }
            if (c < 0) continue;
            c = in.read();
        }
        in.close();
        this.install(this.makeSmap());
    }

    private void findCommand(LineNumberReader in) throws IOException {
        int c;
        while ((!Character.isJavaIdentifierStart((char)(c = in.read())) || c == 116 && (c = in.read()) == 114 && (c = in.read()) == 121 && !Character.isJavaIdentifierPart((char)(c = in.read()))) && c != 59 && c != 61 && c >= 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeSmap() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(baos);
        ByteArrayOutputStream baos0 = new ByteArrayOutputStream();
        DataOutputStream dOut0 = new DataOutputStream(new DeflaterOutputStream(baos0));
        int lsize = this.lines.size() - 1;
        int inputStartLine = -1;
        int outputStartLine = -1;
        short repeatCount = 1;
        int s = -1;
        ByteArrayOutputStream linesBaos = new ByteArrayOutputStream();
        DataOutputStream linesOut = new DataOutputStream(linesBaos);
        int nLines = 0;
        for (int i = 0; i <= lsize; ++i) {
            SmapLine sl = (SmapLine)this.lines.elementAt(i);
            if (sl.cobolLine == inputStartLine + repeatCount && sl.javaLine == outputStartLine + repeatCount && sl.fileIndex == s) {
                repeatCount = (short)(repeatCount + 1);
            } else {
                if (inputStartLine > 0) {
                    this.makeLine(linesOut, inputStartLine, (short)s, repeatCount, outputStartLine);
                    ++nLines;
                }
                s = sl.fileIndex;
                inputStartLine = sl.cobolLine;
                outputStartLine = sl.javaLine;
                repeatCount = 1;
            }
            if (i != lsize) continue;
            this.makeLine(linesOut, inputStartLine, (short)sl.fileIndex, repeatCount, outputStartLine);
            ++nLines;
        }
        linesOut.close();
        dOut0.writeInt(nLines);
        dOut0.write(linesBaos.toByteArray());
        if (this.copyFiles != null) {
            dOut0.writeInt(this.copyFiles.length);
            for (CopyBookDesc desc : this.copyFiles) {
                dOut0.writeUTF(desc.getParentName());
                dOut0.writeInt(desc.getParentLineNumber());
                dOut0.writeUTF(desc.getName());
                dOut0.writeShort(desc.getParentIndex());
                dOut0.writeShort(desc.getIndex());
            }
        } else {
            dOut0.writeInt(0);
        }
        if (this.sourceFileNames != null) {
            dOut0.writeInt(this.sourceFileNames.length);
            for (String sfn : this.sourceFileNames) {
                dOut0.writeUTF(sfn);
            }
        } else {
            dOut0.writeInt(0);
        }
        if (this.copyResources != null) {
            dOut0.writeInt(this.copyResources.length);
            for (String cr : this.copyResources) {
                try (FileInputStream is = null;){
                    is = new FileInputStream(cr);
                    byte[] contents = new byte[is.available()];
                    is.read(contents);
                    dOut0.writeUTF(new File(cr).getName().toLowerCase());
                    dOut0.writeInt(contents.length);
                    dOut0.write(contents);
                }
            }
        } else {
            dOut0.writeInt(0);
        }
        dOut0.writeLong(System.currentTimeMillis());
        if (this.ok) {
            dOut0.writeBoolean(true);
            ArrayList<String> compProps = new ArrayList<String>();
            Properties p = Config.getAllProperties();
            boolean userepl = false;
            String debugReplSrc = null;
            Enumeration<?> en = p.propertyNames();
            while (en.hasMoreElements()) {
                String propName = (String)en.nextElement();
                if (propName.startsWith("iscobol.compiler.const.")) {
                    compProps.add(propName + "=" + p.getProperty(propName));
                    continue;
                }
                if (propName.equals("iscobol.compiler.debug.replaced_source")) {
                    debugReplSrc = propName + "=" + p.getProperty(propName);
                    continue;
                }
                if (!propName.equals("iscobol.compiler.regexp") && !propName.equals("iscobol.compiler.custompreproc")) continue;
                userepl = true;
            }
            if (userepl) {
                if (debugReplSrc != null) {
                    compProps.add(debugReplSrc);
                }
            } else {
                compProps.add("iscobol.compiler.debug.replaced_source=0");
            }
            dOut0.writeInt(compProps.size());
            for (String prop : compProps) {
                dOut0.writeUTF(prop);
            }
        } else {
            dOut0.writeBoolean(false);
        }
        dOut0.close();
        byte[] b = baos0.toByteArray();
        dOut.writeInt(b.length);
        dOut.write(b);
        if (this.sourceFileNames != null) {
            baos0 = new ByteArrayOutputStream();
            dOut0 = new DataOutputStream(new DeflaterOutputStream(baos0));
            this.buildDebugResourceFile(dOut0);
            dOut0.close();
            b = baos0.toByteArray();
            dOut.write(b);
        }
        dOut.close();
        return baos.toByteArray();
    }

    private File getReplFileList() throws IOException {
        File f;
        if (this.sourceFileName != null && (f = new File(tmpdir + File.separator + new File(this.sourceFileName).getName() + ".filelist")).exists()) {
            return f;
        }
        return null;
    }

    private void buildDebugResourceFile(DataOutputStream dOut) throws IOException {
        File replFileList;
        String enc = this.encoding != null ? this.encoding : System.getProperty("file.encoding");
        dOut.writeUTF(enc);
        if (this.debugReplSrc && (replFileList = this.getReplFileList()) != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(replFileList), enc));
            class MyFile {
                ByteArrayOutputStream baos;
                PrintStream ps;
                String name;

                MyFile() {
                }
            }
            Stack<MyFile> files = new Stack<MyFile>();
            MyFile file = null;
            String line = r.readLine();
            while (line != null) {
                if (line.startsWith("      *>>((file: ")) {
                    file = new MyFile();
                    file.baos = new ByteArrayOutputStream();
                    file.ps = new PrintStream((OutputStream)file.baos, false, enc);
                    file.name = line.substring("      *>>((file: ".length(), line.length() - 2);
                    files.push(file);
                } else if (line.startsWith("      *<<((file: ")) {
                    file.ps.close();
                    files.pop();
                    byte[] b = file.baos.toByteArray();
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = scramble[b[i] & 0xFF];
                    }
                    dOut.writeUTF(file.name);
                    dOut.writeInt(b.length);
                    dOut.write(b);
                    file = files.isEmpty() ? null : (MyFile)files.peek();
                } else {
                    file.ps.println(line);
                }
                line = r.readLine();
            }
            r.close();
            replFileList.delete();
        } else {
            TreeMap<File, String> map = new TreeMap<File, String>();
            for (String sfn : this.sourceFileNames) {
                map.put(new File(sfn), sfn);
            }
            for (File sfn : map.keySet()) {
                dOut.writeUTF((String)map.get(sfn));
                this.writeFile(sfn, true, dOut);
            }
        }
        dOut.writeUTF("");
    }

    private void writeFile(File sfn, boolean findDef, DataOutputStream dOut) throws IOException {
        byte[] b;
        if (sfn.exists()) {
            FileInputStream in = new FileInputStream(sfn);
            b = new byte[in.available()];
            in.read(b);
            in.close();
        } else if (!findDef || (b = PreProcessor.getDefFileContents(sfn.getPath())) == null) {
            b = new byte[]{};
        }
        for (int i = 0; i < b.length; ++i) {
            b[i] = scramble[b[i] & 0xFF];
        }
        dOut.writeInt(b.length);
        dOut.write(b);
    }

    private void makeLine(DataOutputStream dOut, int isl, short ifl, short rpt, int jlin) throws IOException {
        dOut.writeInt(isl);
        dOut.writeShort(ifl);
        dOut.writeShort(rpt);
        dOut.writeInt(jlin);
    }

    private void install(byte[] smap) throws IOException {
        File clazz = new File(this.name + ".class");
        if (!clazz.exists()) {
            throw new FileNotFoundException("File not found: " + clazz);
        }
        FileInputStream fis = new FileInputStream(clazz);
        this.origClass = new byte[(int)clazz.length()];
        if (fis.read(this.origClass, 0, this.origClass.length) != this.origClass.length) {
            fis.close();
            throw new IOException("Wrong length: " + this.origClass.length);
        }
        fis.close();
        this.newClass = new byte[this.origClass.length + smap.length + 100];
        this.newPos = 0;
        this.origPos = 0;
        this.copy(8);
        int constantPoolCountPos = this.newPos;
        int constantPoolCount = this.read2();
        this.write2(constantPoolCount);
        this.sdeIndex = this.copyConstantPool(constantPoolCount);
        if (this.sdeIndex < 0) {
            this.writeSDE();
            this.sdeIndex = constantPoolCount++;
            this.randomAccessWrite2(constantPoolCountPos, constantPoolCount);
        }
        this.copy(6);
        int interfaceCount = this.read2();
        this.write2(interfaceCount);
        this.copy(interfaceCount * 2);
        this.copyMembers();
        this.copyMembers();
        int attrCountPos = this.newPos;
        int attrCount = this.read2();
        this.write2(attrCount);
        if (!this.copyAttrs(attrCount)) {
            this.randomAccessWrite2(attrCountPos, ++attrCount);
        }
        this.writeAttrForSDE(this.sdeIndex, smap);
        File tmpFile = new File(this.name + ".class.tmp");
        FileOutputStream outClazz = new FileOutputStream(tmpFile);
        outClazz.write(this.newClass, 0, this.newPos);
        outClazz.close();
        if (!clazz.delete()) {
            throw new IOException("Delete failed: " + clazz.getPath());
        }
        if (!tmpFile.renameTo(clazz)) {
            throw new IOException("RenameTo failed: " + clazz.getPath());
        }
    }

    int copyConstantPool(int constantPoolCount) throws IOException {
        int Return2 = -1;
        block7: for (int i = 1; i < constantPoolCount; ++i) {
            int tag = this.read1();
            this.write1(tag);
            switch (tag) {
                case 1: {
                    int len = this.read2();
                    this.write2(len);
                    if (nameSDE.equals(this.readUTF8String(len))) {
                        Return2 = i;
                    }
                    this.copy(len);
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.copy(2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.copy(4);
                    continue block7;
                }
                case 15: {
                    this.copy(3);
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i;
                    continue block7;
                }
                default: {
                    throw new IOException("Unexpected tag: " + tag);
                }
            }
        }
        return Return2;
    }

    private void copy(int count) {
        while (count > 0) {
            this.newClass[this.newPos++] = this.origClass[this.origPos++];
            --count;
        }
    }

    private int read1() {
        return this.origClass[this.origPos++] & 0xFF;
    }

    private int read2() {
        return (this.read1() << 8) + this.read1();
    }

    private int read4() {
        return (this.read2() << 16) + this.read2();
    }

    private void write1(int val) {
        this.newClass[this.newPos++] = (byte)val;
    }

    private void write2(int val) {
        this.write1(val >> 8);
        this.write1(val & 0xFF);
    }

    private void write4(int val) {
        this.write2(val >> 16);
        this.write2(val & 0xFFFF);
    }

    private String readUTF8String(int count) throws UnsupportedEncodingException {
        return new String(this.origClass, this.origPos, count, "UTF-8");
    }

    private void writeSDE() {
        this.write1(1);
        this.write2(nameSDE.length());
        for (int i = 0; i < nameSDE.length(); ++i) {
            this.write1(nameSDE.charAt(i));
        }
    }

    private void randomAccessWrite2(int pos, int val) {
        int savePos = this.newPos;
        this.newPos = pos;
        this.write2(val);
        this.newPos = savePos;
    }

    private void copyMembers() {
        int count = this.read2();
        this.write2(count);
        for (int i = 0; i < count; ++i) {
            this.copy(6);
            int attrCount = this.read2();
            this.write2(attrCount);
            this.copyAttrs(attrCount);
        }
    }

    private boolean copyAttrs(int attrCount) {
        boolean Return2 = false;
        for (int i = 0; i < attrCount; ++i) {
            int nameIndex = this.read2();
            if (nameIndex == this.sdeIndex) {
                Return2 = true;
                continue;
            }
            this.write2(nameIndex);
            int len = this.read4();
            this.write4(len);
            this.copy(len);
        }
        return Return2;
    }

    void writeAttrForSDE(int index, byte[] smap) {
        this.write2(index);
        this.write4(smap.length);
        for (int i = 0; i < smap.length; ++i) {
            this.write1(smap[i]);
        }
    }

    static class SmapLine {
        final int javaLine;
        final int cobolLine;
        final int fileIndex;

        SmapLine(int jl, String cl, int f) {
            int line;
            this.fileIndex = f;
            this.javaLine = jl + 1;
            try {
                line = Integer.parseInt(cl);
            }
            catch (NumberFormatException _ex) {
                line = 0;
            }
            this.cobolLine = line;
        }

        boolean isOk() {
            return this.cobolLine > 0;
        }

        public String toString() {
            return "java=" + this.javaLine + ",cobol=" + this.cobolLine + ",file=\"" + this.fileIndex + "\"";
        }
    }

    static class SmapCopy {
        int lineStart;
        int lineEnd;
        short fileIndex;
        byte copyDeep;
        String fileName;

        SmapCopy() {
        }
    }
}

