/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlDelete
extends SqlStatement {
    private Vector bindVars;
    private Vector bindInds;
    private Vector parmVars;
    private Vector parmInds;
    private SqlDeclareCursor cursorOf;
    private boolean rowset = false;
    private VariableName rowsetHostVar = null;
    private int rowsetVal = 0;

    public SqlDelete(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, VariableName forVar, int forVal, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, forVar, forVal, err);
        Token tk;
        while ((tk = this.getSqlToken()).getToknum() != 433) {
            if (tk.getWord().equalsIgnoreCase("WHERE")) {
                this.parmVars = new Vector();
                this.parmInds = new Vector();
                tk = this.getSqlToken();
                if (tk.getWord().equalsIgnoreCase("CURRENT")) {
                    this.addToQuery(" WHERE CURRENT ");
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 610) {
                        this.addToQuery("OF ");
                        tk = this.getSqlToken();
                        if (tk.getToknum() == 58) {
                            throw new ExpectedFoundException(tk, this.error, "CURSOR NAME");
                        }
                        this.curName = tk.getWord();
                        this.addToQuery(this.curName);
                        this.cursorOf = this.pc.getCursor(this.curName);
                        if (this.cursorOf == null) {
                            throw new GeneralErrorException(93, 4, tk, this.curName, this.error);
                        }
                        this.cursorOf.setCurrentOf();
                        this.cursHndl = this.cursorOf.cursHndl;
                    } else if (this.db2Esql && db2Registers.containsKey(tk.getWord().toUpperCase())) {
                        String[] regToken = (String[])db2Registers.get(tk.getWord());
                        this.addToQuery(" CURRENT ");
                        this.addToken(tk);
                        for (int i = 1; i < regToken.length && tk != null && tk.getToknum() != 433; ++i) {
                            this.addToken(tk);
                            tk = this.getSqlToken();
                        }
                    } else {
                        throw new ExpectedFoundException(tk, this.error, "OF");
                    }
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 495) {
                        this.rowset = true;
                        tk = this.getSqlToken();
                        if (!tk.getWord().equals("ROW")) {
                            throw new ExpectedFoundException(tk, this.error, "ROW");
                        }
                        tk = this.getSqlToken();
                        if (tk.getToknum() == 58) {
                            boolean changed = false;
                            tk = this.getSqlToken();
                            Token tkFalse = this.getSqlToken();
                            if (tkFalse.getToknum() == 610) {
                                tk = this.getSqlToken();
                                if (tk.getWord().equals("ROWSET")) {
                                    tkFalse.setToknum(10009);
                                    tkFalse.setWord("OFFF");
                                    changed = true;
                                }
                                this.ungetSqlToken();
                            }
                            this.ungetSqlToken();
                            this.ungetSqlToken();
                            this.rowsetHostVar = this.getHostVariable();
                            if (changed) {
                                tkFalse.setToknum(610);
                                tkFalse.setWord("OF");
                            }
                        } else if (tk.getToknum() == 10002) {
                            this.rowsetVal = new Integer(tk.getWord());
                        } else {
                            throw new ExpectedFoundException(tk, this.error, "SQL HOST VARIABLE or Int literal");
                        }
                        tk = this.getSqlToken();
                        if (tk.getToknum() != 610) {
                            throw new ExpectedFoundException(tk, this.error, "OF");
                        }
                        tk = this.getSqlToken();
                        if (tk.getWord().equals("ROWSET")) continue;
                        throw new ExpectedFoundException(tk, this.error, "ROWSET");
                    }
                    this.ungetSqlToken();
                    continue;
                }
                this.ungetSqlToken();
                this.addToQuery(" WHERE");
                this.where(this.parmVars, this.parmInds);
                continue;
            }
            if (tk.getToknum() == 695 || tk.getToknum() == 694) {
                this.bindVars = new Vector();
                this.bindInds = new Vector();
                this.returningClause(this.parmVars, this.parmInds, this.bindVars, this.bindInds);
                continue;
            }
            this.addToken(tk);
        }
        this.ungetAllSqlToken();
        if (this.parmInds != null && this.optionXLVNULL) {
            this.fillParmInds(this.parmInds, this.parmVars);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int i;
        if (this.parmVars != null) {
            for (i = 0; i < this.parmVars.size(); ++i) {
                Object obj = this.parmVars.elementAt(i);
                if (!(obj instanceof VariableName)) continue;
                ((VariableName)obj).check(this.pc);
            }
        }
        if (this.parmInds != null) {
            for (i = 0; i < this.parmInds.size(); ++i) {
                VariableName vn = (VariableName)this.parmInds.elementAt(i);
                if (vn == null) continue;
                vn.check();
                vn.getVarDecl().setEsqlIndicator();
            }
        }
    }

    public SqlDeclareCursor getCursorOf() {
        return this.cursorOf;
    }

    @Override
    public Vector getParmVars() {
        return this.parmVars;
    }

    @Override
    public Vector getParmInds() {
        return this.parmInds;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        this.startForClause(Return2);
        if (this.cursorOf == null) {
            this.getCodeGeneric(this.pc, Return2, null, null, null, true, this.bindVars, this.bindInds, this.parmVars, this.parmInds);
        } else if (this.sqlj) {
            this.setQuery(this.getQuery().toString().replace(this.curName, ":" + this.cursorOf.getIterName()));
            this.getCodeGeneric(this.pc, Return2, null, null, null, true, this.bindVars, this.bindInds, this.parmVars, this.parmInds);
        } else {
            Return2.append(this.getReturnCode());
            if (this.rowset) {
                Return2.append(".set(Esql.RS_DELETE_ROWSET(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            } else {
                Return2.append(".set(Esql.RS_DELETE_ROW(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
            }
            Return2.append(this.cursHndl.getCode());
            if (this.rowset) {
                Return2.append(", Factory.getNumLiteral( ");
                if (this.rowsetHostVar != null) {
                    Return2.append(this.rowsetHostVar.getCode() + ".toint()");
                } else {
                    Return2.append(this.rowsetVal);
                }
                Return2.append(", 4, 0, false)");
            }
            Return2.append("})); ");
            this.addWhenever(Return2);
        }
        this.endForClause(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

