/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.phases.Phases;
import com.iscobol.rts.Config;
import com.iscobol.rts.LicenseCheck;
import com.iscobol.rts.RuntimeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StandardPhases
implements Phases {
    private static final byte[] prefix = new byte[]{20, -45, -84, -111, 25, 11, 52, -24};
    private static final byte[] suffix = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 99, 111, 109, 112, 105, 108, 101, 114, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 53};
    private List<String[][]> classToBeRemoved = new ArrayList<String[][]>();
    private Map<File, Map> pccToBeCompiled = new LinkedHashMap<File, Map>();
    public static final String PROGRAM_NAME = "programName";
    public static final String ENTRY_POINTS = "entryPoints";
    public static final String EASYLINKAGE_ACTIVATED = "easyLinkageActivated";
    public static final String EASYLINKAGE_FILE_NAME = "easyLinkageFileName";
    public static final String EASYLINKAGE_ENTRY_PREFIX = "easyLinkageEntryPrefix";

    @Override
    public void generateSourceCode(Pcc pcc) throws GeneralErrorException {
        if (pcc instanceof CobolMethod) {
            throw new UnsupportedOperationException("Not supported.");
        }
        if (pcc instanceof CobolClass) {
            throw new UnsupportedOperationException("Not supported.");
        }
        if (pcc instanceof CobolProgram) {
            CobolProgram pgm = (CobolProgram)pcc;
            pgm.doCode();
        } else {
            pcc.doCodeForClass();
        }
    }

    @Override
    public int generateBinaryCode(Pcc pcc) {
        pcc.prepareCompileData(this);
        return 0;
    }

    public List<String[][]> getClassToBeRemoved() {
        return this.classToBeRemoved;
    }

    public Map putCompileData(String sourceName) {
        int idx = sourceName.lastIndexOf(46);
        if (idx >= 0) {
            sourceName = sourceName.substring(0, idx);
        }
        File fn = new File(sourceName);
        HashMap compileData = new HashMap();
        this.pccToBeCompiled.put(fn, compileData);
        return compileData;
    }

    public Collection<Map> getCompileDatas() {
        return this.pccToBeCompiled.values();
    }

    public static void copyright() {
        String eol = System.getProperty("line.separator", "\n");
        String infolic = Config.getProperty(".licinfo", "Missing license!");
        String exdate = infolic.substring(infolic.length() - 8).equals("99991231") ? "None" : infolic.substring(infolic.length() - 8);
        String[] licid = infolic.substring(0, infolic.length() - 9).split("(##)");
        String licenseId = licid.length > 1 ? LicenseCheck.displayLicenseId(licid[1], true) : "Missing";
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = Version.getFullVersionNumber();
        if (fullVersionNumber.startsWith("isCOBOL")) {
            fullVersionNumber = "isCOBOL-Compiler" + fullVersionNumber.substring(7);
        }
        String productCopyright = RuntimeProperties.getProductCopyright();
        System.err.println(fullVersionNumber + eol + productCopyright + eol + eol + "Company:         " + licid[0] + eol + "License ID:      " + licenseId + eol + "Expiration Date: " + exdate + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home"));
        System.exit(0);
    }

    static {
        Config.putProperty(suffix, prefix);
    }
}

