/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Synchronized
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Block syncBlock;
    private VariableName syncVar;

    public Synchronized(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 614) {
            this.syncVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (this.syncVar == null) {
                tk = this.tm.getToken();
                throw new UnexpectedTokenException(tk, this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.syncBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        tk = this.tm.getToken();
        if (tk.getToknum() != 451) {
            throw new ExpectedFoundException(tk, this.error, "'END-SYNCHRONIZED'");
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        Return2.append("synchronized (");
        if (this.syncVar != null) {
            Return2.append(this.syncVar.getCode());
        } else {
            Pcc rootPcc = this.pc.getRoot();
            if (rootPcc != this.pc) {
                Return2.append(rootPcc.getFullClassName() + ".");
            }
            Return2.append("this");
        }
        Return2.append(")");
        Return2.append(this.syncBlock.getCode());
        return Return2.toString();
    }
}

