/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MSVariableGenerator;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IVerb;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public abstract class Verb
implements CobolToken,
ErrorsNumbers,
IVerb {
    protected TokenManager tm;
    protected Errors error;
    private static int uniqueId;
    protected Token keyWord;
    protected Pcc pc;
    protected Block parent;
    protected Vector nestedBlocks = new Vector();
    protected int deferredMethodId;
    protected boolean allowAllLitGen = true;
    protected String endCode;
    protected boolean endStmt;
    ArrayList<VariableDeclaration> visibleLocalVars;

    protected Verb(Token kw, Block par, Pcc p, TokenManager t, Errors err) {
        this.keyWord = kw;
        this.parent = par;
        this.pc = p;
        this.tm = t;
        this.error = err;
    }

    public final String getCodeLiteral(Token tk) {
        if (tk.isAll() && !this.allowAllLitGen) {
            Token tk0 = new Token(tk);
            tk0.setFigurative(tk.isFigurative());
            tk0.setResource(tk.isResource());
            tk0.setHexdecimal(tk.isHexdecimal());
            tk0.setAll(false);
            tk = tk0;
        }
        return this.tm.getCodeLiteral(tk);
    }

    protected static int getUniqueId() {
        return ++uniqueId;
    }

    public Block[] getNestedBlocks() {
        Block[] Return2 = new Block[this.nestedBlocks.size()];
        this.nestedBlocks.toArray(Return2);
        return Return2;
    }

    public abstract void check() throws GeneralErrorException;

    protected void getCodeDebug(StringBuffer buff) {
        int fln = this.keyWord.getFLN();
        if (this.keyWord.isLineRepl()) {
            if (fln != this.pc.lastReplLine) {
                this.pc.lastReplLine = fln;
            } else {
                fln = -fln;
            }
        }
        if (this.pc.getOption("-d") != null) {
            int idx = this.keyWord.getFileIndex();
            boolean dx = this.pc.getOption("-dx") != null;
            if (dx) {
                buff.append("if(");
            }
            buff.append("Debugger.statement");
            if (dx) {
                buff.append("Ext");
            }
            buff.append(" (");
            buff.append(fln);
            buff.append(", \"");
            String fn = this.keyWord.getFileName();
            if (File.separatorChar != '/') {
                fn = fn.replace(File.separatorChar, '/');
            }
            buff.append(Pcc.escapeString(fn));
            buff.append("\"");
            buff.append(", ");
            buff.append(idx);
            buff.append(")");
            if (dx) {
                buff.append(") {");
            } else {
                buff.append(";");
            }
            buff.append(eol);
            if (this.parent != null) {
                buff.append(this.parent.getIndent());
            }
            if (fln > 0) {
                Pcc rootPcc = this.pc.getRoot();
                int parId = 0;
                boolean dec = false;
                if (this.parent != null && this.parent.getParent() != null && this.parent.getParentVerb() == null) {
                    parId = this.parent.getParent().getIdNumber();
                    dec = this.parent.getParent().isDeclaratives();
                }
                rootPcc.addLine(new StatementDesc(idx, fln, parId, dec));
            }
        }
        this.getCodeSMAP(buff, fln, true);
    }

    protected final void getCodeSMAP(StringBuffer buff, int fln, boolean writeEOL) {
        if (this.pc.getOption("-g") != null) {
            buff.append("/*!#");
            buff.append(fln);
            buff.append(",");
            buff.append(this.keyWord.getFileIndex());
            buff.append("*/");
            buff.append(eol);
            if (this.parent != null) {
                buff.append(this.parent.getIndent());
            }
        }
    }

    protected void getCodeDebugEnd(StringBuffer buff) {
        this.getEndCode(buff);
        if (this.pc.getOption("-dx") != null) {
            buff.append(this.parent.getIndent());
            buff.append("}");
            buff.append(eol);
        }
    }

    protected void getEndCode(StringBuffer buff) {
        if (this.endCode != null) {
            buff.append(this.endCode);
            this.endCode = null;
        }
    }

    public static void resetCounters() {
        uniqueId = 0;
    }

    @Override
    public Block getParent() {
        return this.parent;
    }

    protected String getLocalVar(String name) {
        return Verb.getLocalVar(name, this.pc.capitalizeNames);
    }

    protected String getReturnCode() {
        return Verb.getLocalVar("RETURN-CODE", this.pc.capitalizeNames);
    }

    protected String getExceptionObject() {
        return Verb.getLocalVar("EXCEPTION-OBJECT", this.pc.capitalizeNames);
    }

    protected static String getDebugItemLocalVar(String name, boolean jjms, boolean capitalize) {
        if (jjms) {
            if (capitalize) {
                return MSVariableGenerator.getDeclUnivoqueName("DEBUG-ITEM", 0) + "." + MSVariableGenerator.getDeclUnivoqueName(name, 0);
            }
            return ("DEBUG-ITEM." + name).replace('-', Pcc.hyphenRepl);
        }
        return name.replace('-', Pcc.hyphenRepl);
    }

    protected static String getLocalVar(String name, boolean capitalize) {
        if (capitalize) {
            return MSVariableGenerator.getDeclUnivoqueName(name, 0);
        }
        return name.replace('-', Pcc.hyphenRepl);
    }

    protected static String getReturnCode(boolean capitalize) {
        return Verb.getLocalVar("RETURN-CODE", capitalize);
    }

    protected static String getExceptionObject(boolean capitalize) {
        return Verb.getLocalVar("EXCEPTION-OBJECT", capitalize);
    }

    public abstract String getCode();

    void getCodeCorresponding(StringBuffer Return2, VariableName fromVar, VariableName toVar, boolean numericOnly) {
        VariableDeclarationList src = new VariableDeclarationList();
        VariableDeclarationList dst = new VariableDeclarationList();
        int srcSubCount = fromVar.getIndexes() != null ? fromVar.getIndexes().getItemNum() : 0;
        int dstSubCount = toVar.getIndexes() != null ? toVar.getIndexes().getItemNum() : 0;
        Verb.getCorrespondingVars(src, fromVar.getVarDecl().children);
        Verb.getCorrespondingVars(dst, toVar.getVarDecl().children);
        VariableDeclaration vds = src.getFirst();
        while (vds != null) {
            VariableDeclaration vdd = dst.getFirst();
            while (vdd != null) {
                VariableDeclaration vdP = vds.parent;
                String nameS = vds.name.getWord();
                while (vdP != null && !vdP.name.getWord().equals(fromVar.name.getWord())) {
                    nameS = nameS + " OF " + vdP.name.getWord();
                    vdP = vdP.parent;
                }
                vdP = vdd.parent;
                String nameD = vdd.name.getWord();
                while (vdP != null && !vdP.name.getWord().equals(toVar.name.getWord())) {
                    nameD = nameD + " OF " + vdP.name.getWord();
                    vdP = vdP.parent;
                }
                if (nameS.equals(nameD) && (!numericOnly || vds.isNumeric() && !vds.isEdited() && vdd.isNumeric() && !vdd.isEdited())) {
                    VariableDeclaration mvd;
                    int vdsChilds = 0;
                    int vddChilds = 0;
                    if (vds.children.getItemNum() > 0) {
                        mvd = vds.children.getFirst();
                        while (mvd != null && vdsChilds == 0) {
                            if (mvd.level != 88 && mvd.level != 78 && mvd.level != 66) {
                                ++vdsChilds;
                            }
                            mvd = vds.children.getNext();
                        }
                    }
                    if (vdd.children.getItemNum() > 0) {
                        mvd = vdd.children.getFirst();
                        while (mvd != null && vddChilds == 0) {
                            if (mvd.level != 88 && mvd.level != 78 && mvd.level != 66) {
                                ++vddChilds;
                            }
                            mvd = vdd.children.getNext();
                        }
                    }
                    if ((vdsChilds == 0 || vddChilds == 0) && vds.dimension == srcSubCount && vdd.dimension == dstSubCount && vds.rename1 == null && vdd.rename1 == null) {
                        String sFrom = vds.getUnivoqueName();
                        if (srcSubCount > 0) {
                            sFrom = sFrom + fromVar.getSubscriptCode();
                        }
                        String sTo = vdd.getUnivoqueName();
                        if (dstSubCount > 0) {
                            sTo = sTo + toVar.getSubscriptCode();
                        }
                        this.getCodeCorrEach(Return2, sFrom, vds, sTo, vdd);
                    }
                }
                vdd = dst.getNext();
            }
            vds = src.getNext();
        }
    }

    void getCodeCorrEach(StringBuffer ret, String sFrom, VariableDeclaration vdf, String sTo, VariableDeclaration vdt) {
        throw new InternalErrorException("Undefined getCodeCorrEach:" + this);
    }

    static void getCorrespondingVars(VariableDeclarationList result, VariableDeclarationList toScan) {
        if (toScan != null) {
            Object[] ts = new VariableDeclaration[toScan.getItemNum()];
            toScan.toArray(ts);
            for (int i = 0; i < ts.length; ++i) {
                int j;
                if (ts[i] == null) continue;
                Object vd = ts[i];
                for (j = i + 1; !(j >= ts.length || ts[j] != null && ((VariableDeclaration)vd).getName().equals(((VariableDeclaration)ts[j]).getName())); ++j) {
                }
                if (j < ts.length) {
                    ts[j] = null;
                    ts[i] = null;
                    continue;
                }
                if (((VariableDeclaration)vd).level == 88 || ((VariableDeclaration)vd).redefines != null || ((VariableDeclaration)vd).getName().equalsIgnoreCase("filler")) continue;
                result.addItem((VariableDeclaration)vd);
                Verb.getCorrespondingVars(result, ((VariableDeclaration)vd).children);
            }
        }
    }

    @Override
    public Token getKeyWord() {
        return this.keyWord;
    }

    public Pcc getPcc() {
        return this.pc;
    }

    public int getPreProcessorIndex() {
        return this.keyWord.getFileIndex();
    }

    public int getDeferredMethodId() {
        return this.deferredMethodId;
    }

    public void setDeferredMethodId(int deferredMethodId) {
        this.deferredMethodId = deferredMethodId;
    }
}

