/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.bincode;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.bincode.BinaryCodeGenerator;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.rts.Config;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractJavaCompiler
implements BinaryCodeGenerator {
    protected final OptionList optionList;
    private String sourcePath;

    public AbstractJavaCompiler(OptionList optionList) {
        this.optionList = optionList;
    }

    protected void addCompilerOptions(List<String> list) {
        String jcOpt;
        String tk;
        String conf = Config.getProperty(".compiler.javac.options", null);
        if (conf != null) {
            StringTokenizer st = new StringTokenizer(conf);
            while (st.hasMoreTokens()) {
                tk = st.nextToken();
                if ("-sourcepath".equals(tk)) {
                    if (!st.hasMoreTokens()) continue;
                    this.sourcePath = st.nextToken();
                    continue;
                }
                list.add(tk);
            }
        }
        if ((jcOpt = this.optionList.getOption("-jo=")) != null) {
            StringTokenizer st = new StringTokenizer(jcOpt);
            while (st.hasMoreTokens()) {
                tk = st.nextToken();
                if ("-sourcepath".equals(tk)) {
                    if (!st.hasMoreTokens()) continue;
                    this.sourcePath = st.nextToken();
                    continue;
                }
                list.add(tk);
            }
        }
    }

    protected final void addSourcePathOption(List list, String[] sourceUnits) {
        String sp = this.sourcePath;
        HashSet<File> paths = new HashSet<File>();
        for (String sourceUnit : sourceUnits) {
            File dir = new File(sourceUnit).getParentFile();
            if (dir == null) continue;
            paths.add(dir);
        }
        for (File path : paths) {
            if (sp != null && sp.length() > 0) {
                sp = sp + File.pathSeparator + path.getPath();
                continue;
            }
            sp = path.getPath();
        }
        list.add("-sourcepath");
        if (sp != null) {
            list.add(sp + File.pathSeparator + ".");
        } else {
            list.add(".");
        }
    }

    @Override
    public final Callable getCompilationTask(String[] sourceUnit) {
        return this.getCompilationTaskImpl(sourceUnit);
    }

    @Override
    public final Callable getCompilationTask(String sourceUnit) {
        return this.getCompilationTask(new String[]{sourceUnit});
    }

    protected abstract Callable getCompilationTaskImpl(String[] var1);
}

