/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SubstitutionMarker
implements CobolToken,
ErrorsNumbers {
    private final int nextCharPos;
    private StringBuffer value = new StringBuffer();
    private ArrayList indexes;
    private final VariableName varName;
    private final Token keyWord;
    private boolean isInteger;

    SubstitutionMarker(Token kw, String line, int idx) {
        char c = '\u0000';
        int len = line.length();
        this.isInteger = true;
        while (idx < len && SubstitutionMarker.isValidChar(c = line.charAt(idx))) {
            this.value.append(c);
            this.isInteger &= Character.isDigit(c);
            ++idx;
        }
        if (idx < len && !this.isInteger) {
            int savePos = idx;
            while (idx < len && (c = line.charAt(idx)) <= ' ') {
                ++idx;
            }
            if (c == '(' && ++idx < len && SubstitutionMarker.isValidChar(line.charAt(idx))) {
                block8: {
                    SubstitutionMarker sm;
                    this.indexes = new ArrayList();
                    do {
                        sm = new SubstitutionMarker(kw, line, idx);
                        this.indexes.add(sm);
                        for (idx = sm.nextCharPos; idx < len && ((c = line.charAt(idx)) <= ' ' || c == ',' || c == ';'); ++idx) {
                        }
                        if (idx >= len) break block8;
                        if (c != ')') continue;
                        ++idx;
                        break block8;
                    } while (SubstitutionMarker.isValidChar(c));
                    idx = sm.nextCharPos;
                }
                this.nextCharPos = idx;
            } else {
                this.nextCharPos = savePos;
            }
        } else {
            this.nextCharPos = idx;
        }
        this.keyWord = kw;
        this.varName = new VariableName(new Token(10009, this.value.toString().toUpperCase(), this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.value);
        if (this.indexes != null) {
            Return2.append('(');
            int i = 0;
            while (true) {
                Return2.append(this.indexes.get(i).toString());
                if (++i >= this.indexes.size()) break;
                Return2.append(',');
            }
            Return2.append(')');
        }
        return Return2.toString();
    }

    public static boolean isValidChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-';
    }

    public static SubstitutionMarker get(Token kw, Pcc pc, String line, int idx) {
        SubstitutionMarker Return2 = new SubstitutionMarker(kw, line, idx);
        if (Return2.isInteger || !Return2.varName.isDeclared(pc)) {
            Return2 = null;
        }
        return Return2;
    }

    public int getNextCharPos() {
        return this.nextCharPos;
    }

    public void check(Pcc pc, Errors err) throws GeneralErrorException {
        if (!this.isInteger) {
            this.varName.check(pc, false, true, GetVarOpts.NO_OPTS);
            VariableDeclaration vd = this.varName.getVarDecl();
            if (this.indexes == null) {
                if (vd.getDimension() != 0) {
                    throw new GeneralErrorException(41, 4, this.keyWord, this.value.toString(), err);
                }
            } else {
                int size = this.indexes.size();
                if (vd.getDimension() != size) {
                    throw new GeneralErrorException(189, 4, this.keyWord, this.value.toString(), err);
                }
                if (vd.hasVariableOffset()) {
                    throw new GeneralErrorException(19, 4, this.keyWord, " -cod1:" + this.value.toString(), err);
                }
                for (int i = 0; i < size; ++i) {
                    ((SubstitutionMarker)this.indexes.get(i)).check(pc, err);
                }
            }
        }
    }

    public String getCode() {
        return this.getCode(false);
    }

    public String getCodeAsInt() {
        return this.getCode(true);
    }

    private String getCode(boolean asInt) {
        StringBuffer Return2 = new StringBuffer();
        if (this.isInteger) {
            Return2.append(this.value);
        } else {
            Token tk;
            VariableDeclaration vd = this.varName.getVarDecl();
            if (vd.isConstant() && (tk = vd.getValueToken()) != null) {
                Return2.append("\"");
                Return2.append(tk.getCode());
                Return2.append("\"");
            } else {
                Return2.append(vd.getUnivoqueName());
                if (this.indexes != null) {
                    int indexSize = this.indexes.size();
                    if (vd.isObjectReference()) {
                        for (int i = 0; i < indexSize; ++i) {
                            SubstitutionMarker sm = (SubstitutionMarker)this.indexes.get(i);
                            Return2.append("[");
                            Return2.append(sm.getCodeAsInt());
                            Return2.append("]");
                        }
                    } else {
                        if (vd.isEdited() && vd.isNumeric()) {
                            Return2.append(".atEdit");
                        } else {
                            Return2.append(".at");
                        }
                        if (indexSize == 1) {
                            SubstitutionMarker sm = (SubstitutionMarker)this.indexes.get(0);
                            Return2.append(" (");
                            Return2.append(sm.getCodeAsInt());
                            Return2.append(" )");
                        } else {
                            Return2.append(" (new int[] {");
                            int i = 0;
                            while (true) {
                                SubstitutionMarker sm = (SubstitutionMarker)this.indexes.get(i);
                                Return2.append(sm.getCodeAsInt());
                                if (++i >= indexSize) break;
                                Return2.append(",");
                            }
                            Return2.append("})");
                        }
                    }
                }
                if (asInt) {
                    Return2.append(".toint()");
                } else {
                    Return2.append(".toString().trim()");
                }
            }
        }
        return Return2.toString();
    }

    public static void main(String[] args) throws Exception {
        Token tk = new Token(10009, "dummy", 1, 1, "System.in");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String s = in.readLine();
        SubstitutionMarker voi = new SubstitutionMarker(tk, s, 0);
        System.out.println(s);
        System.out.println("0----5----0----5----0----5----0----5----0----5----");
        System.out.println(voi);
        System.out.println(voi.nextCharPos);
    }
}

