/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.interfaces.compiler.remote.IRemoteFile;
import com.iscobol.rts.RtsUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteFile
implements IRemoteFile,
Externalizable {
    private static final long serialVersionUID = 1L;
    private byte[] content;
    private String path;

    public RemoteFile() {
    }

    public RemoteFile(byte[] content, String path) {
        this.content = content;
        this.path = path;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        RtsUtil.writeUTF(this.path, out);
        if (this.content != null) {
            out.writeInt(this.content.length);
            out.write(this.content);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = RtsUtil.readUTF(in);
        this.content = new byte[in.readInt()];
        in.readFully(this.content);
    }
}

