/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.client;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.compiler.remote.client.Callback;
import com.iscobol.compiler.remote.server.IDERemoteCompilerHandler;
import com.iscobol.compiler.remote.server.RemoteCompilerHandler;
import com.iscobol.gui.client.IDEClientHandler;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.remote.IRemoteCompilerClientExtension;
import com.iscobol.interfaces.runtime.IIDEClientHelper;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class Client
extends AbstractClientRpcHandler
implements IClientCallbackHandler,
IRpcWorkerFactory,
IRemoteCompilerClientExtension {
    private String hostName;
    private int portNumber;
    private boolean compileOnServer;
    private boolean createListingFile;
    private boolean createErrorFile;
    private boolean showMessagesOnSysErr;
    private OptionList optionList;
    private String[] sourceFiles;
    private String[] preprocessorNames;
    private OutputData output;
    private DualRpcClient rpcClient;
    private FileFinder fileFinder;
    private Set filesAlreadySent;
    private IDEClientHandler ideHandler;
    private String serverHandlerName = RemoteCompilerHandler.class.getName();

    public Client() {
    }

    public Client(String host, int port) {
        this.setHostName(host);
        this.setPortNumber(port);
    }

    @Override
    public OutputData getOutput() {
        return this.output;
    }

    @Override
    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        this.rpcClient = new DualRpcClient(this.hostName, this.portNumber);
        this.rpcClient.setDefaultCallTimeoutInSeconds(0);
        RemoteRegistry.setClientCaller(new ClientCaller(this.rpcClient));
        RemoteRegistry.setSharedRegistry(new RemoteRegistry());
        this.rpcClient.registerClientSideHandler(this);
        this.rpcClient.setMessageSerializer(new IscobolMessageSerializer());
        this.rpcClient.setCallbackHandler(this);
        this.rpcClient.setRpcWorkerFactory(this);
        this.rpcClient.connect();
        this.filesAlreadySent = new HashSet();
    }

    private OutputData compile(InputData input) throws CallException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException("not connected");
        }
        Callback cb = new Callback();
        OutputData output = (OutputData)this.rpcClient.call(this.serverHandlerName, "compile", cb, input);
        return output;
    }

    @Override
    public boolean isConnected() {
        try {
            return this.rpcClient != null && this.rpcClient.getSession() != null;
        }
        catch (NotConnectedException e) {
            return false;
        }
    }

    @Override
    public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
        return new Worker(dispatcher, message, RemoteRegistry.getSharedRegistry());
    }

    @Override
    public void disconnect() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException("not connected");
        }
        this.rpcClient.getSession().closeSession();
        this.brokenConnection();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public boolean getCompileOnServer() {
        return this.compileOnServer;
    }

    @Override
    public void setCompileOnServer(boolean compileOnServer) {
        this.compileOnServer = compileOnServer;
    }

    @Override
    public boolean getCreateListingFile() {
        return this.createListingFile;
    }

    @Override
    public void setCreateListingFile(boolean createListingFile) {
        this.createListingFile = createListingFile;
    }

    @Override
    public boolean getCreateErrorFile() {
        return this.createErrorFile;
    }

    @Override
    public void setCreateErrorFile(boolean createErrorFile) {
        this.createErrorFile = createErrorFile;
    }

    @Override
    public String[] getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public void setSourceFiles(String[] sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    @Override
    public OptionList getOptionList() {
        return this.optionList;
    }

    @Override
    public void setOptionList(IOptionList optionList) {
        if (optionList != null && !(optionList instanceof OptionList)) {
            throw new IllegalArgumentException(optionList.toString());
        }
        this.optionList = (OptionList)optionList;
    }

    public void setOptionList(OptionList optionList) {
        this.optionList = optionList;
    }

    @Override
    public String[] getPreprocessorNames() {
        return this.preprocessorNames;
    }

    @Override
    public void setPreprocessorNames(String[] preprocessorNames) {
        this.preprocessorNames = preprocessorNames;
    }

    @Override
    public void brokenConnection() {
        this.rpcClient = null;
        this.filesAlreadySent = null;
    }

    @Override
    public void compile() throws Exception {
        if (this.sourceFiles == null || this.sourceFiles.length == 0) {
            throw new IllegalStateException("Missing source files");
        }
        if (this.preprocessorNames == null || this.preprocessorNames.length == 0) {
            throw new IllegalStateException("Missing preproc names");
        }
        if (this.portNumber <= 0) {
            throw new IllegalStateException("Invalid port number: " + this.portNumber);
        }
        if (this.hostName == null || this.hostName.length() == 0) {
            throw new IllegalStateException("Host name cannot be null" + this.hostName);
        }
        if (this.optionList == null) {
            throw new IllegalStateException("OptionList cannot be null");
        }
        InputData in = new InputData();
        in.setCompile(this.compileOnServer);
        in.setListing(this.createListingFile);
        in.setError(this.createErrorFile);
        in.setShowMessagesOnSysErr(this.showMessagesOnSysErr);
        in.setPreProcessorsNames(this.preprocessorNames);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        Enumeration e = this.optionList.getAllKeys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            ht.put(k, this.optionList.getOption(k));
        }
        in.setCompileOptions(ht);
        final RemoteFile[] inputFiles = new RemoteFile[this.sourceFiles.length];
        final ArrayList copyBookList = new ArrayList();
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            OptionList ol = new OptionList(new String[]{this.sourceFiles[i]});
            String sourcePath = this.optionList.getOption("-sp=");
            if (sourcePath == null || sourcePath.length() == 0) {
                sourcePath = ".";
            }
            final String[] pathList = RtsUtil.getPathList(sourcePath);
            final int i0 = i;
            FileFinder ff = new FileFinder(){

                @Override
                public File findFile(String name) {
                    File Return2 = Client.this.fileFinder != null ? Client.this.fileFinder.findFile(name) : Client.findFile(name, pathList);
                    boolean isSourceFile = false;
                    if (Return2 != null && ((isSourceFile = name.equals(Client.this.sourceFiles[i0])) || !Client.this.filesAlreadySent.contains(Return2))) {
                        Client.this.filesAlreadySent.add(Return2);
                        String path = name;
                        try {
                            FileInputStream is = new FileInputStream(Return2);
                            byte[] bytes = new byte[is.available()];
                            is.read(bytes);
                            is.close();
                            File p = new File(path);
                            RemoteFile inputFile = new RemoteFile(bytes, p.isAbsolute() ? p.getName() : p.getPath().replace('\\', '/'));
                            if (isSourceFile) {
                                inputFiles[i0] = inputFile;
                            } else {
                                copyBookList.add(inputFile);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return Return2;
                }
            };
            ff.findFile("SQLCA");
            PreProcessor pp = new PreProcessor(this.sourceFiles[i], null, ol, new Errors(ol.getOption("-xmsgfmt=")), ff, null);
            if (inputFiles[i] == null) {
                FileInputStream is = new FileInputStream(this.sourceFiles[i]);
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                File fileName = new File(this.sourceFiles[i]);
                inputFiles[i] = new RemoteFile(bytes, fileName.isAbsolute() ? fileName.getName() : fileName.getPath().replace('\\', '/'));
                is.close();
            }
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(inputFiles[i].getContent()));
            pp.start(reader, null, (byte)0, null, true);
            while (pp.getLine(null) >= 0) {
            }
        }
        in.setInputFiles(inputFiles);
        RemoteFile[] copyBooks = new RemoteFile[copyBookList.size()];
        copyBookList.toArray(copyBooks);
        in.setCopyBooks(copyBooks);
        this.output = this.compile(in);
    }

    @Override
    public FileFinder getFileFinder() {
        return this.fileFinder;
    }

    @Override
    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public static File findFile(String filename, String[] pathList) {
        File file = new File(filename);
        if (file.isFile() && file.canRead()) {
            return file;
        }
        if (file.isAbsolute()) {
            return Client.findFile0(file.getName(), pathList);
        }
        File p = Client.findFile0(filename, pathList);
        if (p != null) {
            return p;
        }
        String name = file.getName();
        if (!name.equals(filename)) {
            return Client.findFile0(name, pathList);
        }
        return null;
    }

    private static File findFile0(String name, String[] pathList) {
        for (int i = 0; i < pathList.length; ++i) {
            String path = pathList[i] + '/' + name;
            File f = new File(path);
            if (!f.isFile() || !f.canRead()) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean getShowMessagesOnSysErr() {
        return this.showMessagesOnSysErr;
    }

    @Override
    public void setShowMessagesOnSysErr(boolean showMessagesOnSysErr) {
        this.showMessagesOnSysErr = showMessagesOnSysErr;
    }

    @Override
    public IIDEClientHelper getIDEHelper() {
        return this.ideHandler != null ? this.ideHandler.getHelper() : null;
    }

    @Override
    public void setIDEHelper(IIDEClientHelper helper) {
        if (helper != null) {
            if (this.ideHandler == null) {
                this.ideHandler = new IDEClientHandler();
                this.rpcClient.registerClientSideHandler(this.ideHandler);
            }
            this.ideHandler.setHelper(helper);
            this.serverHandlerName = IDERemoteCompilerHandler.class.getName();
        }
    }
}

