/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.as.Login;
import com.iscobol.as.UserData;
import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.client.ICallback;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.Config;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RemoteCompilerHandler
extends AbstractServerRpcHandler
implements IServerCallbackHandler {
    final String AUTH_FILE;
    static final int AUTH_NONE = 0;
    static final int AUTH_ADMINONLY = 1;
    static final int AUTH_ALL = 2;

    public RemoteCompilerHandler(DualRpcServerDispatcher disp) {
        super(disp);
        Config.markNoIscobolRuntimeThread();
        this.AUTH_FILE = Config.getProperty(".as.password_file", "password.properties");
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller caller = new ServerCaller(disp, new RemoteRegistry());
        int sessionId = RemoteRegistry.setCaller(caller);
        this.getDispatcher().getSession().setSessionId(sessionId);
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        RemoteCompiler.dispatchBrokenConnection(session.getSessionId());
    }

    protected boolean checkLogin(ICallback cb) {
        UserData ud = null;
        int auth = Config.getProperty(".as.authentication", 1);
        if (auth == 2) {
            Login l = new Login();
            try {
                ud = l.login(this.AUTH_FILE);
            }
            catch (IOException _ex) {
                System.err.println(_ex.getMessage());
            }
            if (ud != null) {
                if (ud.getId() != 0) {
                    RemoteCompilerHandler.exit(cb, "Operation not permitted");
                    return false;
                }
            } else {
                RemoteCompilerHandler.exit(cb, "login failed");
                return false;
            }
        }
        return true;
    }

    public OutputData compile(ICallback cb, InputData input) throws IOException {
        OutputData output = new OutputData();
        if (!this.checkLogin(cb)) {
            output.setStdErr("login failed");
            output.setExitCode(11);
            return output;
        }
        RemoteCompiler rc = RemoteCompiler.getInstance();
        if (rc == null) {
            RemoteCompilerHandler.exit(cb, "RemoteCompiler not started");
            return output;
        }
        try {
            rc.compile(input, output, this.getDispatcher().getSession().getSessionId());
        }
        catch (ErrorInCompilationException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            System.err.println(e.getMessage());
        }
        return output;
    }

    private static void exit(ICallback cb, String msg) {
        try {
            cb.exit(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

