/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.compiler.remote.server.RemoteCompilerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcWorker;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;

public class Server {
    public static void main(String[] args) {
        Config.markNoIscobolRuntimeThread();
        IscobolSystem.setAS(true);
        if (RemoteCompiler.instance != null) {
            System.err.println("RemoteCompiler already started");
            System.exit(-1);
        }
        if (RemoteCompiler.getInstance() != null) {
            try {
                Server.start(RemoteCompiler.getInstance().getHostName(), RemoteCompiler.getInstance().getPortNumber());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void start(String hostName, int portNumber) throws IOException {
        System.out.println("Remote Compiler started and listening on port " + portNumber);
        try {
            DualRpcServer server = new DualRpcServer(hostName, portNumber, false, "RemoteCompiler");
            server.registerServerSideHandlerClassname(RemoteCompilerHandler.class.getName());
            server.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
                    return new RpcWorker(dispatcher, message);
                }
            });
            server.setMessageSerializer(new IscobolMessageSerializer());
            server.listen();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

