/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Filename;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolVar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FileLoader
implements IFileLoader {
    private String[] pathList;
    private Map cobolFiles;
    private Map remoteFiles;
    private String debugCodePrefix;
    private DebuggerInvoker invoker;
    private String encoding;

    public FileLoader() {
        this(null);
    }

    public FileLoader(DebuggerInvoker invoker) {
        this.invoker = invoker;
        if (this.invoker != null) {
            this.encoding = this.invoker.getRemoteEncoding();
        }
        if (this.encoding == null) {
            this.encoding = CobolVar.encoding;
        }
        this.debugCodePrefix = Config.getProperty(".debug.code_prefix", ".debug_code_prefix", null);
        if (this.debugCodePrefix == null) {
            this.debugCodePrefix = System.getProperty("java.class.path", ".");
        }
        if (File.separatorChar != '/') {
            this.debugCodePrefix = this.debugCodePrefix.replace(File.separatorChar, '/');
        }
        this.cobolFiles = new HashMap();
        this.remoteFiles = new HashMap();
        this.pathList = RtsUtil.getPathList(this.debugCodePrefix, true);
    }

    String getRemoteEncoding() {
        return this.encoding;
    }

    public String getLine(int lineNumber, String file, boolean reload) throws FileNotFoundException {
        String[] fileLines = this.loadFile((String)file, (boolean)reload).lines;
        if (lineNumber > 0 && lineNumber <= fileLines.length) {
            return fileLines[lineNumber - 1];
        }
        return "";
    }

    public String getLongestLine(String file, boolean reload) throws FileNotFoundException {
        return this.loadFile((String)file, (boolean)reload).longestLine;
    }

    public int getMaxLineLength(String file, boolean reload) throws FileNotFoundException {
        return this.loadFile((String)file, (boolean)reload).maxLength;
    }

    public String[] list(String file, int fromLine, boolean reload) throws FileNotFoundException {
        return this.list(file, fromLine, 100000000, null, reload);
    }

    public String[] list(String file, int fromLine, int toLine, boolean reload) throws FileNotFoundException {
        return this.list(file, fromLine, toLine, null, reload);
    }

    public String[] list(String file, int fromLine, int toLine, int[] begIdx, boolean reload) throws FileNotFoundException {
        String[] lines = this.loadFile((String)file, (boolean)reload).lines;
        if (fromLine <= 0) {
            fromLine = 1;
        }
        if (toLine > lines.length) {
            toLine = lines.length;
        }
        if (fromLine > lines.length || fromLine > toLine) {
            return new String[0];
        }
        int beginIdx = fromLine - 1;
        if (begIdx != null && begIdx.length > 0) {
            begIdx[0] = beginIdx;
        }
        int endIdx = toLine - 1;
        String[] Return2 = new String[endIdx - beginIdx + 1];
        int i = beginIdx;
        for (int j = 0; j < Return2.length; ++j) {
            Return2[j] = lines[i];
            ++i;
        }
        return Return2;
    }

    public String[] getLines(String file, boolean reload) throws FileNotFoundException {
        return this.loadFile((String)file, (boolean)reload).lines;
    }

    public int getLineCount(String file, boolean reload) throws FileNotFoundException {
        return this.loadFile((String)file, (boolean)reload).lines.length;
    }

    public void finalize() {
        this.cobolFiles.clear();
        this.remoteFiles.clear();
    }

    private FileObj loadFile(String file, boolean reload) throws FileNotFoundException {
        String key = file;
        if (!reload && this.cobolFiles.containsKey(key)) {
            return (FileObj)this.cobolFiles.get(key);
        }
        Vector<String> lines = new Vector<String>();
        try {
            String path = this.getAbsolutePath(file, false);
            if (path == null) {
                throw new FileNotFoundException(file);
            }
            LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(path), this.encoding));
            String longLine = "";
            int maxLen = 0;
            String line = ((BufferedReader)reader).readLine();
            while (line != null) {
                int len = line.length();
                if (len > maxLen) {
                    maxLen = len;
                    longLine = line;
                }
                lines.addElement(line);
                line = ((BufferedReader)reader).readLine();
            }
            reader.close();
            String[] linesToArray = new String[lines.size()];
            lines.toArray(linesToArray);
            FileObj Return2 = new FileObj(path, linesToArray, longLine);
            this.cobolFiles.put(key, Return2);
            return Return2;
        }
        catch (FileNotFoundException fnf) {
            throw fnf;
        }
        catch (IOException e) {
            return new FileObj(file, new String[0], "");
        }
    }

    @Override
    public String getAbsolutePath(String filename) {
        return this.getAbsolutePath(filename, true);
    }

    private String getAbsolutePath(String filename, boolean checkTable) {
        String ret = this.getAbsolutePath0(filename, checkTable);
        if (ret == null) {
            ret = this.findFileRemotely(filename);
        }
        return ret;
    }

    private String getAbsolutePath0(String filename, boolean checkTable) {
        String key;
        if (filename == null || filename.length() == 0) {
            return null;
        }
        if (checkTable && this.cobolFiles.containsKey(key = filename)) {
            return ((FileObj)this.cobolFiles.get((Object)key)).path;
        }
        File file = new File(filename);
        if (this.invoker != null && this.invoker.isPathLoaded(file)) {
            return filename;
        }
        if (file.isFile() && file.canRead()) {
            return filename;
        }
        if (file.isAbsolute()) {
            return this.findFile(file.getName());
        }
        String p = this.findFile(filename);
        if (p != null) {
            return p;
        }
        String name = file.getName();
        if (!name.equals(filename)) {
            return this.findFile(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFileRemotely(String filename) {
        String Return2;
        if (!Config.getProperty(".debug.remote_source", false) || this.invoker == null) {
            return null;
        }
        Map map = this.remoteFiles;
        synchronized (map) {
            String name = new File(filename).getName();
            if (this.remoteFiles.containsKey(name)) {
                Return2 = (String)this.remoteFiles.get(name);
            } else {
                Return2 = null;
                String remoteContents = this.invoker.getRemoteFileContents(filename);
                if (remoteContents != null) {
                    String path = System.getProperty("java.io.tmpdir") + File.separator + this.invoker.getRemoteHost() + "-" + this.invoker.getRemotePort();
                    new File(path).mkdirs();
                    path = path + File.separator + new File(filename).getName();
                    try {
                        File newFile = new File(path);
                        newFile.deleteOnExit();
                        PrintWriter out = new PrintWriter(new FileOutputStream(newFile));
                        out.write(remoteContents);
                        out.close();
                        newFile.setLastModified(0L);
                        Return2 = path;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.remoteFiles.put(name, Return2);
            }
        }
        return Return2;
    }

    private String findFile(String name) {
        for (int i = 0; i < this.pathList.length; ++i) {
            String path = this.pathList[i] + '/' + name;
            File f = new File(path);
            if (!f.isFile() || !f.canRead()) continue;
            return path;
        }
        return null;
    }

    public boolean checkTimestamp(Filename[] filenames, long timestamp) {
        for (int i = 0; i < filenames.length; ++i) {
            String path = this.getAbsolutePath(filenames[i].getOrigName());
            if (path == null || new File(path).lastModified() < timestamp) continue;
            return false;
        }
        return true;
    }

    private static class FileObj {
        public String path;
        public String[] lines;
        public String longestLine;
        public int maxLength;

        public FileObj(String path, String[] lines, String longestLine) {
            this.path = path;
            this.lines = lines;
            this.longestLine = longestLine;
            this.maxLength = longestLine.length();
        }
    }
}

