/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugTMWithAliases;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.FileLoaderHelper;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.TextFile;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.dialogs.AcceptEnvVariableDialog;
import com.iscobol.debugger.dialogs.AcceptVariableDialog;
import com.iscobol.debugger.dialogs.BreakpointDialog;
import com.iscobol.debugger.dialogs.BreakpointsSettingsDialog;
import com.iscobol.debugger.dialogs.ConnectDialog;
import com.iscobol.debugger.dialogs.ConsoleSettingsDialog;
import com.iscobol.debugger.dialogs.CustomizeCommandsDialog;
import com.iscobol.debugger.dialogs.CustomizeShortcutsDialog;
import com.iscobol.debugger.dialogs.DataSettingsDialog;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.DisplayVariableDialog;
import com.iscobol.debugger.dialogs.FindDialog;
import com.iscobol.debugger.dialogs.GotoDialog;
import com.iscobol.debugger.dialogs.HelpDialog;
import com.iscobol.debugger.dialogs.InputDialog;
import com.iscobol.debugger.dialogs.JumpToDialog;
import com.iscobol.debugger.dialogs.MonitorDialog;
import com.iscobol.debugger.dialogs.NamesRecorder;
import com.iscobol.debugger.dialogs.OffsetLengthDialog;
import com.iscobol.debugger.dialogs.QuickWatchDialog;
import com.iscobol.debugger.dialogs.SessionSettingsDialog;
import com.iscobol.debugger.dialogs.SettingsDialog;
import com.iscobol.debugger.dialogs.SourceSettingsDialog;
import com.iscobol.debugger.dialogs.TraceDialog;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public class GraphDebugger
implements FileLoaderHelper {
    static final String TITLE = "isCOBOL Graphic Debugger";
    public static final String eol = System.getProperty("line.separator", "\n");
    public static final int COMMAND_HISTORY_LIMIT = 50;
    public static final int ANSI_FORMAT = 1;
    public static final int TERMINAL_FORMAT = 2;
    public static final int FREE_FORMAT = 3;
    public static final int VARIABLE_FORMAT = 4;
    public static final int LONG_FORMAT = 5;
    private static final int ATTEMPT_NUMBER = 10;
    private static final String START_AUTOSTEP_LBL = "Start autostep [" + GraphDebugger.getCommandShortName("ston") + "]";
    private static final String STOP_AUTOSTEP_LBL = "Stop autostep [" + GraphDebugger.getCommandShortName("stoff") + "]";
    private static final String START_AUTOSTEP_ACTION = "start";
    private static final String STOP_AUTOSTEP_ACTION = "stop";
    private static final int START_AUTOSTEP_MNEMONIC = 65;
    private static final int STOP_AUTOSTEP_MNEMONIC = 85;
    private static String mainClassName;
    private static String[] dbgArgv;
    private static String hostname;
    private static int port;
    private static String chainingString;
    private JFrame jframe;
    private FindDialog findDialog;
    private GotoDialog gotoDialog;
    private QuickWatchDialog quickWatchDialog;
    private Vector<JPopupMenu> popupMenus = new Vector();
    private Rectangle breakpointSettingsDialogBds;
    private Rectangle sourceSettingsDialogBds;
    private Rectangle dataSettingsDialogBds;
    private Rectangle customizeCommandsDialogBds;
    private Rectangle customizeShortcutsDialogBds;
    private Rectangle sessionSettingsDialogBds;
    private HelpDialog helpDialog;
    private Rectangle acceptEnvVariableDialogBds;
    private Rectangle acceptVariableDialogBds;
    private Rectangle breakpointDialogBds;
    private Rectangle connectDialogBds;
    private Rectangle consoleSettingsDialogBds;
    private Rectangle displayVariableDialogBds;
    private Rectangle displayEnvVariableDialogBds;
    private Rectangle setParametersDialogBds;
    private Rectangle displayOffsetDialogBds;
    private Rectangle displayLengthDialogBds;
    private Rectangle stepToDialogBds;
    private Rectangle jumpToDialogBds;
    private Rectangle monitorDialogBds;
    private Rectangle settingsDialogBds;
    private Rectangle traceDialogBds;
    private DebugPanel preview;
    private String lparam;
    private List previousCommands = new Vector();
    private int previousCommandIndex = Integer.MIN_VALUE;
    private int lastCommandCode = -1;
    private DebugTM tm;
    private boolean remote;
    private boolean remoteThinClient;
    private boolean quitCmdExecuted = true;
    private volatile boolean processing;
    boolean stopImmediately = true;
    private boolean running;
    private boolean suspended;
    private boolean exitDebug;
    private String[] watchedVariableCommands;
    private int maxHexDumpLength;
    private int hexDumpStartOffset;
    private int maxArrayLength;
    private int arrayStartOffset;
    private int maxTextValueLength;
    private int maxTextValueLengthOutput;
    boolean dataSettingsChanged = true;
    private Timer autoStepTimer;
    private boolean isASActive;
    private JFileChooser fileChooser;
    private JMenu runMenu;
    private JMenu dataMenu;
    private JMenu bpMenu;
    private JMenuItem tronItem;
    private JMenuItem troffItem;
    private JMenuItem loadItem;
    private JMenuItem unloadItem;
    private JMenuItem saveDebugItem;
    private JMenuItem loadDebugItem;
    private JMenuItem exitItem;
    private JMenuItem setParametersItem;
    private JMenuItem displayEnvVarItem;
    private JMenuItem acceptEnvVarItem;
    private JMenuItem displayVersionItem;
    private JMenuItem startItem;
    private JMenuItem restartItem;
    private JMenuItem quitItem;
    private JMenuItem continueItem;
    private JMenuItem suspendItem;
    private JMenuItem stepIntoItem;
    private JMenuItem stepOverItem;
    private JMenuItem continueToLineItem;
    private JMenuItem runToSelLineItem;
    private JMenuItem runToNextProgItem;
    private JMenuItem stepOutParItem;
    private JMenuItem stepOutProgItem;
    private JMenuItem autostepItem;
    private JMenuItem copySourceItem;
    private JMenuItem firstItem;
    private JMenuItem firstExecItem;
    private JMenuItem lastItem;
    private JMenuItem currentLineItem;
    private JMenuItem findItem;
    private JMenuItem gotoItem;
    private JMenuItem gotoDeclItem;
    private DebugPanel.MyVarName gotoDeclItemVn;
    private JMenuItem backItem;
    private JMenuItem forwardItem;
    private JMenuItem findForwardItem;
    private JMenuItem findBackwardItem;
    private JMenuItem findFromTopItem;
    private JMenuItem expandAllCopyItem;
    private JMenuItem collapseAllCopyItem;
    private JMenuItem repeatFindItem;
    private JMenuItem clearoutItem;
    private JMenuItem lastCmdItem;
    private JMenuItem prevCmdItem;
    private JMenuItem nextCmdItem;
    private JMenuItem displayItem;
    private JMenuItem displayOnLineItem;
    private JMenuItem offsetItem;
    private JMenuItem lengthItem;
    private JMenuItem acceptItem;
    private JMenuItem setMonitorItem;
    private JMenuItem clearAllMonitorsItem;
    private JMenuItem setBreakpointItem;
    private JMenuItem toggleBreakpointItem;
    private JMenuItem clearAllBreakpointsItem;
    private JMenuItem commandsItem;
    private JMenuItem aboutItem;
    private JMenuItem incrFontSizeItem;
    private JMenuItem decrFontSizeItem;
    private JMenuItem jumpToItem;
    private JMenuItem jumpToSelLineItem;
    private JMenuItem jumpOutParItem;
    private JMenuItem jumpOutProgItem;
    private JMenuItem jumpNextItem;
    private JMenuItem fontsAndColorsItem;
    private JMenuItem shortcutsItem;
    private JMenuItem custCommandsItem;
    private JMenuItem consoleItem;
    private JMenuItem quickWatchItem;
    private JMenuItem refreshItem;
    private JMenuItem f10Item;
    private JRadioButtonMenuItem[] threadItems = new JRadioButtonMenuItem[0];
    private JRadioButtonMenuItem[] fontSizeItems = new JRadioButtonMenuItem[12];
    private JMenuItem dataItem;
    private JMenuItem breakpointsItem;
    private JMenuItem sessionItem;
    private Map commandEnablingTable = new HashMap();
    private MyDebuggerInvoker invoker;

    private GraphDebugger(MyDebuggerInvoker invoker, LocalDebugInfo dInfo, String title, boolean remote, boolean notifyClient) throws IOException {
        this.invoker = invoker;
        this.invoker.gd = this;
        this.remote = remote;
        DebuggerInvoker.setDefaultMonitorEnabledState(Settings.getDefaultMonitorEnabledState());
        DebuggerInvoker.setDefaultBreakpointEnabledState(Settings.getDefaultBreakpointEnabledState());
        this.jframe = new JFrame();
        this.jframe.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (GraphDebugger.this.preview != null) {
                    GraphDebugger.this.preview.hideTipPopup();
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.jframe.setDefaultCloseOperation(0);
        this.jframe.setTitle(title);
        this.remoteThinClient = notifyClient;
        this.preview = new DebugPanel(this, dInfo, true);
        this.createAndShow(notifyClient);
    }

    private void createAndShow(boolean notifyClient) {
        this.autoStepTimer = new Timer(1000, e -> this.setTextCommand("step"));
        this.autoStepTimer.setRepeats(false);
        this.findDialog = new FindDialog(this.jframe, "Find", false, this.preview);
        this.findDialog.setMatchCaseSelected(Settings.isFindMatchCase());
        this.findDialog.setMatchMinusUnderscoreSelected(Settings.isFindMatchMinusUnderscore());
        this.findDialog.setSearchFromTopSelected(Settings.isFindTopSearch());
        this.findDialog.setWholeWordsSelected(Settings.isFindWholeWord());
        this.findDialog.setWrapSearchSelected(Settings.isFindWrapSearch());
        this.findDialog.setBackwardSearchSelected(Settings.isFindBackwardSearch());
        this.gotoDialog = new GotoDialog(this.jframe, "Go To", false, this.preview);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir", ".")));
        this.fileChooser.addActionListener(e -> {
            String string = this.lparam = this.fileChooser.getSelectedFile() != null ? this.fileChooser.getSelectedFile().getAbsolutePath() : null;
            if (this.lparam != null) {
                this.lparam = this.lparam.replace('\\', '/');
                String className = DebugUtilities.getIscobolClassName(this.lparam);
                LocalDebugInfo dInfo = this.getInvoker().getInfo(className, this.processing, true);
                if (dInfo != null) {
                    if (dInfo.getErrorString() == null) {
                        this.preview.loadFile(dInfo, new Filename(dInfo.getSourcefile()), dInfo.getTimestamp(), true);
                    } else {
                        this.preview.loadFile(null, new Filename(this.lparam), dInfo.getTimestamp(), false);
                    }
                } else {
                    this.preview.loadFile(null, new Filename(this.lparam), 0L, false);
                }
            }
        });
        Rectangle winBds = Settings.getWindowBounds();
        if (winBds.x <= 0 || winBds.y <= 0) {
            this.jframe.setSize(winBds.getSize());
            this.jframe.setLocationRelativeTo(null);
        } else {
            this.jframe.setBounds(Settings.getWindowBounds());
        }
        this.buildMenuBar();
        Image icon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("favicon.gif"));
        this.jframe.getContentPane().setLayout(new GridLayout(1, 0));
        this.jframe.setIconImage(icon);
        this.jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (GraphDebugger.this.showConfirmExitDialog()) {
                    GraphDebugger.close(GraphDebugger.this, GraphDebugger.this.getInvoker());
                }
            }
        });
        this.jframe.getContentPane().add(this.preview);
        this.preview.setInitFocus();
        this.jframe.setVisible(true);
        this.preview.setVisible(true);
        int state = Settings.getWindowState();
        if (state != 0) {
            this.jframe.setExtendedState(state);
        }
        if (notifyClient) {
            System.out.println("Ready");
            System.out.flush();
            if (Settings.isConsoleAttached()) {
                new Thread(() -> {
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        String line = in.readLine();
                        while (line != null) {
                            System.out.println(line);
                            line = in.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }).start();
            }
        }
        if (Settings.isConsoleAttached()) {
            this.preview.overwriteSysOut();
            this.preview.overwriteSysErr();
        } else {
            GraphUtilities.setOut(GraphUtilities.systemOut);
            GraphUtilities.setErr(GraphUtilities.systemErr);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (e.getID() == 401 && e.getKeyCode() == 121 && e.getModifiers() == 0 && this.f10Item != null) {
                this.f10Item.doClick(20);
                e.consume();
                return true;
            }
            return false;
        });
        if (Settings.getLaf() == Settings.LAF.FLAT_DARK || Settings.getLaf() == Settings.LAF.FLAT_LIGHT) {
            SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this.jframe.getRootPane()));
        }
    }

    private void buildMenuBar() {
        JMenuBar bar = new JMenuBar();
        this.jframe.setJMenuBar(bar);
        JMenu file = new JMenu("File");
        file.setMnemonic(70);
        this.tronItem = new JMenuItem("Trace On... [" + GraphDebugger.getCommandShortName("tron") + "]", 78);
        file.add(this.tronItem).addActionListener(e -> this.showTraceDialog());
        this.troffItem = new JMenuItem("Trace Off [" + GraphDebugger.getCommandShortName("troff") + "]", 70);
        file.add(this.troffItem).addActionListener(e -> this.setTextCommand("troff"));
        file.addSeparator();
        this.loadItem = new JMenuItem("Load file...", 76);
        file.add(this.loadItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            this.fileChooser.showDialog(this.jframe, "Load");
        });
        this.unloadItem = new JMenuItem("Unload current file", 85);
        file.add(this.unloadItem).addActionListener(evt -> this.preview.unload());
        file.addSeparator();
        this.loadDebugItem = new JMenuItem("Load debugger session... [" + GraphDebugger.getCommandShortName("readsession") + "]", 68);
        file.add(this.loadDebugItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            JFileChooser jfc = this.getIsdFileChooser("Load debugger session", null);
            int ret = jfc.showDialog(this.jframe, "Load info");
            if (ret == 0) {
                this.setTextCommand("readsession " + jfc.getSelectedFile().getAbsolutePath());
            }
        });
        this.saveDebugItem = new JMenuItem("Save debugger session... [" + GraphDebugger.getCommandShortName("writesession") + "]", 69);
        file.add(this.saveDebugItem).addActionListener(e -> {
            JFileChooser jfc;
            int ret;
            this.preview.hideTipPopup();
            String fileName = Settings.getSessionOutputFileName();
            if (fileName.length() == 0) {
                fileName = mainClassName + ".isd";
            }
            if ((ret = (jfc = this.getIsdFileChooser("Save debugger session", fileName)).showDialog(this.jframe, "Save info")) == 0) {
                String fn = jfc.getSelectedFile().getAbsolutePath();
                if (fn.lastIndexOf(46) < 0) {
                    fn = fn + ".isd";
                }
                this.setTextCommand("writesession " + fn);
            }
        });
        file.addSeparator();
        this.exitItem = new JMenuItem("Exit", 88);
        file.add(this.exitItem).addActionListener(e -> {
            if (this.showConfirmExitDialog()) {
                GraphDebugger.close(this, this.getInvoker());
            }
        });
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        String msg = this.remote ? "Connect to" : "Set command line parameters";
        this.setParametersItem = new JMenuItem(msg + "...", 68);
        this.runMenu.add(this.setParametersItem).addActionListener(e -> {
            if (this.remote) {
                this.preview.hideTipPopup();
                ConnectDialog cd = new ConnectDialog(this.jframe, msg, hostname, "" + port);
                this.connectDialogBds = cd.openDialog(this.connectDialogBds);
                if (cd.isOk()) {
                    hostname = cd.getHost();
                    port = cd.getPort();
                }
            } else {
                this.preview.hideTipPopup();
                InputDialog d = new InputDialog(this.jframe, msg, "Arguments:", "this change will take effect at the next run", chainingString, 20, false, false);
                this.setParametersDialogBds = d.openDialog(this.setParametersDialogBds);
                String ret = d.getValue();
                if (ret != null) {
                    chainingString = ret;
                }
            }
        });
        this.runMenu.addSeparator();
        this.displayVersionItem = new JMenuItem("Display class info [" + GraphDebugger.getCommandShortName("display") + " " + "-classinfo" + "]", 70);
        this.runMenu.add(this.displayVersionItem).addActionListener(e -> this.setTextCommand("display -classinfo"));
        this.runMenu.addSeparator();
        String startTitle = this.remote ? "Connect" : "Start session";
        String imageName = this.remote ? "connect.gif" : "rundebug.gif";
        this.startItem = new JMenuItem(startTitle + " [" + GraphDebugger.getCommandShortName("run") + "]", new ImageIcon(GraphUtilities.getImage(imageName)));
        this.startItem.setMnemonic(69);
        this.runMenu.add(this.startItem).addActionListener(e -> this.setTextCommand("run " + chainingString));
        if (!this.remote) {
            this.restartItem = new JMenuItem("Restart session [" + GraphDebugger.getCommandShortName("restart") + "]", new ImageIcon(GraphUtilities.getImage("restart.png")));
            this.restartItem.setMnemonic(83);
            this.runMenu.add(this.restartItem).addActionListener(e -> this.setTextCommand("restart " + chainingString));
        }
        String quitTitle = this.remote ? "Disconnect" : "Finish session";
        imageName = this.remote ? "disconnect.gif" : "stop.gif";
        this.quitItem = new JMenuItem(quitTitle + " [" + GraphDebugger.getCommandShortName("quit") + "]", new ImageIcon(GraphUtilities.getImage(imageName)));
        this.quitItem.setMnemonic(78);
        this.runMenu.add(this.quitItem).addActionListener(e -> {
            if (this.processing) {
                if (this.showConfirmQuitDialog()) {
                    this.quitCmdExecuted = true;
                    this.getInvoker().exitDebug(this.isRemote() && Settings.getForceStopRun());
                }
            } else {
                this.setTextCommand("quit");
            }
        });
        this.runMenu.addSeparator();
        this.continueItem = new JMenuItem("Continue [" + GraphDebugger.getCommandShortName("continue") + "]", new ImageIcon(GraphUtilities.getImage("continue.gif")));
        this.continueItem.setMnemonic(67);
        this.runMenu.add(this.continueItem).addActionListener(e -> this.setTextCommand("continue"));
        this.suspendItem = new JMenuItem("Pause [" + GraphDebugger.getCommandShortName("pause") + "]", new ImageIcon(GraphUtilities.getImage("suspend.gif")));
        this.suspendItem.setMnemonic(85);
        this.runMenu.add(this.suspendItem).addActionListener(e -> this.setTextCommand("pause"));
        this.stepIntoItem = new JMenuItem("Step into [" + GraphDebugger.getCommandShortName("step") + "]", new ImageIcon(GraphUtilities.getImage("stepinto.gif")));
        this.stepIntoItem.setMnemonic(73);
        this.runMenu.add(this.stepIntoItem).addActionListener(e -> this.setTextCommand("step"));
        this.stepOverItem = new JMenuItem("Step over [" + GraphDebugger.getCommandShortName("next") + "]", new ImageIcon(GraphUtilities.getImage("stepover.gif")));
        this.stepOverItem.setMnemonic(79);
        this.runMenu.add(this.stepOverItem).addActionListener(e -> this.setTextCommand("next"));
        this.stepOutParItem = new JMenuItem("Step out paragraph [" + GraphDebugger.getCommandShortName("outpar") + "]", new ImageIcon(GraphUtilities.getImage("stepout.gif")));
        this.stepOutParItem.setMnemonic(80);
        this.runMenu.add(this.stepOutParItem).addActionListener(e -> this.setTextCommand("outpar"));
        this.stepOutProgItem = new JMenuItem("Step out program [" + GraphDebugger.getCommandShortName("outprog") + "]", new ImageIcon(GraphUtilities.getImage("stepoutprog.gif")));
        this.stepOutProgItem.setMnemonic(82);
        this.runMenu.add(this.stepOutProgItem).addActionListener(e -> this.setTextCommand("outprog"));
        this.runMenu.addSeparator();
        this.continueToLineItem = new JMenuItem("Continue to line number [" + GraphDebugger.getCommandShortName("to") + "]", 66);
        this.runMenu.add(this.continueToLineItem).addActionListener(e -> this.showStepToDialog());
        this.runToSelLineItem = new JMenuItem("Run to selected line", new ImageIcon(GraphUtilities.getImage("runtilcurs.gif")));
        this.runToSelLineItem.setMnemonic(84);
        this.runMenu.add(this.runToSelLineItem).addActionListener(e -> this.runToSelectedLine(this.preview.getSelectedLine(), this.preview.getFile()));
        this.runToNextProgItem = new JMenuItem("Run to next program [" + GraphDebugger.getCommandShortName("prog") + "]", new ImageIcon(GraphUtilities.getImage("runtilpgm.gif")));
        this.runToNextProgItem.setMnemonic(71);
        this.runMenu.add(this.runToNextProgItem).addActionListener(e -> this.setTextCommand("prog"));
        this.runMenu.addSeparator();
        this.autostepItem = new JMenuItem(START_AUTOSTEP_LBL, new ImageIcon(GraphUtilities.getImage("autostep.gif")));
        this.autostepItem.setActionCommand(START_AUTOSTEP_ACTION);
        this.autostepItem.setMnemonic(65);
        this.runMenu.add(this.autostepItem).addActionListener(e -> this.preview.setAutostepState(this.autostepItem.getActionCommand().equals(START_AUTOSTEP_ACTION)));
        this.runMenu.addSeparator();
        this.jumpNextItem = new JMenuItem("Jump next statement [" + GraphDebugger.getCommandShortName("jump") + " -next]", new ImageIcon(GraphUtilities.getImage("jumpover.gif")));
        this.jumpNextItem.setMnemonic(69);
        this.jumpNextItem.setEnabled(false);
        this.runMenu.add(this.jumpNextItem).addActionListener(e -> this.setTextCommand("jump -next"));
        this.jumpOutParItem = new JMenuItem("Jump out paragraph [" + GraphDebugger.getCommandShortName("jump") + " -outpar]", new ImageIcon(GraphUtilities.getImage("jumpout.gif")));
        this.jumpOutParItem.setMnemonic(77);
        this.jumpOutParItem.setEnabled(false);
        this.setCommandEnabled(29, false);
        this.runMenu.add(this.jumpOutParItem).addActionListener(e -> this.setTextCommand("jump -outpar"));
        this.jumpOutProgItem = new JMenuItem("Jump out program [" + GraphDebugger.getCommandShortName("jump") + " -outprog]", new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif")));
        this.jumpOutProgItem.setMnemonic(85);
        this.jumpOutProgItem.setEnabled(false);
        this.runMenu.add(this.jumpOutProgItem).addActionListener(e -> this.setTextCommand("jump -outprog"));
        this.jumpToItem = new JMenuItem("Jump to [" + GraphDebugger.getCommandShortName("jump") + "]");
        this.jumpToItem.setMnemonic(74);
        this.jumpToItem.setEnabled(false);
        this.runMenu.add(this.jumpToItem).addActionListener(e -> this.showJumpToDialog());
        this.jumpToSelLineItem = new JMenuItem("Jump to selected line", new ImageIcon(GraphUtilities.getImage("jump.gif")));
        this.jumpToSelLineItem.setMnemonic(83);
        this.jumpToSelLineItem.setEnabled(false);
        this.runMenu.add(this.jumpToSelLineItem).addActionListener(e -> {
            int row = this.preview.getSelectedLine();
            if (row >= 0) {
                CobolRef ref = this.preview.getFile().getBPArgs(this.preview.getListingline(row));
                this.setTextCommand("jump " + ref.lineNo() + " " + ref.filename() + " " + "-fi" + " " + ref.getFileIndex());
            }
        });
        this.runMenu.addSeparator();
        JMenu edit = new JMenu("Edit");
        edit.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GraphDebugger.this.gotoDeclItemVn = GraphDebugger.this.preview.getVarName();
                GraphDebugger.this.gotoDeclItem.setEnabled(GraphDebugger.this.gotoDeclItemVn != null);
                GraphDebugger.this.backItem.setEnabled(GraphDebugger.this.preview.canGoBack());
                GraphDebugger.this.forwardItem.setEnabled(GraphDebugger.this.preview.canGoForward());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GraphDebugger.this.gotoDeclItem.setEnabled(true);
                GraphDebugger.this.backItem.setEnabled(true);
                GraphDebugger.this.forwardItem.setEnabled(true);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        edit.setMnemonic(69);
        this.copySourceItem = new JMenuItem("Copy source code", 89);
        edit.add(this.copySourceItem).addActionListener(e -> this.preview.copy());
        edit.addSeparator();
        this.firstItem = new JMenuItem("First line [" + GraphDebugger.getCommandShortName("wt") + "]", 70);
        edit.add(this.firstItem).addActionListener(e -> this.preview.select(0, 0));
        this.firstExecItem = new JMenuItem("First executable line [" + GraphDebugger.getCommandShortName("w0") + "]", 88);
        edit.add(this.firstExecItem).addActionListener(e -> {
            DebugParagraph p = DebuggerInvoker.getFirstParagraphNoDecl(this.preview.getFile().getDebugParagraphs());
            if (p != null) {
                this.preview.goTo(p.getLineNumber(), p.getParagraphName(), p.getFileIndex());
            }
        });
        this.lastItem = new JMenuItem("Last line [" + GraphDebugger.getCommandShortName("wb") + "]", 76);
        edit.add(this.lastItem).addActionListener(e -> this.preview.selectLast());
        this.currentLineItem = new JMenuItem("Current line [" + GraphDebugger.getCommandShortName("w@") + "]", new ImageIcon(GraphUtilities.getImage("gotocurrline.gif")));
        this.currentLineItem.setMnemonic(85);
        edit.add(this.currentLineItem).addActionListener(e -> this.preview.selectCurrentLine());
        edit.addSeparator();
        this.findItem = new JMenuItem("Find...", new ImageIcon(GraphUtilities.getImage("find.gif")));
        this.findItem.setMnemonic(73);
        this.findItem.addActionListener(e -> {
            this.preview.hideTipPopup();
            String def = this.preview.getHighlightedVariable(true);
            if (def == null) {
                def = this.preview.getHighlightedWord();
            }
            this.findDialog.setVisible(def);
        });
        edit.add(this.findItem);
        this.repeatFindItem = new JMenuItem("Repeat find [" + GraphDebugger.getCommandShortName("f") + "]", new ImageIcon(GraphUtilities.getImage("find_repeat.gif")));
        this.repeatFindItem.setMnemonic(82);
        edit.add(this.repeatFindItem).addActionListener(e -> this.preview.repeatFind());
        this.findForwardItem = new JMenuItem("Find forwards... [" + GraphDebugger.getCommandShortName("ff") + "]", 78);
        edit.add(this.findForwardItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            this.findDialog.setBackwardSearchSelected(false);
            this.findDialog.setSearchFromTopSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        this.findBackwardItem = new JMenuItem("Find backwards... [" + GraphDebugger.getCommandShortName("fb") + "]", 83);
        edit.add(this.findBackwardItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            this.findDialog.setBackwardSearchSelected(true);
            this.findDialog.setSearchFromTopSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        this.findFromTopItem = new JMenuItem("Find from top... [" + GraphDebugger.getCommandShortName("ft") + "]", 84);
        edit.add(this.findFromTopItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            this.findDialog.setSearchFromTopSelected(true);
            this.findDialog.setBackwardSearchSelected(false);
            this.findDialog.setVisible(this.preview.getHighlightedWord());
        });
        edit.addSeparator();
        this.expandAllCopyItem = new JMenuItem("Expand all copy books", 66);
        edit.add(this.expandAllCopyItem).addActionListener(e -> this.preview.expandAllCopies());
        this.collapseAllCopyItem = new JMenuItem("Collapse all copy books", 67);
        edit.add(this.collapseAllCopyItem).addActionListener(e -> this.preview.collapseAllCopies());
        edit.addSeparator();
        this.gotoItem = new JMenuItem("Go to...", 71);
        edit.add(this.gotoItem).addActionListener(e -> this.showGotoDialog());
        this.gotoDeclItem = new JMenuItem("Go to declaration", 68);
        edit.add(this.gotoDeclItem).addActionListener(e -> {
            if (this.gotoDeclItemVn == null) {
                this.gotoDeclItemVn = this.preview.getVarName();
            }
            if (this.gotoDeclItemVn != null) {
                this.preview.gotoDeclaration(this.gotoDeclItemVn.varName);
                this.gotoDeclItemVn = null;
            }
        });
        this.backItem = new JMenuItem("Back", new ImageIcon(GraphUtilities.getImage("backward.png")));
        this.backItem.setMnemonic(75);
        edit.add(this.backItem).addActionListener(e -> {
            if (this.preview.canGoBack()) {
                this.preview.back();
            }
        });
        this.forwardItem = new JMenuItem("Forward", new ImageIcon(GraphUtilities.getImage("forward.png")));
        this.forwardItem.setMnemonic(87);
        edit.add(this.forwardItem).addActionListener(e -> {
            if (this.preview.canGoForward()) {
                this.preview.forward();
            }
        });
        edit.addSeparator();
        this.clearoutItem = new JMenuItem("Clear output", 79);
        edit.add(this.clearoutItem).addActionListener(e -> this.preview.clearOutput());
        edit.addSeparator();
        this.prevCmdItem = new JMenuItem("Previous command", 80);
        edit.add(this.prevCmdItem).addActionListener(e -> {
            String cmd = this.getPreviousCommand();
            if (cmd != null) {
                this.preview.setLineCommandText(cmd);
            }
        });
        this.nextCmdItem = new JMenuItem("Next command", 69);
        edit.add(this.nextCmdItem).addActionListener(e -> {
            String cmd = this.getNextCommand();
            if (cmd != null) {
                this.preview.setLineCommandText(cmd);
            }
        });
        this.lastCmdItem = new JMenuItem("Last command", 65);
        edit.add(this.lastCmdItem).addActionListener(e -> {
            this.previousCommandIndex = Integer.MIN_VALUE;
            String lastCommand = this.getPreviousCommand();
            if (lastCommand != null) {
                this.preview.setLineCommandText(lastCommand);
            }
        });
        this.dataMenu = new JMenu("Data");
        this.dataMenu.setMnemonic(68);
        this.displayEnvVarItem = new JMenuItem("Display environment variable... [" + GraphDebugger.getCommandShortName("display") + " " + "-env" + "]", 86);
        this.dataMenu.add(this.displayEnvVarItem).addActionListener(e -> this.showEnvDialog());
        this.acceptEnvVarItem = new JMenuItem("Change environment variable... [" + GraphDebugger.getCommandShortName("let") + " " + "-env" + "]", 72);
        this.dataMenu.add(this.acceptEnvVarItem).addActionListener(e -> this.showAcceptEnvVarDialog());
        this.dataMenu.addSeparator();
        this.displayItem = new JMenuItem("Display... [" + GraphDebugger.getCommandShortName("display") + "]", 68);
        this.dataMenu.add(this.displayItem).addActionListener(e -> this.showDisplayVariableDialog());
        this.displayOnLineItem = new JMenuItem("Display variables on selected line", 89);
        this.dataMenu.add(this.displayOnLineItem).addActionListener(e -> this.preview.displayVarsOnSelLine());
        this.offsetItem = new JMenuItem("Offset... [of]", 79);
        this.dataMenu.add(this.offsetItem).addActionListener(e -> this.showOffsetVariableDialog());
        this.lengthItem = new JMenuItem("Length... [len]", 76);
        this.dataMenu.add(this.lengthItem).addActionListener(e -> this.showLengthVariableDialog());
        this.quickWatchItem = new JMenuItem("Quick watch", 81);
        this.quickWatchItem.addActionListener(e -> {
            String vn = this.preview.getNormalizedVarName();
            String varname = vn != null ? vn : this.preview.getHighlightedVariable();
            this.showQuickWatchDialog(varname, this.preview.getSelectedModule());
        });
        this.dataMenu.add(this.quickWatchItem);
        this.quickWatchItem.setEnabled(false);
        this.refreshItem = new JMenuItem("Refresh Variables Area", 82);
        this.refreshItem.addActionListener(e -> this.preview.refreshVariables());
        this.dataMenu.add(this.refreshItem);
        this.refreshItem.setEnabled(false);
        this.dataMenu.addSeparator();
        this.acceptItem = new JMenuItem("Change value... [" + GraphDebugger.getCommandShortName("let") + "]", 65);
        this.dataMenu.add(this.acceptItem).addActionListener(e -> this.showAcceptVariableDialog());
        this.dataMenu.addSeparator();
        this.setMonitorItem = new JMenuItem("Set monitor... [" + GraphDebugger.getCommandShortName("monitor") + "]", 83);
        this.dataMenu.add(this.setMonitorItem).addActionListener(e -> this.showMonitorDialog());
        this.clearAllMonitorsItem = new JMenuItem("Clear all monitors [" + GraphDebugger.getCommandShortName("unmonitor") + " " + "-a" + "]", 69);
        this.dataMenu.add(this.clearAllMonitorsItem).addActionListener(e -> this.setTextCommand("unmonitor -a"));
        this.bpMenu = new JMenu("Breakpoint");
        this.bpMenu.setMnemonic(66);
        this.setBreakpointItem = new JMenuItem("Set... [" + GraphDebugger.getCommandShortName("break") + "]", 115);
        this.bpMenu.add(this.setBreakpointItem).addActionListener(e -> this.showBreakpointDialog(null));
        this.toggleBreakpointItem = new JMenuItem("Toggle breakpoint at current line", 99);
        this.bpMenu.add(this.toggleBreakpointItem).addActionListener(e -> this.toggleBreakpoint(this.preview.getSelectedLine(), this.preview.getFile(), !this.preview.hasNestedPrograms(), this.preview.getBreakpoint(this.preview.getSelectedLine())));
        this.clearAllBreakpointsItem = new JMenuItem("Clear all [" + GraphDebugger.getCommandShortName("clear") + " " + "-a" + "]", 97);
        this.bpMenu.add(this.clearAllBreakpointsItem).addActionListener(e -> this.setTextCommand("clear -a"));
        JMenu settings = new JMenu("Settings");
        settings.setMnemonic(83);
        this.dataItem = new JMenuItem("Data", 68);
        this.dataItem.addActionListener(e -> this.showDataSettingsDialog());
        settings.add(this.dataItem);
        this.breakpointsItem = new JMenuItem("Breakpoint", 66);
        this.breakpointsItem.addActionListener(e -> this.showBreakpointsSettingsDialog());
        settings.add(this.breakpointsItem);
        JMenuItem sourceItem = new JMenuItem("Source", 82);
        sourceItem.addActionListener(e -> this.showSourceSettingsDialog());
        settings.add(sourceItem);
        JMenu fsizeMenu = new JMenu("Font size");
        fsizeMenu.setMnemonic(70);
        settings.add(fsizeMenu);
        this.incrFontSizeItem = new JMenuItem("Increment font size", 73);
        fsizeMenu.add(this.incrFontSizeItem).addActionListener(e -> {
            this.preview.setSourceFontSize(this.preview.getSourceFontSize() + 1);
            this.fontSizeItems[this.preview.getSourceFontSize() - 9].setSelected(true);
        });
        this.decrFontSizeItem = new JMenuItem("Decrement font size", 68);
        fsizeMenu.add(this.decrFontSizeItem).addActionListener(e -> {
            this.preview.setSourceFontSize(this.preview.getSourceFontSize() - 1);
            this.fontSizeItems[this.preview.getSourceFontSize() - 9].setSelected(true);
        });
        ButtonGroup fsizeGroup = new ButtonGroup();
        int i = 0;
        int fs = 9;
        while (fs <= 20) {
            this.fontSizeItems[i] = new JRadioButtonMenuItem("" + fs, fs == this.preview.getSourceFontSize());
            int ffs = fs++;
            fsizeMenu.add(this.fontSizeItems[i]).addActionListener(e -> this.preview.setSourceFontSize(ffs));
            fsizeGroup.add(this.fontSizeItems[i]);
            ++i;
        }
        JMenu custom = new JMenu("Customize");
        settings.add(custom);
        custom.setMnemonic('c');
        this.custCommandsItem = new JMenuItem("Commands", 99);
        custom.add(this.custCommandsItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            CustomizeCommandsDialog ccd = new CustomizeCommandsDialog(this.jframe, "Commands");
            this.customizeCommandsDialogBds = ccd.openDialog(this.customizeCommandsDialogBds);
        });
        this.shortcutsItem = new JMenuItem("Shortcuts", 115);
        custom.add(this.shortcutsItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            CustomizeShortcutsDialog csd = new CustomizeShortcutsDialog(this.jframe, "Shortcuts", this);
            this.customizeShortcutsDialogBds = csd.openDialog(this.customizeShortcutsDialogBds);
        });
        this.fontsAndColorsItem = new JMenuItem("Fonts And Colors", 102);
        custom.add(this.fontsAndColorsItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            SettingsDialog sd = new SettingsDialog(this.jframe, "Fonts and Colors", true, this.preview);
            this.settingsDialogBds = sd.openDialog(this.settingsDialogBds);
        });
        this.sessionItem = new JMenuItem("Session", 83);
        this.sessionItem.addActionListener(e -> this.showSessionSettingsDialog());
        settings.add(this.sessionItem);
        this.consoleItem = new JMenuItem("Console", 79);
        this.consoleItem.addActionListener(e -> this.showConsoleSettingsDialog());
        settings.add(this.consoleItem);
        boolean b = Settings.isFlatLafAvailable();
        JMenu laf = new JMenu("Look and Feel");
        ButtonGroup lafGroup = new ButtonGroup();
        JMenu flatlaf = new JMenu("FlatLaf");
        laf.add(flatlaf);
        JRadioButtonMenuItem darkItem = new JRadioButtonMenuItem(Settings.LAF.FLAT_DARK.toString());
        darkItem.setActionCommand(Settings.LAF.FLAT_DARK.name());
        flatlaf.add(darkItem);
        darkItem.setEnabled(b);
        lafGroup.add(darkItem);
        JRadioButtonMenuItem lightItem = new JRadioButtonMenuItem(Settings.LAF.FLAT_LIGHT.toString());
        lightItem.setActionCommand(Settings.LAF.FLAT_LIGHT.name());
        flatlaf.add(lightItem);
        lightItem.setEnabled(b);
        lafGroup.add(lightItem);
        JRadioButtonMenuItem systemItem = new JRadioButtonMenuItem(Settings.LAF.SYSTEM.toString());
        systemItem.setActionCommand(Settings.LAF.SYSTEM.name());
        laf.add(systemItem);
        lafGroup.add(systemItem);
        JRadioButtonMenuItem metalItem = new JRadioButtonMenuItem(Settings.LAF.METAL.toString());
        metalItem.setActionCommand(Settings.LAF.METAL.name());
        laf.add(metalItem);
        lafGroup.add(metalItem);
        JRadioButtonMenuItem nimbusItem = new JRadioButtonMenuItem(Settings.LAF.NIMBUS.toString());
        nimbusItem.setActionCommand(Settings.LAF.NIMBUS.name());
        laf.add(nimbusItem);
        lafGroup.add(nimbusItem);
        switch (Settings.getLaf()) {
            default: {
                darkItem.setSelected(true);
                break;
            }
            case FLAT_LIGHT: {
                lightItem.setSelected(true);
                break;
            }
            case SYSTEM: {
                systemItem.setSelected(true);
                break;
            }
            case METAL: {
                metalItem.setSelected(true);
                break;
            }
            case NIMBUS: {
                nimbusItem.setSelected(true);
            }
        }
        ActionListener al = e -> {
            Settings.LAF currLaf = Settings.LAF.valueOf(e.getActionCommand());
            try {
                Settings.setLaf(currLaf);
                UIManager.setLookAndFeel(currLaf.getLaf());
            }
            catch (Exception ex) {
                System.err.println("Failed to load '" + currLaf.getLaf() + "' laf, restored '" + UIManager.getSystemLookAndFeelClassName() + "'");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Settings.setLaf(Settings.LAF.SYSTEM);
            }
            JFrame frame = this.getFrame();
            JRootPane rootPane = frame.getRootPane();
            SwingUtilities.updateComponentTreeUI(rootPane);
            if (this.findDialog != null) {
                SwingUtilities.updateComponentTreeUI(this.findDialog.getRootPane());
            }
            if (this.quickWatchDialog != null) {
                SwingUtilities.updateComponentTreeUI(this.quickWatchDialog.getRootPane());
            }
            if (this.gotoDialog != null) {
                SwingUtilities.updateComponentTreeUI(this.gotoDialog.getRootPane());
            }
            if (this.helpDialog != null) {
                SwingUtilities.updateComponentTreeUI(this.helpDialog.getRootPane());
            }
            if (this.fileChooser != null) {
                SwingUtilities.updateComponentTreeUI(this.fileChooser);
            }
            for (JPopupMenu pm : this.popupMenus) {
                SwingUtilities.updateComponentTreeUI(pm);
            }
            frame.dispose();
            frame.setVisible(true);
            Settings.loadFontAndColors();
            SettingsDialog.performApply(Settings.getSettings(), this.preview, true);
        };
        if (b) {
            darkItem.addActionListener(al);
            lightItem.addActionListener(al);
        }
        systemItem.addActionListener(al);
        metalItem.addActionListener(al);
        nimbusItem.addActionListener(al);
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        this.commandsItem = new JMenuItem("Commands... [" + GraphDebugger.getCommandShortName("help") + "]", 67);
        help.add(this.commandsItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            this.showHelpDialog(null);
        });
        this.aboutItem = new JMenuItem("About...", 65);
        help.add(this.aboutItem).addActionListener(e -> {
            this.preview.hideTipPopup();
            JOptionPane.showMessageDialog(this.jframe, GraphDebugger.version(), TITLE, 1);
        });
        this.setAccelerators();
        bar.add(file);
        bar.add(edit);
        bar.add(this.runMenu);
        bar.add(this.dataMenu);
        bar.add(this.bpMenu);
        bar.add(settings);
        bar.add(laf);
        bar.add(help);
        this.unloadItem.setEnabled(false);
        if (this.restartItem != null) {
            this.restartItem.setEnabled(false);
        }
        this.setCommandEnabled(58, false);
        this.quitItem.setEnabled(false);
        this.setCommandEnabled(21, false);
        this.continueItem.setEnabled(false);
        this.setCommandEnabled(1, false);
        this.suspendItem.setEnabled(false);
        this.setCommandEnabled(28, false);
        this.stepIntoItem.setEnabled(false);
        this.setCommandEnabled(3, false);
        this.stepOverItem.setEnabled(false);
        this.setCommandEnabled(4, false);
        this.continueToLineItem.setEnabled(false);
        this.setCommandEnabled(12, false);
        this.runToSelLineItem.setEnabled(false);
        this.setCommandEnabled(56, false);
        this.runToNextProgItem.setEnabled(false);
        this.jumpToItem.setEnabled(false);
        this.setCommandEnabled(29, false);
        this.jumpToSelLineItem.setEnabled(false);
        this.jumpOutParItem.setEnabled(false);
        this.jumpOutProgItem.setEnabled(false);
        this.jumpNextItem.setEnabled(false);
        this.stepOutParItem.setEnabled(false);
        this.setCommandEnabled(10, false);
        this.stepOutProgItem.setEnabled(false);
        this.setCommandEnabled(11, false);
        this.displayItem.setEnabled(false);
        this.offsetItem.setEnabled(false);
        this.lengthItem.setEnabled(false);
        this.setCommandEnabled(5, false);
        this.displayOnLineItem.setEnabled(false);
        this.quickWatchItem.setEnabled(false);
        if (this.displayVersionItem != null) {
            this.displayVersionItem.setEnabled(false);
        }
        this.acceptItem.setEnabled(false);
        this.setCommandEnabled(6, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (!this.exitDebug) {
            GraphDebugger graphDebugger = this;
            synchronized (graphDebugger) {
                boolean b = this.quitCmdExecuted;
                this.quitCmdExecuted = false;
                if (!this.getInvoker().isRunning() && !b && this.remote && Settings.getAutoConnect()) {
                    this.lastCommandCode = 2;
                    this.process(true);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.exitDebug) {
                    this.process(false);
                }
            }
        }
    }

    boolean canJump(DebugResponse resp) {
        return this.preview.getFile().isSupportingJumpCommand();
    }

    private static GraphDebugger start(MyDebuggerInvoker invoker, DebugResponse resp, LocalDebugInfo dInfo, boolean notifyClient, boolean remote) throws IOException {
        String title = TITLE;
        if (remote) {
            title = title + " [Remote execution]";
        }
        GraphDebugger Return2 = new GraphDebugger(invoker, dInfo, title, remote, notifyClient);
        invoker.setFileLoaderHelper(Return2);
        if (remote) {
            Return2.setRunCommandsButtonsEnabled(true, Return2.canJump(null));
            Return2.processing = true;
            Return2.setEnabledAll(false, false);
            Return2.handleResponse(resp, true);
            boolean bl = Return2.stopImmediately = resp.getFirstBlockMode() != 1;
            if (!Return2.stopImmediately) {
                Return2.running = true;
                Return2.setEnabledAll(false, false);
                if (invoker.isRunning()) {
                    invoker.processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
                    Return2.loadDebugSession();
                }
                GraphDebugger.getAsynchronousResponse(() -> {
                    DebugResponse r = invoker.getResponse(1);
                    Return2.handleResponse(r, true);
                    Return2.processing = false;
                    Return2.setEnabledAll(true, Return2.canJump(r));
                });
            } else {
                resp = invoker.getResponse();
                Return2.handleResponse(resp, true);
                if (invoker.isRunning()) {
                    invoker.processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
                    Return2.loadDebugSession();
                }
                Return2.processing = false;
                Return2.setEnabledAll(true, Return2.canJump(resp));
            }
        } else {
            Return2.setRunCommandsButtonsEnabled(false, Return2.canJump(null));
            if (invoker.isRunning()) {
                Return2.loadDebugSession();
            }
            Return2.processing = false;
        }
        Return2.run();
        return Return2;
    }

    public String getLastCommand() {
        if (!this.previousCommands.isEmpty()) {
            return (String)this.previousCommands.get(this.previousCommands.size() - 1);
        }
        return null;
    }

    public void setLastCommand(String cmd) {
        String lastCommand = this.getLastCommand();
        if (lastCommand == null || !lastCommand.equals(cmd)) {
            if (this.previousCommands.size() == 50) {
                this.previousCommands.remove(0);
            }
            this.previousCommands.add(cmd);
            this.preview.setLastCommand(cmd);
        }
        this.previousCommandIndex = Integer.MIN_VALUE;
    }

    public String getPreviousCommand() {
        if (this.previousCommandIndex == Integer.MIN_VALUE) {
            if (!this.previousCommands.isEmpty()) {
                this.previousCommandIndex = this.previousCommands.size() - 1;
            }
        } else if (this.previousCommandIndex == this.previousCommands.size() - 1 && this.previousCommands.size() > 1) {
            --this.previousCommandIndex;
        }
        if (this.previousCommandIndex >= 0 && !this.previousCommands.isEmpty()) {
            String cmd = (String)this.previousCommands.get(this.previousCommandIndex);
            if (this.previousCommandIndex > 0) {
                --this.previousCommandIndex;
            }
            return cmd;
        }
        return null;
    }

    public String getNextCommand() {
        if (this.previousCommandIndex == Integer.MIN_VALUE) {
            return null;
        }
        if (this.previousCommandIndex == 0 && this.previousCommands.size() > 1) {
            ++this.previousCommandIndex;
        }
        if (this.previousCommandIndex < this.previousCommands.size()) {
            String cmd = (String)this.previousCommands.get(this.previousCommandIndex);
            if (this.previousCommandIndex < this.previousCommands.size() - 1) {
                ++this.previousCommandIndex;
            }
            return cmd;
        }
        return null;
    }

    public String[] setTextCommand(String c) {
        block63: {
            block64: {
                if (c == null) break block63;
                c = c.trim();
                String lastCommand = this.getLastCommand();
                if (c.length() == 0 && lastCommand != null) {
                    c = lastCommand;
                }
                if (c.length() <= 0) break block64;
                String firstToken = new StringTokenizer(c).nextToken();
                String alias = Settings.getCommandAlias("debugger.commands.alias." + firstToken);
                if (alias != null) {
                    c = new StringBuffer(c).replace(0, firstToken.length(), alias).toString();
                }
                lastCommand = c;
                this.setLastCommand(lastCommand);
                this.tm = new DebugTMWithAliases(lastCommand, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                int cmd = -1;
                try {
                    cmd = this.tm.getCommand(this.tm.getToken());
                    if (!this.isCommandEnabled(cmd)) {
                        this.preview.outputResult("- command not allowed" + eol, true);
                        return null;
                    }
                }
                catch (DebuggerException de) {
                    this.preview.outputResult(de.getMessage() + eol, true);
                    return null;
                }
                switch (cmd) {
                    case 21: 
                    case 58: {
                        if (this.processing) {
                            this.preview.outputResult("- debugger running" + eol, true);
                            break;
                        }
                        this.setCommand(cmd);
                        break;
                    }
                    case 28: {
                        if (!this.processing) {
                            this.preview.outputResult("- the debugger is already paused" + eol, true);
                            break;
                        }
                        this.setSuspended(true);
                        this.getInvoker().suspend();
                        break;
                    }
                    case 2: {
                        String cn;
                        if (this.processing) {
                            this.preview.outputResult("- debugger running" + eol, true);
                            break;
                        }
                        if (this.tm.countTokens() == 0 && (cn = GraphDebugger.getChainingString()).length() > 0) {
                            lastCommand = "run " + cn;
                            this.setLastCommand(lastCommand);
                            this.tm = new DebugTMWithAliases(lastCommand, " ,;(:=)+*\"<>", DebuggerInvoker.defCommands);
                            this.tm.getToken();
                        }
                        this.setCommand(cmd);
                        break;
                    }
                    case 27: {
                        if (this.showConfirmExitDialog()) {
                            GraphDebugger.close(this, this.getInvoker());
                            break;
                        }
                        break block63;
                    }
                    case 17: {
                        if (this.tm.countTokens() == 0) {
                            this.showTraceDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 26: {
                        if (this.tm.countTokens() == 0) {
                            this.showEnvDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 20: {
                        this.preview.hideTipPopup();
                        this.showHelpDialog(this.tm.getToken());
                        break;
                    }
                    case 31: {
                        this.preview.doFind(lastCommand, false, false);
                        break;
                    }
                    case 32: {
                        this.preview.doFind(lastCommand, true, false);
                        break;
                    }
                    case 33: {
                        this.preview.doFind(lastCommand, false, true);
                        break;
                    }
                    case 34: {
                        this.preview.repeatFind();
                        break;
                    }
                    case 35: {
                        this.preview.select(0, 0);
                        break;
                    }
                    case 36: {
                        this.preview.selectLast();
                        break;
                    }
                    case 37: {
                        this.preview.selectCurrentLine();
                        break;
                    }
                    case 38: {
                        DebugParagraph p = DebuggerInvoker.getFirstParagraphNoDecl(this.preview.getFile().getDebugParagraphs());
                        if (p != null) {
                            this.preview.goTo(p.getLineNumber(), p.getParagraphName(), p.getFileIndex());
                            break;
                        }
                        break block63;
                    }
                    case 39: {
                        try {
                            AutoOnCommand autoon = (AutoOnCommand)this.getInvoker().parseCommand(cmd, this.tm);
                            if (autoon.isGet()) {
                                this.preview.outputResult("Autostep Delay: " + this.preview.getAutostepDelay(), false);
                                break;
                            }
                            if (autoon.isSet()) {
                                this.preview.setAutostepDelay(autoon.getDelay());
                                this.preview.outputResult("Autostep Delay: " + this.preview.getAutostepDelay(), false);
                                break;
                            }
                            this.preview.setAutostepState(true);
                        }
                        catch (DebuggerException ex) {
                            this.preview.outputResult(ex.getMessage() + eol, true);
                        }
                        break;
                    }
                    case 40: {
                        this.preview.setAutostepState(false);
                        break;
                    }
                    case 5: {
                        if (this.tm.countTokens() == 0) {
                            this.showDisplayVariableDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 54: {
                        if (this.tm.countTokens() == 0) {
                            this.showLengthVariableDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 55: {
                        if (this.tm.countTokens() == 0) {
                            this.showOffsetVariableDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 6: {
                        if (this.tm.countTokens() == 0) {
                            this.showAcceptVariableDialog();
                            break;
                        }
                        try {
                            DebugTM.Marker mk = this.tm.setMarker();
                            LetCommand lc = (LetCommand)this.getInvoker().parseCommand(cmd, this.tm);
                            if (lc.getNewValue() != null) {
                                this.tm.rewindToMarker(mk);
                                this.caseDefault(cmd);
                                break;
                            }
                            if (this.processing) {
                                this.preview.outputResult(LetCommand.USAGE + eol, false);
                                break;
                            }
                            String dc = "display" + c.substring(c.indexOf(32));
                            DebugResponse resp = this.getInvoker().processCommand(dc);
                            if (resp != null && resp.getReturnCode() == 0) {
                                return new String[]{c + "=" + resp.getVarValue(), Integer.toString(c.length() + 1)};
                            }
                            this.tm.rewindToMarker(mk);
                            this.caseDefault(cmd);
                        }
                        catch (DebuggerException ex) {
                            this.preview.outputResult(ex.getMessage() + eol, true);
                        }
                        break;
                    }
                    case 12: {
                        if (this.tm.countTokens() == 0) {
                            this.showStepToDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 29: {
                        if (this.preview.getFile().isSupportingJumpCommand()) {
                            if (this.tm.countTokens() == 0) {
                                this.showJumpToDialog();
                                break;
                            }
                            this.caseDefault(cmd);
                            break;
                        }
                        this.preview.outputResult("- JUMP command not supported for this program. Please recompile with -dx option" + eol, true);
                        break;
                    }
                    case 13: {
                        if (this.tm.countTokens() == 0) {
                            this.showMonitorDialog();
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 0: {
                        if (this.tm.countTokens() == 0) {
                            this.showBreakpointDialog(null);
                            break;
                        }
                        this.caseDefault(cmd);
                        break;
                    }
                    case 16: {
                        this.caseDefault(cmd);
                        break;
                    }
                    case 1: {
                        if (this.suspended) {
                            this.setSuspended(false);
                            this.getInvoker().resume();
                            break;
                        }
                    }
                    default: {
                        this.caseDefault(cmd);
                    }
                }
                break block63;
            }
            if (this.processing) {
                this.preview.outputResult("- debugger running" + eol, true);
            } else {
                this.setCommand(this.lastCommandCode);
            }
        }
        return null;
    }

    private void caseDefault(int cmd) {
        if (this.processing && !this.isCommandAllowedInProcessing(cmd)) {
            this.preview.outputResult("- debugger running" + eol, true);
        } else {
            this.setCommand(cmd);
        }
    }

    private synchronized void setCommand(int code) {
        this.lastCommandCode = code;
        this.notify();
    }

    protected synchronized void setAllBreakpointsEnabledCommand(boolean enable) {
        this.lastCommandCode = enable ? 48 : 49;
        this.notify();
    }

    protected synchronized void setAllMonitorsEnabledCommand(boolean enable) {
        this.lastCommandCode = enable ? 50 : 51;
        this.notify();
    }

    private boolean startRemoteSession(DebugResponse resp) {
        boolean bl = this.stopImmediately = !this.remote || resp.getFirstBlockMode() != 1;
        if (this.remote) {
            this.preview.outputResult("+ Connected at host '" + hostname + "' on port " + port + eol, false);
            this.handleResponse(resp, true);
            this.processing = true;
            if (this.restartItem != null) {
                this.restartItem.setEnabled(true);
            }
            this.quitItem.setEnabled(true);
            this.setCommandEnabled(21, true);
            this.preview.setQuitEnabled(true);
            if (this.stopImmediately) {
                resp = this.getInvoker().getResponse();
            } else {
                this.setEnabledAll(false, false);
                GraphDebugger.getAsynchronousResponse(() -> {
                    DebugResponse r = this.getInvoker().getResponse(1);
                    this.handleResponse(r, true);
                    this.processing = false;
                    this.setEnabledAll(true, this.canJump(r));
                    this.reloadSession(this.preview.getBreakpoints(), this.preview.getMonitors(), this.watchedVariableCommands);
                });
            }
        }
        if (this.stopImmediately) {
            boolean programFinished = this.handleResponse(resp, true);
            this.processing = false;
            return programFinished;
        }
        return false;
    }

    private String connectionRefusedMsg() {
        return GraphDebugger.connectionRefusedMsg(hostname, port);
    }

    private static String connectionRefusedMsg(String hostname, int port) {
        return "- Connection refused: host = '" + hostname + "', port = " + port;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void process(boolean reconnect) {
        boolean alreadyProcessing;
        block30: {
            boolean programFinished;
            block29: {
                DebugResponse resp;
                boolean ok;
                block31: {
                    programFinished = false;
                    if (this.getInvoker().isRunning()) break block30;
                    this.setRunEnabled(false);
                    this.preview.outputResult("Restarting debugger..." + eol, false);
                    this.preview.resetIdxs();
                    ok = false;
                    if (!this.remote) break block31;
                    int rc = 106;
                    resp = null;
                    if (!reconnect) {
                        resp = this.getInvoker().invokeRemote(hostname, port, 1, true);
                        rc = resp.getReturnCode();
                    }
                    boolean bl = ok = !DebugResponse.isErrorCode(rc);
                    if (ok) {
                        programFinished = this.startRemoteSession(resp);
                        break block29;
                    } else {
                        if (!Settings.getAutoConnect()) {
                            System.out.println(this.connectionRefusedMsg());
                            this.setRunEnabled(true);
                            return;
                        }
                        resp = GraphDebugger.showAutoConnectDialog(this.invoker, this.jframe);
                        boolean bl2 = ok = resp != null && !DebugResponse.isErrorCode(rc = resp.getReturnCode());
                        if (ok) {
                            programFinished = this.startRemoteSession(resp);
                            break block29;
                        } else {
                            if (resp == null) {
                                this.quitCmdExecuted = true;
                            }
                            System.out.println(this.connectionRefusedMsg());
                            this.setRunEnabled(true);
                            return;
                        }
                    }
                }
                int port = this.getInvoker().launchIsCobolProgram(dbgArgv);
                boolean bl = ok = port > 0;
                if (!ok) {
                    this.setRunEnabled(true);
                    return;
                }
                resp = this.getInvoker().invokeRemote("localhost", port, 10, true);
                int rc = resp.getReturnCode();
                if (!DebugResponse.isErrorCode(rc)) {
                    programFinished = this.startRemoteSession(resp);
                }
            }
            if (programFinished) {
                return;
            }
            if (this.remote && !this.remoteThinClient) {
                this.getInvoker().processCommand(new SetRedirectStreamsCommand(Settings.isConsoleAttached()));
            }
            this.reloadSession(this.preview.getBreakpoints(), this.stopImmediately ? this.preview.getMonitors() : null, this.stopImmediately ? this.watchedVariableCommands : null);
        }
        if (!(alreadyProcessing = this.processing)) {
            this.processing = true;
            this.setEnabledAll(false, false);
        }
        switch (this.lastCommandCode) {
            case -1: {
                break;
            }
            case 2: {
                this.setRunQuitEnabled(true);
                if (this.remote) break;
                this.genericCommand();
                break;
            }
            case 48: {
                this.handleResponse(this.setAllBreakpointsEnabled(this.preview.getBreakpoints(), true), false);
                break;
            }
            case 49: {
                this.handleResponse(this.setAllBreakpointsEnabled(this.preview.getBreakpoints(), false), false);
                break;
            }
            case 50: {
                this.handleResponse(this.setAllMonitorsEnabled(this.preview.getMonitors(), true), false);
                break;
            }
            case 51: {
                this.handleResponse(this.setAllMonitorsEnabled(this.preview.getMonitors(), false), false);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                this.genericCommand();
                break;
            }
            case 21: {
                if (!this.showConfirmQuitDialog()) break;
                this.quitCmdExecuted = true;
                this.stopSession();
                break;
            }
            case 58: {
                if (!this.showConfirmRestartDialog()) break;
                this.stopSession();
                StringBuffer sb = new StringBuffer("run");
                if (this.tm.countTokens() > 1) {
                    String tk = this.tm.getAllToken();
                    while (tk != null) {
                        sb.append(tk);
                        tk = this.tm.getAllToken();
                    }
                } else if (GraphDebugger.getChainingString() != null) {
                    sb.append(" ");
                    sb.append(GraphDebugger.getChainingString());
                }
                SwingUtilities.invokeLater(() -> this.setTextCommand(sb.toString()));
                break;
            }
            default: {
                if (this.getLastCommand() == null) break;
                this.genericCommand();
            }
        }
        if (!alreadyProcessing) {
            this.setEnabledAll(true, this.canJump(null));
            if (!this.running) {
                this.setRunEnabled(true);
            }
            this.processing = false;
        }
    }

    private void reloadSession(Breakpoint[] bps, Watch[] ws, String[] wvc) {
        Vector<DebugCommand> cmdList = new Vector<DebugCommand>();
        cmdList.addElement(new ClearBreakpointCommand(true));
        if (ws != null) {
            cmdList.addElement(new ClearMonitorCommand(true));
        }
        DebugResponse r = null;
        if (bps != null) {
            for (Breakpoint bp : bps) {
                try {
                    cmdList.addElement(this.getInvoker().parseCommand(bp.getDebugCommand()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (ws != null) {
            for (Watch w : ws) {
                try {
                    cmdList.addElement(this.getInvoker().parseCommand(w.getDebugCommand()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (wvc != null) {
            for (String s : wvc) {
                try {
                    DisplayCommand cmd = (DisplayCommand)this.getInvoker().parseCommand(s);
                    cmd.setDeferredIfNotRunning(true);
                    cmdList.addElement(cmd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!cmdList.isEmpty()) {
            CompositeCommand cmd = new CompositeCommand(cmdList);
            r = this.getInvoker().processCommand(cmd);
        }
        if (r != null) {
            bps = r.getBreakpoints();
            if (bps != null) {
                this.preview.setBreakpoints(bps);
            }
            this.preview.setMonitors(r.getMonitors());
        }
    }

    private DebugResponse setAllMonitorsEnabled(Watch[] ws, boolean enabled) {
        DebugResponse r = null;
        StringBuffer msg = new StringBuffer();
        if (ws.length > 0) {
            for (int i = 0; i < ws.length; ++i) {
                ws[i].setEnabled(enabled);
                r = this.getInvoker().processCommand(ws[i].getDebugCommand());
                if (r == null) continue;
                msg.append(r.getMessage());
            }
        }
        if (r != null) {
            r.setMessage(msg.toString());
        }
        return r;
    }

    private DebugResponse setAllBreakpointsEnabled(Breakpoint[] bps, boolean enabled) {
        DebugResponse r = null;
        StringBuffer msg = new StringBuffer();
        if (bps.length > 0) {
            for (int i = 0; i < bps.length; ++i) {
                bps[i].setEnabled(enabled);
                r = this.getInvoker().processCommand(bps[i].getDebugCommand());
                if (r == null) continue;
                msg.append(r.getMessage());
            }
        }
        if (r != null) {
            r.setMessage(msg.toString());
        }
        return r;
    }

    void setUnloadEnabled(boolean e) {
        if (this.unloadItem != null) {
            this.unloadItem.setEnabled(e);
        }
    }

    void stopSession() {
        this.getInvoker().exitDebug(this.isRemote() && Settings.getForceStopRun());
        this.running = false;
        this.preview.setAutostepState(false);
        this.setRunCommandsButtonsEnabled(false, false);
        this.preview.setParStack(null);
        this.preview.setMemory(0L, 0L);
        this.preview.deactivateMonitors();
        this.watchedVariableCommands = this.preview.getWatchedVariableCommands();
        this.preview.clearTrees();
        this.maxHexDumpLength = 0;
        this.hexDumpStartOffset = 0;
        this.maxArrayLength = 0;
        this.arrayStartOffset = 0;
        this.maxTextValueLength = 0;
        this.maxTextValueLengthOutput = 0;
        this.dataSettingsChanged = true;
        this.setThreads(null, null);
        this.preview.outputResult("- Program finished" + eol, false);
    }

    private void setEnabledAll(boolean e, boolean jumpEnabled) {
        this.setRunMenuEnabled(e && this.running, jumpEnabled);
        this.preview.setEnabledAll(e && this.running, jumpEnabled);
    }

    private void setRunMenuEnabled(boolean e, boolean jumpEnabled) {
        this.dataMenu.setEnabled(e);
        if (this.stopImmediately) {
            this.bpMenu.setEnabled(this.running ? e : true);
        }
        this.stepIntoItem.setEnabled(e);
        this.setCommandEnabled(3, e);
        this.stepOverItem.setEnabled(e);
        this.setCommandEnabled(4, e);
        this.continueItem.setEnabled(e);
        this.setCommandEnabled(1, e);
        this.suspendItem.setEnabled(!e && this.running);
        this.setCommandEnabled(28, !e && this.running);
        this.continueToLineItem.setEnabled(e);
        this.runToSelLineItem.setEnabled(e);
        this.setCommandEnabled(12, e);
        this.runToNextProgItem.setEnabled(e);
        this.setCommandEnabled(56, e);
        this.jumpToSelLineItem.setEnabled(e && jumpEnabled);
        this.jumpToItem.setEnabled(e && jumpEnabled);
        this.jumpOutParItem.setEnabled(e && jumpEnabled);
        this.jumpOutProgItem.setEnabled(e && jumpEnabled);
        this.jumpNextItem.setEnabled(e && jumpEnabled);
        this.setCommandEnabled(29, e && jumpEnabled);
        this.acceptItem.setEnabled(e);
        this.setCommandEnabled(6, e);
        this.stepOutParItem.setEnabled(e);
        this.setCommandEnabled(10, e);
        this.stepOutProgItem.setEnabled(e);
        this.setCommandEnabled(11, e);
        this.autostepItem.setEnabled(e);
        this.displayItem.setEnabled(e);
        this.offsetItem.setEnabled(e);
        this.lengthItem.setEnabled(e);
        this.setCommandEnabled(5, e);
        this.quickWatchItem.setEnabled(e);
        this.refreshItem.setEnabled(e);
        this.displayOnLineItem.setEnabled(e);
        boolean e2 = e || !this.running;
        this.tronItem.setEnabled(e2);
        this.troffItem.setEnabled(e2);
        this.loadDebugItem.setEnabled(e2);
        this.saveDebugItem.setEnabled(e2);
        if (this.displayVersionItem != null) {
            this.displayVersionItem.setEnabled(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genericCommand() {
        String cmd;
        DebugTM dbgTm;
        int cmdCode;
        DebugResponse resp = null;
        GraphDebugger graphDebugger = this;
        synchronized (graphDebugger) {
            cmdCode = this.lastCommandCode;
            dbgTm = this.tm;
            cmd = this.getLastCommand();
        }
        try {
            resp = this.getInvoker().processCommand(cmdCode, dbgTm);
        }
        catch (DebuggerException de) {
            resp = new DebugResponse(1, de.getMessage() + eol);
        }
        catch (IllegalArgumentException iae) {
            resp = new DebugResponse(1, "Internal error: " + cmd + eol);
        }
        this.handleResponse(resp, false);
        while (resp.getLastCmd() == 28 && resp.getReturnCode() == 0) {
            resp = this.getInvoker().getResponse();
            this.handleResponse(resp, false);
        }
    }

    static int getClassNameIndex(String[] argv) {
        int i;
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
        }
        return i;
    }

    static boolean isIsCobolClass(String className) throws ClassNotFoundException {
        try {
            return GraphDebugger.isIsCobolClass(DebugUtilities.classForNameNoInitialize(className));
        }
        catch (ClassNotFoundException ex) {
            if (GraphDebugger.isIsCobolClass(Config.getProperty("iscobol.code_prefix", ""), className)) {
                return true;
            }
            throw ex;
        }
    }

    static boolean isIsCobolClass(String codePrefix, String className) throws ClassNotFoundException {
        CallLoader callLoader = CallLoader.getInstance(codePrefix);
        if (callLoader != null) {
            return GraphDebugger.isIsCobolClass(callLoader.loadClass(className));
        }
        return false;
    }

    static boolean isIsCobolClass(Class cls) {
        try {
            Class<?> iscobolClass = Class.forName("com.iscobol.rts.IscobolClass", false, GraphDebugger.class.getClassLoader());
            return iscobolClass.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    boolean isQuickWatchActive() {
        return this.quickWatchDialog != null && this.quickWatchDialog.isActive();
    }

    private boolean handleResponse(DebugResponse resp, boolean startingSession) {
        boolean quickWatchActive;
        boolean updateQuickWatch;
        if (this.exitDebug) {
            return true;
        }
        boolean programFinished = false;
        if (!this.isASActive) {
            this.jframe.toFront();
            this.preview.setInitFocus();
        }
        boolean bl = updateQuickWatch = (quickWatchActive = this.isQuickWatchActive()) && !this.quickWatchDialog.isExecutingDisplayCommand();
        if (resp != null) {
            switch (resp.getLastCmd()) {
                case 5: 
                case 6: 
                case 13: 
                case 54: 
                case 55: {
                    NamesRecorder nr = NamesRecorder.removeLastInstance(resp.getReturnCode() != 0);
                    if (!quickWatchActive) break;
                    NamesRecorder.setLastInstance(nr);
                }
            }
            boolean stderr = false;
            switch (resp.getReturnCode()) {
                case 103: 
                case 104: {
                    programFinished = true;
                }
                case 0: 
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    boolean bl2 = stderr = resp.getLastCmd() != 28;
                }
            }
            if (quickWatchActive) {
                if (!this.quickWatchDialog.commandExecuted(resp)) {
                    this.preview.outputResult(resp.getMessage(), stderr);
                }
            } else {
                this.preview.outputResult(resp.getMessage(), stderr);
            }
            if (Settings.getExitAfterTermination() && resp.getReturnCode() == 103) {
                GraphDebugger.close(this, null);
            }
        } else {
            programFinished = true;
        }
        if (programFinished) {
            String msg = "- The program is finished. Type ";
            if (!this.remote) {
                msg = msg + "'run' to restart session or ";
            }
            msg = msg + "'exit' to exit debug";
            this.getInvoker().exitDebug();
            this.setRunCommandsButtonsEnabled(false, false);
            this.running = false;
            this.suspended = false;
            this.preview.outputResult(msg + eol, false);
            if (this.isASActive) {
                this.preview.setAutostepState(false);
            }
            if (resp.getReturnCode() == 104) {
                this.setCurrentLine(resp, resp.getInfo());
            }
            this.preview.setParStack(null);
            this.preview.setMemory(0L, 0L);
            this.setThreads(null, null);
            this.preview.deactivateMonitors();
            this.watchedVariableCommands = this.preview.getWatchedVariableCommands();
            this.preview.clearTrees();
            this.maxHexDumpLength = 0;
            this.hexDumpStartOffset = 0;
            this.maxArrayLength = 0;
            this.arrayStartOffset = 0;
            this.maxTextValueLength = 0;
            this.maxTextValueLengthOutput = 0;
            this.dataSettingsChanged = true;
        } else {
            this.update(resp, startingSession, updateQuickWatch);
            if (this.isASActive) {
                this.autoStepTimer.restart();
            }
        }
        return programFinished;
    }

    private void setCurrentLine(DebugResponse resp, DebugResponse.DebugInfo exceptionDInfo) {
        int idx;
        if ("".equals(resp.getLastProgram())) {
            return;
        }
        int newLine = resp.getLine();
        int fileIndex = resp.getLastFileIndex();
        Filename newProg = new Filename(resp.getLastProgram());
        Filename newFile = new Filename(resp.getLastFile());
        long newTimestamp = resp.getLastProgramTimestamp();
        TextFile tFile = this.preview.getFile();
        long oldTimestamp = tFile.getTimestamp();
        boolean clearHistory = false;
        if (!newProg.equals(new Filename(tFile.getFilename())) || oldTimestamp > 0L && newTimestamp != oldTimestamp) {
            String lastClass;
            DebugResponse.DebugInfo dInfo = null;
            if (resp.getCurrentThread() != null && (resp.getInfo() == null || resp.getInfo().getErrorString() == null) && (lastClass = resp.getLastClass()) != null) {
                if (mainClassName == null || mainClassName.equals("$Dummy$")) {
                    int idx2 = lastClass.lastIndexOf(47);
                    mainClassName = idx2 >= 0 ? lastClass.substring(idx2 + 1) : lastClass;
                }
                dInfo = this.getInvoker().getInfo(lastClass, false, true);
            }
            if ((dInfo == null || dInfo.getErrorString() != null) && exceptionDInfo != null && exceptionDInfo.getErrorString() == null) {
                dInfo = new LocalDebugInfo(this.getInvoker(), exceptionDInfo);
                this.getInvoker().putLocalDebugInfo(dInfo.getClassName(), 991, (LocalDebugInfo)dInfo, true);
            }
            if (dInfo != null && dInfo.getErrorString() == null) {
                tFile = this.preview.loadFile((LocalDebugInfo)dInfo, newProg, newTimestamp, true);
                boolean jumpSupported = dInfo.isJumpCommandSupported();
                this.jumpToItem.setEnabled(jumpSupported);
                this.jumpToSelLineItem.setEnabled(jumpSupported);
                this.jumpOutParItem.setEnabled(jumpSupported);
                this.jumpOutProgItem.setEnabled(jumpSupported);
                this.jumpNextItem.setEnabled(jumpSupported);
                this.setCommandEnabled(29, jumpSupported);
                this.preview.setJumpCommandEnabled(jumpSupported);
                clearHistory = true;
            } else {
                tFile = this.preview.loadFile(null, new Filename(""), 0L, true);
            }
        }
        int saveline = newLine;
        newLine = tFile.toListingLine(newLine, newFile, fileIndex);
        tFile.setTimestamp(newTimestamp);
        if (newLine == -1 && saveline > 0) {
            for (int i = saveline - 1; newLine == -1 && i >= 0; --i) {
                newLine = tFile.toListingLine(i, newFile, fileIndex);
            }
        }
        if ((idx = this.preview.getLineIndex(newLine, true)) >= 0) {
            this.preview.setCurrentLine(idx, clearHistory);
        }
    }

    private static void getAsynchronousResponse(Runnable run) {
        Thread t = new Thread(run);
        t.setName("AsynchronousGetResponse");
        t.start();
    }

    private void updateTabs(DebugResponse resp, boolean startingSession) {
        this.preview.setParStack(resp.getParStack());
        if (!startingSession) {
            int prevFileIndex;
            int prevLine;
            if (resp.getLastProgram().equals(resp.getOldProgram())) {
                prevLine = resp.getOldLine();
                prevFileIndex = resp.getOldFileIndex();
            } else {
                prevLine = -1;
                prevFileIndex = -1;
            }
            if (this.preview.isAutoRefreshEnabled() && !this.suspended) {
                this.preview.refreshCurrentVariables(resp.getLine(), resp.getLastFileIndex(), prevLine, prevFileIndex);
                this.preview.refreshVariables(1);
            }
            this.preview.setMonitors(resp.getMonitors());
        }
        this.preview.setMemory(resp.getTotalMemory(), resp.getFreeMemory());
        this.setThreads(resp.getThreads(), resp.getCurrentThread());
    }

    private void update(DebugResponse r, boolean startingSession, boolean quickWatchActive) {
        int rc = r.getReturnCode();
        if (rc == 101 || rc == 102) {
            this.running = true;
            this.suspended = false;
            this.setCurrentLine(r, null);
            this.updateTabs(r, startingSession);
            return;
        }
        if (rc != 0) {
            return;
        }
        int cmdCode = r.getLastCmd();
        Breakpoint[] bps = r.getBreakpoints();
        Watch[] ws = r.getMonitors();
        Tree[] tr = r.getTrees();
        this.suspended = false;
        switch (cmdCode) {
            case 28: {
                this.suspended = true;
            }
            case 16: {
                this.preview.selectThreadsTab();
                this.setCurrentLine(r, null);
                this.updateTabs(r, startingSession);
                break;
            }
            case 2: {
                this.running = true;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 56: {
                this.setCurrentLine(r, null);
                this.updateTabs(r, startingSession);
                break;
            }
            case 0: 
            case 9: 
            case 19: 
            case 48: 
            case 49: 
            case 52: {
                this.preview.selectBreakpointsTab();
                this.preview.setBreakpoints(bps);
                break;
            }
            case 22: {
                if (bps != null) {
                    this.preview.setBreakpoints(bps);
                }
                if (ws == null) break;
                this.preview.setMonitors(ws);
                break;
            }
            case 13: 
            case 14: 
            case 50: 
            case 51: {
                this.preview.selectMonitorsTab();
                this.preview.setMonitors(r.getMonitors());
                break;
            }
            case 15: {
                this.preview.selectPerformStackTab();
                break;
            }
            case 24: 
            case 25: {
                this.preview.setMemory(r.getTotalMemory(), r.getFreeMemory());
            }
        }
        if (tr != null && !quickWatchActive) {
            for (int i = 0; i < tr.length; ++i) {
                this.preview.setTree(tr[i], i == tr.length - 1);
            }
        }
        if (cmdCode == 6) {
            this.preview.refreshVariables();
        }
    }

    private void setThreads(ThreadObject[] threads, ThreadObject currThread) {
        new IsguiWorker(false, () -> {
            for (int i = 0; i < this.threadItems.length; ++i) {
                this.runMenu.remove(this.threadItems[i]);
            }
            if (threads != null) {
                int i;
                Arrays.sort(threads);
                ButtonGroup menuBg = new ButtonGroup();
                this.threadItems = new JRadioButtonMenuItem[threads.length];
                Font menuFont = this.runMenu.getFont();
                for (i = 0; i < threads.length; ++i) {
                    this.threadItems[i] = new JRadioButtonMenuItem(threads[i].toString());
                    this.threadItems[i].setName(threads[i].getName());
                    menuBg.add(this.threadItems[i]);
                    this.runMenu.add(this.threadItems[i]);
                    this.threadItems[i].setFont(menuFont);
                    this.threadItems[i].addActionListener(this.preview.getThreadActionListener());
                }
                for (i = 0; i < threads.length; ++i) {
                    if (!threads[i].equals(currThread)) continue;
                    this.threadItems[i].setSelected(true);
                    break;
                }
            } else {
                this.threadItems = new JRadioButtonMenuItem[0];
            }
            this.preview.setThreads(threads, currThread);
        }).start();
    }

    void startAutostep() {
        if (!this.isASActive) {
            new IsguiWorker(false, () -> {
                if (this.startItem.isEnabled()) {
                    this.setTextCommand("run " + chainingString);
                } else {
                    this.autoStepTimer.restart();
                }
                this.isASActive = true;
                this.autostepItem.setText(STOP_AUTOSTEP_LBL);
                this.autostepItem.setActionCommand(STOP_AUTOSTEP_ACTION);
                this.autostepItem.setMnemonic(85);
                this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, "graphdebugger.shortcut.stoff"));
            }).start();
        }
    }

    void stopAutostep() {
        if (this.isASActive) {
            new IsguiWorker(false, () -> {
                this.autoStepTimer.stop();
                this.isASActive = false;
                this.autostepItem.setText(START_AUTOSTEP_LBL);
                this.autostepItem.setActionCommand(START_AUTOSTEP_ACTION);
                this.autostepItem.setMnemonic(65);
                this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, "graphdebugger.shortcut.ston"));
            }).start();
        }
    }

    private void setRunQuitEnabled(boolean b) {
        this.startItem.setEnabled(!b);
        this.setCommandEnabled(2, !b);
        if (this.restartItem != null) {
            this.restartItem.setEnabled(b);
            this.setCommandEnabled(58, b);
        }
        this.quitItem.setEnabled(b);
        this.setCommandEnabled(21, b);
        this.preview.setRunQuitEnabled(b);
    }

    private void setSuspended(boolean b) {
        this.suspended = b;
        this.continueItem.setEnabled(b);
        this.setCommandEnabled(1, b);
        this.suspendItem.setEnabled(!b);
        this.setCommandEnabled(28, !b);
        this.preview.setSuspended(b);
    }

    private void setRunEnabled(boolean b) {
        this.startItem.setEnabled(b);
        this.setCommandEnabled(2, b);
        this.preview.setRunEnabled(b);
    }

    private void setRunCommandsButtonsEnabled(boolean b, boolean canJump) {
        this.startItem.setEnabled(!b);
        this.setCommandEnabled(2, !b);
        if (this.restartItem != null) {
            this.restartItem.setEnabled(b);
            this.setCommandEnabled(58, b);
        }
        this.quitItem.setEnabled(b);
        this.setCommandEnabled(21, b);
        this.setRunMenuEnabled(b, canJump);
        this.preview.setRunCommandsButtonsEnabled(b, canJump);
    }

    private JFileChooser getIsdFileChooser(String title, String selFilename) {
        JFileChooser Return2 = new JFileChooser();
        Return2.resetChoosableFileFilters();
        Return2.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().toLowerCase().endsWith(".isd");
            }

            @Override
            public String getDescription() {
                return "*.isd";
            }
        });
        Return2.setAcceptAllFileFilterUsed(false);
        Return2.setDialogTitle(title);
        Return2.setCurrentDirectory(new File(System.getProperty("user.dir", ".")));
        if (selFilename != null) {
            Return2.setSelectedFile(new File(selFilename));
        }
        return Return2;
    }

    public static void main(String[] argv) throws IOException {
        GraphDebugger gd;
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Config.markNoIscobolRuntimeThread();
        Locale.setDefault(Locale.ENGLISH);
        String usage = "Usage: java GraphDebugger [-opt1 ... -optN] java-class [arg1 ... argN]" + eol + "Usage: java GraphDebugger -r [hostname [port]]";
        if (argv.length == 0) {
            GraphDebugger.exit(usage, -1);
        }
        if (argv.length == 1 && argv[0].equals("-v")) {
            SwingErrorBox.message(RuntimeProperties.getFullVersionNumber(), GraphDebugger.version(), TITLE, "Inform.gif");
            System.exit(0);
        }
        boolean remoteDebug = argv[0].equalsIgnoreCase("-r");
        boolean clientRemoteDebug = argv[0].startsWith("-r_notifyclient");
        if (remoteDebug || clientRemoteDebug) {
            try {
                Class<?> clazz = Class.forName("com.iscobol.gui.client.Client");
                Field fa = clazz.getDeclaredField("a");
                fa.setAccessible(true);
                byte[] a = (byte[])fa.get(null);
                Field fb = clazz.getDeclaredField("b");
                fb.setAccessible(true);
                byte[] b = (byte[])fb.get(null);
                Properties p = new Properties();
                p.setProperty(RtsUtil.newUTFString(a), RtsUtil.newUTFString(b));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                p.store(out, "GraphDebugger Static Configurations");
                out.close();
                Config.setStaticProps(out.toByteArray());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            UIManager.setLookAndFeel(Settings.getLaf().getLaf());
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception fa) {
                // empty catch block
            }
            Settings.setLaf(Settings.LAF.SYSTEM);
        }
        MyDebuggerInvoker invoker = new MyDebuggerInvoker();
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.addAll(Factory.getJVMArguments());
        for (int i = 0; i < argv.length; ++i) {
            programArgs.add(argv[i]);
        }
        String[] programArgsStr = new String[programArgs.size()];
        programArgs.toArray(programArgsStr);
        if (remoteDebug) {
            gd = GraphDebugger.doRemoteDebugging(invoker, argv, false, true);
        } else if (clientRemoteDebug) {
            gd = GraphDebugger.doRemoteDebugging(invoker, argv, true, true);
        } else {
            boolean ok;
            int port;
            String className;
            block37: {
                int classNameIndex = GraphDebugger.getClassNameIndex(argv);
                className = null;
                if (classNameIndex >= argv.length) {
                    GraphDebugger.exit(usage, -1);
                } else {
                    className = argv[classNameIndex];
                }
                port = 0;
                ok = false;
                boolean isic = false;
                try {
                    try {
                        isic = GraphDebugger.isIsCobolClass(className);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        isic = GraphDebugger.isIsCobolClass(RtsUtil.normalizeClassName(className));
                    }
                    if (isic) {
                        port = invoker.launchIsCobolProgram(programArgsStr);
                        ok = true;
                    } else {
                        GraphDebugger.exit("Invalid class '" + className + "'", -1);
                    }
                }
                catch (ClassNotFoundException ex) {
                    String codePrefixProp = "-Discobol.code_prefix=";
                    String confProp = "-Discobol.conf=";
                    for (int i = 0; i < argv.length; ++i) {
                        if (argv[i].startsWith("-Discobol.code_prefix=")) {
                            String codePrefix = argv[i].substring("-Discobol.code_prefix=".length());
                            try {
                                try {
                                    isic = GraphDebugger.isIsCobolClass(codePrefix, className);
                                }
                                catch (ClassNotFoundException e) {
                                    isic = GraphDebugger.isIsCobolClass(codePrefix, RtsUtil.normalizeClassName(className));
                                }
                                if (!isic) break;
                                port = invoker.launchIsCobolProgram(programArgsStr);
                                ok = true;
                            }
                            catch (ClassNotFoundException e) {}
                            break;
                        }
                        if (!argv[i].startsWith("-Discobol.conf=")) continue;
                        Properties props = new Properties();
                        RtsUtil.loadPropertiesWithImport(props, argv[i].substring("-Discobol.conf=".length()));
                        String codePrefix = props.getProperty("iscobol.code_prefix");
                        if (codePrefix == null) continue;
                        try {
                            try {
                                isic = GraphDebugger.isIsCobolClass(codePrefix, className);
                            }
                            catch (ClassNotFoundException e) {
                                isic = GraphDebugger.isIsCobolClass(codePrefix, RtsUtil.normalizeClassName(className));
                            }
                            if (!isic) break;
                            port = invoker.launchIsCobolProgram(programArgsStr);
                            ok = true;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        break;
                    }
                    if (ok) break block37;
                    GraphDebugger.exit("Cannot load class '" + className + "'", -1);
                }
            }
            if (port > 0) {
                dbgArgv = programArgsStr;
                mainClassName = className;
                chainingString = "";
                for (int i = classNameIndex + 1; i < argv.length; ++i) {
                    boolean hasSpaces = argv[i].indexOf(32) >= 0;
                    if (hasSpaces) {
                        chainingString = chainingString + "\"";
                    }
                    chainingString = chainingString + argv[i];
                    if (hasSpaces) {
                        chainingString = chainingString + "\"";
                    }
                    if (i >= argv.length - 1) continue;
                    chainingString = chainingString + " ";
                }
            } else {
                GraphDebugger.exit("Cannot load class '" + className + "'", -1);
            }
            gd = ok ? GraphDebugger.doRemoteDebugging(invoker, new String[]{"-r", "localhost", Integer.toString(port)}, false, false) : null;
        }
        GraphDebugger.close(gd, invoker);
    }

    private static void close(GraphDebugger gd, DebuggerInvoker invoker) {
        if (gd != null) {
            gd.saveDebugSession();
            gd.saveWindowLayout();
            Settings.setFindFlags(gd.findDialog.isMatchCaseSelected(), gd.findDialog.isBackwardSearchSelected(), gd.findDialog.isWrapSearchSelected(), gd.findDialog.isWholeWordsSelected(), gd.findDialog.isSearchFromTopSelected(), gd.findDialog.isMatchMinusUnderscoreSelected());
            Settings.saveSettings();
        }
        if (invoker != null) {
            invoker.exitDebug(gd != null && gd.isRemote() && Settings.getForceStopRun());
        }
        System.exit(0);
    }

    private void saveDebugSession() {
        if (Settings.getAutosave()) {
            String fileName = Settings.getSessionOutputFileName();
            if (fileName.length() == 0) {
                fileName = mainClassName + ".isd";
            }
            DebuggerInvoker.save(fileName, this.preview.getBreakpoints(), this.preview.getMonitors(), this.preview.getWatchedVariableCommands(), chainingString);
        }
    }

    private void loadDebugSession() {
        Vector bps = new Vector();
        Vector ws = new Vector();
        Vector vars = new Vector();
        String fileName = Settings.getSessionOutputFileName();
        if (fileName.length() == 0) {
            fileName = mainClassName + ".isd";
        }
        String[] other = new String[2];
        CompositeCommand cmd = this.getInvoker().load(fileName, bps, ws, vars, other);
        if (cmd != null) {
            int i;
            DataExternalizable[] tmp;
            if (other[0] != null && (chainingString == null || chainingString.trim().length() == 0)) {
                chainingString = other[0];
            }
            if (ws.size() > 0) {
                tmp = new Watch[ws.size()];
                ws.toArray(tmp);
                this.preview.setMonitors((Watch[])tmp);
            }
            if (bps.size() > 0) {
                tmp = new Breakpoint[bps.size()];
                bps.toArray(tmp);
                this.preview.setBreakpoints((Breakpoint[])tmp);
            }
            Vector<DebugCommand> cmdList = cmd.getCommandList();
            ArrayList<String[]> watchedVarnames = new ArrayList<String[]>();
            for (i = 0; i < cmdList.size(); ++i) {
                if (!(cmdList.get(i) instanceof DisplayCommand)) continue;
                DisplayCommand dc = (DisplayCommand)cmdList.get(i);
                watchedVarnames.add(new String[]{dc.getVarName().getFullName(), dc.getClassName()});
            }
            this.preview.setWatchedVariableNames(watchedVarnames);
            if (vars.size() > 0) {
                for (i = 0; i < vars.size(); ++i) {
                    this.preview.setTree((Tree)vars.elementAt(i), i == vars.size() - 1);
                }
            }
            if (other[1] != null) {
                String msg = other[1];
                BufferedReader rdr = new BufferedReader(new StringReader(msg));
                try {
                    String line = rdr.readLine();
                    while (line != null) {
                        if (line.startsWith("- ")) {
                            this.preview.outputResult(line + eol, true);
                        }
                        line = rdr.readLine();
                    }
                    rdr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static GraphDebugger doRemoteDebugging(MyDebuggerInvoker invoker, String[] argv, boolean notifyClient, boolean remote) throws IOException {
        DebugResponse resp;
        int rc;
        GraphDebugger gd = null;
        hostname = argv.length > 1 ? argv[1] : Config.getProperty("iscobol.hostname", "localhost");
        if (argv.length > 2) {
            try {
                port = Integer.parseInt(argv[2]);
            }
            catch (NumberFormatException ex) {
                port = Config.getProperty("iscobol.debug.port", 9999);
            }
        } else {
            port = Config.getProperty("iscobol.debug.port", 9999);
        }
        if (!DebugResponse.isErrorCode(rc = (resp = invoker.invokeRemote(hostname, port, remote ? 1 : 10, true)).getReturnCode())) {
            mainClassName = resp.getInfo().getClassName();
            LocalDebugInfo ldInfo = invoker.getInfo(mainClassName, true, false);
            if (ldInfo == null) {
                ldInfo = invoker.createLocalDebugInfo(resp);
            }
            gd = GraphDebugger.start(invoker, resp, ldInfo, notifyClient, remote);
        } else if (remote) {
            resp = GraphDebugger.showAutoConnectDialog(invoker, null);
            if (resp != null && !DebugResponse.isErrorCode(rc = resp.getReturnCode())) {
                mainClassName = resp.getInfo().getClassName();
                LocalDebugInfo ldInfo = invoker.getInfo(mainClassName, true, false);
                if (ldInfo == null) {
                    ldInfo = invoker.createLocalDebugInfo(resp);
                }
                gd = GraphDebugger.start(invoker, resp, ldInfo, notifyClient, remote);
            } else {
                GraphDebugger.exit(GraphDebugger.connectionRefusedMsg(hostname, port), -2);
            }
        } else {
            GraphDebugger.exit(resp.getMessage(), -2);
        }
        return gd;
    }

    public void runToSelectedLine(int selLine, TextFile tFile) {
        CobolRef ref = tFile.toCobolLine(this.preview.getListingline(selLine));
        String cmd = "to ";
        cmd = cmd + ref.lineNo() + " \"" + ref.filename() + "\"";
        if (ref.getFileIndex() >= 0) {
            cmd = cmd + " -fi " + ref.getFileIndex();
        }
        this.setTextCommand(cmd);
    }

    public void toggleBreakpoint(int selLine, TextFile tFile, boolean addProgName, Breakpoint bp) {
        if (!this.processing && selLine >= 0) {
            String cmd;
            CobolRef ref = tFile.getBPArgs(this.preview.getListingline(selLine));
            if (bp != null) {
                cmd = "clear ";
                cmd = bp.getParagraph() != null ? cmd + bp.getParagraph() : cmd + ref.lineNo();
                cmd = cmd + " \"" + ref.filename() + "\"";
            } else {
                cmd = "break " + ref.lineNo() + " \"" + ref.filename() + "\"";
            }
            if (ref.getFileIndex() >= 0) {
                cmd = cmd + " -fi " + ref.getFileIndex();
            }
            if (addProgName && ref.progname() != null) {
                cmd = cmd + " " + ref.progname();
            }
            this.setTextCommand(cmd);
        }
    }

    void showAcceptVariableDialog() {
        String defmodule;
        String cmd;
        DebugResponse resp;
        this.preview.hideTipPopup();
        String vn = this.preview.getNormalizedVarName();
        String defname = vn != null ? vn : "";
        String defvalue = null;
        if (defname.length() > 0 && (resp = this.invoker.processCommand("display " + defname)) != null && resp.getReturnCode() == 0) {
            defvalue = resp.getVarValue();
        }
        if ((cmd = this.showAcceptVariableDialog(defname, defmodule = this.preview.getSelectedModule(), defvalue, defvalue, this.exitDebug)) != null) {
            this.setTextCommand(cmd);
        } else {
            NamesRecorder.removeLastInstance();
        }
    }

    public String showAcceptVariableDialog(String defname, String defmodule, String defvalue, String propname, boolean hex) {
        AcceptVariableDialog d = new AcceptVariableDialog(this.jframe, "Change value", defname, defmodule, defvalue, null, Settings.getHexOption());
        this.acceptVariableDialogBds = d.openDialog(this.acceptVariableDialogBds);
        return d.getCommandString();
    }

    private void showDataSettingsDialog() {
        this.preview.hideTipPopup();
        DataSettingsDialog dsd = new DataSettingsDialog(this.jframe, "Data Settings", this.preview);
        this.dataSettingsDialogBds = dsd.openDialog(this.dataSettingsDialogBds);
    }

    private void showBreakpointsSettingsDialog() {
        this.preview.hideTipPopup();
        BreakpointsSettingsDialog d = new BreakpointsSettingsDialog(this.jframe, "Breakpoint Settings");
        this.breakpointSettingsDialogBds = d.openDialog(this.breakpointSettingsDialogBds);
    }

    private void showSourceSettingsDialog() {
        this.preview.hideTipPopup();
        SourceSettingsDialog d = new SourceSettingsDialog(this.jframe, "Source Settings", this.preview);
        this.sourceSettingsDialogBds = d.openDialog(this.sourceSettingsDialogBds);
    }

    private void showHelpDialog(String cmd) {
        if (this.helpDialog == null) {
            this.helpDialog = new HelpDialog(this.jframe, "Debug commands");
        }
        if (this.helpDialog.isVisible()) {
            this.helpDialog.toFront();
        } else {
            this.helpDialog.openDialog(this.helpDialog.getLastBounds());
        }
        if (cmd != null) {
            this.helpDialog.selectCommand(cmd);
        }
    }

    private void showSessionSettingsDialog() {
        this.preview.hideTipPopup();
        SessionSettingsDialog ssd = new SessionSettingsDialog(this.jframe, "Session Settings", true);
        this.sessionSettingsDialogBds = ssd.openDialog(this.sessionSettingsDialogBds);
    }

    private void showConsoleSettingsDialog() {
        this.preview.hideTipPopup();
        ConsoleSettingsDialog csd = new ConsoleSettingsDialog(this.jframe, this.preview);
        this.consoleSettingsDialogBds = csd.openDialog(this.consoleSettingsDialogBds);
    }

    void showDisplayVariableDialog() {
        String vn = this.preview.getNormalizedVarName();
        String def = vn != null ? vn : "";
        String defmodule = this.preview.getSelectedModule();
        this.showDisplayVariableDialog(def, defmodule, false);
    }

    void showDisplayVariableDialog(String def, String defmodule, boolean showInWatchedVar) {
        this.preview.hideTipPopup();
        DisplayVariableDialog dvd = new DisplayVariableDialog(this.jframe, "Display variable", def, defmodule, showInWatchedVar);
        this.displayVariableDialogBds = dvd.openDialog(this.displayVariableDialogBds);
        String cmd = dvd.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        } else {
            NamesRecorder.removeLastInstance();
        }
    }

    private void showOffsetVariableDialog() {
        this.preview.hideTipPopup();
        String vn = this.preview.getNormalizedVarName();
        String defname = vn != null ? vn : "";
        String defmodule = this.preview.getSelectedModule();
        OffsetLengthDialog d = new OffsetLengthDialog(this.jframe, "Display offset of variable", new String[]{defname, defmodule});
        this.displayOffsetDialogBds = d.openDialog(this.displayOffsetDialogBds);
        String[] ret = d.getValues();
        if (ret[0] != null && ret[0].length() > 0) {
            String cmd = "offset";
            if (ret[1].length() > 0) {
                cmd = cmd + " ";
                cmd = cmd + "-c";
                cmd = cmd + " ";
                cmd = cmd + ret[1];
            }
            cmd = cmd + " ";
            cmd = cmd + ret[0];
            this.setTextCommand(cmd);
        }
    }

    private void showLengthVariableDialog() {
        String vn = this.preview.getNormalizedVarName();
        String defname = vn != null ? vn : "";
        String defmodule = this.preview.getSelectedModule();
        OffsetLengthDialog d = new OffsetLengthDialog(this.jframe, "Display length of variable", new String[]{defname, defmodule});
        this.displayLengthDialogBds = d.openDialog(this.displayLengthDialogBds);
        String[] ret = d.getValues();
        if (ret[0] != null && ret[0].length() > 0) {
            String cmd = "length";
            if (ret[1].length() > 0) {
                cmd = cmd + " ";
                cmd = cmd + "-c";
                cmd = cmd + " ";
                cmd = cmd + ret[1];
            }
            cmd = cmd + " ";
            cmd = cmd + ret[0];
            this.setTextCommand(cmd);
        }
    }

    private void showStepToDialog() {
        InputDialog d = new InputDialog(this.jframe, "Continue to line number", "TO line-number [filename]:", null, null, 20, false, false);
        this.stepToDialogBds = d.openDialog(this.stepToDialogBds);
        String steptoArg = d.getValue();
        if (steptoArg != null && steptoArg.length() > 0) {
            this.setTextCommand("to " + steptoArg);
        }
    }

    private void showJumpToDialog() {
        this.preview.hideTipPopup();
        JumpToDialog d = new JumpToDialog(this.jframe, "Jump to", this.preview);
        this.jumpToDialogBds = d.openDialog(this.jumpToDialogBds);
        if (d.getSelectedLineNumber() > 0) {
            this.setTextCommand("jump " + d.getSelectedLineNumber() + " " + d.getSelectedFileName());
        } else if (d.getSelectedParagraphName() != null) {
            this.setTextCommand("jump " + d.getSelectedParagraphName());
        }
    }

    void showMonitorDialog() {
        String vn = this.preview.getNormalizedVarName();
        String def = vn != null ? vn : "";
        this.showMonitorDialog(def, this.preview.getSelectedModule(), null, this.running, Settings.getHexOption());
    }

    public String showMonitorDialog(String defname, String moduleName, String propname, boolean debugIsRunning, boolean dataAsHex) {
        this.preview.hideTipPopup();
        MonitorDialog md = new MonitorDialog(this.jframe, "Set monitor", defname, moduleName, propname, debugIsRunning, dataAsHex, Settings.getDefaultMonitorEnabledState());
        this.monitorDialogBds = md.openDialog(this.monitorDialogBds);
        String cmd = md.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        }
        return cmd;
    }

    void showModifyMonitorDialog(Watch w) {
        this.preview.hideTipPopup();
        MonitorDialog md = new MonitorDialog(this.jframe, "Modify monitor", w, this.running, Settings.getHexOption(), Settings.getDefaultMonitorEnabledState());
        this.monitorDialogBds = md.openDialog(this.monitorDialogBds);
        String cmd = md.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        }
    }

    private void showAcceptEnvVarDialog() {
        this.preview.hideTipPopup();
        AcceptEnvVariableDialog d = new AcceptEnvVariableDialog(this.jframe, "Change environment variable");
        this.acceptEnvVariableDialogBds = d.openDialog(this.acceptEnvVariableDialogBds);
        String cmd = d.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        }
    }

    void showBreakpointDialog(Breakpoint bp) {
        this.preview.hideTipPopup();
        BreakpointDialog d = new BreakpointDialog(this.jframe, "Set breakpoint", bp, this.running);
        this.breakpointDialogBds = d.openDialog(this.breakpointDialogBds);
        String cmd = d.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        }
    }

    private void showTraceDialog() {
        this.preview.hideTipPopup();
        TraceDialog td = new TraceDialog(this.jframe, "Start tracing", true);
        this.traceDialogBds = td.openDialog(this.traceDialogBds);
        String cmd = td.getCommandString();
        if (cmd != null) {
            this.setTextCommand(cmd);
        }
    }

    public void showGotoDialog() {
        this.preview.hideTipPopup();
        this.gotoDialog.openDialog(this.gotoDialog.getLastBounds());
    }

    private void showEnvDialog() {
        this.preview.hideTipPopup();
        InputDialog d = new InputDialog(this.jframe, "Display environment variable", "Name:", null, null, 20, true, true);
        this.displayEnvVariableDialogBds = d.openDialog(this.displayEnvVariableDialogBds);
        String value = d.getValue();
        boolean hex = d.isHexadecimal();
        boolean full = d.isFull();
        if (value != null && value.length() > 0) {
            String cmd = "display";
            if (hex) {
                cmd = cmd + " -x";
            }
            if (full) {
                cmd = cmd + " -full";
            }
            cmd = cmd + " -env";
            cmd = cmd + " " + value;
            this.setTextCommand(cmd);
        }
    }

    void showQuickWatchDialog(String varname, String modulename) {
        this.preview.hideTipPopup();
        if (this.quickWatchDialog == null) {
            this.quickWatchDialog = new QuickWatchDialog(this, this.jframe, "Quick Watch");
        }
        this.quickWatchDialog.setVariableName(varname);
        this.quickWatchDialog.setModuleName(modulename);
        this.quickWatchDialog.openDialog(this.quickWatchDialog.getLastBounds());
    }

    boolean showConfirmQuitDialog() {
        this.preview.hideTipPopup();
        if (!Settings.getAskConfirmWhenQuit()) {
            return true;
        }
        boolean[] b = this.showConfirmDialog("Quit session?", "Always quit without prompt");
        Settings.setAskConfirmWhenQuit(!b[1]);
        return b[0];
    }

    boolean showConfirmRestartDialog() {
        this.preview.hideTipPopup();
        if (!Settings.getAskConfirmWhenRestart()) {
            return true;
        }
        boolean[] b = this.showConfirmDialog("Restart session?", "Always restart without prompt");
        Settings.setAskConfirmWhenRestart(!b[1]);
        return b[0];
    }

    boolean showConfirmExitDialog() {
        this.preview.hideTipPopup();
        if (!Settings.getAskConfirmWhenExit()) {
            return true;
        }
        boolean[] b = this.showConfirmDialog("Exit debug?", "Always exit without prompt");
        Settings.setAskConfirmWhenExit(!b[1]);
        return b[0];
    }

    private boolean[] showConfirmDialog(String question, String cbText) {
        JCheckBox chk = new JCheckBox(cbText);
        chk.setFont(chk.getFont().deriveFont(8));
        return new boolean[]{JOptionPane.showOptionDialog(null, question, "Question", 0, 3, null, new Object[]{chk, "OK", "No"}, "OK") == 1, chk.isSelected()};
    }

    private static DebugResponse showAutoConnectDialog(DebuggerInvoker invoker, JFrame f) {
        class AutoConnectTimer
        extends Timer {
            private static final long serialVersionUID = 1L;
            int times;

            AutoConnectTimer(int times) {
                super(1000, null);
                this.times = times;
            }
        }
        AutoConnectTimer autoConnectTimer = new AutoConnectTimer(Settings.getAutoConnectDelay() - 1);
        DebugDialog connectDialog = new DebugDialog(f, "Connect", true);
        DebugResponse[] Return2 = new DebugResponse[1];
        connectDialog.setLocationRelativeTo(f);
        connectDialog.setDefaultCloseOperation(0);
        connectDialog.getContentPane().setLayout(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(1, 10, 30));
        int LIMIT = Settings.getAutoConnectDelay();
        JLabel connRef = new JLabel("Connection refused.");
        connRef.setForeground(Color.red);
        JButton connBtn = new JButton("Reconnect " + LIMIT + ".");
        connBtn.addActionListener(e -> {
            autoConnectTimer.stop();
            connBtn.setEnabled(false);
            Return2[0] = invoker.invokeRemote(hostname, port, 1, true);
            int rc = Return2[0].getReturnCode();
            if (DebugResponse.isErrorCode(rc)) {
                connRef.setVisible(true);
                autoConnectTimer.times = Settings.getAutoConnectDelay();
                autoConnectTimer.start();
            } else {
                connectDialog.closeDialog();
            }
        });
        connBtn.setToolTipText("hostname: " + hostname + ", port: " + port);
        connBtn.setPreferredSize(new Dimension(200, 25));
        p.add(connBtn);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic(67);
        cancel.addActionListener(e -> {
            autoConnectTimer.stop();
            Return2[0] = null;
            connectDialog.dispose();
        });
        cancel.setPreferredSize(new Dimension(80, 25));
        p.add(cancel);
        autoConnectTimer.addActionListener(e -> {
            connBtn.setEnabled(true);
            connRef.setVisible(false);
            connBtn.setText("Reconnect " + autoConnectTimer.times + ".");
            if (autoConnectTimer.times == 0) {
                connBtn.setEnabled(false);
                Return2[0] = invoker.invokeRemote(hostname, port, 1, true);
                int rc = Return2[0].getReturnCode();
                if (DebugResponse.isErrorCode(rc)) {
                    connRef.setVisible(true);
                    autoConnectTimer.times = Settings.getAutoConnectDelay();
                    autoConnectTimer.start();
                } else {
                    connectDialog.dispose();
                }
            } else {
                --autoConnectTimer.times;
                autoConnectTimer.start();
            }
        });
        autoConnectTimer.setRepeats(false);
        connectDialog.getContentPane().add((Component)p, "Center");
        connectDialog.getContentPane().add((Component)connRef, "South");
        connRef.setVisible(false);
        connectDialog.setResizable(false);
        connectDialog.pack();
        autoConnectTimer.start();
        connectDialog.setVisible(true);
        return Return2[0];
    }

    public String getDebugPanelInfoRow(int r) {
        return this.preview.menuBPintoCMD(r);
    }

    private KeyStroke getKeyStroke(JMenuItem item, String propName) {
        String shortcut = Settings.getShortcut(propName);
        int[] params = Settings.getShortcutParams(shortcut);
        if (params[1] == 121 && params[0] == 0) {
            this.f10Item = item;
        }
        return KeyStroke.getKeyStroke(params[1], params[0]);
    }

    public void setAccelerators() {
        this.f10Item = null;
        this.tronItem.setAccelerator(this.getKeyStroke(this.tronItem, "graphdebugger.shortcut.tron"));
        this.troffItem.setAccelerator(this.getKeyStroke(this.troffItem, "graphdebugger.shortcut.troff"));
        this.loadItem.setAccelerator(this.getKeyStroke(this.loadItem, "graphdebugger.shortcut.loadfile"));
        this.unloadItem.setAccelerator(this.getKeyStroke(this.unloadItem, "graphdebugger.shortcut.unloadfile"));
        this.exitItem.setAccelerator(this.getKeyStroke(this.exitItem, "graphdebugger.shortcut.exit"));
        this.startItem.setAccelerator(this.getKeyStroke(this.startItem, "graphdebugger.shortcut.run"));
        if (this.restartItem != null) {
            this.restartItem.setAccelerator(this.getKeyStroke(this.restartItem, "graphdebugger.shortcut.restart"));
        }
        this.quitItem.setAccelerator(this.getKeyStroke(this.quitItem, "graphdebugger.shortcut.quit"));
        this.continueItem.setAccelerator(this.getKeyStroke(this.continueItem, "graphdebugger.shortcut.continue"));
        this.stepIntoItem.setAccelerator(this.getKeyStroke(this.stepIntoItem, "graphdebugger.shortcut.step"));
        this.stepOverItem.setAccelerator(this.getKeyStroke(this.stepOverItem, "graphdebugger.shortcut.next"));
        this.stepOutParItem.setAccelerator(this.getKeyStroke(this.stepOutParItem, "graphdebugger.shortcut.outpar"));
        this.stepOutProgItem.setAccelerator(this.getKeyStroke(this.stepOutProgItem, "graphdebugger.shortcut.outprog"));
        this.continueToLineItem.setAccelerator(this.getKeyStroke(this.continueToLineItem, "graphdebugger.shortcut.to"));
        this.runToSelLineItem.setAccelerator(this.getKeyStroke(this.runToSelLineItem, "graphdebugger.shortcut.toline"));
        this.runToNextProgItem.setAccelerator(this.getKeyStroke(this.runToNextProgItem, "graphdebugger.shortcut.prog"));
        this.jumpNextItem.setAccelerator(this.getKeyStroke(this.jumpNextItem, "graphdebugger.shortcut.jumpnext"));
        this.jumpToItem.setAccelerator(this.getKeyStroke(this.jumpToItem, "graphdebugger.shortcut.jump"));
        this.jumpOutParItem.setAccelerator(this.getKeyStroke(this.jumpOutParItem, "graphdebugger.shortcut.jumpoutpar"));
        this.jumpOutProgItem.setAccelerator(this.getKeyStroke(this.jumpOutProgItem, "graphdebugger.shortcut.jumpoutprog"));
        this.jumpToSelLineItem.setAccelerator(this.getKeyStroke(this.jumpToSelLineItem, "graphdebugger.shortcut.jumptoline"));
        this.autostepItem.setAccelerator(this.getKeyStroke(this.autostepItem, this.autostepItem.getActionCommand().equals(START_AUTOSTEP_ACTION) ? "graphdebugger.shortcut.ston" : "graphdebugger.shortcut.stoff"));
        this.findItem.setAccelerator(this.getKeyStroke(this.findItem, "graphdebugger.shortcut.find"));
        this.gotoItem.setAccelerator(this.getKeyStroke(this.gotoItem, "graphdebugger.shortcut.goto"));
        this.gotoDeclItem.setAccelerator(this.getKeyStroke(this.gotoDeclItem, "graphdebugger.shortcut.gotodecl"));
        this.backItem.setAccelerator(this.getKeyStroke(this.backItem, "graphdebugger.shortcut.gotoback"));
        this.forwardItem.setAccelerator(this.getKeyStroke(this.forwardItem, "graphdebugger.shortcut.gotoforw"));
        this.clearoutItem.setAccelerator(this.getKeyStroke(this.clearoutItem, "graphdebugger.shortcut.clearout"));
        this.lastCmdItem.setAccelerator(this.getKeyStroke(this.lastCmdItem, "graphdebugger.shortcut.lastcmd"));
        this.prevCmdItem.setAccelerator(this.getKeyStroke(this.prevCmdItem, "graphdebugger.shortcut.prevcmd"));
        this.nextCmdItem.setAccelerator(this.getKeyStroke(this.nextCmdItem, "graphdebugger.shortcut.nextcmd"));
        this.findBackwardItem.setAccelerator(this.getKeyStroke(this.findBackwardItem, "graphdebugger.shortcut.fb"));
        this.findForwardItem.setAccelerator(this.getKeyStroke(this.findForwardItem, "graphdebugger.shortcut.ff"));
        this.findFromTopItem.setAccelerator(this.getKeyStroke(this.findFromTopItem, "graphdebugger.shortcut.ft"));
        this.repeatFindItem.setAccelerator(this.getKeyStroke(this.repeatFindItem, "graphdebugger.shortcut.repfind"));
        this.displayItem.setAccelerator(this.getKeyStroke(this.displayItem, "graphdebugger.shortcut.display"));
        this.quickWatchItem.setAccelerator(this.getKeyStroke(this.quickWatchItem, "graphdebugger.shortcut.quickwatch"));
        this.refreshItem.setAccelerator(this.getKeyStroke(this.refreshItem, "graphdebugger.shortcut.refreshvararea"));
        this.displayOnLineItem.setAccelerator(this.getKeyStroke(this.displayOnLineItem, "graphdebugger.shortcut.displayonselline"));
        this.acceptItem.setAccelerator(this.getKeyStroke(this.acceptItem, "graphdebugger.shortcut.let"));
        this.setMonitorItem.setAccelerator(this.getKeyStroke(this.setMonitorItem, "graphdebugger.shortcut.monitor"));
        this.setBreakpointItem.setAccelerator(this.getKeyStroke(this.setBreakpointItem, "graphdebugger.shortcut.break"));
        this.toggleBreakpointItem.setAccelerator(this.getKeyStroke(this.toggleBreakpointItem, "graphdebugger.shortcut.togglebreak"));
        this.incrFontSizeItem.setAccelerator(this.getKeyStroke(this.incrFontSizeItem, "graphdebugger.shortcut.incfont"));
        this.decrFontSizeItem.setAccelerator(this.getKeyStroke(this.decrFontSizeItem, "graphdebugger.shortcut.decfont"));
        this.commandsItem.setAccelerator(this.getKeyStroke(this.commandsItem, "graphdebugger.shortcut.help"));
        this.copySourceItem.setAccelerator(this.getKeyStroke(this.copySourceItem, "graphdebugger.shortcut.copy_source"));
        this.firstItem.setAccelerator(this.getKeyStroke(this.firstItem, "graphdebugger.shortcut.first_line"));
        this.firstExecItem.setAccelerator(this.getKeyStroke(this.firstExecItem, "graphdebugger.shortcut.first_exec_line"));
        this.lastItem.setAccelerator(this.getKeyStroke(this.lastItem, "graphdebugger.shortcut.last_line"));
        this.currentLineItem.setAccelerator(this.getKeyStroke(this.currentLineItem, "graphdebugger.shortcut.curr_line"));
        this.preview.setAccelerators();
    }

    public static String version() {
        String infolic = Config.getProperty(".licinfo", "Missing license!");
        String exdate = infolic.substring(infolic.length() - 8).equals("99991231") ? "None" : infolic.substring(infolic.length() - 8);
        String[] licid = infolic.substring(0, infolic.length() - 8).split("(##)");
        String licenseId = licid.length > 1 ? licid[1] : "Missing";
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
        String productCopyright = RuntimeProperties.getProductCopyright();
        return fullVersionNumber + eol + "Company:         " + licid[0] + eol + "License ID:      " + licenseId + eol + "Expiration Date: " + exdate + eol + productCopyright + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home");
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public JFrame getFrame() {
        return this.jframe;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isRemoteThinClient() {
        return this.remoteThinClient;
    }

    public static String getChainingString() {
        return chainingString;
    }

    public void setAutostepDelay(int v) {
        this.autoStepTimer.setInitialDelay(v);
    }

    public void setQuitCommandExecuted(boolean v) {
        this.quitCmdExecuted = v;
    }

    public FindDialog getFindDialog() {
        return this.findDialog;
    }

    private void saveWindowLayout() {
        Settings.setWindowBounds(this.jframe.getBounds());
        Settings.setWindowState(this.jframe.getExtendedState());
        this.preview.saveWindowLayout();
    }

    private void setCommandEnabled(int cmdCode, boolean enabled) {
        this.commandEnablingTable.put(new Integer(cmdCode), new Boolean(enabled));
    }

    private boolean isCommandEnabled(int cmdCode) {
        Boolean enabled = (Boolean)this.commandEnablingTable.get(new Integer(cmdCode));
        return enabled == null || enabled != false;
    }

    protected void clearCommandHistory() {
        this.previousCommands.clear();
        this.previousCommandIndex = Integer.MIN_VALUE;
    }

    protected void executeCommand(String command) {
        if (this.isProcessing() && this.isRunning() && !this.isCommandAllowedInProcessing(command)) {
            this.getInvoker().putInput(command);
        } else {
            this.setTextCommand(command);
        }
    }

    @Override
    public String getLine(int lineNo, String filename, int fileIndex) {
        if (this.preview != null) {
            TextFile tFile = this.preview.getFile();
            int lineIndex = tFile.toListingLine(lineNo, new Filename(filename), fileIndex);
            return tFile.getLine(lineIndex, false, false);
        }
        return null;
    }

    public DebuggerInvoker getInvoker() {
        return this.invoker;
    }

    private static void exit(final String errorMessage, int errorCode) {
        String title = errorMessage.indexOf(eol) >= 0 ? "<html>" + errorMessage.replace(eol, "<br>") + "</html>" : errorMessage;
        ErrorBox.showDirect(new Exception(title){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }

            @Override
            public String toString() {
                return errorMessage;
            }
        });
        System.exit(errorCode);
    }

    private void addLetEnvPropCommands(Vector cmdList) {
        if (Settings.getMaxHexDumpLength() != this.maxHexDumpLength) {
            this.maxHexDumpLength = Settings.getMaxHexDumpLength();
            cmdList.addElement(new LetCommand("debug.internal.max_hex_dump_length", Integer.toString(this.maxHexDumpLength)));
        }
        if (Settings.getHexDumpStartOffset() != this.hexDumpStartOffset) {
            this.hexDumpStartOffset = Settings.getHexDumpStartOffset();
            cmdList.addElement(new LetCommand("debug.internal.hex_dump_start", Integer.toString(this.hexDumpStartOffset)));
        }
        if (Settings.getMaxArrayLength() != this.maxArrayLength) {
            this.maxArrayLength = Settings.getMaxArrayLength();
            cmdList.addElement(new LetCommand("debug.internal.max_array_length", Integer.toString(this.maxArrayLength)));
        }
        if (Settings.getArrayStartOffset() != this.arrayStartOffset) {
            this.arrayStartOffset = Settings.getArrayStartOffset();
            cmdList.addElement(new LetCommand("debug.internal.array_start", Integer.toString(this.arrayStartOffset)));
        }
        if (Settings.getMaxTextValueLength() != this.maxTextValueLength) {
            this.maxTextValueLength = Settings.getMaxTextValueLength();
            cmdList.addElement(new LetCommand("debug.internal.max_text_length", Integer.toString(this.maxTextValueLength)));
        }
        if (Settings.getMaxTextValueLengthOutput() != this.maxTextValueLengthOutput) {
            this.maxTextValueLengthOutput = Settings.getMaxTextValueLengthOutput();
            cmdList.addElement(new LetCommand("debug.internal.max_text_length_out", Integer.toString(this.maxTextValueLengthOutput)));
        }
    }

    boolean isCommandAllowedInProcessing(String cmd) {
        try {
            return this.isCommandAllowedInProcessing(new DebugTM(cmd).getCommand());
        }
        catch (DebuggerException e) {
            return false;
        }
    }

    boolean isCommandAllowedInProcessing(int cmd) {
        switch (cmd) {
            case 28: {
                return true;
            }
            case 1: {
                return this.suspended;
            }
            case 0: 
            case 9: 
            case 19: 
            case 52: {
                return !this.stopImmediately;
            }
        }
        return false;
    }

    void outputResult(String str, boolean stderr) {
        this.preview.outputResult0(str, stderr);
    }

    private static String getCommandShortName(String command) {
        DebugCommand[] cmds = DebuggerInvoker.defCommands;
        for (int i = 1; i < command.length(); ++i) {
            DebugCommand cmd;
            int count = 0;
            String shortName = command.substring(0, i);
            DebugCommand[] debugCommandArray = cmds;
            int n = debugCommandArray.length;
            for (int j = 0; !(j >= n || (cmd = debugCommandArray[j]).getStringId().startsWith(shortName) && ++count > 1); ++j) {
            }
            if (count != true) continue;
            return shortName;
        }
        return command;
    }

    public void addPopupMenu(JPopupMenu m) {
        this.popupMenus.addElement(m);
    }

    static {
        hostname = "localhost";
        port = 9999;
        chainingString = "";
    }

    static class MyDebuggerInvoker
    extends DebuggerInvoker {
        GraphDebugger gd;

        MyDebuggerInvoker() {
        }

        @Override
        protected DebugCommand parseLet(DebugTM tm) throws DebuggerException {
            return super.parseLet(tm, true);
        }

        @Override
        protected DebugCommand parseDisplay(DebugTM tm) throws DebuggerException {
            DisplayCommand dc = (DisplayCommand)super.parseDisplay(tm);
            if (dc.displayAsTree()) {
                dc.setDisplayAsHex(true);
                dc.setDisplayAsText(true);
                dc.setShowChildren(this.gd.isQuickWatchActive() ? (short)2 : 0);
            }
            return dc;
        }

        @Override
        public DebugResponse processCommand(DebugCommand cmd) {
            if (cmd instanceof CompositeCommand) {
                Vector<DebugCommand> cmdList = ((CompositeCommand)cmd).getCommandList();
                if (this.gd.dataSettingsChanged) {
                    Vector letCmdList = new Vector();
                    this.gd.addLetEnvPropCommands(letCmdList);
                    if (letCmdList.size() > 0) {
                        cmdList.addAll(0, letCmdList);
                    }
                    this.gd.dataSettingsChanged = false;
                }
            } else if (this.gd.dataSettingsChanged) {
                Vector<DebugCommand> cmdList = new Vector<DebugCommand>();
                this.gd.addLetEnvPropCommands(cmdList);
                if (cmdList.size() > 0) {
                    cmdList.addElement(cmd);
                    cmd = new CompositeCommand(cmdList);
                }
                this.gd.dataSettingsChanged = false;
            }
            return super.processCommand(cmd);
        }

        @Override
        protected String getChainingString() {
            return chainingString;
        }

        @Override
        protected void setChainingString(String cs) {
            chainingString = cs;
        }

        @Override
        protected DebugResponse save(DebugTM tm) {
            if (this.gd != null) {
                SaveCommand cmd = (SaveCommand)this.parseSave(tm);
                boolean ok = MyDebuggerInvoker.save(cmd.getFilename(), this.gd.preview.getBreakpoints(), this.gd.preview.getMonitors(), this.gd.preview.getWatchedVariableCommands(), chainingString);
                if (ok) {
                    return new DebugResponse(0, "+ saved information in '" + cmd.getFilename() + "'" + eol, 23);
                }
                return new DebugResponse(1, "");
            }
            return super.save(tm);
        }
    }
}

