/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.OptionListForCodeAnalyzer;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.debugger.TextFile;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalDebugInfo
extends DebugResponse.DebugInfo {
    private static final long serialVersionUID = 1L;
    private static final int NOT_LOADED = 0;
    private static final int LOADING = 1;
    private static final int LOADED = 2;
    private static final int ERROR = 3;
    private int metadataLoadState = 0;
    private Map metadata = new HashMap();
    private int format;
    private boolean hasNestedPrograms;
    private static final Set COMPILER_OPTIONS;
    private DebuggerInvoker invoker;
    private boolean usedAll;

    public LocalDebugInfo(DebuggerInvoker invoker, DebugResponse.DebugInfo info) {
        super(info.getClassName(), info.getFilenames(), info.getLines(), info.getParagraphs(), info.getCopyfiles(), info.getSourcefile(), info.getCopyPath(), info.getTimestamp(), info.isJumpCommandSupported(), info.getCompilerOptions(), info.fileSeparators, info.getCompilerProps(), info.getListingInfos(), info.getInfoFormat());
        this.invoker = invoker;
    }

    public LocalDebugInfo(String error) {
        super(error);
    }

    public void loadMetadata(boolean background) {
        if (background) {
            new Thread(){

                @Override
                public void run() {
                    Config.markNoIscobolRuntimeThread();
                    LocalDebugInfo.this.loadMetadata();
                }
            }.start();
        } else {
            this.loadMetadata();
        }
    }

    public synchronized boolean isReady() {
        return this.metadataLoadState != 1;
    }

    public synchronized void waitUntilIsReady() {
        if (this.metadataLoadState == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void setMetadataLoadState(int state) {
        this.metadataLoadState = state;
    }

    public String normalizeVarName(String varName, int listingLine, TextFile tFile) {
        String Return2;
        Location loc;
        int idx = varName.indexOf(40);
        String sub = "";
        if (idx >= 0) {
            sub = " " + varName.substring(idx);
            varName = varName.substring(0, idx).trim();
        }
        if ((loc = this.getMemberLocation(varName, listingLine, tFile)) != null) {
            if (loc.element instanceof VariableDeclaration) {
                VariableDeclaration vd = (VariableDeclaration)loc.element;
                if (this.usedAll || vd.getLevel() == 78 || vd.isUsed()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(vd.getName());
                    if (!loc.capacityVar && loc.hasDuplicates) {
                        for (vd = vd.getParent(); vd != null; vd = vd.getParent()) {
                            if (!this.usedAll && !vd.isUsed()) continue;
                            sb.append(" OF ");
                            sb.append(vd.getName());
                        }
                    }
                    sb.append(sub);
                    Return2 = sb.toString();
                } else {
                    Return2 = null;
                }
            } else {
                Return2 = loc.element instanceof FileDescriptor ? ((FileDescriptor)loc.element).getNameToken().getOriginalWord() : null;
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    public Location getMemberLocation(String fullName, int listingLine, TextFile tFile) {
        String name;
        int dotIdx;
        int idx = (fullName = fullName.toUpperCase().replace(this.getHyphenReplacingChar(), '-')).indexOf(40);
        if (idx >= 0) {
            fullName = fullName.substring(0, idx).trim();
        }
        if ((dotIdx = (name = fullName).lastIndexOf(46)) >= 0 && dotIdx < name.length() - 1) {
            name = name.substring(dotIdx + 1).trim();
        } else {
            idx = name.indexOf(32);
            if (idx >= 0) {
                name = name.substring(0, idx).trim();
            }
        }
        Object obj = this.metadata.get(name);
        if (obj instanceof List) {
            String[] groupNames = fullName.split("(\\s+(OF|IN)\\s+)|(\\.)");
            if (dotIdx >= 0) {
                int i = 0;
                for (int j = groupNames.length - 1; i < j; ++i, --j) {
                    String tmp = groupNames[i];
                    groupNames[i] = groupNames[j];
                    groupNames[j] = tmp;
                }
            }
            List list = (List)obj;
            ArrayList<Location> Return2 = new ArrayList<Location>();
            for (Location loc : list) {
                Token lastToken;
                Token firstToken;
                Pcc pc = loc.element instanceof VariableDeclaration ? ((VariableDeclaration)loc.element).getPcc() : (loc.element instanceof FileDescriptor ? ((FileDescriptor)loc.element).getPcc() : ((Paragraph)loc.element).getPcc());
                if (pc instanceof CobolClass) {
                    firstToken = ((CobolClass)pc).getFirstToken();
                    lastToken = ((CobolClass)pc).getLastToken();
                } else if (pc instanceof CobolMethod) {
                    firstToken = ((CobolMethod)pc).getFirstToken();
                    lastToken = ((CobolMethod)pc).getLastToken();
                } else {
                    firstToken = null;
                    lastToken = null;
                }
                if (firstToken != null && lastToken != null) {
                    int firstLine = tFile.toListingLine(firstToken.getFLN(), firstToken.getFileIndex());
                    int lastLine = tFile.toListingLine(lastToken.getFLN(), lastToken.getFileIndex());
                    if (listingLine >= 0 && (listingLine < firstLine || listingLine > lastLine)) continue;
                }
                if (loc.element instanceof VariableDeclaration) {
                    int i;
                    VariableDeclaration vd;
                    VariableDeclaration vd0 = vd = (VariableDeclaration)loc.element;
                    for (i = 1; i < groupNames.length; ++i) {
                        boolean found = false;
                        for (VariableDeclaration par = vd0.getParent(); par != null; par = par.getParent()) {
                            if (!par.getName().equals(groupNames[i])) continue;
                            vd0 = par;
                            found = true;
                            break;
                        }
                        if (!found) break;
                    }
                    if (i != groupNames.length) continue;
                    Return2.add(loc);
                    continue;
                }
                if (loc.element instanceof Paragraph) {
                    Paragraph p = (Paragraph)loc.element;
                    if (groupNames.length <= 1 || p.getSection() == null || !p.getSection().getName().equals(groupNames[1])) continue;
                    Return2.add(loc);
                    break;
                }
                Return2.add(loc);
            }
            if (Return2.size() == 0) {
                return null;
            }
            if (Return2.size() == 1) {
                return new Location((Location)Return2.get(0));
            }
            int diff = Integer.MAX_VALUE;
            Location ret = null;
            for (Location loc : Return2) {
                VariableDeclaration vd;
                Token nameTk;
                int d;
                if (!(loc.element instanceof VariableDeclaration) || (d = listingLine - tFile.toListingLine((nameTk = (vd = (VariableDeclaration)loc.element).getNameToken()).getFLN(), nameTk.getFileIndex())) < 0 || d >= diff) continue;
                diff = d;
                ret = new Location(loc);
            }
            if (ret == null) {
                ret = new Location((Location)Return2.get(0));
            }
            return ret;
        }
        return (Location)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        if (this.getErrorString() != null) {
            this.setMetadataLoadState(3);
        } else {
            boolean ok;
            this.setMetadataLoadState(1);
            try {
                ok = this.analyzeSource();
            }
            catch (Throwable t) {
                if (this.invoker instanceof GraphDebugger.MyDebuggerInvoker) {
                    GraphDebugger gd = ((GraphDebugger.MyDebuggerInvoker)this.invoker).gd;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    pw.close();
                    gd.outputResult(sw.toString(), true);
                } else {
                    t.printStackTrace();
                }
                ok = false;
            }
            if (ok) {
                this.setMetadataLoadState(2);
            } else {
                this.setMetadataLoadState(3);
            }
        }
        LocalDebugInfo localDebugInfo = this;
        synchronized (localDebugInfo) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyzeSource() {
        FileFinder fFinder;
        PreProcessorReaderProvider readerProv;
        IFileLoader fileLoader;
        ArrayList<String> compOptList = new ArrayList<String>();
        String[] compilerOpts = this.getCompilerOptions();
        DebugUtilities.setCompilerConsts(this.getCompilerProps(), false);
        HashSet<String> sourcePaths = new HashSet<String>();
        String sourceFilePath = this.invoker.getFileLoader().getAbsolutePath(this.getSourcefile());
        if (sourceFilePath == null) {
            return false;
        }
        File sourceFile = new File(sourceFilePath);
        String path = sourceFile.getParent();
        if (path == null) {
            path = ".";
        }
        if (!sourcePaths.contains(path)) {
            sourcePaths.add(path);
        }
        compOptList.add(sourceFile.getName());
        String ceOpt = null;
        DebugCopyFile[] copyFiles = this.getCopyfiles();
        for (int i = 0; i < compilerOpts.length; ++i) {
            String opt = compilerOpts[i];
            int idx = opt.indexOf(61);
            if (idx >= 0 && "-ce=".equals(opt = opt.substring(0, idx + 1))) {
                ceOpt = TextFile.canonicalizePathList(compilerOpts[i].substring(idx + 1), this.getPathSeparator());
                compilerOpts[i] = opt + ceOpt;
            }
            if (COMPILER_OPTIONS.contains(opt)) {
                compOptList.add(compilerOpts[i]);
                continue;
            }
            if (!"-dx".equals(opt)) continue;
            this.usedAll = true;
        }
        ListingInfo li = null;
        if (this.getListingInfos() != null) {
            try {
                li = new ListingInfo(this.getListingInfos(), this.getCopyfiles(), this.getInfoFormat());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (li != null) {
            fileLoader = li.getFileLoader();
            readerProv = li.getReaderProvider();
            fFinder = new FileFinder(){

                @Override
                public File findFile(String name) {
                    String s = fileLoader.getAbsolutePath(name);
                    return s != null ? new File(s) : null;
                }
            };
        } else {
            final HashMap<String, File> copyFilesTable = new HashMap<String, File>();
            if (copyFiles != null) {
                for (DebugCopyFile dcf : copyFiles) {
                    String copyfile = dcf.getCopyFileName();
                    File f = new File(copyfile);
                    copyFilesTable.put(copyfile.toLowerCase(), f);
                    copyFilesTable.put(f.getName().toLowerCase(), f);
                }
            }
            final String[] extList = ceOpt != null ? RtsUtil.getPathList(ceOpt) : null;
            fileLoader = this.invoker.getFileLoader();
            readerProv = null;
            fFinder = new FileFinder(){

                @Override
                public File findFile(String name) {
                    String path;
                    File f = (File)copyFilesTable.get(name.toLowerCase());
                    if (f != null) {
                        if (f.exists()) {
                            return f;
                        }
                        name = f.getPath();
                    }
                    if ((path = fileLoader.getAbsolutePath(name)) == null) {
                        if (extList != null) {
                            for (String ext : extList) {
                                path = fileLoader.getAbsolutePath(name + "." + ext);
                                if (path != null) break;
                            }
                        }
                        if (path == null) {
                            return null;
                        }
                    }
                    return new File(path);
                }
            };
        }
        compOptList.add("-jj");
        String[] argv = new String[compOptList.size()];
        compOptList.toArray(argv);
        OptionListForCodeAnalyzer ol = OptionListForCodeAnalyzer.newInstance(argv);
        GraphUtilities.disableErrorStream();
        GraphUtilities.disableOutputStream();
        Pcc pcc = null;
        try {
            pcc = Pcc.analyze(sourceFilePath, ol, new Errors(), null, fFinder, readerProv);
            this.format = ((PreProcessor)pcc.getTokenManager().getAllPreProcessors().get(0)).getFormat();
            this.hasNestedPrograms = pcc.hasNested();
        }
        catch (Throwable throwable) {
        }
        finally {
            GraphUtilities.enableErrorStream();
            GraphUtilities.enableOutputStream();
        }
        if (pcc != null) {
            Repository rep = pcc.getRepository();
            if (rep != null) {
                this.loadVariablesInfo(rep.getAllClasses());
            }
            if (!pcc.getCobolPrograms().isEmpty()) {
                for (CobolProgram cp : pcc.getCobolPrograms()) {
                    this.loadPccInfo(cp);
                }
            } else {
                if (pcc.getFactoryPart() != null) {
                    this.loadCobolClassInfo(pcc.getFactoryPart());
                }
                if (pcc.getObjectPart() != null) {
                    this.loadCobolClassInfo(pcc.getObjectPart());
                }
            }
            return true;
        }
        return false;
    }

    private void loadCobolClassInfo(CobolClass cobolClass) {
        CobolMethod[] methods = cobolClass.getAllMethods();
        if (cobolClass.getDataDivision() != null) {
            this.loadDataDivisionInfo(cobolClass.getDataDivision());
        }
        for (int i = 0; i < methods.length; ++i) {
            this.loadPccInfo(methods[i]);
        }
    }

    private void loadPccInfo(CobolProgram cp) {
        this.loadPccInfo((Pcc)cp);
        for (CobolProgram nested : cp.getCobolPrograms()) {
            this.loadPccInfo(nested);
        }
    }

    private void loadPccInfo(Pcc pcc) {
        if (pcc.getDataDivision() != null) {
            this.loadDataDivisionInfo(pcc.getDataDivision());
        }
        if (pcc.getProcedureDivision() != null) {
            this.loadProcedureDivisionInfo(pcc.getProcedureDivision());
        }
        this.loadVariablesInfo(pcc.getAllLocalVariables());
    }

    private void loadProcedureDivisionInfo(ProcedureDivision procedureDivision) {
        Paragraph[] paragraphs = procedureDivision.getParagraphs();
        for (int i = 0; i < paragraphs.length; ++i) {
            Token startToken = paragraphs[i].getNameToken();
            this.putMemberLocation(paragraphs[i].getName(), new Location(startToken.getFLN(), new Filename(startToken.getFileName()), startToken.getFileIndex(), paragraphs[i], false));
        }
    }

    private void putMemberLocation(String name, Location loc) {
        Object obj = this.metadata.get(name);
        if (obj != null) {
            if (obj instanceof Location) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(obj);
                list.add(loc);
                this.metadata.put(name, list);
            } else {
                ((List)obj).add(loc);
            }
        } else {
            this.metadata.put(name, loc);
        }
    }

    private void loadDataDivisionInfo(DataDivision dataDivision) {
        if (dataDivision.getFileSection() != null) {
            FileDescriptorList fdList = dataDivision.getFileSection().getFileDescriptorList();
            FileDescriptor fd = fdList.getFirst();
            while (fd != null) {
                Token startToken = fd.getNameToken();
                this.putMemberLocation(startToken.getWord(), new Location(startToken.getFLN(), new Filename(startToken.getFileName()), startToken.getFileIndex(), fd, false));
                this.loadVariablesInfo(fd.getRecordDescription());
                fd = fdList.getNext();
            }
        }
        if (dataDivision.getWorkingStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getWorkingStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getLocalStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getLocalStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getThreadLocalStorageSection() != null) {
            this.loadVariablesInfo(dataDivision.getThreadLocalStorageSection().getVariableDeclarationList());
        }
        if (dataDivision.getLinkageSection() != null) {
            this.loadVariablesInfo(dataDivision.getLinkageSection().getVariableDeclarationList());
        }
        if (dataDivision.getScreenSection() != null) {
            this.loadVariablesInfo(dataDivision.getScreenSection().getVariableDeclarationList());
        }
    }

    private void loadVariablesInfo(VariableDeclarationList vdList) {
        VariableDeclaration vd = vdList.getFirst();
        while (vd != null) {
            if (!vd.isFiller()) {
                Token startToken = vd.getNameToken();
                this.putMemberLocation(vd.getName(), new Location(startToken.getFLN(), new Filename(startToken.getFileName()), startToken.getFileIndex(), vd, false));
                VariableName cap = vd.getCapacity();
                if (cap != null) {
                    startToken = cap.getNameToken();
                    Location loc = new Location(startToken.getFLN(), new Filename(startToken.getFileName()), startToken.getFileIndex(), cap.getVarDecl(), true);
                    this.putMemberLocation(cap.getName(), loc);
                }
            }
            this.loadVariablesInfo(vd.getChildren());
            vd = vdList.getNext();
        }
    }

    public int getFormat() {
        return this.format;
    }

    public boolean hasNestedPrograms() {
        return this.hasNestedPrograms;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set = new HashSet();
        set.add("-ca");
        set.add("-cdlz");
        set.add("-ce=");
        set.add("-cghv");
        set.add("-cm");
        set.add("-cms");
        set.add("-cp");
        set.add("-csl");
        set.add("-cv");
        set.add("-d");
        set.add("-ds");
        set.add("-exec=");
        set.add("-flsu");
        set.add("-noexec");
        set.add("-rc=");
        set.add("-rm=");
        set.add("-rw=");
        set.add("-s78c");
        set.add("-sa");
        set.add("-scnl");
        set.add("-scnu");
        set.add("-sf");
        set.add("-sl");
        set.add("-smat");
        set.add("-smfu");
        set.add("-st");
        set.add("-sv");
        set.add("-xms");
        set.add("-xoldsmat");
        COMPILER_OPTIONS = Collections.unmodifiableSet(set);
    }

    public static class Location {
        public final int line;
        public final Filename file;
        public final int fileIndex;
        public final Object element;
        public final boolean capacityVar;
        public final boolean hasDuplicates;

        public Location(int line, Filename file, int fileIndex, Object element, boolean capacityVar) {
            this(line, file, fileIndex, element, capacityVar, false);
        }

        public Location(Location loc) {
            this(loc.line, loc.file, loc.fileIndex, loc.element, loc.capacityVar, true);
        }

        private Location(int line, Filename file, int fileIndex, Object element, boolean capacityVar, boolean hasDuplicates) {
            this.line = line;
            this.file = file;
            this.fileIndex = fileIndex;
            this.element = element;
            this.capacityVar = capacityVar;
            this.hasDuplicates = hasDuplicates;
        }
    }
}

