/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

public class RepositoryEntry {
    public static final String CLASS = "C";
    public static final String PROPERTY = "P";
    private String type;
    private String cobolName;
    private String javaName;

    public RepositoryEntry(String type, String cobolName, String javaName) {
        this.type = type;
        this.cobolName = cobolName;
        this.javaName = javaName;
    }

    public String getType() {
        return this.type;
    }

    public String getCobolName() {
        return this.cobolName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCobolName(String cobolName) {
        this.cobolName = cobolName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public boolean isProperty() {
        return PROPERTY.equals(this.type);
    }

    public boolean isClass() {
        return CLASS.equals(this.type);
    }

    public static String findPropertyName(String cobolPropName, RepositoryEntry[] reps) {
        for (RepositoryEntry r : reps) {
            if (!r.isProperty() || !r.getCobolName().equalsIgnoreCase(cobolPropName)) continue;
            return r.getJavaName();
        }
        return null;
    }

    public static String findClassName(String cobolClassName, RepositoryEntry[] reps) {
        for (RepositoryEntry r : reps) {
            if (!r.isClass() || !r.getCobolName().equalsIgnoreCase(cobolClassName)) continue;
            return r.getJavaName();
        }
        return null;
    }
}

