/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SourceSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox formatCmb;
    private JCheckBox expandCopyChk;
    private JTextField gotoEntryTxt;
    private DebugPanel panel;

    public SourceSettingsDialog(JFrame parent, String title, DebugPanel panel) {
        super(parent, title, true);
        this.panel = panel;
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        LMResize layout = new LMResize(10, 10, 5, 0);
        mainPanel.setLayout(layout);
        JLabel lbl = new JLabel("Format:");
        this.formatCmb = new JComboBox<String>(new String[]{"Auto", "Ansi", "Terminal", "Free", "Variable", "Long Line"});
        int sf = Settings.getSourceFormat();
        this.formatCmb.setSelectedIndex(sf >= 0 && sf < 6 ? sf : 0);
        Dimension d = layout.getPreferredSize(lbl);
        lbl.setBounds(10, 10, d.width, d.height);
        mainPanel.add(lbl);
        d = layout.getPreferredSize(this.formatCmb);
        this.formatCmb.setBounds(LMResize.getRight(lbl) + 5, LMResize.getTop(lbl), 100, d.height);
        mainPanel.add(this.formatCmb);
        this.expandCopyChk = new JCheckBox("Expand copy books when loading source");
        this.expandCopyChk.setSelected(Settings.isExpandCopiesOnLoad());
        d = layout.getPreferredSize(this.expandCopyChk);
        this.expandCopyChk.setBounds(LMResize.getLeft(lbl), LMResize.getBottom(lbl) + 15, d.width, d.height);
        mainPanel.add(this.expandCopyChk);
        JLabel lbl2 = new JLabel("Max Back/Forward last items:");
        d = layout.getPreferredSize(lbl2);
        lbl2.setBounds(LMResize.getLeft(lbl), LMResize.getBottom(this.expandCopyChk) + 15, d.width, d.height);
        mainPanel.add(lbl2);
        this.gotoEntryTxt = new JTextField();
        this.gotoEntryTxt.setHorizontalAlignment(4);
        this.gotoEntryTxt.setText("" + Settings.getMaxGotoEntries());
        d = layout.getPreferredSize(this.gotoEntryTxt);
        this.gotoEntryTxt.setBounds(LMResize.getRight(lbl2) + 5, LMResize.getTop(lbl2), 100, d.height);
        mainPanel.add(this.gotoEntryTxt);
        this.gotoEntryTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceSettingsDialog.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceSettingsDialog.this.setDirty(true);
            }
        });
        ActionListener actionListener = e -> this.setDirty(true);
        this.formatCmb.addActionListener(actionListener);
        this.expandCopyChk.addActionListener(actionListener);
    }

    @Override
    protected void performApply() {
        int sl = this.formatCmb.getSelectedIndex();
        if (sl != Settings.getSourceFormat()) {
            Settings.setSourceFormat(sl);
            this.panel.repaintSource();
        }
        Settings.setExpandCopiesOnLoad(this.expandCopyChk.isSelected());
        int max = Integer.parseInt(this.gotoEntryTxt.getText());
        Settings.setMaxGotoEntries(max);
        super.performApply();
    }

    @Override
    protected String validateInput() {
        try {
            int maxEntry = Integer.parseInt(this.gotoEntryTxt.getText());
            if (maxEntry <= 0) {
                return "Max Back/Forward last items must be > 0";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid Max Back/Forward last items";
        }
        return null;
    }
}

