/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TraceDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField levelField;
    private JTextField logfileField;
    private JButton ok;
    private JButton close;

    public TraceDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        JLabel levelLbl = new JLabel("Trace level:");
        Dimension d = layout.getPreferredSize(levelLbl);
        levelLbl.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(levelLbl);
        this.levelField = new JTextField(5);
        this.levelField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.levelField));
        this.levelField.setBounds(LMResize.getRight(levelLbl) + 5, LMResize.getTop(levelLbl), 50, this.levelField.getPreferredSize().height);
        this.getContentPane().add(this.levelField);
        JLabel logLbl = new JLabel("Log file:");
        d = layout.getPreferredSize(logLbl);
        logLbl.setBounds(LMResize.getLeft(levelLbl), LMResize.getBottom(levelLbl) + 15, d.width, d.height);
        this.getContentPane().add(logLbl);
        this.logfileField = new JTextField();
        this.logfileField.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.logfileField));
        this.logfileField.setBounds(LMResize.getLeft(this.levelField), LMResize.getTop(logLbl), 150, this.logfileField.getPreferredSize().height);
        this.getContentPane().add((Component)this.logfileField, new LMResizeData(1));
        JButton btn = new JButton("...");
        btn.setBounds(LMResize.getRight(this.logfileField) + 5, LMResize.getTop(this.logfileField), 20, this.logfileField.getSize().height);
        btn.addActionListener(e -> {
            JFileChooser jfc = new JFileChooser(new File(System.getProperty("user.home", ".")));
            jfc.showDialog(this, "OK");
            File selFile = jfc.getSelectedFile();
            if (selFile != null) {
                this.logfileField.setText(selFile.getPath());
            }
        });
        this.getContentPane().add((Component)btn, new LMResizeData(2));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(btn) - d.width + 5, LMResize.getBottom(btn) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String s = this.levelField.getText();
        if (s.length() > 0) {
            this.commandString = "tron " + s;
            s = this.logfileField.getText();
            if (s.length() > 0) {
                this.commandString = this.commandString + " \"" + s + "\"";
            }
        } else {
            this.commandString = null;
        }
    }
}

