/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.dialogs.treetable.model.VectorModel;

public class ThreadModel
extends VectorModel {
    protected String currThread = "";

    public ThreadModel(GraphDebugger graphDebug) {
        super(new Class[]{Boolean.class, String.class, String.class, String.class}, new String[]{"", "Name", "Paragraph", "Program"}, 0, graphDebug);
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        if (node == this.vector || column != 0 || !(value instanceof Boolean) || this.graphDebug.isProcessing()) {
            return;
        }
        ThreadObject to = (ThreadObject)node;
        if (!to.getName().equals(this.currThread)) {
            this.graphDebug.setTextCommand("thread " + to.getName());
        }
    }

    public String getCurrThread() {
        return this.currThread;
    }

    public void setCurrThread(String currThread) {
        this.currThread = currThread;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node == this.vector) {
            return null;
        }
        ThreadObject to = (ThreadObject)node;
        switch (column) {
            case 0: {
                return new Boolean(to.getName().equals(this.currThread));
            }
            case 1: {
                return to.getName();
            }
            case 2: {
                ParagraphObject[] parStack = to.getParStack();
                if (parStack != null && parStack.length > 0) {
                    return parStack[parStack.length - 1].getName();
                }
                return null;
            }
            case 3: {
                ParagraphObject[] parStack = to.getParStack();
                if (parStack != null && parStack.length > 0) {
                    return parStack[parStack.length - 1].getProgName();
                }
                return null;
            }
        }
        return null;
    }
}

