/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.gui.client.swing.treetable.AbstractTreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import java.util.HashMap;
import java.util.Map;

public class VariableModel
extends AbstractTreeTableModel {
    protected VariableNode rootNode;
    private Map cache = new HashMap();
    private Class[] columnTypes;
    private String[] columnNames;
    protected boolean showHexValues;

    public VariableModel(VariableNode root, boolean showHexValues) {
        super(root);
        this.rootNode = (VariableNode)this.getRoot();
        this.columnNames = this.getColumnNames();
        this.columnTypes = this.getColumnTypes();
        this.showHexValues = showHexValues;
    }

    protected Class[] getColumnTypes() {
        return new Class[]{TreeTableModel.class, String.class, String.class};
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return column == 0;
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Value", "Hex"};
    }

    public VariableNode getRootNode() {
        return this.rootNode;
    }

    public void updateRoot(VariableNode newRootNode) {
        this.updateNode(this.rootNode, newRootNode);
    }

    public void updateNode(VariableNode oldNode, VariableNode newNode) {
        oldNode.setName(newNode.getName());
        oldNode.setHexDump(newNode.getHexDump());
        oldNode.setTextValue(newNode.getTextValue());
        oldNode.setHasChildren(newNode.hasChildren());
        int oldSize = oldNode.getChildCount();
        int newSize = newNode.getChildCount();
        int minSize = Math.min(newSize, oldSize);
        for (int i = 0; i < minSize; ++i) {
            this.updateNode((VariableNode)oldNode.getChildAt(i), (VariableNode)newNode.getChildAt(i));
        }
        this.cache.remove(oldNode);
        int diff = newNode.getChildCount() - oldNode.getChildCount();
        if (diff != 0) {
            if (diff > 0) {
                for (int i = minSize; i < newSize; ++i) {
                    VariableNode newChild = (VariableNode)newNode.getChildAt(i);
                    oldNode.addChild(newChild);
                }
            } else {
                for (int i = minSize; i < oldSize; ++i) {
                    VariableNode oldChild = (VariableNode)oldNode.getChildAt(minSize);
                    oldNode.removeChildAt(minSize);
                    this.cache.remove(oldChild);
                }
            }
            this.cache.put(oldNode, oldNode.getChildren().toArray());
        }
    }

    @Override
    public Class getColumnClass(int column) {
        if (column >= 0 && column < this.columnTypes.length) {
            return this.columnTypes[column];
        }
        return Object.class;
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildren(parent).length;
    }

    public Object[] getChildren(Object parent) {
        Object[] children = (Object[])this.cache.get(parent);
        if (children == null) {
            children = ((VariableNode)parent).getChildren().toArray();
            this.cache.put(parent, children);
        }
        return children;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildren(parent)[index];
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.columnNames.length) {
            return this.columnNames[column];
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node == null || node == this.rootNode) {
            return null;
        }
        switch (column) {
            case 0: {
                return ((VariableNode)node).getName();
            }
            case 1: {
                return ((VariableNode)node).getTextValue();
            }
            case 2: {
                return this.showHexValues ? ((VariableNode)node).getHexDump() : "";
            }
        }
        return null;
    }

    public boolean isShowHexValues() {
        return this.showHexValues;
    }

    public void setShowHexValues(boolean showHexValues) {
        this.showHexValues = showHexValues;
    }
}

