/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import com.iscobol.docking.eleritec.BorderManager;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.eleritec.SubComponentProvider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultDockingPort
extends JPanel
implements DockingPort {
    private static final WeakHashMap COMPONENT_TITLES = new WeakHashMap();
    private static final SubComponentProvider DEFAULT_CMP_PROVIDER = new DefaultComponentProvider();
    private SubComponentProvider subComponentProvider;
    private int borrowedTabIndex;
    private int cachedSplitDividerSize;
    private Component dockedComponent;
    private boolean dockingAllowed;
    private Insets dockingInsets;
    private boolean resizableDesired;
    private BorderManager borderManager;

    public DefaultDockingPort(String name) {
        this.setDockingInsets(new Insets(12, 12, 8, 8));
        this.setDockingAllowed(true);
        this.setName(name);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Component add(Component comp) {
        return this.setComponent(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.setComponent(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.setComponent(comp);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.setComponent(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.setComponent(comp);
    }

    private void addCmp(DockingPort port, Component c) {
        if (port instanceof Container) {
            ((Container)((Object)port)).add(c);
        }
    }

    @Override
    public boolean allowsDocking(String region) {
        return this.dockingAllowed && this.isValidDockingRegion(region);
    }

    public final void evaluateDockingBorderStatus() {
        if (this.borderManager == null) {
            return;
        }
        Component docked = this.getDockedComponent();
        if (docked == null) {
            this.borderManager.managePortNullChild(this);
        } else if (docked instanceof JSplitPane) {
            this.borderManager.managePortSplitChild(this);
        } else if (docked instanceof JTabbedPane) {
            this.borderManager.managePortTabbedChild(this);
        } else {
            this.borderManager.managePortSimpleChild(this);
        }
    }

    private DockingPort createChildPort() {
        DockingPort port;
        DockingPort dockingPort = port = this.subComponentProvider == null ? null : this.subComponentProvider.createChildPort(this.getName());
        if (port == null) {
            port = DEFAULT_CMP_PROVIDER.createChildPort(this.getName());
        }
        if (port instanceof DefaultDockingPort) {
            ((DefaultDockingPort)port).setBorderManager(this.borderManager);
        }
        return port;
    }

    private JSplitPane createSplitPane(String region, boolean resize) {
        JSplitPane pane;
        JSplitPane jSplitPane = pane = this.subComponentProvider == null ? new JSplitPane() : this.subComponentProvider.createSplitPane();
        if (pane == null) {
            pane = DEFAULT_CMP_PROVIDER.createSplitPane();
        }
        pane.setContinuousLayout(true);
        pane.setDividerSize(3);
        pane.setResizeWeight(0.5);
        int orient = 1;
        if ("NORTH".equals(region) || "SOUTH".equals(region)) {
            orient = 0;
        }
        pane.setOrientation(orient);
        this.cachedSplitDividerSize = pane.getDividerSize();
        if (!resize) {
            pane.setDividerSize(0);
        }
        return pane;
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane pane = this.subComponentProvider == null ? null : this.subComponentProvider.createTabbedPane();
        return pane == null ? DEFAULT_CMP_PROVIDER.createTabbedPane() : pane;
    }

    @Override
    public boolean dock(Dockable dockable, String region) {
        if (dockable == null) {
            return false;
        }
        return this.dock(dockable.getDockable(), dockable.getDockableDesc(), region, dockable.isDockedLayoutResizable());
    }

    @Override
    public boolean dock(Component comp, String desc, String region, boolean resizable) {
        boolean success;
        Component docked;
        if (comp == null || !this.allowsDocking(region)) {
            return false;
        }
        String string = desc = desc == null ? "null" : desc.trim();
        if (desc.length() == 0) {
            desc = "null";
        }
        if (comp == (docked = this.getDockedComponent())) {
            return false;
        }
        if (docked instanceof JSplitPane) {
            Component c = ((JSplitPane)docked).getLeftComponent();
            if (c instanceof DockingPort) {
                return ((DockingPort)((Object)c)).dock(comp, desc, region, resizable);
            }
            return false;
        }
        this.resizableDesired = resizable;
        COMPONENT_TITLES.put(comp, desc);
        if (docked == null) {
            this.setComponent(comp);
            this.evaluateDockingBorderStatus();
            return true;
        }
        boolean bl = success = "CENTER".equals(region) ? this.dockInCenterRegion(comp) : this.dockInOuterRegion(comp, region);
        if (success) {
            this.evaluateDockingBorderStatus();
            if (!"CENTER".equals(region)) {
                this.resolveSplitDividerLocation();
            }
        }
        return success;
    }

    private void resolveSplitDividerLocation() {
        double proportion;
        Component cmp = this.getDockedComponent();
        if (!(cmp instanceof JSplitPane)) {
            return;
        }
        JSplitPane split = (JSplitPane)cmp;
        Insets in = this.getInsets();
        boolean vert = split.getOrientation() == 0;
        int dim = vert ? this.getHeight() - in.top - in.bottom : this.getWidth() - in.left - in.right;
        double d = proportion = this.subComponentProvider == null ? DEFAULT_CMP_PROVIDER.getInitialDividerLocation() : this.subComponentProvider.getInitialDividerLocation();
        if (proportion < 0.0 || proportion > 1.0) {
            proportion = 0.5;
        }
        split.setDividerLocation((int)((double)dim * proportion));
    }

    private boolean dockInCenterRegion(Component comp) {
        Component docked = this.getDockedComponent();
        if (docked instanceof JTabbedPane) {
            JTabbedPane tabs = null;
            tabs = (JTabbedPane)docked;
            tabs.add(comp, this.getValidTabTitle(tabs, comp));
            tabs.revalidate();
            tabs.setSelectedIndex(tabs.getTabCount() - 1);
            return true;
        }
        final JTabbedPane tabs = this.createTabbedPane();
        if (tabs == null) {
            return false;
        }
        this.remove(docked);
        tabs.add(docked, this.getValidTabTitle(tabs, docked));
        tabs.add(comp, this.getValidTabTitle(tabs, comp));
        this.setComponent(tabs);
        tabs.setSelectedIndex(tabs.getTabCount() - 1);
        tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Dockable d = (Dockable)((Object)tabs.getSelectedComponent());
                if (d != null) {
                    d.setSelected();
                }
            }
        });
        ((Dockable)((Object)comp)).setSelected();
        return true;
    }

    @Override
    public void dockingComplete(String region) {
    }

    private boolean dockInOuterRegion(Component comp, String region) {
        Dimension halfSize = this.getSize();
        halfSize.width /= 2;
        halfSize.height /= 2;
        Component docked = this.getDockedComponent();
        this.remove(docked);
        DockingPort oldContent = this.createChildPort();
        DockingPort newContent = this.createChildPort();
        this.addCmp(oldContent, docked);
        this.addCmp(newContent, comp);
        DockingPort[] ports = this.putPortsInOrder(oldContent, newContent, region);
        this.setPreferredSize(ports[0], halfSize);
        this.setPreferredSize(ports[1], halfSize);
        JSplitPane newDockedContent = this.createSplitPane(region, this.resizableDesired);
        if (ports[0] instanceof Component) {
            newDockedContent.setLeftComponent((Component)((Object)ports[0]));
        }
        if (ports[1] instanceof Component) {
            newDockedContent.setRightComponent((Component)((Object)ports[1]));
        }
        this.setComponent(newDockedContent);
        return true;
    }

    @Override
    public void doLayout() {
        Component docked = this.getDockedComponent();
        if (docked == null) {
            return;
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        docked.setBounds(insets.left, insets.top, w, h);
    }

    @Override
    public Component getDockedComponent() {
        return this.dockedComponent;
    }

    private JSplitPane getDockedSplitPane() {
        Component docked = this.getDockedComponent();
        return docked instanceof JSplitPane ? (JSplitPane)docked : null;
    }

    @Override
    public Insets getDockingInsets() {
        return this.dockingInsets;
    }

    private String getValidTabTitle(JTabbedPane tabs, Component comp) {
        String title = (String)COMPONENT_TITLES.get(comp);
        if (title == null || title.trim().length() == 0) {
            title = "null";
        }
        int tc = tabs.getTabCount();
        int occurrances = 0;
        HashSet<String> titles = new HashSet<String>();
        String tmp = null;
        for (int i = 0; i < tc; ++i) {
            tmp = tabs.getTitleAt(i).toLowerCase();
            titles.add(tmp);
            if (!tmp.startsWith(title.toLowerCase())) continue;
            ++occurrances;
        }
        if (titles.contains(title) && occurrances > 0) {
            title = title + occurrances;
        }
        COMPONENT_TITLES.put(comp, title);
        return title;
    }

    @Override
    public boolean hasDockedChild(Component comp) {
        Container grandParent;
        if (comp == null) {
            return false;
        }
        Container parent = comp.getParent();
        if (parent == null) {
            return false;
        }
        return !(parent instanceof JTabbedPane || parent instanceof JSplitPane ? (grandParent = parent.getParent()) != this : parent != this);
    }

    @Override
    public boolean isLayoutResizable() {
        JSplitPane wrapper = this.getDockedSplitPane();
        return wrapper == null ? false : wrapper.getDividerSize() != 0;
    }

    private boolean isValidDockingRegion(String region) {
        return "CENTER".equals(region) || "NORTH".equals(region) || "SOUTH".equals(region) || "EAST".equals(region) || "WEST".equals(region);
    }

    @Override
    public Component lendDockedComponent() {
        Component docked = this.getDockedComponent();
        if (docked == null) {
            return null;
        }
        super.remove(docked);
        return docked;
    }

    private DockingPort[] putPortsInOrder(DockingPort oldPort, DockingPort newPort, String region) {
        if ("NORTH".equals(region) || "WEST".equals(region)) {
            return new DockingPort[]{newPort, oldPort};
        }
        return new DockingPort[]{oldPort, newPort};
    }

    public void reevaluateContainerTree() {
        this.reevaluateDockingWrapper();
        this.reevaluateTabbedPane();
        this.evaluateDockingBorderStatus();
        this.revalidate();
    }

    private void reevaluateDockingWrapper() {
        Container grandParent;
        Component docked = this.getDockedComponent();
        Container parent = this.getParent();
        Container container = grandParent = parent == null ? null : parent.getParent();
        if (docked == null && parent instanceof JSplitPane && grandParent instanceof DefaultDockingPort) {
            parent.remove(this);
            ((DefaultDockingPort)grandParent).reevaluateContainerTree();
        } else if (docked instanceof JSplitPane) {
            JSplitPane wrapper = (JSplitPane)docked;
            Component left = wrapper.getLeftComponent();
            Component right = wrapper.getRightComponent();
            if (left != null && right != null) {
                return;
            }
            if (left == right) {
                this.removeAll();
                return;
            }
            Component comp = left == null ? right : left;
            wrapper.remove(comp);
            super.remove(wrapper);
            if (comp instanceof DefaultDockingPort) {
                comp = ((DefaultDockingPort)comp).getDockedComponent();
            }
            if (comp != null) {
                this.setComponent(comp);
            }
        }
    }

    private void reevaluateTabbedPane() {
        Component docked = this.getDockedComponent();
        if (!(docked instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)docked;
        int componentCount = tabs.getComponentCount();
        if (componentCount > 1) {
            return;
        }
        Component comp = componentCount == 1 ? tabs.getComponent(0) : null;
        this.removeAll();
        if (comp != null) {
            this.setComponent(comp);
        }
    }

    @Override
    public void remove(int index) {
        Component docked = this.getDockedComponent();
        Component comp = this.getComponent(index);
        super.remove(index);
        if (docked == comp) {
            this.dockedComponent = null;
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.dockedComponent = null;
    }

    @Override
    public void retainDockedComponent() {
        Component docked = this.getDockedComponent();
        if (docked == null) {
            return;
        }
        Container tempParent = docked.getParent();
        if (tempParent != null) {
            tempParent.remove(docked);
        }
        this.setComponent(docked);
        this.revalidate();
    }

    public void setComponentProvider(SubComponentProvider provider) {
        this.subComponentProvider = provider;
    }

    public void setBorderManager(BorderManager mgr) {
        this.borderManager = mgr;
    }

    private Component setComponent(Component c) {
        if (this.getDockedComponent() != null) {
            this.removeAll();
        }
        this.dockedComponent = c;
        Component ret = super.add(this.dockedComponent);
        return ret;
    }

    @Override
    public void setDockingAllowed(boolean b) {
        this.dockingAllowed = b;
    }

    @Override
    public void setDockingInsets(Insets insets) {
        this.dockingInsets = insets == null ? new Insets(0, 0, 0, 0) : insets;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public void setLayoutResizable(boolean b) {
        this.resizableDesired = b;
        JSplitPane split = this.getDockedSplitPane();
        if (split == null) {
            return;
        }
        int divSize = b ? this.cachedSplitDividerSize : 0;
        split.setDividerSize(divSize);
    }

    private void setPreferredSize(DockingPort port, Dimension pref) {
        if (port instanceof JComponent) {
            ((JComponent)((Object)port)).setPreferredSize(pref);
        }
    }

    @Override
    public boolean undock(Component comp) {
        if (!this.hasDockedChild(comp)) {
            return false;
        }
        comp.getParent().remove(comp);
        this.reevaluateContainerTree();
        return true;
    }

    private static class DefaultComponentProvider
    implements SubComponentProvider {
        private DefaultComponentProvider() {
        }

        @Override
        public DockingPort createChildPort(String name) {
            return new DefaultDockingPort(name);
        }

        @Override
        public JSplitPane createSplitPane() {
            return new JSplitPane();
        }

        @Override
        public JTabbedPane createTabbedPane() {
            return new JTabbedPane(3);
        }

        @Override
        public double getInitialDividerLocation() {
            return 0.5;
        }
    }
}

