/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import com.iscobol.docking.eleritec.CursorProvider;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockingPort;
import java.awt.Component;
import java.awt.Point;

public class DockableComponentWrapper
implements Dockable {
    private Component dragSrc;
    private String description;
    private boolean dockingEnabled;
    private boolean dockedLayoutResizable;

    public static DockableComponentWrapper create(Component src, String desc, boolean resizable) {
        if (src == null) {
            return null;
        }
        return new DockableComponentWrapper(src, desc, resizable);
    }

    private DockableComponentWrapper(Component src, String desc, boolean resizable) {
        this.dragSrc = src;
        this.setDockableDesc(desc);
        this.dockingEnabled = true;
        this.dockedLayoutResizable = resizable;
    }

    @Override
    public Component getDockable() {
        return this.dragSrc;
    }

    @Override
    public String getDockableDesc() {
        return this.description;
    }

    @Override
    public void undock(Point p) {
    }

    @Override
    public void dockingCanceled() {
    }

    @Override
    public void dockingCompleted(DockingPort p) {
    }

    @Override
    public CursorProvider getCursorProvider() {
        return null;
    }

    @Override
    public boolean isDockingEnabled() {
        return this.dockingEnabled;
    }

    @Override
    public void setDockingEnabled(boolean b) {
        this.dockingEnabled = b;
    }

    @Override
    public boolean mouseMotionListenersBlockedWhileDragging() {
        return true;
    }

    @Override
    public boolean isDockedLayoutResizable() {
        return this.dockedLayoutResizable;
    }

    @Override
    public void setDockedLayoutResizable(boolean b) {
        this.dockedLayoutResizable = b;
    }

    @Override
    public void setDockableDesc(String desc) {
        String string = desc = desc == null ? "null" : desc.trim();
        if (desc.length() == 0) {
            desc = "null";
        }
        this.description = desc;
    }

    @Override
    public Component getInitiator() {
        return this.getDockable();
    }

    @Override
    public void setSelected() {
    }
}

