/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Errors;
import com.iscobol.easydb.ModSql;
import com.iscobol.easydb.ModSqlRel;
import com.iscobol.easydb.ModSqlSeq;
import com.iscobol.easydb.MulSql;
import com.iscobol.easydb.OptionList;
import com.iscobol.easydb.SqlGenerator;
import com.iscobol.easydb.Table;
import com.iscobol.easydb.XmlDocument;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import java.io.File;
import java.util.List;

public class EdbiIs
implements EdbiIsCommon {
    protected OptionList options;
    protected boolean debug = false;
    protected int maxCharLen = 0;
    protected static int returnCode = 0;
    protected static XmlDocument docXml;
    protected static int dbt;
    protected static String suffix;
    protected static String suffixSql;
    protected static String prefix;
    protected static String dbStrType;
    protected static String oidName;
    protected static Table tab;
    protected static String subsC;
    protected static String xmlFile;
    public static String notNull;

    public static void main(String[] argv) {
        OptionList ol;
        System.err.println(EdbiIs.getFullVersionNumber());
        if (argv.length < 1) {
            System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            System.exit(-3);
        }
        if ((ol = new OptionList(argv)).getOption("-help") != null) {
            ol.help(false);
            System.exit(0);
        } else if (ol.getOption("-v") != null) {
            System.exit(0);
        } else if (ol.hasErrors()) {
            System.err.println("" + Errors.errors[new Integer(ol.getErrorNum())] + " " + ol.getErrors());
            System.exit(0);
        }
        String outDir = EdbiIs.loadOutDir(ol);
        argv = ol.getArgs();
        if (returnCode == 0) {
            if (argv[0] == null) {
                System.err.println("Missing xml_file");
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
                returnCode = -3;
            } else {
                int intReturnCode = 0;
                for (int i = 0; i < argv.length; ++i) {
                    xmlFile = argv[i];
                    EdbiIs.run((OptionList)ol.clone(), outDir, null);
                    if (returnCode == 0) continue;
                    intReturnCode = returnCode;
                    returnCode = 0;
                }
                returnCode = intReturnCode;
            }
        }
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    static String getFullVersionNumber() {
        String version = RuntimeProperties.getFullVersionNumber();
        if (version.startsWith("isCOBOL")) {
            version = "isCOBOL-EdbiIs" + version.substring(7);
        }
        return version;
    }

    public EdbiIs() {
        dbt = 1;
        returnCode = 0;
        subsC = "";
    }

    public static String runComp(String xmlString, String[] sl) {
        return EdbiIs.runComp(xmlString, sl, null);
    }

    public static String runComp(String xmlString, String[] sl, List<String> scriptList) {
        OptionList ol = new OptionList(sl);
        String outDir = EdbiIs.loadOutDir(ol);
        xmlFile = null;
        EdbiIs.run(ol, outDir, xmlString, scriptList);
        return subsC;
    }

    public static EdbiIs run(OptionList ol, String outDir, String xmlString) {
        return EdbiIs.run(ol, outDir, xmlString, null);
    }

    public static EdbiIs run(OptionList ol, String outDir, String xmlString, List<String> scriptList) {
        if (!EdbiIs.checkLicense()) {
            return null;
        }
        EdbiIs edbi = new EdbiIs();
        String outDirScript = null;
        if (ol.getOption("-sql") != null) {
            outDirScript = EdbiIs.loadOutDirScript(ol);
        }
        if (ol.getOption("-prefix=") != null) {
            prefix = ol.getOption("-prefix=");
        }
        if (ol.getOption("-nn") != null) {
            notNull = " not null";
        }
        returnCode = 0;
        edbi.debug = Config.getProperty(".jeasydb.debug", false);
        edbi.setOption(ol);
        ol.checkOptions(edbi);
        if (xmlString != null) {
            suffix = ".cbl";
        }
        docXml = new XmlDocument(edbi, xmlFile, xmlString, false, 0);
        if (returnCode == 0) {
            tab = new Table(edbi, docXml);
            if (returnCode == 0) {
                if (!(tab.isIndexed() || ol.getOption("-dmld") == null && ol.getOption("-dmlu") == null && ol.getOption("-dsld") == null && ol.getOption("-dslu") == null && ol.getOption("-dpld") == null && ol.getOption("-dplu") == null)) {
                    System.err.println(xmlFile + ": #" + 23 + " " + Errors.errors[23] + ":  table type not INDEXED  not allows LIMIT option (dmld,dmlu,dpld,dplu,dsld,dslu)!, line = 1");
                    return edbi;
                }
                if (!EdbiIs.tab.isMasterTable) {
                    String fn;
                    SqlGenerator gen = null;
                    if (tab.isIndexed()) {
                        gen = new ModSql(edbi, tab, outDir, outDirScript);
                    } else if (tab.isRelative()) {
                        gen = new ModSqlRel(edbi, tab, outDir, outDirScript);
                    } else if (tab.isSequential()) {
                        gen = new ModSqlSeq(edbi, tab, outDir, outDirScript);
                    }
                    if (gen != null && scriptList != null && (fn = gen.getEdbiScriptFileName()) != null) {
                        scriptList.add(fn);
                    }
                } else {
                    new MulSql(edbi, tab, outDir);
                    if (returnCode == 0) {
                        Table mtab = EdbiIs.tab.multiTables.getFirst();
                        while (mtab != null) {
                            String fn;
                            ModSql gen = new ModSql(edbi, mtab, outDir, outDirScript);
                            if (scriptList != null && (fn = gen.getEdbiScriptFileName()) != null) {
                                scriptList.add(fn);
                            }
                            mtab = EdbiIs.tab.multiTables.getNext();
                        }
                    }
                }
            }
        }
        return edbi;
    }

    public static String loadOutDir(OptionList ol) {
        String outDir = "";
        outDir = ol.getOption("-od=");
        if (outDir != null) {
            File fil;
            if (!outDir.endsWith(File.separator)) {
                outDir = outDir + File.separator;
            }
            if (!(fil = new File(outDir)).exists() || !fil.isDirectory()) {
                System.err.println("Missing out directory:" + outDir);
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            }
        } else {
            outDir = "";
        }
        return outDir;
    }

    public static String loadOutDirScript(OptionList ol) {
        String outDir = "";
        outDir = ol.getOption("-os=");
        if (outDir != null) {
            File fil;
            if (!outDir.endsWith(File.separator)) {
                outDir = outDir + File.separator;
            }
            if (!(fil = new File(outDir)).exists() || !fil.isDirectory()) {
                System.err.println("Missing out script directory:" + outDir);
                System.err.println("usage: java EdbiIs -help|license|[options] xml_file");
            }
        } else {
            outDir = "";
        }
        return outDir;
    }

    public String getOption(String key) {
        if (this.options == null) {
            return null;
        }
        return this.options.getOption(key);
    }

    public String getAllOptions() {
        return this.options.getAll();
    }

    public void setOption(OptionList op) {
        this.options = op;
    }

    public boolean hasDebug() {
        return this.debug;
    }

    public void setDebug(boolean dbg) {
        this.debug = dbg;
    }

    public int getDbt() {
        return dbt;
    }

    public void setMaxCharLen(int i) {
        this.maxCharLen = i;
    }

    public int getMaxCharLen() {
        return this.maxCharLen;
    }

    public void setOidName(String o) {
        oidName = o;
    }

    public void addSubs(String o) {
        subsC = o + "!" + subsC;
    }

    public String getOidName() {
        return oidName;
    }

    public void printErr(int num, String other, int lineNum) {
        String mess = xmlFile + ": #" + num + " ";
        returnCode = num;
        mess = mess + Errors.errors[num];
        if (other != null) {
            mess = mess + ": " + other;
        }
        if (lineNum > 0) {
            mess = mess + ", line = " + lineNum;
        }
        System.err.println(mess);
        returnCode = num;
    }

    static boolean checkLicense() {
        return EdbiIs.checkLicense(true);
    }

    static boolean checkLicense(boolean catchExc) {
        byte[] d = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 97, 115, 121, 100, 98, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 53};
        byte[] m = new byte[]{20, 41, -107, 58, 25, 67, 0, -23};
        byte[] d3 = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 105, 110, 102, 111};
        if (catchExc) {
            try {
                Config.putProperty(d, m);
                Config.getProperty(RtsUtil.newUTFString(d3), null);
                Config.gn(7);
            }
            catch (Throwable t) {
                System.err.println("DataBase Bridge: " + t);
                return false;
            }
        } else {
            Config.putProperty(d, m);
            Config.getProperty(RtsUtil.newUTFString(d3), null);
            Config.gn(7);
        }
        return true;
    }

    public void setReturnCode(int rc) {
        returnCode = rc;
    }

    public int getReturnCode() {
        return returnCode;
    }

    static {
        dbt = 1;
        suffix = ".gen";
        suffixSql = ".sql";
        prefix = "";
        dbStrType = "GEN";
        oidName = "OID";
        subsC = "";
        xmlFile = "";
        notNull = "";
    }
}

