/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.extfh3;

import com.iscobol.extfh.EXTFH;
import com.iscobol.extfh3.ExtfhBase;
import com.iscobol.rts.DynamicInput;

public class ExtfhInput
extends ExtfhBase
implements DynamicInput {
    private int openMode = 0;

    public ExtfhInput() {
        super(new byte[216]);
    }

    @Override
    public int open(String f, int lckt, int maxRec, int minRec, boolean bin, boolean lineSeq, boolean optional, boolean assignExt) {
        this.setPath(f.getBytes());
        if (lineSeq) {
            this.FCD_ORGANIZATION.set(0);
        } else {
            this.FCD_ORGANIZATION.set(1);
        }
        this.FCD_ACCESS_MODE.set(0);
        this.FCD_OPEN_MODE.set(128);
        this.FCD_NAME_LENGTH.set(this.pathLen);
        this.FCD_LOCK_MODE.set(0);
        this.setLock(lckt);
        this.FCD_OTHER_FLAGS.set((optional ? 128 : 0) | (assignExt ? 16 : 0));
        this.FCD_FILE_FORMAT.set(0);
        this.FCD_MAX_REC_LENGTH.set(maxRec);
        if (minRec == maxRec) {
            this.FCD_RECORDING_MODE.set(0);
        } else {
            this.FCD_RECORDING_MODE.set(1);
        }
        this.FCD_MIN_REC_LENGTH.set(minRec);
        this.FCD_DATA_COMPRESS.set(0);
        this.FCD_LOCKTYPES.set(0);
        EXTFH.extfh('\ufa00', this.XFHFCD.getMemory(), null, 0, 0, this.path, null);
        int Return2 = this.mapError();
        if (Return2 == 1) {
            this.openMode = 1;
            this.maxRecordSize = maxRec;
            this.minRecordSize = minRec;
        }
        return Return2;
    }

    @Override
    public int read(byte[] record, int offs, int len) {
        this.FCD_CURRENT_REC_LEN.set(len);
        EXTFH.extfh('\ufaf5', this.XFHFCD.getMemory(), record, offs, offs + len, this.path, null);
        if (this.mapError() == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public String readLine() {
        byte[] record = new byte[this.maxRecordSize];
        if (this.read(record, 0, record.length) == 1) {
            int i;
            for (i = record.length - 1; i >= 0 && record[i] == 0; --i) {
            }
            return new String(record, 0, ++i);
        }
        return null;
    }

    @Override
    public int read(char[] record, int offs, int len) {
        String l = this.readLine();
        if (l != null) {
            char[] rs = l.toCharArray();
            if (len > rs.length) {
                len = rs.length;
            }
            System.arraycopy(rs, 0, record, offs, len);
            return 1;
        }
        return 0;
    }

    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public int close() {
        if (this.isOpen()) {
            EXTFH.extfh('\ufa80', this.XFHFCD.getMemory(), null, 0, 0, this.path, null);
            this.openMode = 0;
            return this.mapError();
        }
        return 1;
    }
}

