/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.Constants;
import java.awt.Color;
import java.awt.SystemColor;

public class Palette
implements Constants {
    static final Color[] defaultColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(0, 128, 128), new Color(128, 0, 0), new Color(128, 0, 128), new Color(128, 128, 0), new Color(192, 192, 192), new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    public static final int USER_GRAY_NUM = 7;
    public static final int USER_WHITE_NUM = 15;
    private static boolean userGray;
    private static boolean userWhite;
    public static final Color windowColor;
    public static final Color controlColor;
    public static final Color controlHighlightColor;
    private Color[] colors = new Color[16];

    public Palette(Palette current) {
        if (current == null) {
            for (int n = 0; n < 16; ++n) {
                this.colors[n] = defaultColors[n];
            }
        } else {
            for (int n = 0; n < 16; ++n) {
                this.colors[n] = current.colors[n];
            }
        }
    }

    public boolean setUserColor(int userColor, int colorNum) {
        if (colorNum < 0 || colorNum >= 16) {
            return false;
        }
        switch (userColor) {
            case 1: {
                this.colors[colorNum] = controlColor;
                break;
            }
            case 2: {
                this.colors[colorNum] = windowColor;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void setUserGray(boolean b) {
        userGray = b;
    }

    public static void setUserWhite(boolean b) {
        userWhite = b;
    }

    public static Color getDefaultColor(int colorNum) {
        switch (colorNum) {
            case 7: {
                if (userGray) {
                    return controlColor;
                }
                return defaultColors[colorNum];
            }
            case 15: {
                if (userWhite) {
                    return windowColor;
                }
                return defaultColors[colorNum];
            }
            case 16: {
                return windowColor;
            }
        }
        if (colorNum < 0 || colorNum >= defaultColors.length) {
            return null;
        }
        return defaultColors[colorNum];
    }

    public Color getColor(int colorNum) {
        if (colorNum < 0) {
            return null;
        }
        if (colorNum == 16) {
            return windowColor;
        }
        return this.colors[colorNum];
    }

    static {
        windowColor = SystemColor.window;
        controlColor = SystemColor.control;
        controlHighlightColor = SystemColor.controlHighlight;
    }
}

