/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import javax.swing.JColorChooser;
import javax.swing.JDialog;

public class RemotePalette
implements Constants {
    Color[] defaultColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(0, 128, 128), new Color(128, 0, 0), new Color(128, 0, 128), new Color(128, 128, 0), new Color(192, 192, 192), new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    private static final int USER_GRAY_NUM = 7;
    private static final int USER_WHITE_NUM = 15;
    private static Color defaultUserGray;
    private static Color defaultUserWhite;
    public static final Color windowColor;
    public static final Color controlColor;
    public static final Color controlHighlightColor;
    private final AbstractGuiFactoryImpl gf;

    public RemotePalette() {
        this(null);
    }

    public RemotePalette(AbstractGuiFactoryImpl gf) {
        defaultUserGray = this.defaultColors[7];
        defaultUserWhite = this.defaultColors[15];
        this.gf = gf;
    }

    public boolean setColor(int idx, int r, int g, int b) {
        if (idx >= 0 && idx < this.defaultColors.length) {
            this.defaultColors[idx] = new Color(r, g, b);
            return true;
        }
        return false;
    }

    public Color getColor(int idx) {
        if (idx >= 0 && idx < this.defaultColors.length) {
            return this.defaultColors[idx];
        }
        if (ColorCmp.isRGB(idx)) {
            return ColorCmp.getRGBColor(idx);
        }
        return null;
    }

    public void setUserGray(boolean b) {
        this.defaultColors[7] = b ? controlColor : defaultUserGray;
    }

    public void setUserWhite(boolean b) {
        this.defaultColors[15] = b ? windowColor : defaultUserWhite;
    }

    public Color chooseColor(int flags, int r, int g, int b) {
        JColorChooser jcc = new JColorChooser(new Color(r, g, b));
        boolean[] ok = new boolean[1];
        JDialog d = JColorChooser.createDialog(null, null, true, jcc, e -> {
            ok[0] = true;
        }, null);
        if (this.gf != null && this.gf.getIcon() != null) {
            d.setIconImage(this.gf.getIcon());
        }
        d.setVisible(true);
        return ok[0] ? jcc.getColor() : null;
    }

    public boolean setUserColor(int idx, int userColorId) {
        if (idx >= 0 && idx < this.defaultColors.length) {
            switch (userColorId) {
                case 1: {
                    this.defaultColors[idx] = controlColor;
                    return true;
                }
                case 2: {
                    this.defaultColors[idx] = windowColor;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Color getDefaultColor(int colorNum) {
        if (ColorCmp.isRGB(colorNum)) {
            return ColorCmp.getRGBColor(colorNum);
        }
        switch (colorNum) {
            case 16: {
                return windowColor;
            }
        }
        if (colorNum < 0 || colorNum >= this.defaultColors.length) {
            return null;
        }
        return this.defaultColors[colorNum];
    }

    public int getNumColors() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (gs.length > 0) {
            DisplayMode dm = gs[0].getDisplayMode();
            int bitDepth = dm.getBitDepth();
            if (bitDepth == -1) {
                bitDepth = 24;
            }
            return (int)Math.pow(2.0, bitDepth);
        }
        return 0;
    }

    static {
        windowColor = SystemColor.window;
        controlColor = SystemColor.control;
        controlHighlightColor = SystemColor.controlHighlight;
    }
}

