/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.Terminal;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TerminalAccept
extends Component
implements PicobolWidget,
InputMethodRequests,
InputMethodListener,
KeyListener {
    private static final char UNDERSCORE_CHAR = '_';
    private static final long NOT_SET = 0xFFFFFFFFFFFFFFFL;
    private boolean doubleByteCompat;
    private final boolean alphaAutoClear;
    private final boolean numericAutoClear;
    private final boolean noAutoClear;
    private final boolean editedFormatted;
    private final boolean updateFromScreen;
    private final boolean cl2endFillSpaces;
    private final char[] acceptedControlCharacters;
    private final int[] dataRange;
    private boolean national;
    private String undo;
    private InpData inp = new InpData();
    private Terminal tt;
    private TerminalModel tm;
    private int col;
    private int line;
    private Dimension size;
    private boolean isNumeric;
    private int attr;
    private boolean autoTermination;
    private PicobolTextListener listener;
    private boolean aKeyTyped;
    private boolean activeAccept;
    private boolean update;
    private boolean prompt;
    private char promptChar;
    private boolean upper;
    private boolean lower;
    private boolean full;
    private boolean required;
    private boolean zeroFill;
    private long savebackcolor = 0xFFFFFFFFFFFFFFFL;
    private long savetermattr = 0xFFFFFFFFFFFFFFFL;
    private Justification just;
    private AbstractGuiFactoryImpl gf;
    private char promptCharOrig;
    private boolean promptAll;
    private String promptAllStr;
    private int taMaxIdx;
    private final int upperLowerMethod;
    private boolean listenersAdded;
    private int lastKeyCode;
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();
    private InpData savedInp;
    private int maxImeLen;
    private boolean imeActive;
    private boolean gomyrepaint;

    private static final boolean isEditing(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '9': 
            case 'Z': {
                return false;
            }
        }
        return true;
    }

    private static final char[] normalizePic(String p) {
        int iLen;
        if (p != null && (iLen = p.length()) > 0) {
            StringBuilder sb = new StringBuilder();
            char lChar = '\u0000';
            for (int i = 0; i < iLen; ++i) {
                char c = p.charAt(i);
                if (c == '(') {
                    int pLen = 0;
                    while (Character.isDigit(c = p.charAt(++i))) {
                        pLen *= 10;
                        pLen += Character.digit(c, 10);
                    }
                    --pLen;
                    for (int j = 0; j < pLen; ++j) {
                        sb.append(lChar);
                    }
                    continue;
                }
                lChar = c;
                sb.append(lChar);
            }
            char[] Return2 = sb.toString().toCharArray();
            block6: for (int i = 0; i < Return2.length; ++i) {
                switch (Return2[i]) {
                    case 'B': 
                    case 'b': {
                        Return2[i] = 32;
                        continue block6;
                    }
                }
            }
            return Return2;
        }
        return null;
    }

    public TerminalAccept(AbstractGuiFactoryImpl gf) {
        String[] ss;
        this.promptCharOrig = this.promptChar = gf.getCsProperty().get("iscobol.terminal.screen_prompt", '_');
        this.promptAllStr = gf.getCsProperty().get("iscobol.terminal.screen_prompt_all", "");
        if (this.promptAllStr != null && (this.promptAllStr.equalsIgnoreCase("YES") || this.promptAllStr.equalsIgnoreCase("PROTECTED"))) {
            this.promptAll = true;
        }
        this.doubleByteCompat = true;
        this.alphaAutoClear = gf.getCsProperty().get("iscobol.terminal.alpha_autoclear", false);
        this.numericAutoClear = gf.getCsProperty().get("iscobol.terminal.numeric_autoclear", true);
        this.noAutoClear = gf.getCsProperty().get("iscobol.terminal.no_autoclear", false);
        this.editedFormatted = gf.getCsProperty().get("iscobol.terminal.edited_formatted", false);
        this.updateFromScreen = gf.getCsProperty().get("iscobol.terminal.update_from_screen", false);
        this.cl2endFillSpaces = gf.getCsProperty().get("iscobol.terminal.cl2end_fill_spaces", false);
        String s = gf.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.acceptedControlCharacters = s != null ? s.toCharArray() : null;
        this.upperLowerMethod = gf.getUpperLowerMethod();
        s = gf.getCsProperty().get("iscobol.terminal.data_range", null);
        int[] dr = null;
        if (s != null && (ss = s.split("\\,")).length > 0) {
            if (ss.length == 1) {
                try {
                    dr = new int[]{Integer.parseInt(ss[0]), Integer.MAX_VALUE};
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    dr = new int[]{Integer.parseInt(ss[0]), Integer.parseInt(ss[1])};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.dataRange = dr;
        this.gf = gf;
    }

    @Override
    public void repaint() {
        this.repaint(true);
    }

    private void repaint(boolean cursorOn) {
        if (cursorOn && this.isVisible()) {
            if (this.savedInp != null) {
                boolean atEnd;
                int c = this.savedInp.col;
                if (this.inp.imeCol > 0) {
                    for (int i = 0; i < this.inp.imeCol && i + this.savedInp.idx < this.inp.data.length; ++i) {
                        c += this.tm.dblWidth(this.inp.data[i + this.savedInp.idx]) ? 2 : 1;
                    }
                }
                if (this.doubleByteCompat && c > this.inp.len) {
                    c = this.inp.len;
                }
                boolean bl = this.doubleByteCompat ? c == this.inp.len : (atEnd = this.savedInp.idx + this.inp.imeCol == this.inp.len);
                if (atEnd) {
                    this.tm.setCaretAt(this.col + c - 1, this.line, this);
                } else {
                    this.tm.setCaretAt(this.col + c, this.line, this);
                }
            } else if (this.inp.isAtEnd()) {
                this.tm.setCaretAt(this.col + this.inp.col - 1, this.line, this);
            } else {
                this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
            }
        } else {
            this.tm.unsetCaret(this);
        }
        if (this.gomyrepaint) {
            this.tt.myrepaint();
        } else {
            this.tt.repaint();
        }
    }

    public void clear() {
        if (!this.updateFromScreen && this.inp != null) {
            this.inp.clear();
        }
    }

    public void display() {
        this.display(this.promptAll, true);
    }

    public void display(boolean prmpt) {
        this.display(prmpt, true);
    }

    public void display(boolean prmpt, boolean changeattr) {
        this.tm.move(this.col, this.line);
        if (changeattr) {
            this.tm.setAttr(this.attr);
            this.tm.setBackColor(this.getBackground());
            this.tm.setForeColor(this.getForeground());
        }
        if (this.aKeyTyped || (this.attr & 0x10000000) == 0) {
            char[] data = this.just != null && !prmpt && (!this.noAutoClear || this.update) ? this.just.get(this.inp.getData(this.prompt & prmpt)) : this.inp.getData(this.prompt & prmpt);
            this.taMaxIdx = Math.max(this.taMaxIdx, this.inp.idx);
            if (this.noAutoClear && !this.update && this.taMaxIdx < data.length) {
                char[] c = this.tm.getTextAt(this.line, this.col + this.taMaxIdx, data.length - this.taMaxIdx);
                System.arraycopy(c, 0, data, this.taMaxIdx, c.length);
            }
            this.tm.addstr(data, this.doubleByteCompat ? this.inp.len : 0);
            if (this.savedInp != null && this.inp.imeTextLen > 0 && this.inp.imeHl != null) {
                int dataLen = 0;
                for (int i = 0; i < data.length; ++i) {
                    dataLen += this.tm.dblWidth(data[i]) ? 2 : 1;
                }
                StringBuilder sb = new StringBuilder();
                int d = this.maxImeLen - dataLen;
                if (d > 0) {
                    for (int i = 0; i < d; ++i) {
                        sb.append(' ');
                    }
                    char[] c = sb.toString().toCharArray();
                    this.tm.addstr(c, this.doubleByteCompat ? Math.min(c.length, this.inp.len) : 0);
                }
                this.maxImeLen = Math.max(this.maxImeLen, dataLen);
                this.tm.move(this.col + this.savedInp.col, this.line);
                sb = new StringBuilder();
                int i = 0;
                for (int j = this.savedInp.idx; i < this.inp.imeTextLen && j < this.inp.data.length; ++i, ++j) {
                    sb.append(this.inp.data[j]);
                }
                if (this.inp.imeHl.getState() == 0) {
                    this.tm.setAttr(this.attr | 0x2000000);
                } else {
                    this.tm.setBackColor(Color.blue);
                    this.tm.setForeColor(Color.white);
                }
                char[] c = sb.toString().toCharArray();
                this.tm.addstr(c, this.doubleByteCompat ? Math.min(c.length, this.inp.len) : 0);
            }
        }
        this.repaint(prmpt);
    }

    private void toClipBoard(char[] txt) {
        StringSelection selectedText = new StringSelection(new String(txt));
        Clipboard clipboard = this.tt.getToolkit().getSystemClipboard();
        clipboard.setContents(selectedText, selectedText);
    }

    private String fromClipBoard() {
        String Return2;
        Clipboard clipboard = this.tt.getToolkit().getSystemClipboard();
        Transferable data = clipboard.getContents(this.tt);
        try {
            Return2 = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception _ex) {
            Return2 = null;
        }
        return Return2;
    }

    public void setPicture(String p, boolean dpc) {
        if (this.inp != null) {
            this.inp.setPicture(p, dpc);
        }
    }

    public void initializerowcol(int c, int l) {
        this.col = c;
        this.line = l;
    }

    public void initialize(Terminal t, int c, int l, String iniVal, int ll, String pict, boolean decPointComma) {
        this.setFocusable(true);
        this.col = c;
        this.line = l;
        this.tt = t;
        this.tm = t.getTerminalModel();
        int tmWidth = this.tm.getWidth();
        int len = this.col + ll <= tmWidth ? ll : (tmWidth > this.col ? tmWidth - this.col : 0);
        this.size = len == 0 ? new Dimension(1, this.tm.getCharDim().height) : new Dimension(this.tm.getCharDim().width * len, this.tm.getCharDim().height);
        this.inp.setLen(len);
        this.inp.setPicture(pict, decPointComma);
        if (this.updateFromScreen) {
            iniVal = this.tm.acceptFromScreen(this.line + 1, this.col + 1, len);
        }
        if (iniVal != null && iniVal.length() >= 0) {
            this.undo = iniVal;
            this.inp.setValue(this.undo);
        }
        if (!this.listenersAdded) {
            this.listenersAdded = true;
            this.addKeyListener(this);
            this.enableEvents(2056L);
            this.enableInputMethods(true);
            this.addInputMethodListener(this);
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    public void addTextListener(PicobolTextListener l) {
        this.listener = l;
    }

    public void removeTextListener() {
        this.listener = null;
    }

    public void setUnderline(boolean b) {
        if (b) {
            if (this.promptChar == '_') {
                this.promptChar = (char)32;
            }
            this.attr |= 0x2000000;
        } else {
            this.attr &= 0xFDFFFFFF;
            this.promptChar = this.promptCharOrig;
        }
    }

    public void setBold(boolean b) {
        this.attr = b ? (this.attr |= 0x1000000) : (this.attr &= 0xFEFFFFFF);
    }

    public void setNoEcho(boolean b) {
        if (b) {
            this.attr |= 0x10000000;
            if (this.updateFromScreen) {
                this.inp.setValue("");
            }
        } else {
            this.attr &= 0xEFFFFFFF;
        }
    }

    public void setBlink(boolean b) {
        this.attr = b ? (this.attr |= 0x8000000) : (this.attr &= 0xF7FFFFFF);
    }

    public void setAuto(boolean b) {
        this.autoTermination = b;
    }

    public void setUpdate(boolean b) {
        this.update = b;
    }

    public void setPrompt(boolean b) {
        this.prompt = b;
    }

    public void setPromptChar(char c) {
        this.promptChar = c;
    }

    public void setLower(boolean b) {
        this.lower = b;
    }

    public void setUpper(boolean b) {
        this.upper = b;
    }

    public void setFull(boolean b) {
        this.full = b;
    }

    public void setRequired(boolean b) {
        this.required = b;
    }

    public void setZeroFill(boolean b) {
        this.zeroFill = b;
    }

    public void focusGained(CobolFocusEvent e) {
        this.tm.move(this.col, this.line);
        this.savebackcolor = this.tm.getBackColor();
        this.savetermattr = this.tm.getTermAttr();
        this.tm.setAttr(this.attr);
        this.tm.setBackColor(this.getBackground());
        this.tm.setForeColor(this.getForeground());
        if (this.update || this.prompt) {
            this.tm.addstr(this.inp.getData(this.prompt), this.doubleByteCompat ? this.inp.len : 0);
        }
        this.tm.move(this.col + this.inp.idx, this.line);
        this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
        if (this.alphaAutoClear && (!this.isNumeric || this.inp.pict != null && this.editedFormatted) || this.numericAutoClear && this.isNumeric && (this.inp.pict == null || !this.editedFormatted)) {
            this.inp.setSelectedAll(true);
        }
        this.tt.myrepaint();
    }

    public void focusLost(CobolFocusEvent e) {
        this.tm.unsetCaret(this);
        this.inp.col = (this.inp.idx = 0);
        this.resetInsMode();
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        this.tt.myrepaint();
    }

    @Override
    public void setActiveAccept(boolean b) {
        if (this.tm != null && !b && this.promptAll && (this.activeAccept && this.promptAllStr.equalsIgnoreCase("PROTECTED") || !this.activeAccept)) {
            this.display(false);
        }
        this.activeAccept = b;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean b) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void setSize(int w, int h) {
        if (this.size != null) {
            super.setSize(this.size.width, this.size.height);
        } else {
            super.setSize(1, 1);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.size != null) {
            super.setBounds(x, y, this.size.width, this.size.height);
        } else {
            super.setBounds(x, y, 1, 1);
        }
    }

    public void setValue(String v) {
        this.inp.setValue(v);
        this.display(this.promptAll);
    }

    public String getValue() {
        String Return2 = this.inp.getValue();
        if (this.just != null) {
            Return2 = this.just.get(Return2, this.inp.getLength());
        }
        if (this.upper) {
            return Factory.toUpperCase(Return2, this.upperLowerMethod);
        }
        if (this.lower) {
            return Factory.toLowerCase(Return2, this.upperLowerMethod);
        }
        if (this.gf.getKdbUpper()) {
            return Factory.toUpperCase(Return2, this.upperLowerMethod);
        }
        if (this.gf.getKdbLower()) {
            return Factory.toLowerCase(Return2, this.upperLowerMethod);
        }
        return Return2;
    }

    public void setNumeric(boolean b) {
        this.isNumeric = b;
    }

    public void setCursorPos(int crs) {
        if (this.update && crs > 0 && (crs >> 16) - 1 == this.line) {
            this.inp.setOffset((crs & 0xFFFF) - 1 - this.col);
        }
    }

    public void setJustification(Justification j) {
        this.just = j;
    }

    public int getCursorPos() {
        int offs = this.inp.getOffset();
        if (offs == this.inp.getLength()) {
            --offs;
        }
        return this.line + 1 << 16 | this.col + offs + 1;
    }

    public int getOffset() {
        return this.inp.getOffset();
    }

    public int getIdx() {
        return this.inp.getIdx();
    }

    public String check() {
        if (this.required && this.getValue().trim().length() == 0) {
            return Factory.getSysMsg("ef_input_required_msg");
        }
        if (this.full && this.inp.idx != this.inp.len && this.inp.idx != 0) {
            return Factory.getSysMsg("ef_input_filled_msg");
        }
        if (this.zeroFill) {
            this.inp.end();
            while (this.inp.idx < this.inp.len) {
                this.inp.addch('0');
            }
        }
        this.display(this.promptAll);
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        return null;
    }

    public void setKdbUpper(boolean b) {
        if (b) {
            this.setKdbLower(false);
        }
    }

    public void setKdbLower(boolean b) {
        if (b) {
            this.setKdbUpper(false);
        }
    }

    private void resetInsMode() {
        if (this.inp.insMode) {
            this.toggleInsMode();
        }
    }

    private void toggleInsMode() {
        this.tm.insertCursor = this.inp.insMode = !this.inp.insMode;
        this.inp.selectedAll = false;
    }

    public void saveBGandAttr() {
        if (this.savebackcolor == 0xFFFFFFFFFFFFFFFL) {
            this.savebackcolor = this.tm.getBackColor();
        }
        if (this.savetermattr == 0xFFFFFFFFFFFFFFFL) {
            this.savetermattr = this.tm.getTermAttr();
        }
    }

    public void restoreBGandAttr() {
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
    }

    private char getValidChar(char c) {
        return (char)(this.dataRange == null || c >= this.dataRange[0] && c <= this.dataRange[1] ? c : 32);
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        Point loc;
        InpData id = this.savedInp != null ? this.savedInp : this.inp;
        try {
            loc = this.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            loc = new Point(0, 0);
        }
        Rectangle r = new Rectangle(loc, this.getSize());
        Dimension charDim = this.tm.getCharDim();
        int p = this.col + id.col;
        if (id.isAtEnd()) {
            --p;
        }
        r.width += p * charDim.width;
        r.height += this.tm.getFontMetrics().getAscent();
        return r;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        InpData id = this.savedInp != null ? this.savedInp : this.inp;
        Point p = this.getLocationOnScreen();
        int pos = (x -= p.x) / this.tm.getCharDim().width;
        TextHitInfo ret = pos < id.len ? TextHitInfo.leading(pos) : null;
        return ret;
    }

    @Override
    public int getInsertPositionOffset() {
        InpData id = this.savedInp != null ? this.savedInp : this.inp;
        int r = this.doubleByteCompat ? id.col : id.idx;
        return r;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        InpData id = this.savedInp != null ? this.savedInp : this.inp;
        AttributedString as = new AttributedString(new String(id.data, 0, this.doubleByteCompat ? id.col : id.idx));
        return as.getIterator(null, beginIndex, endIndex);
    }

    @Override
    public int getCommittedTextLength() {
        InpData id = this.savedInp != null ? this.savedInp : this.inp;
        int r = this.doubleByteCompat ? id.col : id.idx;
        return r;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return EMPTY_TEXT;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        AttributedCharacterIterator text = event.getText();
        if (text != null) {
            int committedCharacterCount = event.getCommittedCharacterCount();
            if (committedCharacterCount > 0) {
                if (this.savedInp != null) {
                    this.inp = this.savedInp;
                }
                this.savedInp = null;
                this.inp.imeTextLen = 0;
                this.inp.imeHl = null;
            } else {
                if (this.savedInp != null) {
                    this.inp = this.savedInp.Clone();
                } else {
                    this.savedInp = this.inp;
                    this.inp = this.inp.Clone();
                }
                AttributedString str = new AttributedString(text, text.getBeginIndex(), text.getEndIndex(), new TextAttribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT});
                AttributedCharacterIterator it = str.getIterator();
                this.inp.imeHl = (InputMethodHighlight)it.getAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT);
                if (this.inp.imeHl == null || this.inp.imeHl.getState() == 0) {
                    this.inp.imeCol = event.getCaret().getInsertionIndex();
                }
            }
            int len = 0;
            char c = text.first();
            this.imeActive = true;
            for (int i = 0; c != '\uffff' && (committedCharacterCount == 0 || i < committedCharacterCount); ++i) {
                this.charTyped(c, false, false);
                c = text.next();
                ++len;
            }
            this.imeActive = false;
            if (committedCharacterCount == 0) {
                this.inp.imeTextLen = len;
            }
            this.display(true);
            if (committedCharacterCount > 0) {
                this.checkAutoTermination();
            }
        } else {
            if (this.savedInp != null) {
                this.inp = this.savedInp;
            }
            this.inp.imeTextLen = 0;
            this.savedInp = null;
        }
        event.consume();
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        event.consume();
    }

    private final void undo() {
        this.inp.clear();
        this.inp.setValue(this.undo);
        this.display(true);
    }

    private final void copy() {
        this.toClipBoard(this.inp.getData(false));
    }

    private final void cut() {
        this.toClipBoard(this.inp.getData(false));
        this.inp.clear();
        this.inp.setValue(null);
        this.display(true);
    }

    public final void paste() {
        String str = this.fromClipBoard();
        if (str != null) {
            char[] data = str.toCharArray();
            if (this.isNumeric || this.alphaAutoClear) {
                this.inp.clear();
            }
            for (int i = 0; i < data.length; ++i) {
                this.inp.addch(data[i]);
            }
            this.display(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.lastKeyCode = e.getKeyCode();
        int cobFun = this.gf.getRemoteVirtualKeyboard().mapKey(e, e.getKeyCode());
        this.gomyrepaint = true;
        switch (VirtualKeyboard.editing(cobFun)) {
            case 65536: {
                this.resetInsMode();
                if (this.inp.home()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 131072: {
                this.resetInsMode();
                if (this.inp.end()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 851968: {
                this.toggleInsMode();
                this.repaint();
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 720896: {
                boolean b;
                if (this.isNumeric && !this.numericAutoClear) {
                    b = this.inp.delNnac();
                } else {
                    this.inp.delcur();
                    b = true;
                }
                if (b) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 786432: {
                boolean b;
                boolean bl = b = this.isNumeric && !this.numericAutoClear ? this.inp.delNnac() : this.inp.delch();
                if (b) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 589824: {
                this.resetInsMode();
                if (this.inp.myleft()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(e);
                break;
            }
            case 655360: {
                this.resetInsMode();
                if (this.inp.myright()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(e);
                break;
            }
            case 917504: {
                this.inp.clear();
                this.display(true);
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 983040: {
                if (this.cl2endFillSpaces) {
                    while (this.inp.idx < this.inp.len) {
                        this.inp.addch(' ');
                    }
                    this.display(true);
                    if (!this.autoTermination) break;
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 2202));
                    break;
                }
                if (this.isNumeric && !this.numericAutoClear) {
                    this.inp.cl2EndNnac();
                } else {
                    this.inp.cl2End();
                }
                this.display(true);
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
            }
        }
        this.gomyrepaint = false;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int modifiers = e.getModifiers();
        this.gomyrepaint = true;
        int cobExtFun = this.gf.getRemoteVirtualKeyboard().mapExtKey(e);
        if (cobExtFun > 0 && (cobExtFun & 0x20000) == 131072) {
            this.paste();
            return;
        }
        switch (modifiers) {
            case 0: {
                switch (e.getKeyCode()) {
                    case 65483: {
                        this.undo();
                        break;
                    }
                    case 65485: {
                        this.copy();
                        break;
                    }
                    case 65489: {
                        this.cut();
                        break;
                    }
                    case 65487: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 2: {
                switch (e.getKeyCode()) {
                    case 90: {
                        this.undo();
                        break;
                    }
                    case 67: 
                    case 155: {
                        this.copy();
                        break;
                    }
                    case 88: {
                        this.cut();
                        break;
                    }
                    case 86: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 1: {
                switch (e.getKeyCode()) {
                    case 127: {
                        this.cut();
                        break;
                    }
                    case 155: {
                        if (this.gf.getRemoteVirtualKeyboard().havePasteKey()) break;
                        this.paste();
                    }
                }
                break;
            }
            case 8: {
                switch (e.getKeyCode()) {
                    case 8: {
                        this.undo();
                    }
                }
            }
        }
        this.gomyrepaint = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.gomyrepaint = true;
        this.aKeyTyped = true;
        this.gf.getRemoteVirtualKeyboard().mapKey(e, this.lastKeyCode);
        char ch = e.getKeyChar();
        this.charTyped(ch, e.isAltDown(), e.getModifiers() != 0);
        this.gomyrepaint = false;
    }

    private void charTyped(char ch, boolean isAltDown, boolean hasModifiers) {
        if (this.isNumeric) {
            boolean ok = Character.isDigit(ch);
            boolean addDecPoint = false;
            boolean addSign = false;
            int signIdx = -1;
            if (!ok) {
                if (this.numericAutoClear) {
                    ok = ch == ',' || ch == '.' || ch == '/' || ch == ' ' || ch == '-';
                } else {
                    addSign = ch == '-' || ch == '+';
                    if (addSign) {
                        if (this.inp.isSigned) {
                            for (signIdx = this.inp.getFirstDigitIdx() - 1; signIdx >= 0 && this.inp.isEditingIndex(signIdx); --signIdx) {
                            }
                            if (this.inp.decPointIdx > 0 && signIdx > this.inp.decPointIdx) {
                                signIdx = this.inp.decPointIdx - 1;
                            }
                            if (signIdx < 0) {
                                signIdx = 0;
                            }
                            ok = true;
                        }
                    } else if (ch == this.inp.decPointChar) {
                        ok = addDecPoint = this.inp.idx <= this.inp.decPointIdx;
                    }
                }
            }
            if (ok) {
                if (addDecPoint) {
                    this.inp.addDecPoint();
                } else if (addSign) {
                    if (ch == '-') {
                        ((InpData)this.inp).data[signIdx] = 45;
                    } else if (this.inp.data[signIdx] == '-') {
                        ((InpData)this.inp).data[signIdx] = 32;
                    }
                } else {
                    this.inp.addch(ch);
                }
                this.display(true);
            } else if (ch != '\b' && ch != '\u007f') {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (ch >= ' ' && ch != '\u007f' || !hasModifiers && this.checkControlCharacter(ch)) {
            if (!isAltDown || ch >= '\u007f') {
                if (this.upper) {
                    this.inp.addch(Character.toUpperCase(ch));
                } else if (this.lower) {
                    this.inp.addch(Character.toLowerCase(ch));
                } else if (this.gf.getKdbUpper()) {
                    this.inp.addch(Character.toUpperCase(ch));
                } else if (this.gf.getKdbLower()) {
                    this.inp.addch(Character.toLowerCase(ch));
                } else {
                    this.inp.addch(ch);
                }
            }
            this.display(true);
        }
        this.checkAutoTermination();
    }

    private void checkAutoTermination() {
        if (this.autoTermination && !this.imeActive) {
            boolean terminate;
            int pos = this.doubleByteCompat ? this.inp.col : this.inp.idx;
            boolean bl = terminate = pos >= this.inp.getLastNotEditIdx();
            if (!this.numericAutoClear && this.isNumeric && this.update) {
                boolean bl2 = terminate && this.inp.isSignificantDigit(this.inp.getFirstNotEditIdx(this.inp.decPointIdx >= 0 ? this.inp.leadingZ : 0)) ? true : (terminate = false);
            }
            if (terminate) {
                this.check();
                this.listener.inputTerminated(new PicobolTextEvent(this, 2202));
            }
        }
    }

    private boolean checkControlCharacter(char keyChar) {
        if (this.acceptedControlCharacters == null) {
            return false;
        }
        for (char c : this.acceptedControlCharacters) {
            if (c >= ' ' && c != '\u007f' || c != keyChar) continue;
            return true;
        }
        return false;
    }

    public void setNational(boolean nat) {
        this.national = nat;
        if (nat) {
            this.doubleByteCompat = false;
        }
    }

    public void ttmyrepaint() {
        if (this.tt != null) {
            this.tt.myrepaint();
        }
    }

    public boolean getAlphaAutoClear() {
        return this.alphaAutoClear;
    }

    private class InpData
    implements Cloneable {
        private char[] data;
        private int len;
        private int maxIdx;
        private int maxCol;
        private int idx;
        private int col;
        private boolean selectedAll;
        private boolean insMode;
        private char[] pict;
        private char decPointChar;
        private int decPointIdx;
        private boolean isSigned;
        private int imeCol;
        private int imeTextLen;
        private int leadingZ;
        private InputMethodHighlight imeHl;

        InpData() {
        }

        InpData Clone() {
            InpData Return2;
            try {
                Return2 = (InpData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
            Return2.data = new char[this.data.length];
            System.arraycopy(this.data, 0, Return2.data, 0, this.data.length);
            return Return2;
        }

        public String toString() {
            int dataRealLen = 0;
            for (int i = 0; i < this.data.length; ++i) {
                dataRealLen += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
            }
            String s = "data='" + new String(this.data) + "'";
            s = s + ",idx=" + this.idx;
            s = s + ",col=" + this.col;
            s = s + ",dataRealLen=" + dataRealLen;
            s = s + ",imeCol=" + this.imeCol;
            s = s + ",imeTextLen=" + this.imeTextLen;
            return s;
        }

        void setPicture(String p, boolean dpc) {
            this.pict = TerminalAccept.normalizePic(p);
            if (this.pict != null) {
                boolean foundEditing = false;
                boolean numNoAC = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                this.decPointChar = (char)(dpc ? 44 : 46);
                if (this.pict[0] == 'S') {
                    this.isSigned = true;
                    this.pict[0] = 57;
                }
                this.decPointIdx = -1;
                for (int i = this.pict.length - 1; i >= 0; --i) {
                    foundEditing |= TerminalAccept.isEditing(this.pict[i]);
                    if (!numNoAC) continue;
                    if (this.pict[i] == this.decPointChar) {
                        this.decPointIdx = i;
                    }
                    this.isSigned |= this.pict[i] == '-' || this.pict[i] == '+';
                }
                int end = this.decPointIdx >= 0 ? this.decPointIdx - 1 : this.pict.length - 1;
                this.leadingZ = 0;
                while (this.leadingZ <= end && (this.pict[this.leadingZ] == 'z' || this.pict[this.leadingZ] == 'Z' || this.isEditingIndex(this.leadingZ))) {
                    ++this.leadingZ;
                }
                if (!foundEditing) {
                    this.pict = null;
                }
            } else {
                this.decPointChar = (char)46;
                this.decPointIdx = -1;
                this.isSigned = true;
                this.leadingZ = 0;
            }
        }

        void setSelectedAll(boolean b) {
            this.selectedAll = !TerminalAccept.this.updateFromScreen && b;
        }

        void setLen(int len) {
            this.len = len;
            if (this.data != null) {
                if (len != this.data.length) {
                    int i;
                    char[] od = this.data;
                    this.data = new char[len];
                    int n = i = len <= od.length ? len : od.length;
                    while (--i >= 0) {
                        this.data[i] = od[i];
                    }
                }
            } else {
                this.data = new char[len];
            }
        }

        private int getMaxCol() {
            int Return2 = 0;
            for (int i = 0; i < this.maxIdx; ++i) {
                Return2 += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
            }
            return Return2;
        }

        private boolean isEditingIndex(int idx) {
            return this.pict != null && idx < this.pict.length && TerminalAccept.isEditing(this.pict[idx]);
        }

        void setValue(String val) {
            if (val != null && val.length() > 0) {
                boolean numNoAC;
                if (this.data == null) {
                    this.setLen(val.length());
                }
                boolean bl = numNoAC = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                if (numNoAC) {
                    int offset;
                    char[] ini;
                    int i;
                    int i2;
                    val = val.trim();
                    if (this.decPointIdx > 0) {
                        int idx = val.lastIndexOf(this.decPointChar);
                        if (idx < 0 || idx == val.length() - 1) {
                            int end = this.decPointIdx - this.leadingZ;
                            while (val.length() > end && val.charAt(0) == '0') {
                                val = val.substring(1);
                            }
                            val = val + this.decPointChar;
                            for (i2 = this.decPointIdx + 1; i2 < this.pict.length; ++i2) {
                                val = this.isEditingIndex(i2) ? val + this.pict[i2] : val + '0';
                            }
                        } else {
                            char[] aftDecPoint = val.substring(idx + 1).toCharArray();
                            val = val.substring(0, idx + 1);
                            i = 0;
                            for (int j = this.decPointIdx + 1; j < this.pict.length; ++j) {
                                val = this.isEditingIndex(j) ? val + this.pict[j] : (i < aftDecPoint.length ? val + aftDecPoint[i++] : val + '0');
                            }
                        }
                    } else if (this.pict != null && this.leadingZ > 0) {
                        int end = this.pict.length - this.leadingZ;
                        while (val.length() > end && val.charAt(0) == '0') {
                            val = val.substring(1);
                        }
                    }
                    int ml = this.len <= (ini = val.toCharArray()).length ? this.len : ini.length;
                    for (i2 = 0; i2 < this.len - ml; ++i2) {
                        this.data[i2] = 32;
                    }
                    this.maxIdx = this.len;
                    boolean insertEditChars = TerminalAccept.this.editedFormatted && this.pict != null && this.len <= ini.length;
                    i = 0;
                    for (int j = this.len - ml; i < ini.length && j < this.data.length; ++i, ++j) {
                        this.data[j] = insertEditChars && TerminalAccept.isEditing(this.pict[j]) ? this.pict[j] : ini[i];
                    }
                    int maxOffset = this.decPointIdx > 0 ? this.decPointIdx - 1 : this.len - 1;
                    for (offset = Math.min(this.len - ml, maxOffset); offset < maxOffset && (this.data[offset] == ' ' || this.data[offset] == '-'); ++offset) {
                    }
                    if (!this.isEditingIndex(offset)) {
                        int decPointSave = this.decPointIdx;
                        char[] pictSave = this.pict;
                        this.pict = null;
                        this.decPointIdx = -1;
                        this.setOffset(offset);
                        this.pict = pictSave;
                        this.decPointIdx = decPointSave;
                    }
                } else {
                    char[] ini;
                    int ml;
                    for (int i = ml = this.len <= (ini = val.toCharArray()).length ? this.len : ini.length; i < this.len; ++i) {
                        this.data[i] = 32;
                    }
                    --ml;
                    while (ml >= 0 && ini[ml] == ' ') {
                        --ml;
                    }
                    ++ml;
                    this.maxIdx = ml--;
                    while (ml >= 0) {
                        this.data[ml] = TerminalAccept.this.getValidChar(ini[ml]);
                        --ml;
                    }
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
            } else {
                for (int i = 0; i < this.len; ++i) {
                    this.data[i] = 32;
                }
                this.maxIdx = 0;
                this.maxCol = 0;
            }
        }

        String getValue() {
            return new String(this.data, 0, this.maxIdx);
        }

        void clear() {
            this.idx = 0;
            this.col = 0;
            this.maxIdx = 0;
            this.maxCol = 0;
        }

        void cl2End() {
            this.maxIdx = this.col = this.idx;
            this.maxCol = this.col;
        }

        void cl2EndNnac() {
            boolean hasDecPoint;
            int currIdx = this.idx;
            if (currIdx >= this.len) {
                currIdx = this.len - 1;
            }
            boolean bl = hasDecPoint = this.decPointIdx >= 0;
            if (!hasDecPoint || this.idx < this.decPointIdx) {
                int i;
                int n = this.idx = hasDecPoint ? this.decPointIdx - 1 : this.len - 1;
                while (this.isEditingIndex(this.idx)) {
                    --this.idx;
                }
                int diff = 0;
                for (i = currIdx; i <= this.idx; ++i) {
                    if (this.isEditingIndex(i)) continue;
                    ++diff;
                }
                for (i = 0; i < diff; ++i) {
                    this.delNnac();
                }
                this.idx = hasDecPoint ? (this.col = this.decPointIdx) : (this.col = this.len);
            } else {
                if (currIdx == this.decPointIdx) {
                    ++currIdx;
                }
                while (currIdx < this.len) {
                    if (!this.isEditingIndex(currIdx)) {
                        this.data[currIdx] = 48;
                    }
                    ++currIdx;
                }
            }
        }

        void addDecPoint() {
            int tmpIdx = this.idx;
            this.idx = this.decPointIdx - 1;
            for (int i = this.decPointIdx - 1; i >= tmpIdx; --i) {
                if (this.isEditingIndex(i)) continue;
                this.delNnac();
            }
            this.col = this.idx = this.decPointIdx + 1;
        }

        boolean addch(char c) {
            if (this.selectedAll) {
                this.clear();
                this.selectedAll = false;
            }
            if (TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear) {
                int n;
                int n2 = n = this.decPointIdx > 0 && this.idx <= this.decPointIdx ? this.decPointIdx : this.len;
                if (this.idx < n) {
                    int i;
                    if (this.insMode) {
                        for (i = n - 1; i > this.idx; --i) {
                            int j = i - 1;
                            while (this.isEditingIndex(j)) {
                                --j;
                            }
                            this.data[i] = this.data[j];
                            i = j + 1;
                        }
                        if (this.maxIdx < n) {
                            ++this.maxIdx;
                        }
                    }
                    this.data[this.idx] = c;
                    ++this.idx;
                    ++this.col;
                    if (this.idx > this.maxIdx) {
                        for (i = this.idx - 2; i >= this.maxIdx; --i) {
                            this.data[i] = 32;
                        }
                        this.maxIdx = this.idx;
                    }
                    if (this.idx < n && !this.insMode && this.isEditingIndex(this.idx)) {
                        return this.addch(this.pict[this.idx]);
                    }
                    return true;
                }
                this.addNnac(c);
                return false;
            }
            if (TerminalAccept.this.doubleByteCompat) {
                return this.addchDBC(c);
            }
            if (this.idx < this.len) {
                int i;
                if (this.insMode) {
                    int n = i = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (i > this.idx) {
                        this.data[i] = this.data[i - 1];
                        --i;
                    }
                    if (this.maxIdx < this.len) {
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    for (i = this.idx - 2; i >= this.maxIdx; --i) {
                        this.data[i] = 32;
                    }
                    this.maxIdx = this.idx;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.addch(this.pict[this.idx]);
                }
                return true;
            }
            if (this.idx > 0 && !TerminalAccept.this.imeActive) {
                this.data[this.idx - 1] = c;
            }
            return false;
        }

        private int getFirstNotEditIdx(int r) {
            while (r < this.data.length && this.isEditingIndex(r)) {
                ++r;
            }
            return r;
        }

        private int getLastNotEditIdx() {
            int r;
            for (r = this.len - 1; r >= 0 && this.isEditingIndex(r); --r) {
            }
            return r + 1;
        }

        private boolean isSignificantDigit(int idx) {
            return this.data[idx] != ' ' && this.data[idx] != '+' && this.data[idx] != '-';
        }

        private int getFirstDigitIdx() {
            int firstDigitIdx;
            for (firstDigitIdx = 0; firstDigitIdx < this.data.length && (!this.isSignificantDigit(firstDigitIdx) || this.isEditingIndex(firstDigitIdx)); ++firstDigitIdx) {
            }
            return firstDigitIdx;
        }

        private void addNnac(char c) {
            int idx1;
            int idx0;
            boolean decPart;
            boolean bl = decPart = this.decPointIdx > 0 && this.idx > this.decPointIdx;
            if (decPart) {
                idx0 = this.decPointIdx + 1;
                idx1 = this.data.length;
            } else {
                idx0 = 0;
                idx1 = this.decPointIdx > 0 ? this.decPointIdx : this.data.length;
            }
            int firstDigitIdx = this.getFirstDigitIdx();
            if (!decPart && firstDigitIdx > 0) {
                int editing = 0;
                for (int i = idx0 + 1; i < idx1; ++i) {
                    if (this.isEditingIndex(i)) {
                        if (i >= firstDigitIdx - 1) {
                            this.data[i] = this.pict[i];
                        }
                        ++editing;
                        continue;
                    }
                    this.data[i - 1 - editing] = this.data[i];
                    editing = 0;
                }
            } else if (this.idx > 0 && this.idx == this.decPointIdx && this.getFirstDigitIdx() == 0) {
                this.right();
                this.addch(c);
                return;
            }
            this.data[idx1 - 1] = c;
        }

        private boolean addchDBC(char c) {
            int incr;
            int n = incr = TerminalAccept.this.tm.dblWidth(c) ? 2 : 1;
            if (this.col + incr <= this.len) {
                if (this.insMode) {
                    int i;
                    int n2 = i = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (i > this.idx) {
                        this.data[i] = this.data[i - 1];
                        --i;
                    }
                    if (this.maxCol + incr <= this.len) {
                        this.maxCol += incr;
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    this.maxIdx = this.idx;
                }
                this.maxCol = this.getMaxCol();
                return true;
            }
            if (this.idx > 0 && !TerminalAccept.this.imeActive) {
                this.data[this.idx - 1] = c;
                this.maxCol = this.getMaxCol();
            }
            return false;
        }

        boolean isAtEnd() {
            if (TerminalAccept.this.doubleByteCompat) {
                return this.col == this.len;
            }
            return this.idx == this.len;
        }

        void delcur() {
            this.selectedAll = false;
            if (this.idx < this.maxIdx) {
                for (int i = this.idx + 1; i < this.maxIdx; ++i) {
                    this.data[i - 1] = this.data[i];
                }
                if (this.maxIdx > 0) {
                    this.data[--this.maxIdx] = 32;
                }
                if (this.idx > this.maxIdx) {
                    this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                    --this.idx;
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
            }
        }

        boolean delNnac() {
            this.selectedAll = false;
            int idx = this.idx;
            if (idx >= this.len) {
                idx = this.len - 1;
            }
            while (this.isEditingIndex(idx)) {
                --idx;
            }
            int n = this.decPointIdx > 0 ? (idx > this.decPointIdx ? this.decPointIdx + 1 : 0) : 0;
            int firstDigitIdx = this.getFirstDigitIdx();
            ++firstDigitIdx;
            while (this.isEditingIndex(firstDigitIdx)) {
                ++firstDigitIdx;
            }
            block2: for (int i = idx; i > n; --i) {
                if (this.pict != null) {
                    if (i < this.pict.length && TerminalAccept.isEditing(this.pict[i])) {
                        if (i > firstDigitIdx) continue;
                        this.data[i] = 32;
                        continue;
                    }
                    for (int j = i - 1; j >= n; --j) {
                        if (j < this.pict.length && TerminalAccept.isEditing(this.pict[j])) continue;
                        this.data[i] = this.data[j];
                        continue block2;
                    }
                    continue;
                }
                this.data[i] = this.data[i - 1];
            }
            if (!this.isEditingIndex(n)) {
                this.data[n] = this.decPointIdx > 0 && n > this.decPointIdx ? 48 : 32;
                ++idx;
                while (idx != this.decPointIdx && idx < this.len && this.isEditingIndex(idx)) {
                    this.data[idx] = 32;
                    ++idx;
                }
                if (firstDigitIdx > this.idx) {
                    this.idx = idx;
                    this.col = idx;
                }
            }
            return true;
        }

        boolean delch() {
            boolean Return2;
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    --this.idx;
                } else {
                    for (int i = this.idx; i < this.maxIdx; ++i) {
                        this.data[i - 1] = this.data[i];
                    }
                    --this.idx;
                    this.data[--this.maxIdx] = 32;
                }
                if (TerminalAccept.this.doubleByteCompat) {
                    this.maxCol = this.getMaxCol();
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.delch();
                }
                Return2 = true;
            } else {
                Return2 = false;
            }
            return Return2;
        }

        boolean myleft() {
            if (this.idx == 0 || this.getValue() != null && this.getValue().length() == 0 && this.idx == 0) {
                return false;
            }
            return this.left();
        }

        boolean left() {
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                --this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    return this.left();
                }
                return true;
            }
            return false;
        }

        boolean myright() {
            int c;
            String v = this.getValue();
            int n = c = TerminalAccept.this.national ? this.idx : this.col;
            if (v != null && v.length() != 0 && v.length() == c) {
                return false;
            }
            return this.right();
        }

        boolean right() {
            this.selectedAll = false;
            int myLen = TerminalAccept.this.doubleByteCompat ? this.len - this.maxCol + this.maxIdx : this.len;
            if (this.idx < (TerminalAccept.this.update ? myLen - 1 : this.maxIdx)) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                ++this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    this.right();
                }
                return true;
            }
            return false;
        }

        boolean home() {
            int newIdx;
            this.selectedAll = false;
            boolean Return2 = this.idx != 0;
            this.col = this.idx = (newIdx = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear ? this.getFirstDigitIdx() : 0);
            return Return2;
        }

        boolean end() {
            boolean Return2;
            this.selectedAll = false;
            if (TerminalAccept.this.doubleByteCompat) {
                if (this.maxCol == this.len) {
                    Return2 = this.idx != this.maxIdx - 1;
                    this.idx = this.maxIdx - 1;
                } else {
                    Return2 = this.idx != this.maxIdx;
                    this.idx = this.maxIdx;
                }
            } else if (this.maxIdx == this.len) {
                Return2 = this.idx != this.maxIdx - 1;
                this.idx = this.maxIdx - 1;
            } else {
                Return2 = this.idx != this.maxIdx;
                this.idx = this.maxIdx;
            }
            this.col = 0;
            for (int i = 0; i < this.idx; ++i) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
            }
            return Return2;
        }

        void setOffset(int offs) {
            if (offs > 0) {
                while (this.idx < this.len && this.idx < offs) {
                    if (this.data[this.idx] >= ' ' && this.data[this.idx] != '\u007f') {
                        this.addch(this.data[this.idx]);
                        continue;
                    }
                    this.addch(' ');
                }
            }
            if (this.maxIdx > 0 && offs < this.maxIdx) {
                this.idx = offs;
                this.col = 0;
                for (int i = 0; i < this.idx; ++i) {
                    this.col += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
                }
            }
        }

        int getOffset() {
            return this.col;
        }

        int getIdx() {
            return this.idx;
        }

        int getLength() {
            return this.len;
        }

        char[] getData(boolean prmpt) {
            int i;
            char[] Return2;
            int myLen;
            if (TerminalAccept.this.doubleByteCompat) {
                myLen = Math.min(this.len - this.maxCol + this.maxIdx, this.data.length);
                Return2 = new char[myLen];
                for (i = 0; i < myLen; ++i) {
                    Return2[i] = this.data[i];
                }
            } else {
                myLen = this.len;
                Return2 = this.data;
            }
            if (prmpt) {
                for (i = this.maxIdx; i < myLen; ++i) {
                    Return2[i] = TerminalAccept.this.promptChar;
                }
            } else {
                for (i = this.maxIdx; i < myLen; ++i) {
                    Return2[i] = 32;
                }
            }
            return Return2;
        }
    }
}

