/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TerminalModel
implements Constants,
PropertyChangeListener {
    public static final int A_BOLD = 0x1000000;
    public static final int A_UNDERLINE = 0x2000000;
    public static final int A_REVERSE = 0x4000000;
    public static final int A_BLINK = 0x8000000;
    public static final int A_NOECHO = 0x10000000;
    public static final int A_GRAPHIC = 0x20000000;
    public static final int A_NORESET = 0x30000000;
    public static final int A_MASK = -16777216;
    public static final char ACS_HLINE = '\u0003';
    public static final char ACS_LHLINE = '\u0002';
    public static final char ACS_RHLINE = '\u0001';
    public static final char ACS_VLINE = '\f';
    public static final char ACS_TVLINE = '\u0004';
    public static final char ACS_BVLINE = '\b';
    public static final char ACS_ULCORNER = '\u0006';
    public static final char ACS_URCORNER = '\u0005';
    public static final char ACS_LLCORNER = '\n';
    public static final char ACS_LRCORNER = '\t';
    public static final char ACS_BTEE = '\u000b';
    public static final char ACS_TTEE = '\u0007';
    public static final char ACS_LTEE = '\u000e';
    public static final char ACS_RTEE = '\r';
    public static final char ACS_PLUS = '\u000f';
    public static final char KSN_TYP_HOR_OVER = '\u0000';
    public static final char KSN_TYP_HOR_UNDER = '\u0001';
    public static final char KSN_TYP_VER_LEFT = '\u0002';
    public static final char KSN_TYP_VER_RIGHT = '\u0003';
    public static final char KSN_CLR_BLACK = '\u0000';
    public static final char KSN_CLR_BLUE = '\u0001';
    public static final char KSN_CLR_GREEN = '\u0002';
    public static final char KSN_CLR_CYAN = '\u0003';
    public static final char KSN_CLR_RED = '\u0004';
    public static final char KSN_CLR_MAGENTA = '\u0005';
    public static final char KSN_CLR_YELLOW = '\u0006';
    public static final char KSN_CLR_WHITE = '\u0007';
    public static final char KSN_CLR_MASK = '\u000f';
    public static final char KSN_STK_SOLID = '\u0010';
    public static final char KSN_STK_DASHED = ' ';
    public static final char KSN_STK_DOTTED = '0';
    public static final char KSN_STK_DASHLINE = '@';
    public static final char KSN_STK_TWODOT = 'P';
    public static final char KSN_STK_MASK = '\u00f0';
    public static final boolean DEF_AUTOWRAP = false;
    public static final boolean DEF_ANTIALIASING = false;
    public static final int CURSOR_INVIS = 0;
    public static final int CURSOR_UNDER = 1;
    public static final int CURSOR_BLOCK = 2;
    public static final int CURSOR_MIXED = 3;
    public static final int CURSOR_VLINE = 4;
    public static final int DEF_CURSTYPE = 2;
    public static final char defChar = ' ';
    public static final int defAttr = 0xFFFFFF;
    private int x0Orig;
    private int y0Orig;
    private int x0;
    private int y0;
    private int heightOrig;
    private int widthOrig;
    private int width;
    private int height;
    private int heightOutBound;
    private int[][] backMatrix;
    private int[][] attrMatrix;
    private char[][] charMatrix;
    private int[][] kesnMatrix;
    private Point cursor;
    private Point caret;
    private Component withFocus;
    private Point lastCaret;
    private Color lastCaretColor;
    private Color fixedCaretColor;
    private int backColor;
    private int termAttr;
    private Dimension charDim;
    private FontMetrics fm;
    private int zeroWidth;
    private int cursorType;
    boolean insertCursor;
    Selection selection = new Selection();
    private static final Color selColor = new Color(192, 192, 192);
    private boolean autowrap;
    private boolean doubleByteCompat;
    private boolean antialiasing;
    private boolean dragEnabled;
    private String pasteKey;
    private boolean lines3D;
    private AbstractGuiFactoryImpl gf;
    private int lastx = -1;
    private int lasty = -1;
    private static final String eol = System.getProperty("line.separator", "\n");

    public TerminalModel(AbstractGuiFactoryImpl gf) {
        this.gf = gf;
        this.setBackColor(Color.black);
        this.setForeColor(Color.white);
    }

    public synchronized void init(int cols, int rows, Dimension ch, FontMetrics f) {
        if (this.charMatrix != null && this.widthOrig > 0 && this.heightOrig > 0) {
            if (cols != this.widthOrig || rows != this.heightOrig) {
                if (rows == this.heightOrig && cols != this.widthOrig) {
                    this.changeWidth(cols, false);
                } else {
                    this.changeSize(cols, rows);
                }
            }
            return;
        }
        this.fm = f;
        this.zeroWidth = this.fm.charWidth('0');
        this.x0 = 0;
        this.x0Orig = 0;
        this.y0 = 0;
        this.y0Orig = 0;
        this.widthOrig = this.width = cols;
        this.heightOrig = this.height = rows;
        this.charDim = ch;
        this.cursor = new Point();
        this.caret = new Point(-1, -1);
        this.lastCaret = new Point(-1, -1);
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.kesnMatrix = null;
        this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.antialiasing = this.gf.getCsProperty().get("iscobol.terminal.antialiasing", false);
        this.dragEnabled = this.gf.getCsProperty().get("iscobol.terminal.drag_enabled", true);
        this.lines3D = this.gf.getCsProperty().get("iscobol.terminal.lines_3d", false);
        this.doubleByteCompat = true;
        this.setCaretColor();
        this.gf.getCsProperty().addPropertyChangeListener(this);
    }

    private void setCaretColor() {
        int cc = this.gf.getCsProperty().get("iscobol.terminal.cursor_color", -1);
        this.fixedCaretColor = cc >= 0 ? this.gf.getRemotePalette().getDefaultColor(cc) : null;
    }

    private synchronized void initMatrices() {
        if (this.cursor != null && this.backMatrix == null) {
            if (KeyboardBuffer.guiLog != null) {
                Exception ex = new Exception("INIT TERMINAL MATRICES");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.close();
                KeyboardBuffer.guiLog.info(sw.toString());
            }
            this.backMatrix = new int[this.widthOrig][this.heightOrig];
            this.attrMatrix = new int[this.widthOrig][this.heightOrig];
            this.charMatrix = new char[this.widthOrig][this.heightOrig];
            this.kesnMatrix = new int[this.widthOrig][this.heightOrig];
            this.erase();
        }
    }

    public synchronized void changeWidth(int nw) {
        this.changeWidth(nw, true);
    }

    public synchronized void changeWidth(int nw, boolean initmatrices) {
        int j;
        int i;
        if (initmatrices) {
            this.initMatrices();
        }
        int minw = nw > this.widthOrig ? this.widthOrig : nw;
        int[][] nBackMatrix = new int[nw][this.heightOrig];
        int[][] nAttrMatrix = new int[nw][this.heightOrig];
        char[][] nCharMatrix = new char[nw][this.heightOrig];
        int[][] nKesnMatrix = new int[nw][this.heightOrig];
        for (i = 0; i < minw; ++i) {
            for (j = 0; j < this.heightOrig; ++j) {
                nBackMatrix[i][j] = this.backMatrix[i][j];
                nAttrMatrix[i][j] = this.attrMatrix[i][j];
                nCharMatrix[i][j] = this.charMatrix[i][j];
                nKesnMatrix[i][j] = this.kesnMatrix[i][j];
            }
        }
        while (i < nw) {
            for (j = 0; j < this.heightOrig; ++j) {
                nBackMatrix[i][j] = this.backColor;
                nAttrMatrix[i][j] = this.termAttr;
                nCharMatrix[i][j] = 32;
                nKesnMatrix[i][j] = 0;
            }
            ++i;
        }
        this.backMatrix = nBackMatrix;
        this.attrMatrix = nAttrMatrix;
        this.charMatrix = nCharMatrix;
        this.kesnMatrix = nKesnMatrix;
        if (this.width == this.widthOrig) {
            this.width = nw;
        }
        this.widthOrig = nw;
    }

    public synchronized void changeSize(int nw, int nh) {
        int j;
        int i;
        int minw = nw > this.widthOrig ? this.widthOrig : nw;
        int minh = nh > this.heightOrig ? this.heightOrig : nh;
        int[][] nBackMatrix = new int[nw][nh];
        int[][] nAttrMatrix = new int[nw][nh];
        char[][] nCharMatrix = new char[nw][nh];
        int[][] nKesnMatrix = new int[nw][nh];
        for (i = 0; i < minw; ++i) {
            for (j = 0; j < minh; ++j) {
                nBackMatrix[i][j] = this.backMatrix[i][j];
                nAttrMatrix[i][j] = this.attrMatrix[i][j];
                nCharMatrix[i][j] = this.charMatrix[i][j];
                nKesnMatrix[i][j] = this.kesnMatrix[i][j];
            }
        }
        for (i = minw; i < nw; ++i) {
            for (j = 0; j < nh; ++j) {
                nBackMatrix[i][j] = this.backColor;
                nAttrMatrix[i][j] = this.termAttr;
                nCharMatrix[i][j] = 32;
                nKesnMatrix[i][j] = 0;
            }
        }
        for (i = 0; i < nw; ++i) {
            for (j = minh; j < nh; ++j) {
                nBackMatrix[i][j] = this.backColor;
                nAttrMatrix[i][j] = this.termAttr;
                nCharMatrix[i][j] = 32;
                nKesnMatrix[i][j] = 0;
            }
        }
        this.backMatrix = nBackMatrix;
        this.attrMatrix = nAttrMatrix;
        this.charMatrix = nCharMatrix;
        this.kesnMatrix = nKesnMatrix;
        if (this.width == this.widthOrig) {
            this.width = nw;
        }
        this.widthOrig = nw;
        if (this.height == this.heightOrig) {
            this.height = nh;
        }
        this.heightOrig = nh;
    }

    private void mySetBackColor(Color c) {
        if (c != null) {
            this.backColor = c.getRGB();
        }
    }

    private void mySetForeColor(Color c) {
        if (c != null) {
            this.termAttr = c.getRGB() & 0xFFFFFF | this.termAttr & 0xFF000000;
        }
    }

    public void setSubwindow(int x, int y, int w, int h) {
        this.initMatrices();
        if (x >= 0 && x < this.widthOrig) {
            this.x0 = x;
        }
        if (y >= 0 && y < this.heightOrig) {
            this.y0 = y;
        }
        if (w >= 0 && w < this.widthOrig) {
            this.width = w;
        }
        if (h >= 0 && h < this.heightOrig) {
            this.height = h;
        }
        this.cursor.x = this.x0;
        this.cursor.y = this.y0;
    }

    public void resetSubwindow() {
        this.initMatrices();
        this.x0 = this.x0Orig;
        this.y0 = this.y0Orig;
        this.width = this.widthOrig;
        this.height = this.heightOrig;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.charDim.width * this.widthOrig, this.charDim.height * this.heightOrig);
    }

    public void setBackground(Color c) {
        if (c != null) {
            this.setBackground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, c);
        }
    }

    public void setForeground(Color c, int attr) {
        if (c != null) {
            this.setForeground(this.x0, this.y0, this.width - this.x0, this.height - this.y0, c, attr);
        }
    }

    public void setBackColor(Color c) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetForeColor(c);
        } else {
            this.mySetBackColor(c);
        }
    }

    public void setForeColor(Color c) {
        if ((this.termAttr & 0x4000000) != 0) {
            this.mySetBackColor(c);
        } else {
            this.mySetForeColor(c);
        }
    }

    private void swapForeBack() {
        int swap = this.termAttr;
        this.termAttr = this.backColor & 0xFFFFFF | this.termAttr & 0xFF000000;
        this.backColor = swap & 0xFFFFFF;
    }

    public void setCaret(Component wf) {
        this.setCaretAt(this.cursor.x, this.cursor.y, wf);
    }

    public void setCaretAt(int x, int y, Component wf) {
        this.withFocus = wf;
        this.caret.y = y < 0 ? 0 : (y >= this.heightOrig ? this.heightOrig - 1 : y);
        this.caret.x = x < 0 ? 0 : (x > this.widthOrig ? this.widthOrig : x);
    }

    public void caretLeft() {
        if (this.caret.x < this.width - 1) {
            ++this.caret.x;
        }
    }

    public void caretRight() {
        if (this.caret.x > this.x0) {
            --this.caret.x;
        }
    }

    public void unsetCaret(Component wf) {
        if (wf == this.withFocus) {
            this.caret.y = -1;
            this.caret.x = -1;
            this.withFocus = null;
        }
    }

    public void setAttr(int a) {
        boolean swap = (a & 0x4000000) != 0 && (this.termAttr & 0x4000000) == 0;
        this.termAttr = this.termAttr & 0xFFFFFF | a & 0xFF000000;
        if (swap) {
            this.swapForeBack();
        }
    }

    public void unsetAttr(int a) {
        boolean swap = (a & 0x4000000) != 0 && (this.termAttr & 0x4000000) != 0;
        this.termAttr &= ~(a & 0xFF000000);
        if (swap) {
            this.swapForeBack();
        }
    }

    public void clearAttr() {
        if ((this.termAttr & 0x4000000) != 0) {
            this.swapForeBack();
        }
        this.termAttr &= 0xFFFFFF;
    }

    public boolean move(int x, int y) {
        boolean Return2 = false;
        boolean scrollable = true;
        if (x == this.lastx && y == this.lasty) {
            scrollable = false;
        }
        this.lastx = x;
        this.lasty = y;
        this.initMatrices();
        if (y >= this.height) {
            if (scrollable) {
                if (this.heightOutBound > 0 && y > this.heightOutBound) {
                    this.scroll(y - this.heightOutBound);
                } else {
                    this.scroll(y - this.height + 1);
                }
                this.heightOutBound = y;
            }
            y = this.height - 1;
            Return2 = true;
        } else {
            this.heightOutBound = 0;
        }
        if (x > this.width) {
            x = this.width;
        }
        this.imove(x, y);
        return Return2;
    }

    private void imove(int x, int y) {
        this.cursor.y = y < 0 ? 0 : (y >= this.heightOrig ? this.heightOrig - 1 : y);
        this.cursor.x = x < 0 ? 0 : (x > this.widthOrig ? this.widthOrig : x);
    }

    public Point getyx() {
        return this.cursor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private synchronized void clearToLine(int yEnd) {
        int x;
        this.initMatrices();
        int y = this.cursor.y;
        if (this.cursor.x > this.x0) {
            for (x = this.cursor.x; x < this.width; ++x) {
                this.backMatrix[x][y] = this.backColor;
                this.attrMatrix[x][y] = this.termAttr &= 0xFDFFFFFF;
                this.charMatrix[x][y] = 32;
                this.kesnMatrix[x][y] = 0;
            }
            ++y;
        }
        while (y <= yEnd) {
            for (x = this.x0; x < this.width; ++x) {
                this.backMatrix[x][y] = this.backColor;
                this.attrMatrix[x][y] = this.termAttr &= 0xFDFFFFFF;
                this.charMatrix[x][y] = 32;
                this.kesnMatrix[x][y] = 0;
            }
            ++y;
        }
    }

    public void erase() {
        this.initMatrices();
        this.imove(this.x0, this.y0);
        this.clrtobot();
        this.imove(this.x0, this.y0);
    }

    public void clrtoeol() {
        this.clearToLine(this.cursor.y);
    }

    public void clrtobot() {
        this.clearToLine(this.height - 1);
    }

    public synchronized void scroll(int lines) {
        int x;
        int y1;
        this.initMatrices();
        if (lines > 0) {
            int y = this.y0;
            y1 = this.y0 + lines;
            while (y < this.height - lines) {
                for (x = this.x0; x < this.width; ++x) {
                    this.backMatrix[x][y] = this.backMatrix[x][y1];
                    this.attrMatrix[x][y] = this.attrMatrix[x][y1];
                    this.charMatrix[x][y] = this.charMatrix[x][y1];
                    this.kesnMatrix[x][y] = this.kesnMatrix[x][y1];
                }
                ++y;
                ++y1;
            }
            x = this.cursor.x;
            y1 = this.cursor.y - 1;
            this.imove(this.x0, y);
            this.clearToLine(this.height - 1);
        } else if (lines == 0) {
            x = this.cursor.x;
            y1 = this.cursor.y;
        } else {
            int y = this.height - (lines *= -1) - 1;
            y1 = this.height - 1;
            while (y >= this.y0) {
                for (x = this.x0; x < this.width; ++x) {
                    this.backMatrix[x][y1] = this.backMatrix[x][y];
                    this.attrMatrix[x][y1] = this.attrMatrix[x][y];
                    this.charMatrix[x][y1] = this.charMatrix[x][y];
                    this.kesnMatrix[x][y1] = this.kesnMatrix[x][y];
                }
                --y;
                --y1;
            }
            x = this.cursor.x;
            y1 = this.cursor.y - 1;
            this.imove(this.x0, this.y0);
            this.clearToLine(this.y0 + lines - 1);
        }
        if (y1 < 0) {
            y1 = 0;
        }
        this.imove(x, y1);
    }

    public void setForeground(int x, int y, int w, int h, Color c, int attr) {
        this.setForeColor(c);
        if (w < 1 || h < 1) {
            return;
        }
        attr &= 0xFF000000;
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x < 0) {
            x = 0;
        } else if (x > this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        this.initMatrices();
        if (c == null) {
            for (int i = y + h - 1; i >= y; --i) {
                for (int j = x + w - 1; j >= x; --j) {
                    this.attrMatrix[j][i] = this.attrMatrix[j][i] & 0x20FFFFFF | attr;
                }
            }
        } else {
            int fore = c.getRGB() & 0xFFFFFF;
            for (int i = y + h - 1; i >= y; --i) {
                for (int j = x + w - 1; j >= x; --j) {
                    this.attrMatrix[j][i] = fore | this.attrMatrix[j][i] & 0x20000000 | attr;
                }
            }
        }
    }

    public synchronized void setBackground(int x, int y, int w, int h, Color c) {
        this.setBackColor(c);
        if (w < 1 || h < 1 || c == null) {
            return;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x < 0) {
            x = 0;
        } else if (x > this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (w > this.widthOrig) {
            w = this.widthOrig;
        }
        if (h > this.heightOrig) {
            h = this.heightOrig;
        }
        int back = c.getRGB();
        this.initMatrices();
        for (int i = y + h - 1; i >= y; --i) {
            for (int j = x + w - 1; j >= x; --j) {
                this.backMatrix[j][i] = back;
            }
        }
    }

    public void clrarea(int x, int y, int w, int h, Color fore, int attr, Color back) {
        this.initMatrices();
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        this.clrarea(x, y, w, h);
        this.termAttr = taSave;
        this.backColor = bcSave;
    }

    public synchronized void clrarea(int x, int y, int w, int h) {
        if (w < 0 || h < 0) {
            return;
        }
        if (y < this.y0) {
            y = this.y0;
        } else if (y >= this.height) {
            y = this.height - 1;
        }
        if (x < this.x0) {
            x = this.x0;
        } else if (x > this.width) {
            x = this.width - 1;
        }
        if (x + w > this.width) {
            w = this.width - x;
        }
        if (y + h > this.height) {
            h = this.height - y;
        }
        this.initMatrices();
        for (int i = y + h - 1; i >= y; --i) {
            for (int j = x + w - 1; j >= x; --j) {
                this.backMatrix[j][i] = this.backColor;
                this.attrMatrix[j][i] = this.termAttr;
                this.charMatrix[j][i] = 32;
                this.kesnMatrix[j][i] = 0;
            }
        }
    }

    private synchronized void rawGLAdd(char c, boolean cross) {
        if (!cross || (this.attrMatrix[this.cursor.x][this.cursor.y] & 0x20000000) == 0) {
            this.rawadd(c);
        } else {
            this.rawadd((char)(c | this.charMatrix[this.cursor.x][this.cursor.y]));
        }
    }

    public boolean dblWidth(char c) {
        if (c < '\u0080') {
            return false;
        }
        return this.fm.charWidth(c) > this.zeroWidth;
    }

    private synchronized void rawadd(char c) {
        this.charMatrix[this.cursor.x][this.cursor.y] = c;
        this.backMatrix[this.cursor.x][this.cursor.y] = this.backColor;
        this.attrMatrix[this.cursor.x][this.cursor.y] = this.termAttr;
        if (this.cursor.x < this.widthOrig - 1) {
            ++this.cursor.x;
        }
        if (this.dblWidth(c)) {
            this.rawadd(' ');
        }
    }

    private synchronized boolean addch(char c) {
        boolean db = this.dblWidth(c);
        int cw = db ? 2 : 1;
        int x = this.cursor.x <= this.width - cw ? this.cursor.x : this.width - cw;
        this.backMatrix[x][this.cursor.y] = this.backColor;
        if (this.cursor.x++ >= this.width && this.autowrap) {
            if (++this.cursor.y >= this.height) {
                this.scroll(1);
            }
            this.cursor.x = this.x0;
            x = this.cursor.x++;
        }
        if (c != '\u0000') {
            this.attrMatrix[x][this.cursor.y] = this.termAttr;
            this.charMatrix[x][this.cursor.y] = c;
        } else {
            int[] nArray = this.attrMatrix[x];
            int n = this.cursor.y;
            nArray[n] = nArray[n] & 0x30000000;
            int[] nArray2 = this.attrMatrix[x];
            int n2 = this.cursor.y;
            nArray2[n2] = nArray2[n2] | this.termAttr;
        }
        if (db) {
            this.addch(' ');
        }
        return db;
    }

    public void right() {
        this.initMatrices();
        if (this.cursor.x < this.width) {
            int cw;
            int n = cw = this.dblWidth(this.charMatrix[this.cursor.x][this.cursor.y]) ? 2 : 1;
            if (this.cursor.x <= this.width - cw) {
                this.cursor.x += cw;
            }
        }
    }

    public void left() {
        this.initMatrices();
        if (this.cursor.x > this.x0) {
            --this.cursor.x;
        }
    }

    public void crlf() {
        this.initMatrices();
        if (this.cursor.y < this.height - 1) {
            ++this.cursor.y;
        }
        this.cursor.x = this.x0;
    }

    public Rectangle addstr(char[] c) {
        return this.addstr(c, 0);
    }

    public Rectangle addstr(char[] c, int end) {
        Rectangle Return2 = new Rectangle(0, 0, 0, 0);
        if (c == null) {
            return Return2;
        }
        this.initMatrices();
        this.upperLeft(Return2);
        if (end > 0) {
            for (int i = 0; i < end; ++i) {
                if (!this.addch(c[i])) continue;
                --end;
            }
        } else {
            for (int i = 0; i < c.length; ++i) {
                this.addch(c[i]);
            }
        }
        this.bottomRight(Return2);
        return Return2;
    }

    public Rectangle addstr(String s, int len, Color fore, int attr, Color back, boolean isNational) {
        int i;
        this.initMatrices();
        Rectangle Return2 = new Rectangle(0, 0, 0, 0);
        this.upperLeft(Return2);
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        char[] sc = new char[len];
        char[] cc = s != null ? s.toCharArray() : new char[len];
        int minLen = sc.length < cc.length ? sc.length : cc.length;
        for (i = 0; i < minLen; ++i) {
            sc[i] = cc[i];
        }
        while (i < sc.length) {
            sc[i] = 32;
            ++i;
        }
        if (this.doubleByteCompat && !isNational) {
            for (i = 0; i < len; ++i) {
                if (!this.addch(sc[i])) continue;
                --len;
            }
        } else {
            for (i = 0; i < len; ++i) {
                this.addch(sc[i]);
            }
        }
        this.termAttr = taSave;
        this.backColor = bcSave;
        this.bottomRight(Return2);
        return Return2;
    }

    private void paintBack(Graphics g, int c, int sx, int sy, int ex, int ey) {
        g.setColor(new Color(c & 0xFFFFFF));
        if (sx > 0 && ey > sy) {
            g.fillRect(sx * this.charDim.width, sy * this.charDim.height, this.widthOrig * this.charDim.width, sy * this.charDim.height + this.charDim.height);
            sx = 0;
            ++sy;
        }
        if (sx == 0 && ey > sy) {
            g.fillRect(0, sy * this.charDim.height, this.widthOrig * this.charDim.width, (ey - 1) * this.charDim.height + this.charDim.height);
            sx = 0;
            sy = ey;
        }
        g.fillRect(sx * this.charDim.width, sy * this.charDim.height, ex * this.charDim.width, sy * this.charDim.height + this.charDim.height);
    }

    private void myDrawString(Graphics g, StringBuffer buf, int sx, int y) {
        int len = buf.length();
        char[] c = new char[1];
        for (int i = 0; i < len; ++i) {
            c[0] = buf.charAt(i);
            if (c[0] == ' ') continue;
            g.drawChars(c, 0, 1, (sx + i) * this.charDim.width, y);
        }
    }

    private void paintForeLine(Graphics g, int a, int sx, int sy, int ex) {
        int colorNum = a & 0xFFFFFF;
        Color color = new Color(colorNum);
        g.setColor(color);
        if ((a & 0x20000000) != 0) {
            int y = sy * this.charDim.height + this.charDim.height / 2;
            int mx = this.charDim.width / 2;
            int my = this.charDim.height / 2;
            block13: for (int x = sx; x < ex; ++x) {
                switch (this.charMatrix[x][sy]) {
                    default: {
                        continue block13;
                    }
                    case '\u000f': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + this.charDim.width, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + this.charDim.width, y);
                        continue block13;
                    }
                    case '\u0004': 
                    case '\b': 
                    case '\f': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0006': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width + mx + 1, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height + my + 1, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width + mx, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height + my - 1, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width + mx, y, x * this.charDim.width + this.charDim.width, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height + my, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u0005': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + mx - 2, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height + my, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + mx, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height + my + 1, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + mx, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height + my, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\t': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + mx, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + my);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + mx - 1, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + my - 1);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + mx, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + my);
                        continue block13;
                    }
                    case '\n': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width + mx, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + my);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width + mx + 1, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + my);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width + mx, y, x * this.charDim.width + this.charDim.width, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + my);
                        continue block13;
                    }
                    case '\u0007': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height + my, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height + my, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + this.charDim.width, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height + my, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        continue block13;
                    }
                    case '\u000b': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + my);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + my);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + this.charDim.width, y);
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + my);
                        continue block13;
                    }
                    case '\u000e': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.drawLine(x * this.charDim.width + mx, y + 1, x * this.charDim.width + this.charDim.width, y + 1);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.drawLine(x * this.charDim.width + mx, y - 1, x * this.charDim.width + this.charDim.width, y - 1);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        g.drawLine(x * this.charDim.width + mx, y, x * this.charDim.width + this.charDim.width, y);
                        continue block13;
                    }
                    case '\r': {
                        if (this.lines3D && colorNum == 0) {
                            g.setColor(Color.white);
                            g.drawLine(x * this.charDim.width + mx + 1, sy * this.charDim.height, x * this.charDim.width + mx + 1, sy * this.charDim.height + this.charDim.height);
                            g.drawLine(x * this.charDim.width, y + 1, x * this.charDim.width + mx, y + 1);
                            g.setColor(Color.gray);
                            g.drawLine(x * this.charDim.width + mx - 1, sy * this.charDim.height, x * this.charDim.width + mx - 1, sy * this.charDim.height + this.charDim.height);
                            g.drawLine(x * this.charDim.width, y - 1, x * this.charDim.width + mx, y - 1);
                            g.setColor(color);
                        }
                        g.drawLine(x * this.charDim.width + mx, sy * this.charDim.height, x * this.charDim.width + mx, sy * this.charDim.height + this.charDim.height);
                        g.drawLine(x * this.charDim.width, y, x * this.charDim.width + mx, y);
                    }
                }
            }
        } else if (ex > sx) {
            int y = sy * this.charDim.height + this.charDim.height - this.fm.getDescent();
            int ul = y + 1;
            StringBuffer buf = new StringBuffer();
            for (int x = sx; x < ex; ++x) {
                buf.append(this.charMatrix[x][sy]);
            }
            if ((a & 0x1000000) != 0) {
                Font f = g.getFont();
                g.setFont(new Font(f.getName(), f.getStyle() | 1, f.getSize()));
            }
            if ((a & 0x10000000) == 0) {
                this.myDrawString(g, buf, sx, y);
            }
            if ((a & 0x2000000) != 0) {
                g.drawLine(sx * this.charDim.width, ul, ex * this.charDim.width, ul);
            }
        }
    }

    public void shadow(int x, int y, int w, int h, boolean boxed) {
        if (w > 1 && h > 1) {
            int i;
            this.initMatrices();
            int bcSave = this.backColor;
            this.setBackColor(Color.black);
            if (x + w < this.widthOrig) {
                if (boxed) {
                    this.imove(x + w, y + 1);
                    this.rawadd(' ');
                } else {
                    this.imove(x + w, y);
                    this.rawadd(' ');
                    this.imove(x + w, y + 1);
                    this.rawadd(' ');
                }
                for (i = y + 2; i < y + h && i < this.heightOrig; ++i) {
                    this.imove(x + w, i);
                    this.rawadd(' ');
                }
            }
            if (y + h < this.heightOrig) {
                this.imove(x + 1, y + h);
                this.rawadd(' ');
                for (i = x + 2; i < x + w && i < this.widthOrig; ++i) {
                    this.rawadd(' ');
                }
                this.rawadd(' ');
            }
            this.backColor = bcSave;
        }
    }

    private void box(int x, int y, int w, int h, boolean cross, boolean vertical) {
        if (x < 0) {
            x = 0;
        } else if (x >= this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        this.setAttr(0x20000000);
        if (h == 1 && !vertical) {
            if (w > 0) {
                this.imove(x, y);
                if (w > 1) {
                    this.rawGLAdd('\u0002', cross);
                    for (int i = 1; i < w - 1; ++i) {
                        this.rawGLAdd('\u0003', cross);
                    }
                    this.rawGLAdd('\u0001', cross);
                } else {
                    this.rawGLAdd('\u0003', cross);
                }
            }
        } else if (w == 1) {
            if (h > 0) {
                this.imove(x, y);
                if (h > 1) {
                    int i;
                    this.rawGLAdd('\u0004', cross);
                    for (i = 1; i < h - 1; ++i) {
                        this.imove(x, y + i);
                        this.rawGLAdd('\f', cross);
                    }
                    this.imove(x, y + i);
                    this.rawGLAdd('\b', cross);
                } else {
                    this.rawGLAdd('\f', cross);
                }
            }
        } else {
            int i;
            this.imove(x, y);
            this.rawGLAdd('\u0006', cross);
            for (i = 2; i < w; ++i) {
                this.rawGLAdd('\u0003', cross);
            }
            this.rawGLAdd('\u0005', cross);
            for (i = 1; i < h - 1; ++i) {
                this.imove(x, y + i);
                this.rawGLAdd('\f', cross);
                this.imove(x + w - 1, y + i);
                this.rawGLAdd('\f', cross);
            }
            this.imove(x, y + h - 1);
            this.rawGLAdd('\n', cross);
            for (i = 2; i < w; ++i) {
                this.rawGLAdd('\u0003', cross);
            }
            this.rawGLAdd('\t', cross);
        }
        this.unsetAttr(0x20000000);
    }

    private void printtitle(int x, int y, int w, int h, String title, int tPos) {
        if (title != null && w > 6) {
            int len = title.length();
            if (len > w - 6) {
                len = w - 6;
                title = title.substring(0, len);
            }
            if (title.length() > 0) {
                title = " " + title + " ";
                len += 2;
            }
            switch (tPos) {
                default: {
                    this.move(x + (w - len) / 2, y);
                    break;
                }
                case 1: {
                    this.move(x + 2, y);
                    break;
                }
                case 3: {
                    this.move(x + w - len - 2, y);
                    break;
                }
                case 5: {
                    this.imove(x + (w - len) / 2, y + h - 1);
                    break;
                }
                case 4: {
                    this.imove(x + 2, y + h - 1);
                    break;
                }
                case 6: {
                    this.imove(x + w - len - 2, y + h - 1);
                }
            }
            this.addstr(title.toCharArray());
            this.imove(x + w, y + h - 1);
        }
    }

    public void box(int x, int y, int w, int h, Color fore, int attr, Color back, String[] titles, int[] tPoss, boolean cross) {
        this.box(x, y, w, h, fore, attr, back, titles, tPoss, cross, false);
    }

    public void box(int x, int y, int w, int h, Color fore, int attr, Color back, String[] titles, int[] tPoss, boolean cross, boolean vert) {
        this.initMatrices();
        int taSave = this.termAttr;
        int bcSave = this.backColor;
        this.termAttr &= 0xFFFFFF;
        this.setAttr(attr);
        this.setForeColor(fore);
        this.setBackColor(back);
        this.box(x, y, w, h, cross, vert);
        if (titles[0] != null) {
            this.printtitle(x, y, w, h, titles[0], tPoss[0]);
        }
        if (titles[1] != null) {
            this.printtitle(x, y, w, h, titles[1], tPoss[1]);
        }
        this.termAttr = taSave;
        this.backColor = bcSave;
    }

    private void drawCaretOn(Graphics g) {
        if (this.caret.x >= 0) {
            this.lastCaret.x = this.caret.x;
            this.lastCaret.y = this.caret.y;
            int lastCaret_x = this.lastCaret.x < this.widthOrig ? this.lastCaret.x : this.widthOrig - 1;
            this.lastCaretColor = this.fixedCaretColor != null ? this.fixedCaretColor : new Color(this.attrMatrix[lastCaret_x][this.lastCaret.y] & 0xFFFFFF);
            g.setColor(this.lastCaretColor);
            g.setXORMode(new Color(this.backMatrix[lastCaret_x][this.lastCaret.y] & 0xFFFFFF));
            switch (this.cursorType) {
                case 0: {
                    break;
                }
                case 1: {
                    g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height + this.fm.getAscent(), this.charDim.width, this.fm.getDescent());
                    break;
                }
                case 3: {
                    if (this.insertCursor) {
                        g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height + this.charDim.height / 2, this.charDim.width, this.charDim.height / 2);
                        break;
                    }
                    g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height + this.fm.getAscent(), this.charDim.width, this.fm.getDescent());
                    break;
                }
                case 4: {
                    if (this.insertCursor) {
                        g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height, this.charDim.width / 2, this.charDim.height);
                        break;
                    }
                    g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height, 2, this.charDim.height);
                    break;
                }
                default: {
                    if (this.insertCursor) {
                        g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height + this.charDim.height / 2, this.charDim.width, this.charDim.height / 2);
                        break;
                    }
                    g.fillRect(lastCaret_x * this.charDim.width, this.lastCaret.y * this.charDim.height, this.charDim.width, this.charDim.height);
                }
            }
            g.setPaintMode();
        }
    }

    private void drawCaretOff(Graphics g) {
        if (this.lastCaret.x >= 0) {
            this.lastCaret.y = -1;
            this.lastCaret.x = -1;
            this.lastCaretColor = null;
        }
    }

    public synchronized void paint(Graphics g) {
        int y;
        this.initMatrices();
        int x = 0;
        int curBack = this.backMatrix[0][0];
        int sx = 0;
        int sy = 0;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCaretOff(g);
        for (y = 0; y < this.heightOrig; ++y) {
            for (x = 0; x < this.widthOrig; ++x) {
                if (this.backMatrix[x][y] == curBack) continue;
                this.paintBack(g, curBack, sx, sy, x, y);
                curBack = this.backMatrix[x][y];
                sx = x;
                sy = y;
            }
        }
        this.paintBack(g, curBack, sx, sy, x, y);
        int curAttr = this.attrMatrix[0][0];
        sx = 0;
        sy = 0;
        for (y = 0; y < this.heightOrig; ++y) {
            for (x = 0; x < this.widthOrig; ++x) {
                if (this.attrMatrix[x][y] == curAttr) continue;
                g.setColor(new Color(curAttr & 0xFF000000));
                while (sy < y) {
                    this.paintForeLine(g, curAttr, sx, sy, this.widthOrig);
                    sx = 0;
                    ++sy;
                }
                this.paintForeLine(g, curAttr, sx, sy, x);
                curAttr = this.attrMatrix[x][y];
                sx = x;
                sy = y;
            }
        }
        while (sy < y - 1) {
            this.paintForeLine(g, curAttr, sx, sy, this.widthOrig);
            sx = 0;
            ++sy;
        }
        this.paintForeLine(g, curAttr, sx, sy, x);
        this.paintKeisen(g);
        this.drawSelection(g);
        this.drawCaretOn(g);
    }

    private void drawSelection(Graphics g) {
        if (this.selection.x1 != -1) {
            g.setColor(selColor);
            g.setXORMode(Color.white);
            Selection sortSel = this.selection.sort();
            if (sortSel.y1 != sortSel.y2) {
                g.fillRect(sortSel.x1 * this.charDim.width, sortSel.y1 * this.charDim.height, this.widthOrig * this.charDim.width, this.charDim.height);
                ++sortSel.y1;
                while (sortSel.y1 < sortSel.y2) {
                    g.fillRect(0, sortSel.y1 * this.charDim.height, this.widthOrig * this.charDim.width, this.charDim.height);
                    ++sortSel.y1;
                }
                sortSel.x1 = 0;
            }
            g.fillRect(sortSel.x1 * this.charDim.width, sortSel.y1 * this.charDim.height, (sortSel.x2 - sortSel.x1) * this.charDim.width, this.charDim.height);
            g.setPaintMode();
        }
    }

    private void drawKeisenLine(Graphics g1, int kesn, int kTyp, int x, int y, int len) {
        BasicStroke stroke;
        Color col;
        Graphics2D g = (Graphics2D)g1;
        switch (kesn & 0xF) {
            default: {
                col = Color.black;
                break;
            }
            case 1: {
                col = Color.blue;
                break;
            }
            case 2: {
                col = Color.green;
                break;
            }
            case 3: {
                col = Color.cyan;
                break;
            }
            case 4: {
                col = Color.red;
                break;
            }
            case 5: {
                col = Color.magenta;
                break;
            }
            case 6: {
                col = Color.yellow;
                break;
            }
            case 7: {
                col = Color.white;
            }
        }
        g.setColor(col);
        switch (kesn & 0xF0) {
            default: {
                stroke = new BasicStroke();
                break;
            }
            case 32: {
                stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
                break;
            }
            case 48: {
                stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
                break;
            }
            case 64: {
                stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
                break;
            }
            case 80: {
                stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
            }
        }
        g.setStroke(stroke);
        switch (kTyp) {
            case 0: {
                g.drawLine(x * this.charDim.width, y * this.charDim.height, (x + len) * this.charDim.width - 1, y * this.charDim.height);
                break;
            }
            case 1: {
                g.drawLine(x * this.charDim.width, (y + 1) * this.charDim.height - 1, (x + len) * this.charDim.width - 1, (y + 1) * this.charDim.height - 1);
                break;
            }
            case 2: {
                g.drawLine(x * this.charDim.width, y * this.charDim.height, x * this.charDim.width, (y + len) * this.charDim.height - 1);
                break;
            }
            case 3: {
                g.drawLine((x + 1) * this.charDim.width - 1, y * this.charDim.height, (x + 1) * this.charDim.width - 1, (y + len) * this.charDim.height - 1);
                break;
            }
        }
    }

    public void keisen(int cmd, int x, int y, int w, int h, int clrStk) {
        this.initMatrices();
        int xl = x + w - 1;
        int yl = y + h - 1;
        if (xl >= this.widthOrig) {
            xl = this.widthOrig - 1;
        }
        if (yl >= this.heightOrig) {
            yl = this.heightOrig - 1;
        }
        switch (cmd) {
            case 0: {
                for (int i = 0; i < this.widthOrig; ++i) {
                    for (int j = 0; j < this.heightOrig; ++j) {
                        this.kesnMatrix[i][j] = 0;
                    }
                }
                break;
            }
            case 65536: {
                for (int i = x; i <= xl; ++i) {
                    int[] nArray = this.kesnMatrix[i];
                    int n = y;
                    nArray[n] = nArray[n] | clrStk;
                }
                break;
            }
            case 393216: {
                int[] nArray = this.kesnMatrix[x];
                int n = y;
                nArray[n] = nArray[n] | clrStk << 16;
            }
            case 131072: {
                for (int i = x; i <= xl; ++i) {
                    int[] nArray = this.kesnMatrix[i];
                    int n = y;
                    nArray[n] = nArray[n] | clrStk << 8;
                }
                break;
            }
            case 196608: {
                int i = y;
                while (i <= yl) {
                    int[] nArray = this.kesnMatrix[x];
                    int n = i++;
                    nArray[n] = nArray[n] | clrStk << 16;
                }
                break;
            }
            case 262144: {
                int i = y;
                while (i <= yl) {
                    int[] nArray = this.kesnMatrix[x];
                    int n = i++;
                    nArray[n] = nArray[n] | clrStk << 24;
                }
                break;
            }
            case 327680: {
                int i;
                int[] nArray = this.kesnMatrix[x];
                int n = y;
                nArray[n] = nArray[n] | clrStk << 16;
                for (i = x; i <= xl; ++i) {
                    int[] nArray2 = this.kesnMatrix[i];
                    int n2 = y;
                    nArray2[n2] = nArray2[n2] | clrStk;
                }
                int[] nArray3 = this.kesnMatrix[xl];
                int n3 = y;
                nArray3[n3] = nArray3[n3] | clrStk << 24;
                i = y + 1;
                while (i < yl) {
                    int[] nArray4 = this.kesnMatrix[x];
                    int n4 = i;
                    nArray4[n4] = nArray4[n4] | clrStk << 16;
                    int[] nArray5 = this.kesnMatrix[xl];
                    int n5 = i++;
                    nArray5[n5] = nArray5[n5] | clrStk << 24;
                }
                int[] nArray6 = this.kesnMatrix[x];
                int n6 = yl;
                nArray6[n6] = nArray6[n6] | clrStk << 16;
                for (i = x; i <= xl; ++i) {
                    int[] nArray7 = this.kesnMatrix[i];
                    int n7 = yl;
                    nArray7[n7] = nArray7[n7] | clrStk << 8;
                }
                int[] nArray8 = this.kesnMatrix[xl];
                int n8 = yl;
                nArray8[n8] = nArray8[n8] | clrStk << 24;
                break;
            }
        }
    }

    void paintKeisen(Graphics g) {
        int kesn;
        int x;
        int curKesn;
        int y;
        this.initMatrices();
        for (y = 0; y < this.heightOrig; ++y) {
            curKesn = 0;
            int curOver = 0;
            int curUnder = 0;
            int startOver = 0;
            int startUnder = 0;
            for (x = 0; x < this.widthOrig; ++x) {
                int under;
                kesn = this.kesnMatrix[x][y];
                if (kesn == curKesn) continue;
                int over = kesn & 0xFF;
                if (over != curOver) {
                    if (curOver != 0) {
                        this.drawKeisenLine(g, curOver, 0, startOver, y, x - startOver);
                    }
                    startOver = x;
                    curOver = over;
                }
                if ((under = (kesn & 0xFF00) >>> 8) != curUnder) {
                    if (curUnder != 0) {
                        this.drawKeisenLine(g, curUnder, 1, startUnder, y, x - startUnder);
                    }
                    startUnder = x;
                    curUnder = under;
                }
                curKesn = kesn;
            }
            if (curOver != 0) {
                this.drawKeisenLine(g, curOver, 0, startOver, y, x - startOver);
            }
            if (curUnder == 0) continue;
            this.drawKeisenLine(g, curUnder, 1, startUnder, y, x - startUnder);
        }
        for (x = 0; x < this.widthOrig; ++x) {
            curKesn = 0;
            int curLeft = 0;
            int curRight = 0;
            int startLeft = 0;
            int startRight = 0;
            for (y = 0; y < this.heightOrig; ++y) {
                int right;
                kesn = this.kesnMatrix[x][y];
                if (kesn == curKesn) continue;
                int left = (kesn & 0xFF0000) >>> 16;
                if (left != curLeft) {
                    if (curLeft != 0) {
                        this.drawKeisenLine(g, curLeft, 2, x, startLeft, y - startLeft);
                    }
                    startLeft = y;
                    curLeft = left;
                }
                if ((right = (kesn & 0xFF000000) >>> 24) != curRight) {
                    if (curRight != 0) {
                        this.drawKeisenLine(g, curRight, 3, x, startRight, y - startRight);
                    }
                    startRight = y;
                    curRight = right;
                }
                curKesn = kesn;
            }
            if (curLeft != 0) {
                this.drawKeisenLine(g, curLeft, 2, x, startLeft, y - startLeft);
            }
            if (curRight == 0) continue;
            this.drawKeisenLine(g, curRight, 3, x, startRight, y - startRight);
        }
    }

    private static void rtrim(StringBuffer sb) {
        int i;
        block3: for (i = sb.length() - 1; i >= 0; --i) {
            switch (sb.charAt(i)) {
                case ' ': 
                case '\u3000': {
                    continue block3;
                }
            }
        }
        sb.setLength(i + 1);
        sb.append(eol);
    }

    public StringBuffer getSelectedText() {
        StringBuffer Return2;
        this.initMatrices();
        if (this.selection.x1 != -1) {
            int i;
            Return2 = new StringBuffer();
            Selection sortSel = this.selection.sort();
            if (sortSel.x2 > this.widthOrig) {
                sortSel.x2 = this.widthOrig - 1;
            }
            if (sortSel.y2 > this.heightOrig) {
                sortSel.y2 = this.heightOrig - 1;
            }
            if (sortSel.y1 != sortSel.y2) {
                for (i = sortSel.x1; i < this.widthOrig && i < this.charMatrix.length && sortSel.y1 < this.charMatrix[i].length; ++i) {
                    Return2.append(this.getSelectedChar(i, sortSel.y1));
                }
                TerminalModel.rtrim(Return2);
                ++sortSel.y1;
                while (sortSel.y1 < sortSel.y2) {
                    for (i = 0; i < this.widthOrig && i < this.charMatrix.length && sortSel.y1 < this.charMatrix[i].length; ++i) {
                        Return2.append(this.getSelectedChar(i, sortSel.y1));
                    }
                    TerminalModel.rtrim(Return2);
                    ++sortSel.y1;
                }
                sortSel.x1 = 0;
            }
            for (i = sortSel.x1; i < sortSel.x2 && i < this.charMatrix.length && sortSel.y1 < this.charMatrix[i].length; ++i) {
                Return2.append(this.getSelectedChar(i, sortSel.y1));
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    private char getSelectedChar(int i, int j) {
        if ((this.attrMatrix[i][j] & 0x10000000) == 0x10000000) {
            return ' ';
        }
        return this.charMatrix[i][j];
    }

    public Area getArea(int x, int y, int w, int h) {
        this.initMatrices();
        if (x < 0) {
            x = 0;
        } else if (x >= this.widthOrig) {
            x = this.widthOrig - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.heightOrig) {
            y = this.heightOrig - 1;
        }
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        return new Area(x, y, w, h, this.backMatrix, this.attrMatrix, this.charMatrix, this.kesnMatrix);
    }

    public synchronized void restoreArea(Area a, int x, int y, int w, int h) {
        this.initMatrices();
        if (x + w > this.widthOrig) {
            w = this.widthOrig - x;
        }
        if (y + h > this.heightOrig) {
            h = this.heightOrig - y;
        }
        int j = y + h - 1;
        int ye = y + h - a.y0 - 1;
        while (j >= y) {
            int i = x + w - 1;
            int xe = x + w - a.x0 - 1;
            while (i >= x) {
                this.backMatrix[i][j] = a.backMatrix[xe][ye];
                this.attrMatrix[i][j] = a.attrMatrix[xe][ye];
                this.charMatrix[i][j] = a.charMatrix[xe][ye];
                this.kesnMatrix[i][j] = a.kesnMatrix[xe][ye];
                --i;
                --xe;
            }
            --j;
            --ye;
        }
    }

    private void upperLeft(Rectangle repArea) {
        repArea.x = this.cursor.x;
        repArea.y = this.cursor.y;
    }

    private void bottomRight(Rectangle repArea) {
        if (repArea.y == this.cursor.y && repArea.x < this.cursor.x) {
            repArea.width = (this.cursor.x - repArea.x) * this.charDim.width;
            repArea.height = this.charDim.height;
            repArea.x *= this.charDim.width;
            repArea.y *= this.charDim.height;
        } else if (repArea.y < this.cursor.y) {
            repArea.width = this.width * this.charDim.width;
            repArea.height = (this.cursor.y - repArea.y + 1) * this.charDim.height;
            repArea.x = 0;
            repArea.y *= this.charDim.height;
        } else {
            repArea.height = 0;
            repArea.width = 0;
            repArea.y = 0;
            repArea.x = 0;
        }
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public synchronized String acceptFromScreen(int line, int col, int size) {
        this.initMatrices();
        char[] Return2 = new char[size];
        int i = 0;
        col = col < 1 ? (line < 1 ? this.cursor.x : 0) : --col;
        line = line < 1 ? this.cursor.y : --line;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                Return2[i++] = this.charMatrix[col][line];
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
        return new String(Return2);
    }

    protected synchronized char[] getTextAt(int line, int col, int size) {
        this.initMatrices();
        if (line < 0 || col < 0 || size < 1 || line >= this.height || col >= this.width) {
            return new char[0];
        }
        char[] Return2 = new char[Math.min(size, this.width - col)];
        int c = col;
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = this.charMatrix[c][line];
            ++c;
        }
        return Return2;
    }

    private char getVirtualAttr(int x, int y) {
        int attr = this.attrMatrix[x][y] & 0xFF000000;
        int fore = this.attrMatrix[x][y] & 0xFFFFFF;
        int back = this.backMatrix[x][y] & 0xFFFFFF;
        int Return2 = fore == 0 ? (back == 0 ? attr | 0x10000000 : attr | 0x4000000) : (fore == 0xFFFFFF ? attr | 0x1000000 : (back == 0xFFFFFF ? (fore == 0x808080 ? attr | 0x4000000 | 0x1000000 : attr | 0x4000000) : attr));
        return (char)(Return2 >>> 24);
    }

    private void setVirtualAttr(char c, int x, int y) {
        int attr = c << 24;
        this.attrMatrix[x][y] = attr | 0xC0C0C0;
        switch (attr & 0x5000000) {
            case 0x4000000: {
                this.attrMatrix[x][y] = attr;
                this.backMatrix[x][y] = 0xFFFFFF | this.backMatrix[x][y] & 0xFF000000;
                break;
            }
            case 0x1000000: {
                this.attrMatrix[x][y] = attr | 0xFFFFFF;
                this.backMatrix[x][y] = this.backMatrix[x][y] & 0xFF000000;
                break;
            }
            case 0x5000000: {
                this.attrMatrix[x][y] = attr | 0x808080;
                this.backMatrix[x][y] = 0xFFFFFF | this.backMatrix[x][y] & 0xFF000000;
            }
        }
    }

    public synchronized String attrFromScreen(int line, int col, int size) {
        this.initMatrices();
        char[] Return2 = new char[size];
        int i = 0;
        line = line < 1 ? this.cursor.y : --line;
        col = col < 1 ? this.cursor.x : --col;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                Return2[i++] = this.getVirtualAttr(col, line);
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
        return new String(Return2);
    }

    public synchronized void writeToScreen(int line, int col, int size, String c, String a) {
        this.initMatrices();
        char[] chr = c.toCharArray();
        char[] attr = a.toCharArray();
        int i = 0;
        line = line < 1 ? this.cursor.y : --line;
        col = col < 1 ? this.cursor.x : --col;
        if (col < this.width && line < this.height) {
            while (size > 0 && line < this.height) {
                this.charMatrix[col][line] = chr[i];
                this.setVirtualAttr(attr[i], col, line);
                ++i;
                if (++col >= this.width) {
                    col = 0;
                    ++line;
                }
                --size;
            }
        }
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getTermAttr() {
        return this.termAttr;
    }

    public void setBackColor(int b) {
        this.backColor = b;
    }

    public void setTermAttr(int a) {
        this.termAttr = a;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (this.gf != null && key.equals("iscobol.terminal.autowrap")) {
            this.autowrap = this.gf.getCsProperty().get("iscobol.terminal.autowrap", false);
        }
        if (this.gf != null && key.equals("iscobol.terminal.drag_enabled")) {
            this.dragEnabled = this.gf.getCsProperty().get("iscobol.terminal.drag_enabled", true);
        }
        if (this.gf != null && key.equals("iscobol.terminal.cursor_color")) {
            this.setCaretColor();
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public String getPasteKey() {
        return this.pasteKey;
    }

    public synchronized void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.gf = null;
        this.backMatrix = null;
        this.attrMatrix = null;
        this.charMatrix = null;
        this.kesnMatrix = null;
        this.cursor = null;
        this.caret = null;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public boolean isDoubleByteCompat() {
        return this.doubleByteCompat;
    }

    public static class Selection {
        public int x1 = -1;
        public int y1 = -1;
        public int x2 = -1;
        public int y2 = -1;

        Selection sort() {
            Selection Return2 = new Selection();
            if (this.y2 >= this.y1) {
                Return2.y1 = this.y1;
                Return2.y2 = this.y2;
                if (this.y2 == this.y1 && this.x2 < this.x1) {
                    Return2.x1 = this.x2;
                    Return2.x2 = this.x1 + 1;
                } else {
                    Return2.x1 = this.x1;
                    Return2.x2 = this.x2;
                }
            } else {
                Return2.y1 = this.y2;
                Return2.y2 = this.y1;
                Return2.x1 = this.x2;
                Return2.x2 = this.x1 + 1;
            }
            return Return2;
        }
    }

    public static class Area {
        private int[][] backMatrix;
        private int[][] attrMatrix;
        private char[][] charMatrix;
        private int[][] kesnMatrix;
        int x0;
        int y0;
        int width;
        int height;

        private Area(int x, int y, int w, int h, int[][] bm, int[][] am, char[][] cm, int[][] km) {
            this.x0 = x;
            this.y0 = y;
            this.width = w;
            this.height = h;
            this.backMatrix = new int[this.width][this.height];
            this.attrMatrix = new int[this.width][this.height];
            this.charMatrix = new char[this.width][this.height];
            this.kesnMatrix = new int[this.width][this.height];
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    this.backMatrix[i][j] = bm[i + x][j + y];
                    this.attrMatrix[i][j] = am[i + x][j + y];
                    this.charMatrix[i][j] = cm[i + x][j + y];
                    this.kesnMatrix[i][j] = km[i + x][j + y];
                }
            }
        }
    }
}

