/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import com.iscobol.gui.Events;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.charva.BaseRemoteObject;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import java.io.IOException;

public class CobolEventCouple {
    private BaseRemoteObject sender;
    private BaseRemoteObject receiver;
    private RemoteRecordAccept rra;
    private int eventAction = -1;
    private boolean isControl;
    private boolean isLastEvent;

    private CobolEventCouple() {
        this.isLastEvent = true;
    }

    public CobolEventCouple(RemoteBaseGUIControl sender, BaseRemoteObject receiver, RemoteRecordAccept rra) {
        this((BaseRemoteObject)sender, receiver, rra);
        this.isControl = true;
    }

    public CobolEventCouple(BaseRemoteObject sender, BaseRemoteObject receiver, RemoteRecordAccept rra) {
        this.sender = sender;
        this.receiver = receiver;
        this.rra = rra;
    }

    public CobolEventCouple(RemoteBaseGUIControl sender, RemoteRecordAccept rra) {
        this((BaseRemoteObject)sender, rra);
        this.isControl = true;
    }

    public CobolEventCouple(BaseRemoteObject sender, RemoteRecordAccept rra) {
        this(sender, sender, rra);
    }

    public static CobolEventCouple getLastEvent() {
        return new CobolEventCouple();
    }

    public boolean sendToServer() {
        if (this.isLastEvent) {
            return false;
        }
        if (!this.sender.isInitialized()) {
            return true;
        }
        try {
            if (this.isControl) {
                RemoteBaseGUIControl rbgc = (RemoteBaseGUIControl)this.sender;
                this.eventAction = rbgc.getParentBGW().controlfireevent(rbgc, this.rra);
            } else {
                Events events = this.sender.getEvents();
                if (events != null) {
                    this.eventAction = events.fireevent(this.rra);
                }
            }
            if (this.rra.isHotKeyEvent()) {
                this.receiver.handleResponse(this.eventAction, this.rra, true);
            } else {
                this.receiver.handleResponse(this.eventAction, this.rra);
            }
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return false;
        }
        return true;
    }

    public String toString() {
        return "event-type = " + this.rra.getEventType();
    }

    public RemoteRecordAccept getRemoteRecordAccept() {
        return this.rra;
    }
}

