/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class Bar
extends Component {
    public static final int SOLID = 0;
    public static final int DASH = 1;
    public static final int DOT = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDOTDOT = 4;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private boolean isHorizontal;
    private Color[] colors = new Color[0];
    private int[] shading = new int[0];
    private Stroke style;
    private int[] trailingShift = new int[0];
    private int[] leadingShift = new int[0];

    public Bar() {
    }

    public Bar(int or) {
        if (or == 1) {
            this.isHorizontal = true;
        }
    }

    public Bar setHorizontal() {
        this.isHorizontal = true;
        return this;
    }

    public Bar setVertical() {
        this.isHorizontal = false;
        return this;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public Bar setColors(Color[] c) {
        this.colors = c;
        return this;
    }

    private Color getColorAt(int i) {
        Color Return2 = null;
        if (i < this.colors.length) {
            Return2 = this.colors[i];
        } else if (this.colors.length > 0) {
            Return2 = this.colors[this.colors.length - 1];
        }
        return Return2;
    }

    public Bar setShading(int[] s) {
        this.shading = s;
        return this;
    }

    private Color getShading(int i, Color Return2) {
        if (i < this.shading.length) {
            switch (this.shading[i]) {
                case -2: {
                    Return2 = Color.black.darker();
                    break;
                }
                case -1: {
                    Return2 = Return2.darker();
                    break;
                }
                case 0: {
                    Return2 = null;
                    break;
                }
                case 1: {
                    Return2 = Return2.brighter();
                    break;
                }
                case 2: {
                    Return2 = Color.white.brighter();
                }
            }
        }
        return Return2;
    }

    public Bar setLeadingShift(int[] val) {
        this.leadingShift = val;
        return this;
    }

    private int getLeadingShift(int i) {
        int Return2 = 0;
        if (i < this.leadingShift.length) {
            Return2 = this.leadingShift[i];
        } else if (this.leadingShift.length > 0) {
            Return2 = this.leadingShift[this.leadingShift.length - 1];
        }
        return Return2;
    }

    public Bar setTrailingShift(int[] val) {
        this.trailingShift = val;
        return this;
    }

    private int getTrailingShift(int i) {
        int Return2 = 0;
        if (i < this.trailingShift.length) {
            Return2 = this.trailingShift[i];
        } else if (this.trailingShift.length > 0) {
            Return2 = this.trailingShift[this.trailingShift.length - 1];
        }
        return Return2;
    }

    public Bar setStyle(int s) {
        switch (s) {
            default: {
                this.style = null;
                break;
            }
            case 1: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
                break;
            }
            case 2: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
                break;
            }
            case 3: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
                break;
            }
            case 4: {
                this.style = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{9.0f, 9.0f, 1.0f, 9.0f, 1.0f, 9.0f}, 0.0f);
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        Color defColor = g.getColor();
        Dimension d = this.getSize();
        if (this.style != null) {
            g.setStroke(this.style);
        }
        if (this.isHorizontal) {
            int thickness = d.height;
            for (int i = 0; i < thickness; ++i) {
                Color c = this.getColorAt(i);
                if (c != null) {
                    g.setColor(c);
                }
                if ((c = this.getShading(i, g.getColor())) != null) {
                    g.setColor(c);
                }
                g.drawLine(this.getLeadingShift(i), i, d.width - this.getTrailingShift(i) - 1, i);
            }
        } else {
            int thickness = d.width;
            for (int i = 0; i < thickness; ++i) {
                Color c = this.getColorAt(i);
                if (c != null) {
                    g.setColor(c);
                }
                if ((c = this.getShading(i, g.getColor())) != null) {
                    g.setColor(c);
                }
                g.drawLine(i, this.getLeadingShift(i), i, d.height - this.getTrailingShift(i) - 1);
            }
        }
        g.setColor(defColor);
    }

    public static void main(String[] argv) {
        final JFrame f = new JFrame("Bar Test"){

            @Override
            public void paint(Graphics g) {
                Dimension size = this.getSize();
                int cw = 10;
                int ch = 10;
                g.setColor(Color.cyan);
                for (int i = cw; i <= size.width; i += cw) {
                    g.drawLine(i, 0, i, size.height - 1);
                }
                for (int j = ch; j < size.height; j += ch) {
                    g.drawLine(0, j, size.width - 1, j);
                }
                super.paint(g);
            }
        };
        f.getContentPane().setLayout(null);
        f.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                JFrame jFrame = f;
                synchronized (jFrame) {
                    f.notify();
                }
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                f.dispose();
            }
        });
        f.setBounds(10, 10, 640, 480);
        f.setBackground(Color.white);
        Bar bar1 = new Bar(1);
        bar1.setColors(new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.yellow}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setStyle(3);
        bar1.setBounds(50, 50, 100, 5);
        f.getContentPane().add(bar1);
        Bar bar2 = new Bar(0);
        bar2.setColors(new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.yellow}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setStyle(3);
        bar2.setBounds(70, 70, 5, 100);
        f.getContentPane().add(bar2);
        Bar bar3 = new Bar(0);
        bar3.setColors(new Color[]{new Color(0, 127, 0)}).setLeadingShift(new int[]{0, 1, 2, 3, 4}).setTrailingShift(new int[]{0, 1, 2, 3, 4}).setShading(new int[]{-2, -1, 0, 1, 2}).setStyle(3);
        bar3.setBounds(90, 90, 5, 100);
        f.getContentPane().add(bar3);
        f.setVisible(true);
    }
}

