/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.ZoomLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BmpLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private Image imageorig;
    private Image imageorigscale;
    private int bitmapNumber;
    private int bitmapScale;
    private boolean bitmapScaleBestQuality;

    public BmpLabel() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
    }

    public void setImage(Image img, Image imageorig, int bitmapNumber) {
        this.setText(null);
        this.imageorig = imageorig;
        this.bitmapNumber = bitmapNumber;
        super.setIcon(new ImageIcon(img));
    }

    public void setImage(Image img, int width, int height, int bitmapNumber, int tpColor) {
        this.setText(null);
        if (tpColor >= 0) {
            img = ScreenUtility.makeColorTransparent(img, tpColor);
        }
        this.setIcon(this.getIcon(img, width, height, bitmapNumber));
    }

    private Icon getIcon(Image image, int width, int height, int bitmapNumber) {
        if (bitmapNumber > 0) {
            Image imageStrip = ScreenUtility.getImage(width, height, image, bitmapNumber);
            if (imageStrip != null) {
                return new ImageIcon(imageStrip);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Dimension oldSize = this.getSize();
        super.setBounds(x, y, w, h);
        Icon ii = super.getIcon();
        if (oldSize.width != w || oldSize.height != h) {
            this.checkSetImage(w, h);
        }
    }

    private void checkSetImage(int w, int h) {
        Image currImage;
        int scaleAlign;
        int scaleType;
        switch (this.bitmapScale) {
            case 1: {
                scaleType = 0;
                scaleAlign = 5;
                break;
            }
            case 2: {
                scaleType = 1;
                scaleAlign = 7;
                break;
            }
            default: {
                scaleType = -1;
                scaleAlign = -1;
            }
        }
        if (scaleType >= 0 && this.imageorigscale != null) {
            Image image = this.imageorigscale;
            image = ScreenUtility.scale(this.imageorigscale, w, h, scaleType, scaleAlign, this.bitmapScaleBestQuality);
            this.setImage(image, image, this.bitmapNumber);
        } else if (this.imageorig != null && (currImage = ScreenUtility.getImage(w, h, this.imageorig, this.bitmapNumber)) != null) {
            this.setImage(currImage, this.imageorig, this.bitmapNumber);
        }
    }

    public void setBitmapScale(int bitmapScale, boolean bestQuality, Image imageorigscale) {
        this.bitmapScale = bitmapScale;
        this.bitmapScaleBestQuality = bestQuality;
        this.imageorigscale = imageorigscale;
        if (imageorigscale != null && this.getParent() != null && this.getParent().getLayout() != null && this.getParent().getLayout() instanceof ZoomLayout) {
            Rectangle bounds = super.getBounds();
            Icon ii = super.getIcon();
            if (ii != null && bounds != null && (ii.getIconWidth() != bounds.width || ii.getIconHeight() != bounds.height)) {
                this.checkSetImage(bounds.width, bounds.height);
            }
        }
    }
}

