/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.swing.DateEntryChangeListener;
import com.iscobol.gui.client.swing.DateEntryEvent;
import com.iscobol.gui.client.swing.DateEntryListener;
import com.iscobol.gui.client.swing.DateEntryVetoException;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.OutAcceptListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.toedter.calendar.IDateEditor;
import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;
import com.toedter.calendar.JTextFieldDateEditor;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.text.DateFormatter;

public class DateEntry
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int SPINNER_STYLE = 0;
    public static final int TEXT_FIELD_STYLE = 1;
    private static final String SPINNER_DEFAULT_PATTERN = "d-MMM-yyyy";
    private static final String TEXT_FIELD_DEFAULT_PATTERN = "dd-MM-yyyy";
    private boolean allowEmpty;
    private int style = 0;
    private JCheckBox showNoneCheckBox;
    private JPanel showNonePanel;
    protected MyDateEntry dateEntry;
    protected DateEntryListener deListener;
    private String dateFormatString = "d-MMM-yyyy";
    private DateEntryChangeListener changeListener;
    protected Date oldDate;
    private Date illegalDate;
    private boolean showNone;
    protected OutAcceptListener oaListener;
    private boolean readOnly;
    private Calendar _2DigitsYearStartDate;
    private IDateEditor editor;
    private JFormattedTextField textFieldEditor;
    private KeyEventPostProcessor kepp;
    private String name;
    private Color disabledBackground;
    private Color disabledForeground;
    private KeyListener keyListener;
    private KeyListener keyListenerProxy;
    private ActionListener dayListener;
    private FromToTransferHandler ftth = null;
    private boolean defaultShortcutsEnabled = true;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            if (DateEntry.this.textFieldEditor.getCaret() != null) {
                DateEntry.this.textFieldEditor.getCaret().setVisible(false);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (DateEntry.this.textFieldEditor.isEnabled() && DateEntry.this.textFieldEditor.getCaret() != null) {
                DateEntry.this.textFieldEditor.getCaret().setVisible(true);
            }
        }
    };

    public DateEntry(int style, String dateFormatString) {
        this.dateFormatString = dateFormatString;
        this.showNonePanel = new JPanel(new GridLayout(1, 0));
        this.showNoneCheckBox = new JCheckBox();
        this.showNoneCheckBox.addActionListener(e -> {
            this.intSetShowNoneChecked(this.showNoneCheckBox.isSelected());
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new DateEntryEvent(this));
            }
        });
        this.showNoneCheckBox.setFocusable(false);
        this.showNonePanel.add(this.showNoneCheckBox);
        this.showNonePanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.darkGray));
        this.setLayout(new BorderLayout());
        this.keyListenerProxy = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyTyped(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyReleased(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (DateEntry.this.keyListener != null) {
                    DateEntry.this.keyListener.keyPressed(e);
                }
            }
        };
        this.setStyle(style);
        if (this.name != null && this.textFieldEditor != null) {
            this.textFieldEditor.setName(this.name);
        }
        this.add((Component)((Object)this.dateEntry), "Center");
        this.dateEntry.getCalendarButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Date d = DateEntry.this.getJCalendar().getDate();
                if (!(DateEntry.this.oldDate == null || d != null && d.equals(DateEntry.this.oldDate))) {
                    DateEntry.this.getJCalendar().setDate(DateEntry.this.oldDate);
                }
                if (DateEntry.this.getOutAcceptListener() != null && DateEntry.this.getOutAcceptListener().bufferedOutAcceptEvent(new OutAcceptEvent(evt))) {
                    return;
                }
                DateEntry.this.handleCalendarButtonMousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DateEntry.this.handleCalendarButtonMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                DateEntry.this.handleCalendarButtonMouseClicked(evt);
            }
        });
        this.dateEntry.addPropertyChangeListener("date", evt -> {
            if (this.changeListener != null) {
                if (!this.showNoneCheckBox.isSelected()) {
                    this.showNoneCheckBox.setSelected(true);
                    this.intSetShowNoneChecked(true);
                }
                this.changeListener.stateChanged(new DateEntryEvent(this, (Date)evt.getNewValue()));
            }
        });
        this.intSetAllowEmpty(false);
        if (this.textFieldEditor != null) {
            this.textFieldEditor.addKeyListener(this.keyListenerProxy);
        }
        this.showNoneCheckBox.addKeyListener(this.keyListenerProxy);
        this.kepp = e -> {
            if (e.getSource() == this.textFieldEditor && ((JComponent)this.editor).isEnabled() && e.getID() == 400 && e.getKeyChar() != '\uffff') {
                this.fireStateChanged();
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.kepp);
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
        this.textFieldEditor.repaint();
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
        if (this.disabledForeground != null && this.style == 1) {
            this.textFieldEditor.setDisabledTextColor(disabledForeground);
        }
    }

    private boolean checkDateFormat(String pattern) {
        try {
            new SimpleDateFormat(pattern);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setStyle(int style) {
        this.style = style;
        switch (this.style) {
            default: {
                if (!this.checkDateFormat(this.dateFormatString)) {
                    this.dateFormatString = SPINNER_DEFAULT_PATTERN;
                }
                this.editor = new MyJSpinnerDateEditor();
                JSpinner.DateEditor jsde = new JSpinner.DateEditor((JSpinner)this.editor, this.dateFormatString);
                ((MyJSpinnerDateEditor)this.editor).setEditor(jsde);
                this.textFieldEditor = jsde.getTextField();
                ((MyJSpinnerDateEditor)this.editor).de = this;
                this.dateEntry = new MyDateEntry(this.editor);
                break;
            }
            case 1: {
                if (!this.checkDateFormat(this.dateFormatString)) {
                    this.dateFormatString = TEXT_FIELD_DEFAULT_PATTERN;
                }
                this.dateFormatString = this.dateFormatString.replaceAll("\\bd\\b", "dd").replaceAll("\\bM\\b", "MM");
                this.dateEntry = new MyDateEntry(this, this.dateFormatString, IsguiUtility.createMaskFromDatePattern(this.dateFormatString, '#', true), ' ');
                this.editor = this.dateEntry.getDateEditor();
                this.textFieldEditor = (JTextFieldDateEditor)this.editor;
            }
        }
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.kepp);
        this.dateEntry.cleanup();
    }

    private void fireStateChanged() {
        if (!this.showNoneCheckBox.isSelected()) {
            this.showNoneCheckBox.setSelected(true);
            this.intSetShowNoneChecked(true);
        }
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new DateEntryEvent(this));
        }
    }

    public void setDateEntryListener(DateEntryListener l) {
        this.deListener = l;
    }

    public void addOutAcceptListener(OutAcceptListener oaListener) {
        this.oaListener = oaListener;
    }

    public OutAcceptListener getOutAcceptListener() {
        return this.oaListener;
    }

    public void setChangeListener(DateEntryChangeListener l) {
        this.changeListener = l;
    }

    protected JDateChooser getDateChooser() {
        return this.dateEntry;
    }

    public JCalendar getJCalendar() {
        return this.dateEntry.getJCalendar();
    }

    public void hidePopup() {
        this.dateEntry.getPopup().setVisible(false);
    }

    public void setRightAlignment(boolean b) {
        if (b) {
            this.textFieldEditor.setHorizontalAlignment(4);
        } else {
            this.textFieldEditor.setHorizontalAlignment(2);
        }
    }

    @Override
    public void setFont(Font f) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setFont(f);
            this.showNoneCheckBox.setFont(f);
        } else {
            super.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.textFieldEditor != null) {
            return this.textFieldEditor.getFont();
        }
        return super.getFont();
    }

    public Font getCalendarFont() {
        JCalendar jc = this.getJCalendar();
        if (jc != null) {
            return jc.getFont();
        }
        return null;
    }

    public void setCalendarFont(Font f) {
        JCalendar jc = this.getJCalendar();
        if (jc != null) {
            jc.setFont(f);
            int prefHeight = this.textFieldEditor.getFontMetrics(f).getHeight() + 8;
            Dimension d = jc.getMonthChooser().getParent().getPreferredSize();
            d.height = prefHeight;
            jc.getMonthChooser().getParent().setPreferredSize(d);
        }
    }

    public void setDate(Date date) {
        DateEntryChangeListener tmp = this.changeListener;
        if (this.allowEmpty && this.textFieldEditor.getText().length() == 0) {
            this.changeListener = null;
        }
        this.oldDate = date;
        this.dateEntry.setDate(date);
        if (date != null) {
            this.dateEntry.getJCalendar().setDate(date);
            if (this.allowEmpty && this.textFieldEditor.getText().length() == 0) {
                this.textFieldEditor.setValue(date);
            }
        }
        String formatstr = this.dateEntry.getDateFormatString();
        if (date != null && formatstr != null && formatstr.length() > 0 && formatstr.indexOf(121) == -1 && formatstr.indexOf(89) == -1) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            this.dateEntry.getJCalendar().getYearChooser().setYear(calendar.get(1));
        }
        this.changeListener = tmp;
    }

    String getText() {
        return this.textFieldEditor.getText();
    }

    public Date getDate() {
        try {
            DateFormatter df;
            JFormattedTextField.AbstractFormatter formatter;
            String text = this.textFieldEditor.getText();
            if (this.allowEmpty && (text.length() == 0 || this.dateEntry.emptyMaskPattern != null && text.equals(this.dateEntry.emptyMaskPattern))) {
                DateEntryChangeListener tmp = this.changeListener;
                this.changeListener = null;
                this.dateEntry.setDate(null);
                this.changeListener = tmp;
                this.oldDate = null;
                return this.oldDate;
            }
            if (this.textFieldEditor.getFormatter() != null) {
                formatter = this.textFieldEditor.getFormatter();
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatString);
                sdf.setLenient(false);
                formatter = new DateFormatter(sdf);
            }
            if (formatter instanceof DateFormatter && (df = (DateFormatter)formatter).getFormat() instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)df.getFormat();
                if (!this.dateFormatString.equals(sdf.toPattern())) {
                    sdf = new SimpleDateFormat(this.dateFormatString);
                    sdf.setLenient(false);
                    df.setFormat(sdf);
                }
                if (this._2DigitsYearStartDate != null) {
                    sdf.set2DigitYearStart(this._2DigitsYearStartDate.getTime());
                }
            }
            try {
                this.oldDate = (Date)formatter.stringToValue(text);
            }
            catch (ParseException pe) {
                if (this.illegalDate != null) {
                    this.oldDate = this.illegalDate;
                }
                throw pe;
            }
            String formatstr = this.dateEntry.getDateFormatString();
            if (this.oldDate != null && formatstr != null && formatstr.length() > 0) {
                boolean adjusted = false;
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(this.oldDate);
                if (formatstr.indexOf(121) == -1 && formatstr.indexOf(89) == -1) {
                    calendar.set(1, this.dateEntry.getJCalendar().getYearChooser().getYear());
                    adjusted = true;
                }
                if (formatstr.indexOf(77) == -1) {
                    calendar.set(2, this.dateEntry.getJCalendar().getMonthChooser().getMonth());
                    adjusted = true;
                }
                if (formatstr.indexOf(100) == -1) {
                    calendar.set(5, this.dateEntry.getJCalendar().getDayChooser().getDay());
                    adjusted = true;
                }
                if (adjusted) {
                    return calendar.getTime();
                }
                return this.oldDate;
            }
            return this.oldDate;
        }
        catch (Exception ex) {
            if (this.oldDate != null) {
                return this.oldDate;
            }
            return this.dateEntry.getDate();
        }
    }

    public void setMaxSelectableDate(Date max) {
        this.dateEntry.setMaxSelectableDate(max);
    }

    public void setMinSelectableDate(Date min) {
        this.dateEntry.setMinSelectableDate(min);
    }

    public JButton getCalendarButton() {
        return this.dateEntry.getCalendarButton();
    }

    public JCheckBox getShowNoneButton() {
        return this.showNoneCheckBox;
    }

    public void setDateFormatString(String dfString) {
        this.dateFormatString = dfString;
        this.dateEntry.setDateFormatString(dfString);
    }

    protected void fireActionPerformedEvent() {
        this.dateEntry.intActionPerformed();
    }

    public void showPopup() {
        int x = this.dateEntry.getCalendarButton().getWidth() - (int)this.dateEntry.getPopup().getPreferredSize().getWidth();
        int y = this.dateEntry.getCalendarButton().getY() + this.dateEntry.getCalendarButton().getHeight();
        this.dateEntry.getPopup().show(this.dateEntry.getCalendarButton(), x, y);
        this.dateEntry.setDateSelected(false);
    }

    public void setIcon(ImageIcon icon) {
        this.dateEntry.setIcon(icon);
    }

    public void selectAll() {
        if (this.textFieldEditor != null && (!this.isShowNone() || this.showNoneCheckBox.isSelected())) {
            this.textFieldEditor.selectAll();
        }
    }

    @Override
    public void requestFocus() {
        if (this.isShowNone() && !this.showNoneCheckBox.isSelected()) {
            this.showNoneCheckBox.requestFocus();
        } else if (this.textFieldEditor != null) {
            this.textFieldEditor.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isShowNone() && !this.showNoneCheckBox.isSelected()) {
            return this.showNoneCheckBox.requestFocusInWindow();
        }
        if (this.textFieldEditor != null) {
            return this.textFieldEditor.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.addMouseListener(ml);
        }
        if (this.editor != null) {
            Component[] c = ((Container)this.editor).getComponents();
            for (int i = 0; i < c.length; ++i) {
                c[i].addMouseListener(ml);
            }
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.addMouseListener(ml);
        }
        this.getCalendarButton().addMouseListener(ml);
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.removeMouseListener(ml);
        }
        if (this.editor != null) {
            Component[] c = ((Container)this.editor).getComponents();
            for (int i = 0; i < c.length; ++i) {
                c[i].removeMouseListener(ml);
            }
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.removeMouseListener(ml);
        }
        this.getCalendarButton().removeMouseListener(ml);
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, kl);
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, kl);
    }

    @Override
    public void setBackground(Color c) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBackground(c);
            this.showNoneCheckBox.setBackground(c);
        } else {
            super.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setForeground(c);
            this.showNoneCheckBox.setForeground(c);
        } else {
            super.setForeground(c);
        }
    }

    @Override
    public void setToolTipText(String ttt) {
        if (this.editor != null) {
            ((JComponent)this.editor).setToolTipText(ttt);
        }
    }

    public void setShowNone(boolean b) {
        if (this.showNone != b) {
            this.showNone = b;
            if (this.showNone) {
                this.add((Component)this.showNonePanel, "West");
            } else {
                this.remove(this.showNonePanel);
            }
        }
    }

    public boolean isShowNone() {
        return this.showNone;
    }

    public boolean isShowNoneChecked() {
        return !this.isShowNone() || this.showNoneCheckBox.isSelected();
    }

    public void setShowNoneChecked(boolean b) {
        if (this.isShowNone()) {
            this.showNoneCheckBox.setSelected(b);
            this.intSetShowNoneChecked(b);
        }
    }

    private void intSetShowNoneChecked(boolean newVal) {
        this.showNoneCheckBox.setFocusable(!newVal);
        ((JComponent)this.editor).setEnabled(newVal && this.dateEntry.isEnabled());
        boolean found = false;
        for (KeyListener kl : this.showNoneCheckBox.getKeyListeners()) {
            if (kl != this.keyListenerProxy) continue;
            found = true;
            break;
        }
        if (newVal) {
            if (found) {
                this.showNoneCheckBox.removeKeyListener(this.keyListenerProxy);
            }
        } else if (!found) {
            this.showNoneCheckBox.addKeyListener(this.keyListenerProxy);
        }
        if (!newVal && this.textFieldEditor.isFocusOwner()) {
            this.showNoneCheckBox.requestFocus();
        } else if (newVal && this.showNoneCheckBox.isFocusOwner()) {
            this.textFieldEditor.requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        if (this.dateEntry != null) {
            this.dateEntry.setEnabled(en);
        }
        if (this.showNoneCheckBox != null) {
            this.showNoneCheckBox.setEnabled(en);
        }
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setEnabled(en);
            this.textFieldEditor.setFocusable(en);
        }
        ((JComponent)this.editor).setEnabled(en && (!this.isShowNone() || this.showNoneCheckBox.isSelected()));
    }

    protected void handleCalendarButtonMouseReleased(MouseEvent evt) {
    }

    protected void handleCalendarButtonMouseClicked(MouseEvent evt) {
    }

    protected void handleCalendarButtonMousePressed() {
        if (this.dateEntry.isEnabled()) {
            if (this.deListener != null) {
                try {
                    this.deListener.popupWillBecameVisible(new DateEntryEvent(this));
                    this.dateEntry.intActionPerformed();
                }
                catch (DateEntryVetoException dateEntryVetoException) {}
            } else {
                this.showPopup();
            }
        }
    }

    protected boolean handleSetValue(Date val) {
        Date d = val;
        if (this.oldDate == null || !this.oldDate.equals(d)) {
            if (this.deListener != null) {
                try {
                    this.deListener.stateWillChange(new DateEntryEvent(this, d));
                    return false;
                }
                catch (DateEntryVetoException ex) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        if (allowEmpty != this.allowEmpty) {
            this.intSetAllowEmpty(allowEmpty);
        }
    }

    private void intSetAllowEmpty(boolean allowEmpty) {
        block4: {
            block3: {
                this.allowEmpty = allowEmpty;
                if (this.allowEmpty) break block3;
                if (this.dayListener == null) {
                    this.dayListener = e -> this.textFieldEditor.setValue(this.dateEntry.getDate());
                }
                for (Component c : this.dateEntry.getJCalendar().getDayChooser().getDayPanel().getComponents()) {
                    if (!(c instanceof JButton)) continue;
                    ((JButton)c).addActionListener(this.dayListener);
                }
                break block4;
            }
            if (this.dayListener == null) break block4;
            for (Component c : this.dateEntry.getJCalendar().getDayChooser().getDayPanel().getComponents()) {
                if (!(c instanceof JButton)) continue;
                ((JButton)c).removeActionListener(this.dayListener);
            }
        }
    }

    protected String getEmptyMaskPattern() {
        return this.dateEntry.emptyMaskPattern;
    }

    public int get2DigitsYearStart() {
        return this._2DigitsYearStartDate != null ? this._2DigitsYearStartDate.get(1) : -1;
    }

    public void set2DigitsYearStart(int year) {
        if (year >= 0) {
            if (year >= 100) {
                year %= 100;
            }
            this._2DigitsYearStartDate = Calendar.getInstance();
            this._2DigitsYearStartDate.clear();
            this._2DigitsYearStartDate.set(5, 31);
            this._2DigitsYearStartDate.set(2, 11);
            this._2DigitsYearStartDate.set(11, 23);
            this._2DigitsYearStartDate.set(12, 59);
            this._2DigitsYearStartDate.set(13, 59);
            this._2DigitsYearStartDate.set(1, 1900 + year);
        } else {
            this._2DigitsYearStartDate = null;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.textFieldEditor != null && this.readOnly != readOnly) {
            this.readOnly = readOnly;
            this.textFieldEditor.setEditable(!readOnly);
            if (this.readOnly) {
                this.textFieldEditor.addFocusListener(this.focusListener);
            } else {
                this.textFieldEditor.removeFocusListener(this.focusListener);
            }
        }
    }

    @Override
    public void setName(String s) {
        this.name = s;
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setName(this.name);
        }
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean b) {
        if (this.defaultShortcutsEnabled != b) {
            this.defaultShortcutsEnabled = b;
            if (!this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.textFieldEditor.getKeymap());
            }
        }
    }

    public void setBorderW(Border b) {
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBorder(null);
        }
        if (this.style == 0 && this.editor != null) {
            ((JSpinnerDateEditor)this.editor).setBorder(null);
        }
        if (this.showNonePanel != null) {
            this.showNonePanel.setBorder(null);
        }
        if (this.dateEntry != null) {
            this.dateEntry.setBorder(null);
        }
        if (this.textFieldEditor != null) {
            this.textFieldEditor.setBorder(b);
        }
        super.setBorder(null);
    }

    public Date getIllegalDate() {
        return this.illegalDate;
    }

    public void setIllegalDate(Date illegalDate) {
        this.illegalDate = illegalDate;
    }

    public JComponent getDragDropComponent() {
        return this.textFieldEditor;
    }

    public void setDragComponent(OutDragListener odlistener) {
        if (this.textFieldEditor != null) {
            if (odlistener != null) {
                this.textFieldEditor.setDropMode(DropMode.INSERT);
                this.textFieldEditor.setDragEnabled(true);
                this.ftth = new FromToTransferHandler(odlistener, 1);
                this.textFieldEditor.setTransferHandler(this.ftth);
            } else {
                this.textFieldEditor.setDragEnabled(false);
                if (this.ftth != null) {
                    this.textFieldEditor.setTransferHandler(null);
                }
            }
        }
    }

    private static class MyJSpinnerDateEditor
    extends JSpinnerDateEditor {
        private static final long serialVersionUID = 1L;
        DateEntry de;

        private MyJSpinnerDateEditor() {
        }

        public void setValue(Object val) {
            if (this.de != null) {
                if (!this.de.handleSetValue((Date)val)) {
                    super.setValue(val);
                }
            } else {
                super.setValue(val);
            }
        }
    }

    private static class MyDateEntry
    extends JDateChooser {
        private static final long serialVersionUID = 1L;
        private String emptyMaskPattern;

        public MyDateEntry(IDateEditor editor) {
            super(editor);
            this.setDate(null);
        }

        public MyDateEntry(DateEntry de, String datePattern, String maskPattern, char placeHolder) {
            super(null, null, datePattern, (IDateEditor)new MyTextFieldDateEditor(de, datePattern, maskPattern, placeHolder));
            this.emptyMaskPattern = IsguiUtility.createMaskFromDatePattern(datePattern, placeHolder, false);
            this.setDate(null);
        }

        JPopupMenu getPopup() {
            return this.popup;
        }

        void setDateSelected(boolean b) {
            this.dateSelected = b;
        }

        public void actionPerformed(ActionEvent e) {
        }

        void intActionPerformed() {
            super.actionPerformed(null);
        }

        public JCalendar getJCalendar() {
            return this.jcalendar;
        }
    }

    private static class MyTextFieldDateEditor
    extends JTextFieldDateEditor {
        private static final long serialVersionUID = 1L;
        private DateEntry thisDateEntry;

        MyTextFieldDateEditor(DateEntry de, String datePattern, String maskPattern, char placeHolder) {
            super(datePattern, maskPattern, placeHolder);
            this.thisDateEntry = de;
        }

        public Color getBackground() {
            if (!this.isEnabled() && this.thisDateEntry != null && this.thisDateEntry.disabledBackground != null) {
                return this.thisDateEntry.disabledBackground;
            }
            return super.getBackground();
        }
    }
}

