/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.Filterable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class FilterableTreeViewNode
implements TreeNode {
    private FilterableTreeViewNode parent;
    protected FilterableTreeViewNode root;
    private Vector<FilterableTreeViewNode> children = new Vector();
    private Vector<FilterableTreeViewNode> filteredChildren;
    private String lastFilterString;
    private boolean lastFilterCS;
    protected boolean expanded;

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    private Vector<FilterableTreeViewNode> getChildrenVector(boolean filter) {
        String fs;
        Filterable f = (Filterable)((Object)this.root);
        if (filter && f != null && f.isFilterItems() && (fs = f.getFilterString()) != null && fs.length() > 0) {
            if (this.filteredChildren == null || !fs.equals(this.lastFilterString) || this.lastFilterCS != f.isFilterCaseSensitive()) {
                this.filteredChildren = new Vector();
                if (!f.isFilterCaseSensitive()) {
                    fs = fs.toLowerCase();
                }
                for (FilterableTreeViewNode n : this.children) {
                    Vector<FilterableTreeViewNode> v = n.getChildrenVector(true);
                    if (!v.isEmpty() || this.accept(n, fs, f.isFilterCaseSensitive())) {
                        this.filteredChildren.addElement(n);
                        continue;
                    }
                    n.setExpanded(false);
                }
                if (this.filteredChildren.isEmpty()) {
                    this.setExpanded(false);
                }
            }
            this.lastFilterString = fs;
            this.lastFilterCS = f.isFilterCaseSensitive();
            return this.filteredChildren;
        }
        this.resetFilteredChildren();
        return this.children;
    }

    protected abstract boolean accept(FilterableTreeViewNode var1, String var2, boolean var3);

    public void setExpanded(boolean e) {
        this.expanded = e;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildAt(childIndex, true);
    }

    public TreeNode getChildAt(int childIndex, boolean filter) {
        Vector<FilterableTreeViewNode> v = this.getChildrenVector(filter);
        int count = v.size();
        return childIndex < count ? (TreeNode)v.elementAt(childIndex) : null;
    }

    @Override
    public int getChildCount() {
        return this.getChildCount(true);
    }

    public int getChildCount(boolean filter) {
        return this.getChildrenVector(filter).size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public FilterableTreeViewNode getRoot() {
        return this.root;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getIndex(node, true);
    }

    public int getIndex(TreeNode node, boolean filter) {
        return this.getChildrenVector(filter).indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    public Enumeration<FilterableTreeViewNode> children() {
        return this.getChildrenVector(true).elements();
    }

    public Enumeration<FilterableTreeViewNode> children(boolean filter) {
        return this.getChildrenVector(filter).elements();
    }

    public FilterableTreeViewNode[] getPath() {
        Vector<FilterableTreeViewNode> v = new Vector<FilterableTreeViewNode>();
        FilterableTreeViewNode n = this;
        while (n != null) {
            v.add(0, n);
            n = n.parent;
        }
        return v.toArray(new FilterableTreeViewNode[v.size()]);
    }

    public void removeAllChildren() {
        while (!this.children.isEmpty()) {
            FilterableTreeViewNode n = this.children.elementAt(0);
            n.parent = null;
            n.root = null;
            this.children.removeElementAt(0);
        }
        this.resetFilteredChildren();
    }

    private void resetFilteredChildren() {
        this.lastFilterString = null;
        this.lastFilterCS = false;
        if (this.filteredChildren != null) {
            this.filteredChildren.clear();
            this.filteredChildren = null;
        }
    }

    public FilterableTreeViewNode getFirstChild() {
        return (FilterableTreeViewNode)this.getChildAt(0);
    }

    public FilterableTreeViewNode getLastChild() {
        return this.getLastChild(true);
    }

    public FilterableTreeViewNode getLastChild(boolean filter) {
        Vector<FilterableTreeViewNode> v = this.getChildrenVector(filter);
        int count = v.size();
        return count > 0 ? v.elementAt(count - 1) : null;
    }

    public FilterableTreeViewNode getNextSibling() {
        return this.getNextSibling(true);
    }

    public FilterableTreeViewNode getNextSibling(boolean filter) {
        Vector<FilterableTreeViewNode> v;
        int idx;
        if (this.parent != null && (idx = (v = this.parent.getChildrenVector(filter)).indexOf(this)) >= 0 && idx < v.size() - 1) {
            return v.elementAt(idx + 1);
        }
        return null;
    }

    public FilterableTreeViewNode getPreviousSibling() {
        return this.getPreviousSibling(true);
    }

    public FilterableTreeViewNode getPreviousSibling(boolean filter) {
        Vector<FilterableTreeViewNode> v;
        int idx;
        if (this.parent != null && (idx = (v = this.parent.getChildrenVector(filter)).indexOf(this)) > 0) {
            return v.elementAt(idx - 1);
        }
        return null;
    }

    public void add(FilterableTreeViewNode n) {
        if (n.parent != null) {
            n.parent.remove(n);
        }
        n.parent = this;
        n.root = this.root;
        this.children.addElement(n);
        this.resetFilteredChildren();
    }

    public void insert(FilterableTreeViewNode n, int idx) {
        if (n.parent != null) {
            n.parent.remove(n);
        }
        n.parent = this;
        n.root = this.root;
        if (idx < this.children.size()) {
            this.children.add(idx, n);
        } else {
            this.children.addElement(n);
        }
        this.resetFilteredChildren();
    }

    public void remove(FilterableTreeViewNode n) {
        n.parent = null;
        n.root = null;
        this.children.removeElement(n);
        this.resetFilteredChildren();
    }
}

