/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MyToolBar;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.gui.client.swing.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class RemoteDisplayToolBar
extends RemoteBaseGUIWindow
implements Constants {
    public MyToolBar toolPanel;
    protected float cellWidth = 1.0f;
    protected float cellHeight = 1.0f;
    protected int fontId = -1;
    protected LocalFontCmp font;
    private int toolHeight;
    private int foregroundIndex = -1;
    private int backgroundIndex = -1;
    private String tooltipText;
    private int parentWindowId;
    private RemoteDisplayWindow parentWindow;
    private PopupListener popupListener;
    private RemoteMenu popupMenu;
    private boolean multilineStyle;
    private final boolean nativeToolBar;

    public RemoteDisplayToolBar(Events evs, GuiFactoryImpl gf, int pwId) {
        this(evs, gf, pwId, false);
    }

    public RemoteDisplayToolBar(Events evs, GuiFactoryImpl gf, int pwId, boolean ribboncontainer) {
        super(gf);
        this.parentWindowId = pwId;
        this.parentWindow = (RemoteDisplayWindow)gf.getClient().getId(this.parentWindowId);
        this.events = evs;
        this.nativeToolBar = gf.getCsProperty().get("iscobol.gui.tool_bar.native", true);
        this.toolPanel = this.createToolBar(ribboncontainer);
        if (this.toolPanel instanceof JToolBar) {
            JToolBar jtb = (JToolBar)((Object)this.toolPanel);
            jtb.setFloatable(false);
            jtb.setRollover(true);
        }
    }

    private MyToolBar createToolBar(boolean ribboncontainer) {
        JComponent tb = this.nativeToolBar ? new NativeToolBar(ribboncontainer){

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(0, y, RemoteDisplayToolBar.this.parentWindow != null && RemoteDisplayToolBar.this.parentWindow.getMainWindow() != null && RemoteDisplayToolBar.this.parentWindow.getMainWindow().getSize() != null && ((RemoteDisplayToolBar)RemoteDisplayToolBar.this).parentWindow.getMainWindow().getSize().width > 0 ? ((RemoteDisplayToolBar)RemoteDisplayToolBar.this).parentWindow.getMainWindow().getSize().width : w, RemoteDisplayToolBar.this.toolHeight > 0 ? RemoteDisplayToolBar.this.toolHeight : h);
            }
        } : new PanelToolBar(ribboncontainer){

            @Override
            public void setBounds(int x, int y, int w, int h) {
                super.setBounds(0, y, RemoteDisplayToolBar.this.parentWindow != null && RemoteDisplayToolBar.this.parentWindow.getMainWindow() != null && RemoteDisplayToolBar.this.parentWindow.getMainWindow().getSize() != null && ((RemoteDisplayToolBar)RemoteDisplayToolBar.this).parentWindow.getMainWindow().getSize().width > 0 ? ((RemoteDisplayToolBar)RemoteDisplayToolBar.this).parentWindow.getMainWindow().getSize().width : w, RemoteDisplayToolBar.this.toolHeight > 0 ? RemoteDisplayToolBar.this.toolHeight : h);
            }
        };
        return tb;
    }

    public MyToolBar getMainPanel() {
        return this.toolPanel;
    }

    @Override
    public int setFont(String name, int style, int size) {
        if (this.font != null && LocalFontCmp.equals(this.font, name, style, size)) {
            return this.fontId;
        }
        this.font = new SwingFontCmp(this.gf, name, style, (float)size, false);
        this.fontId = this.gf.getClient().setId(this.font);
        this.setCellWidth(this.font.getWidth());
        this.setCellHeight(this.font.getHeight());
        if (this.toolPanel != null) {
            this.toolPanel.setFont(this.font.getFont());
        }
        return this.fontId;
    }

    @Override
    public void setFont(int fi) {
        LocalFontCmp tmpfont = (LocalFontCmp)this.gf.getClient().getId(fi);
        if (this.font != null && this.font.equals(tmpfont)) {
            return;
        }
        this.fontId = fi;
        this.font = tmpfont;
        this.setCellWidth(this.font.getWidth());
        this.setCellHeight(this.font.getHeight());
        if (this.toolPanel != null) {
            this.toolPanel.setFont(this.font.getFont());
        }
    }

    @Override
    public void setSize(float cols, float lines) {
        this.toolHeight = (int)(lines * (float)this.getCellHeight());
    }

    @Override
    public void add(int controlID, int index, RemoteBaseGUIControl uponCtrl) {
        RemoteBaseGUIControl comp = (RemoteBaseGUIControl)this.gf.getClient().getId(controlID);
        if (this.toolPanel != null && comp != null && comp.getComponent() != null) {
            comp.setParentToolbar(this);
            if (comp.isContainer()) {
                this.setStyle(302);
            }
            if (uponCtrl == null || !uponCtrl.isContainer()) {
                comp.setLocation(comp.getBounds().x, comp.getBounds().y);
                if (index >= 0 && index < this.toolPanel.getComponentCount()) {
                    this.toolPanel.add((Component)((Object)comp.getComponent()), index);
                } else {
                    this.toolPanel.add((Component)((Object)comp.getComponent()));
                }
                if (comp.isContainer()) {
                    this.parentWindow.addtolayout(comp);
                } else if (this.getLayout() != null) {
                    this.addtolayout(comp);
                }
            } else {
                comp.setLocation(comp.getBounds().x, comp.getBounds().y);
                uponCtrl.add(comp, index, this.childGraphics);
                this.parentWindow.addtolayout(comp);
            }
            this.childGraphics.put(comp.getComponent(), comp);
        }
    }

    @Override
    public void add(int controlID, RemoteBaseGUIControl uponCtrl) {
        this.add(controlID, -1, uponCtrl);
    }

    @Override
    public void remove(int controlID) {
        this.remove(controlID, true);
    }

    @Override
    public void remove(int controlID, boolean wait) {
        RemoteBaseGUIControl comp = (RemoteBaseGUIControl)this.gf.getClient().getId(controlID);
        if (this.toolPanel != null && comp != null && comp.getComponent() != null) {
            final Component c = (Component)((Object)comp.getComponent());
            if (wait) {
                new SwingWorker(true){

                    @Override
                    public void launch() {
                        RemoteDisplayToolBar.this.toolPanel.remove(c);
                        RemoteDisplayToolBar.this.childGraphics.remove(c);
                    }
                }.start();
            } else {
                this.toolPanel.remove(c);
                this.childGraphics.remove(c);
            }
        }
    }

    @Override
    public void setBackground(int r, int b, int g) {
        if (this.toolPanel != null) {
            Color newC = new Color(r, g, b);
            this.toolPanel.setBackground(newC);
        }
    }

    @Override
    public void setBackgroundIdx(int idx) {
        Color newC;
        if (this.toolPanel != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.backgroundIndex = idx;
            this.toolPanel.setBackground(newC);
        }
    }

    @Override
    public void setForeground(int r, int b, int g) {
        if (this.toolPanel != null) {
            Color newC = new Color(r, g, b);
            this.toolPanel.setForeground(newC);
        }
    }

    @Override
    public void setForegroundIdx(int idx) {
        Color newC;
        if (this.toolPanel != null && (newC = this.gf.getRemotePalette().getDefaultColor(idx)) != null) {
            this.foregroundIndex = idx;
            this.toolPanel.setForeground(newC);
        }
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public int getCellHeight() {
        if (this.cellHeight < 1.0f) {
            return 1;
        }
        return (int)this.cellHeight;
    }

    @Override
    public float getCellHeightF() {
        return this.cellHeight;
    }

    @Override
    public int getCellWidth() {
        if (this.cellWidth < 1.0f) {
            return 1;
        }
        return (int)this.cellWidth;
    }

    @Override
    public float getCellWidthF() {
        return this.cellWidth;
    }

    @Override
    public void setCellHeight(float ch) {
        if (ch >= 1.0f) {
            this.cellHeight = ch;
        }
    }

    @Override
    public void setCellWidth(float cw) {
        if (cw >= 1.0f) {
            this.cellWidth = cw;
        }
    }

    @Override
    public void setCellWidth(String fontName, int fontStyle, int fontSize) {
        this.cellWidth = new SwingFontCmp(this.gf, fontName, fontStyle, (float)fontSize, false).getWidth();
    }

    @Override
    public void setCellHeight(String fontName, int fontStyle, int fontSize) {
        this.cellHeight = new SwingFontCmp(this.gf, fontName, fontStyle, (float)fontSize, false).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.childGraphics != null) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                Enumeration ctlLI = this.childGraphics.elements();
                while (ctlLI.hasMoreElements()) {
                    RemoteBaseGUIControl ctl = (RemoteBaseGUIControl)ctlLI.nextElement();
                    ctl.destroy();
                }
            }
            this.childGraphics = null;
        }
        if (this.toolPanel != null && this.popupListener != null) {
            this.toolPanel.removeMouseListener(this.popupListener);
        }
        this.gf.getClient().delId(this.terminalDisplayGateId);
        if (this.gf != null && this.gf.getClient() != null) {
            this.gf.getClient().delId(this.theObject);
        }
        this.theObject = 0;
        this.superdestroy();
        this.events = null;
        this.parentWindow = null;
        this.popupMenu = null;
        this.popupListener = null;
        this.toolPanel = null;
        this.destroyed = true;
    }

    @Override
    public Color getBackground() {
        if (this.toolPanel != null) {
            return this.toolPanel.getBackground();
        }
        return null;
    }

    @Override
    public int getBackgroundIdx() {
        return this.backgroundIndex;
    }

    @Override
    public Rectangle getMainBounds() {
        if (this.parentWindow != null) {
            Point parentLoc = this.parentWindow.getMainWindow().getPanel().getLocationOnScreen();
            Point loc = this.toolPanel.getLocationOnScreen();
            return new Rectangle(loc.x - parentLoc.x, loc.y - parentLoc.y, this.parentWindow.getBounds().width, this.toolHeight);
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.toolPanel != null) {
            return this.toolPanel.getBounds(null);
        }
        return null;
    }

    @Override
    public boolean getBoxed() {
        return false;
    }

    @Override
    public int getFont() {
        return this.fontId;
    }

    @Override
    public Color getForeground() {
        if (this.toolPanel != null) {
            return this.toolPanel.getForeground();
        }
        return null;
    }

    @Override
    public int getForegroundIdx() {
        return this.foregroundIndex;
    }

    @Override
    public Insets getInsets() {
        return null;
    }

    public int getMenu() {
        return 0;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean getWrap() {
        return false;
    }

    @Override
    public boolean isGraphical() {
        return true;
    }

    @Override
    public boolean isMainApplicationWindow() {
        return false;
    }

    @Override
    public void setActiveWindow(boolean b) {
    }

    @Override
    public void setAutoResize(boolean f) {
    }

    @Override
    public void setDefaultLocation(int ownerWindowID) {
    }

    public void setMaxHeight(int mh) {
    }

    @Override
    public void setMaxLines(int maxLines) {
    }

    @Override
    public void setMaxSize(int maxSize) {
    }

    public void setMaxWidth(int mw) {
    }

    public void setMinHeight(int mh) {
    }

    @Override
    public void setMinLines(int minLines) {
    }

    @Override
    public void setMinSize(int minSize) {
    }

    public void setMinWidth(int mw) {
    }

    public void setOffsetToolbar(int ot) {
    }

    @Override
    public void setPopupArea() {
    }

    @Override
    public void setResizable(boolean r) {
    }

    @Override
    public void setScroll(boolean s) {
    }

    @Override
    public void setTitle(String t) {
    }

    @Override
    public void setTitlePosition(int t) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean b) {
        if (this.toolPanel != null) {
            this.toolPanel.setEnabled(b);
            if (this.childGraphics != null) {
                Hashtable hashtable = this.childGraphics;
                synchronized (hashtable) {
                    Enumeration ctlLI = this.childGraphics.elements();
                    while (ctlLI.hasMoreElements()) {
                        RemoteBaseGUIControl ctl = (RemoteBaseGUIControl)ctlLI.nextElement();
                        ctl.guiComponentsetEnabled();
                    }
                }
            }
        }
    }

    @Override
    public void setWithSystemMenu(boolean b) {
    }

    @Override
    public void toFront() {
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public boolean isInitialized() {
        return this.toolPanel != null;
    }

    public int getToolBarHeight() {
        return this.toolHeight;
    }

    @Override
    public void setAction(float cv) {
        switch ((int)cv) {
            case 21: {
                break;
            }
            case 20: {
                break;
            }
            case 22: {
                break;
            }
        }
    }

    @Override
    public void setTitleBar(boolean b) {
    }

    @Override
    public void setToolTipText(String ttt) {
        this.tooltipText = ScreenUtility.rightTrim(ttt);
        this.toolPanel.setToolTipText(this.tooltipText.length() > 0 ? this.tooltipText : null);
    }

    @Override
    public void setPopupMenu(RemoteMenu pm) {
        if (this.popupMenu != null) {
            this.popupMenu.setParentWindow(-1);
        }
        if (this.popupListener != null) {
            this.toolPanel.removeMouseListener(this.popupListener);
        }
        this.popupMenu = pm;
        if (this.popupMenu != null) {
            this.popupMenu.setParentWindow(this.parentWindow.getId());
            this.popupListener = new PopupListener(this, this.popupMenu);
            this.toolPanel.addMouseListener(this.popupListener);
        } else {
            this.popupListener = null;
        }
    }

    public int getParentWindowId() {
        return this.parentWindowId;
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation pwl) {
    }

    @Override
    public void setStyle(int s) {
        switch (s) {
            case 154: {
                if (!(this.toolPanel instanceof JToolBar)) break;
                ((JToolBar)((Object)this.toolPanel)).setFloatable(true);
                break;
            }
            case 302: {
                this.multilineStyle = true;
            }
        }
    }

    @Override
    public void unsetStyle(int s) {
        switch (s) {
            case 154: {
                if (!(this.toolPanel instanceof JToolBar)) break;
                ((JToolBar)((Object)this.toolPanel)).setFloatable(false);
                break;
            }
            case 302: {
                this.multilineStyle = false;
            }
        }
    }

    public boolean isMultiline() {
        return this.multilineStyle;
    }

    @Override
    public int[] componentgetControlSamePosition(RemoteBaseGUIControl rbgc) {
        return this.getControlSamePosition(rbgc, (Container)((Object)this.toolPanel));
    }

    @Override
    public int[] componentsetErase(int flgerase, int col, int row, Color bgColor, int[] fieldsid) {
        return this.setErase((Container)((Object)this.toolPanel), flgerase, col, row, bgColor, fieldsid);
    }

    @Override
    public void setParentWindow(RemoteBaseGUIControl rbgc, int idw) {
        rbgc.setParentToolbar(this);
        rbgc.setParentWindow(this.parentWindowId);
    }

    @Override
    public void setParentWindow(RemoteBaseGUIControl rbgc) {
        rbgc.setParentToolbar(this);
        rbgc.setParentWindow(this.parentWindowId);
    }

    @Override
    protected void repaintTerminal(Component cc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Integer srvheadid) {
        if (this.childGraphics != null && this.childGraphics.contains(srvheadid)) {
            Hashtable hashtable = this.childGraphics;
            synchronized (hashtable) {
                this.childGraphics.remove(srvheadid);
            }
        }
    }

    @Override
    public void addMnemonic(char c, RemoteBaseGUIControl comp) {
        if (this.parentWindow != null) {
            this.parentWindow.addMnemonic(c, comp);
        }
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl comp) {
        if (this.parentWindow != null) {
            this.parentWindow.removeMnemonic(comp);
        }
    }

    @Override
    public boolean enableKeyboard() {
        boolean Return2 = true;
        if (this.parentWindow != null) {
            Return2 = this.parentWindow.enableKeyboard();
        }
        return Return2;
    }

    @Override
    protected Container getPanel() {
        return (Container)((Object)this.toolPanel);
    }

    public RemoteDisplayWindow getParentWindowDT() {
        return this.parentWindow;
    }

    public void setId(int wId) {
        this.theObject = wId;
    }

    public int getId() {
        return this.theObject;
    }

    public boolean isEnabledToolPanel() {
        if (this.toolPanel != null) {
            return this.toolPanel.isEnabled();
        }
        return false;
    }

    private class NativeToolBar
    extends JToolBar
    implements MyToolBar {
        private static final long serialVersionUID = 1L;
        private final boolean ribbonContainer;

        NativeToolBar(boolean rc) {
            this.ribbonContainer = rc;
            if (!this.ribbonContainer) {
                super.setLayout(null);
            }
        }

        @Override
        public void updateUI() {
            LayoutManager lm = super.getLayout();
            super.updateUI();
            super.setLayout(lm);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.ribbonContainer) {
                return super.getPreferredSize();
            }
            return this.getSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            RemoteDisplayToolBar.this.gradientMgr.paint((Graphics2D)g, new Rectangle(0, 1, this.getWidth(), this.getHeight() - 2));
            if (!this.ribbonContainer) {
                g.setColor(Color.black);
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private class PanelToolBar
    extends JPanel
    implements MyToolBar {
        private static final long serialVersionUID = 1L;
        private final boolean ribbonContainer;

        PanelToolBar(boolean rc) {
            this.ribbonContainer = rc;
            if (!this.ribbonContainer) {
                super.setLayout(null);
            }
            RemoteDisplayToolBar.this.gradientMgr.addPropertyChangeListener(e -> this.repaint());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.ribbonContainer) {
                return super.getPreferredSize();
            }
            return this.getSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            RemoteDisplayToolBar.this.gradientMgr.paint((Graphics2D)g, new Rectangle(0, 1, this.getWidth(), this.getHeight() - 2));
            if (!this.ribbonContainer) {
                g.setColor(Color.black);
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

