/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.BaseRemoteObject;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingFontCmp;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RemoteMessageBox
extends RemoteBaseGUIWindow
implements Constants,
ActionListener,
WindowListener,
KeyListener,
BaseRemoteObject {
    public static final int ALERT_ASTERISK = 0;
    public static final int ALERT_EXCLAMATION = 1;
    public static final int ALERT_HAND = 2;
    public static final int ALERT_QUESTION = 3;
    public static final int ALERT_DEFAULT = 4;
    private static int defaultFontSize = 12;
    private static int MIN_BUTTON_WIDTH = 77;
    int CENTER = 1;
    LocalFontCmp font;
    JDialog msgbox = null;
    JPanel buttonPanel = new JPanel();
    int Return = 0;
    Image imageCanvas = null;
    private final int type;
    RemoteDisplayWindow parentWindow;
    static JFrame defaultJFrame = new JFrame();
    private Color cBack;
    private Color cFore;
    private Integer configBcolor;
    private Integer configFcolor;
    private String configFont;
    private Hashtable attrs;
    private ArrayList buttonList = new ArrayList();
    private PicobolTimer pTimer;
    private int alertlevel = 4;
    private JButton defButton = null;

    public RemoteMessageBox(GuiFactoryImpl gf, Events evt, int wId, int fontId, String text, String title, int type, int icon, int btnDefault, int backidx, int foreidx, long timeout, String[] attributes) {
        super(gf);
        this.type = type;
        this.events = evt;
        this.parentWindow = (RemoteDisplayWindow)gf.getClient().getId(wId);
        boolean centered = false;
        if (attributes != null && attributes.length > 0) {
            for (int i = 0; i < attributes.length; ++i) {
                centered = attributes[i].equalsIgnoreCase("CENTERED");
            }
        }
        if (!centered) {
            try {
                centered = gf.getCsProperty().get("iscobol.gui.messagebox.centered", false);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        title = title != null ? ScreenUtility.rightTrim(title) : gf.getMessages().getMessage("Error");
        boolean multilines = false;
        String newline = System.getProperty("line.separator");
        boolean bl = multilines = text != null && text.indexOf(newline) > 0;
        if (newline.length() == 2 && !multilines) {
            boolean bl2 = multilines = text != null && text.indexOf(10) > 0;
        }
        if (fontId >= 0) {
            this.font = (LocalFontCmp)gf.getClient().getId(fontId);
        } else {
            this.font = (LocalFontCmp)gf.getClient().getId(fontId * -1);
            try {
                this.configFont = gf.getCsProperty().get("iscobol.gui.messagebox.font", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.configFont != null) {
                this.font = this.myGetFont(this.configFont, this.font.getFont().getName(), this.font.getFont().getStyle(), this.font.getFont().getSize());
            }
        }
        BorderedFrame parWin = null;
        if (this.parentWindow != null && (parWin = this.parentWindow.getMainWindow()) != null && parWin.isNotification()) {
            parWin = parWin.getNotificationOwner();
        }
        if (backidx == -1) {
            try {
                this.configBcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.messagebox.bcolor", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.configBcolor != null) {
                backidx = this.configBcolor;
            }
        }
        if (backidx != -1) {
            this.cBack = gf.getRemotePalette().getDefaultColor(backidx);
        }
        if (foreidx == -1) {
            try {
                this.configFcolor = Integer.valueOf(gf.getCsProperty().get("iscobol.gui.messagebox.fcolor", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.configFcolor != null) {
                foreidx = this.configFcolor;
            }
        }
        if (foreidx != -1) {
            this.cFore = gf.getRemotePalette().getDefaultColor(foreidx);
        }
        if (Client.isWebClient()) {
            BorderedFrame f_parWin = parWin;
            String f_title = title;
            boolean f_multilines = multilines;
            boolean f_centered = centered;
            new IsguiWorker(false, () -> this.init(f_parWin, f_title, text, icon, btnDefault, f_multilines, f_centered, timeout)).start();
        } else {
            this.init(parWin, title, text, icon, btnDefault, multilines, centered, timeout);
        }
    }

    private void init(BorderedFrame parWin, String title, String text, int icon, int btnDefault, boolean multilines, boolean centered, long timeout) {
        if (parWin != null) {
            parWin.setEnabled(true);
            if (parWin.isJFrame()) {
                this.msgbox = new JDialog((Frame)parWin.getJFrame(), title);
            } else if (parWin.isJDialog()) {
                this.msgbox = new JDialog((Dialog)parWin.getJDialog(), title);
            } else if (parWin.isDockable()) {
                this.msgbox = new JDialog(parWin.getDockable().getRootWindow(), title);
            } else if (parWin.isMDIChild()) {
                this.msgbox = new JDialog(parWin.getMyWindow().getRootWindow(), title);
            }
        } else {
            this.msgbox = new JDialog((Frame)defaultJFrame, title);
        }
        if (this.gf != null && this.gf.getCsProperty().get("iscobol.gui.windows_modality", true) && this.msgbox.getToolkit().isModalityTypeSupported(Dialog.ModalityType.DOCUMENT_MODAL)) {
            this.msgbox.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        } else {
            this.msgbox.setModal(true);
        }
        ScreenUtility.disableFocusTraversalKeys(this.msgbox);
        this.msgbox.setDefaultCloseOperation(0);
        this.msgbox.addWindowListener(this);
        this.msgbox.addKeyListener(this);
        this.msgbox.getContentPane().setLayout(new BorderLayout(5, 5));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 10, 8, 7));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        boolean isQuestionBox = false;
        JButton button1 = null;
        JButton button2 = null;
        JButton button3 = null;
        switch (this.type) {
            default: {
                this.defButton = button1 = this.addButton("ok");
                this.buttonList.add(button1);
                break;
            }
            case 2: {
                button1 = this.addButton("yes");
                this.buttonList.add(button1);
                button2 = this.addButton("no");
                this.buttonList.add(button2);
                this.defButton = btnDefault == 2 ? button2 : button1;
                isQuestionBox = true;
                break;
            }
            case 3: {
                button1 = this.addButton("ok");
                this.buttonList.add(button1);
                button2 = this.addButton("cancel");
                this.buttonList.add(button2);
                if (btnDefault == 3) {
                    this.defButton = button2;
                    break;
                }
                this.defButton = button1;
                break;
            }
            case 4: {
                button1 = this.addButton("yes");
                this.buttonList.add(button1);
                button2 = this.addButton("no");
                this.buttonList.add(button2);
                button3 = this.addButton("cancel");
                this.buttonList.add(button3);
                this.defButton = btnDefault == 2 ? button2 : (btnDefault == 3 ? button3 : button1);
                isQuestionBox = true;
                break;
            }
            case 5: {
                button1 = this.addButton("retry");
                this.buttonList.add(button1);
                button2 = this.addButton("cancel");
                this.buttonList.add(button2);
                this.defButton = btnDefault == 3 ? button2 : button1;
                isQuestionBox = true;
                break;
            }
            case 6: {
                button1 = this.addButton("abort");
                this.buttonList.add(button1);
                button2 = this.addButton("retry");
                this.buttonList.add(button2);
                button3 = this.addButton("ignore");
                this.buttonList.add(button3);
                this.defButton = btnDefault == 5 ? button2 : (btnDefault == 6 ? button3 : button1);
                isQuestionBox = true;
                break;
            }
            case 7: {
                button1 = this.addButton("cancel");
                this.buttonList.add(button1);
                button2 = this.addButton("retry");
                this.buttonList.add(button2);
                button3 = this.addButton("continue");
                this.buttonList.add(button3);
                this.defButton = btnDefault == 5 ? button2 : (btnDefault == 7 ? button3 : button1);
                isQuestionBox = true;
            }
        }
        JLabel lblicon = null;
        JLabel lbltext = new JLabel();
        if (this.font != null) {
            Insets is;
            int w;
            FontMetrics fm;
            lbltext.setFont(this.font.getFont());
            if (button1 != null) {
                button1.setFont(this.font.getFont());
                fm = button1.getFontMetrics(button1.getFont());
                w = fm.stringWidth(button1.getText());
                is = button1.getInsets();
                if (is != null) {
                    w += is.left + is.right;
                }
                if (w < MIN_BUTTON_WIDTH) {
                    button1.setMinimumSize(new Dimension(MIN_BUTTON_WIDTH, button1.getMinimumSize().height));
                    button1.setPreferredSize(new Dimension(MIN_BUTTON_WIDTH, button1.getPreferredSize().height));
                }
            }
            if (button2 != null) {
                button2.setFont(this.font.getFont());
                fm = button2.getFontMetrics(button2.getFont());
                w = fm.stringWidth(button2.getText());
                is = button2.getInsets();
                if (is != null) {
                    w += is.left + is.right;
                }
                if (w < MIN_BUTTON_WIDTH) {
                    button2.setMinimumSize(new Dimension(MIN_BUTTON_WIDTH, button2.getMinimumSize().height));
                    button2.setPreferredSize(new Dimension(MIN_BUTTON_WIDTH, button2.getPreferredSize().height));
                }
            }
            if (button3 != null) {
                button3.setFont(this.font.getFont());
                fm = button3.getFontMetrics(button3.getFont());
                w = fm.stringWidth(button3.getText());
                is = button3.getInsets();
                if (is != null) {
                    w += is.left + is.right;
                }
                if (w < MIN_BUTTON_WIDTH) {
                    button3.setMinimumSize(new Dimension(MIN_BUTTON_WIDTH, button3.getMinimumSize().height));
                    button3.setPreferredSize(new Dimension(MIN_BUTTON_WIDTH, button3.getPreferredSize().height));
                }
            }
        }
        this.imageCanvas = this.loadIconAndAlertLevel(icon, isQuestionBox);
        lbltext.setText(RemoteMessageBox.buildTitle(text, lbltext.getFontMetrics(lbltext.getFont())));
        if (multilines) {
            lbltext.setAlignmentY(0.0f);
        } else {
            lbltext.setAlignmentY(0.5f);
        }
        lbltext.setAlignmentX(0.0f);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messagePanel.setBorder(BorderFactory.createEmptyBorder(16, 23, 16, 23));
        messagePanel.add(Box.createHorizontalGlue());
        if (this.imageCanvas != null) {
            lblicon = new JLabel();
            if (multilines) {
                lblicon.setAlignmentY(0.0f);
            } else {
                lblicon.setAlignmentY(0.5f);
            }
            lblicon.setAlignmentX(0.0f);
            lblicon.setIcon(new ImageIcon(this.imageCanvas));
            messagePanel.add(lblicon);
            messagePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        messagePanel.add(lbltext);
        this.msgbox.getContentPane().add("Center", messagePanel);
        this.msgbox.getContentPane().add("South", this.buttonPanel);
        if (this.cBack != null) {
            this.msgbox.getContentPane().setBackground(this.cBack);
            messagePanel.setBackground(this.cBack);
            this.buttonPanel.setBackground(this.cBack);
            if (button1 != null) {
                button1.setBackground(this.cBack);
            }
            if (button2 != null) {
                button2.setBackground(this.cBack);
            }
            if (button3 != null) {
                button3.setBackground(this.cBack);
            }
        } else {
            this.msgbox.getContentPane().setBackground(Color.white);
            messagePanel.setBackground(Color.white);
        }
        if (this.cFore != null) {
            this.msgbox.getContentPane().setForeground(this.cFore);
            messagePanel.setForeground(this.cFore);
            this.buttonPanel.setForeground(this.cFore);
            lbltext.setForeground(this.cFore);
            lblicon.setForeground(this.cFore);
            if (button1 != null) {
                button1.setForeground(this.cFore);
            }
            if (button2 != null) {
                button2.setForeground(this.cFore);
            }
            if (button3 != null) {
                button3.setForeground(this.cFore);
            }
        }
        if (timeout == -1L || timeout > 20L) {
            KeyboardBuffer.setBufferOff();
            this.msgbox.pack();
            this.setDefaultLocation();
            this.defButton.requestFocusInWindow();
            this.msgbox.setResizable(false);
        }
        if (timeout >= 0L) {
            this.startTimer(timeout);
        }
        if (timeout == -1L || timeout > 20L) {
            this.alert(this.alertlevel);
            if (centered) {
                this.msgbox.setLocationRelativeTo(null);
            }
            this.msgbox.setVisible(true);
            KeyboardBuffer.setBufferOn();
        }
    }

    private void alert(int alertlevel) {
        String alertSound = null;
        switch (alertlevel) {
            case 0: {
                alertSound = "win.sound.asterisk";
                break;
            }
            case 1: {
                alertSound = "win.sound.exclamation";
                break;
            }
            case 2: {
                alertSound = "win.sound.hand";
                break;
            }
            case 3: {
                alertSound = "win.sound.question";
                break;
            }
            case 4: {
                alertSound = "win.sound.default";
            }
        }
        if (alertSound != null) {
            Runnable runnable = (Runnable)Toolkit.getDefaultToolkit().getDesktopProperty(alertSound);
            if (runnable != null) {
                runnable.run();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void setDefaultLocation() {
        Container rw = this.msgbox.getParent();
        if (rw != null) {
            Dimension sz;
            Rectangle rwBounds = rw.getBounds(null);
            if (rwBounds.height == 0 && rwBounds.width == 0) {
                sz = Toolkit.getDefaultToolkit().getScreenSize();
                rwBounds.x = rwBounds.y;
                rwBounds.height = sz.height;
                rwBounds.width = sz.width;
            }
            sz = this.msgbox.getSize();
            int startX = rwBounds.x + (rwBounds.width - sz.width) / 2;
            int startY = rwBounds.y + (rwBounds.height - sz.height) / 2;
            if (this.gf.getCsProperty().get("iscobol.gui.windows_uncropped", true)) {
                Point p = this.gf.adjustLocation(new Point(startX, startY), this.msgbox.getSize());
                startX = p.x;
                startY = p.y;
            }
            this.msgbox.setLocation(startX, startY);
        }
    }

    public JButton addButton(String cmd) {
        String text = this.gf.getMessages().getMessage(cmd);
        StringBuffer sb = new StringBuffer(text);
        int c = ScreenUtility.getMnemonicChar(sb);
        text = sb.toString();
        JButton button = new JButton(text);
        if (c >= 0) {
            button.setMnemonic((char)c);
        }
        button.setActionCommand(cmd);
        button.addActionListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        return button;
    }

    public void intactionPerformed() {
        if (this.buttonPanel != null) {
            Component[] carray = this.buttonPanel.getComponents();
            AbstractButton focused = null;
            if (carray != null && carray.length > 0) {
                for (int i = 0; i < carray.length && focused == null; ++i) {
                    if (carray[i] == null || !carray[i].hasFocus() || !(carray[i] instanceof JButton)) continue;
                    focused = (JButton)carray[i];
                }
            }
            ActionEvent event = null;
            event = focused != null ? new ActionEvent(this, 1001, focused.getActionCommand()) : (this.defButton != null ? new ActionEvent(this, 1001, this.defButton.getActionCommand()) : new ActionEvent(this, 1001, "ok"));
            this.actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int commandId = -1;
        String command = evt.getActionCommand();
        this.stopTimer();
        if (command.equals("ok")) {
            commandId = 1;
        } else if (command.equals("yes")) {
            commandId = 1;
        } else if (command.equals("no")) {
            commandId = 2;
        } else if (command.equals("cancel")) {
            commandId = 3;
        } else if (command.equals("abort")) {
            commandId = 4;
        } else if (command.equals("retry")) {
            commandId = 5;
        } else if (command.equals("ignore")) {
            commandId = 6;
        } else if (command.equals("continue")) {
            commandId = 7;
        }
        if (this.events != null && commandId != -1) {
            try {
                this.events.fireevent(new RemoteRecordAccept(22, commandId, 0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.msgbox.setVisible(false);
    }

    @Override
    public void destroy() {
        this.msgbox.dispose();
        this.intstopTimer(true);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.fireCloseRequested();
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Component src = (Component)evt.getSource();
        switch (evt.getKeyCode()) {
            case 27: {
                this.fireCloseRequested();
                break;
            }
            case 9: {
                if (evt.isShiftDown()) {
                    src.transferFocusBackward();
                    break;
                }
                src.transferFocus();
                break;
            }
            case 37: 
            case 38: {
                src.transferFocusBackward();
                break;
            }
            case 39: 
            case 40: {
                src.transferFocus();
                break;
            }
            case 10: {
                ActionEvent event = new ActionEvent(this, 1001, ((JButton)evt.getSource()).getActionCommand());
                this.actionPerformed(event);
                break;
            }
            default: {
                char c = Character.toLowerCase(evt.getKeyChar());
                for (int i = 0; i < this.buttonList.size(); ++i) {
                    JButton button = (JButton)this.buttonList.get(i);
                    String buttonText = button.getText().toLowerCase();
                    if (buttonText.length() <= 0 || c != buttonText.charAt(0)) continue;
                    ActionEvent event = new ActionEvent(this, 1001, button.getActionCommand());
                    this.actionPerformed(event);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    private void fireCloseRequested() {
        if (this.type != 2 && this.type != 6) {
            this.actionPerformed(new ActionEvent(this, 1001, "cancel"));
        }
    }

    public void dispose() {
        this.msgbox.setVisible(false);
        this.msgbox.dispose();
    }

    @Override
    public Events getEvents() {
        return this.events;
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra, boolean foo) {
    }

    @Override
    public boolean isInitialized() {
        return this.msgbox != null;
    }

    @Override
    public void add(int controlID, RemoteBaseGUIControl rbgc) {
    }

    @Override
    public void add(int controlID, int index, RemoteBaseGUIControl rbgc) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public int getBackgroundIdx() {
        return -1;
    }

    @Override
    public Rectangle getMainBounds() {
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public boolean getBoxed() {
        return false;
    }

    @Override
    public int getCellHeight() {
        return 0;
    }

    @Override
    public float getCellHeightF() {
        return 0.0f;
    }

    @Override
    public int getCellWidth() {
        return 0;
    }

    @Override
    public float getCellWidthF() {
        return 0.0f;
    }

    @Override
    public int getFont() {
        return 0;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public int getForegroundIdx() {
        return -1;
    }

    @Override
    public Insets getInsets() {
        return null;
    }

    public int getMenu() {
        return 0;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean getWrap() {
        return false;
    }

    @Override
    public boolean isGraphical() {
        return false;
    }

    @Override
    public boolean isMainApplicationWindow() {
        return false;
    }

    @Override
    public void remove(int controlID) {
    }

    @Override
    public void setActiveWindow(boolean b) {
    }

    @Override
    public void setAutoResize(boolean f) {
    }

    @Override
    public void setBackground(int r, int b, int g) {
    }

    @Override
    public void setBackgroundIdx(int idx) {
    }

    @Override
    public void setCellHeight(float ch) {
    }

    @Override
    public void setCellHeight(String fontName, int fontStyle, int fontSize) {
    }

    @Override
    public void setCellWidth(float cw) {
    }

    @Override
    public void setCellWidth(String fontName, int fontStyle, int fontSize) {
    }

    @Override
    public void setDefaultLocation(int ownerWindowID) {
    }

    @Override
    public void setFont(int fontId) {
    }

    @Override
    public int setFont(String name, int style, int size) {
        return 0;
    }

    @Override
    public void setForeground(int r, int b, int g) {
    }

    @Override
    public void setForegroundIdx(int idx) {
    }

    @Override
    public void setLocation(int x, int y) {
    }

    public void setMaxHeight(int mh) {
    }

    @Override
    public void setMaxLines(int maxLines) {
    }

    @Override
    public void setMaxSize(int maxSize) {
    }

    public void setMaxWidth(int mw) {
    }

    public void setMenu(int menuID) {
    }

    public void setMinHeight(int mh) {
    }

    @Override
    public void setMinLines(int minLines) {
    }

    @Override
    public void setMinSize(int minSize) {
    }

    public void setMinWidth(int mw) {
    }

    public void setOffsetToolbar(int ot) {
    }

    @Override
    public void setPopupArea() {
    }

    @Override
    public void setResizable(boolean r) {
    }

    @Override
    public void setScroll(boolean s) {
    }

    @Override
    public void setSize(float cols, float lines) {
    }

    @Override
    public void setTitle(String t) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void setWithSystemMenu(boolean b) {
    }

    @Override
    public void toFront() {
    }

    private Image loadIconAndAlertLevel(int i, boolean ques) {
        String iconName;
        switch (i) {
            case 3: {
                iconName = "Error.gif";
                this.alertlevel = 2;
                break;
            }
            case 2: {
                iconName = "Warn.gif";
                this.alertlevel = 1;
                break;
            }
            default: {
                if (ques) {
                    iconName = "Question.gif";
                    this.alertlevel = 3;
                    break;
                }
                iconName = "Inform.gif";
                this.alertlevel = 0;
            }
        }
        Image Return2 = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(iconName));
        return Return2;
    }

    @Override
    public void setTitlePosition(int t) {
    }

    @Override
    public void setAction(float cv) {
        switch ((int)cv) {
            case 21: {
                break;
            }
            case 20: {
                break;
            }
            case 22: {
                break;
            }
        }
    }

    @Override
    public void setTitleBar(boolean b) {
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation pwl) {
    }

    @Override
    public void setStyle(int s) {
    }

    @Override
    public void unsetStyle(int s) {
    }

    @Override
    public void remove(int controlID, boolean wait) {
    }

    @Override
    public void addMnemonic(char c, RemoteBaseGUIControl comp) {
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl comp) {
    }

    @Override
    public void startTimer(long hSeconds) {
        if (this.pTimer != null) {
            this.pTimer.restart();
        } else {
            this.pTimer = new PicobolTimer(hSeconds);
            this.pTimer.start();
        }
    }

    public void intstopTimer(boolean force) {
        this.stopTimer(force);
        if (this.pTimer != null) {
            this.pTimer.stop();
            this.pTimer = null;
        }
    }

    public void stopTimer() {
        this.stopTimer(false);
    }

    public void stopTimer(boolean force) {
        if (this.pTimer != null && !force && this.pTimer != null) {
            this.pTimer.stop();
        }
    }

    private SwingFontCmp callFontCmp(String name, int style, float size) {
        SwingFontCmp sfc;
        SwingFontCmp Return2 = null;
        this.attrs = new Hashtable();
        this.attrs.put(FontAttribute.FAMILY, name);
        this.attrs.put(FontAttribute.SIZE, new Float(size));
        if ((style & 1) != 0) {
            this.attrs.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            this.attrs.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
        if ((sfc = new SwingFontCmp(this.gf, this.attrs, false)).getFont() != null) {
            Return2 = sfc;
        }
        return Return2;
    }

    private SwingFontCmp myGetFont(String str, String nm, int st, float sz) {
        Object Return2 = null;
        String fontName = nm;
        float fontSize = sz;
        int fontStyle = st;
        if (str != null) {
            fontName = str;
            fontSize = defaultFontSize;
            fontStyle = 0;
            int i = str.indexOf(45);
            if (i >= 0) {
                fontName = str.substring(0, i);
                if (i < str.length()) {
                    if ((str = str.substring(i + 1).toLowerCase()).startsWith("bolditalic")) {
                        fontStyle = 3;
                        if (str.length() > 11) {
                            str = str.substring(11);
                        }
                    } else if (str.startsWith("bold")) {
                        fontStyle = 1;
                        if (str.length() > 5) {
                            str = str.substring(5);
                        }
                    } else if (str.startsWith("italic")) {
                        fontStyle = 2;
                        if (str.length() > 7) {
                            str = str.substring(7);
                        }
                    }
                    if (str.length() > 0) {
                        try {
                            fontSize = Float.valueOf(str).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (fontSize == 0.0f) {
                        fontSize = defaultFontSize;
                    }
                }
            }
        }
        return this.callFontCmp(fontName, fontStyle, fontSize);
    }

    private static String buildTitle(String t, FontMetrics fm) {
        if (t.toUpperCase().startsWith("<HTML")) {
            return t;
        }
        String eol = System.getProperty("line.separator", "\n");
        int tabWidth = 8;
        int cellWidth = Math.round(fm.stringWidth("0123456789") / 10);
        StringBuffer Return2 = new StringBuffer("<html><body>");
        int lbltextmaxwidth = fm.stringWidth("00000000000000000000000000000000000000000000000000000");
        if (!eol.equals("\n")) {
            t = t.replaceAll(eol, "\n");
        }
        if (t.indexOf(9) >= 0) {
            ArrayList table = new ArrayList();
            for (String string : t.split("\n")) {
                ArrayList<String> row = new ArrayList<String>();
                table.add(row);
                if (string.equals("\n")) continue;
                StringTokenizer cellStn = new StringTokenizer(string, "\t", true);
                while (cellStn.hasMoreTokens()) {
                    String cellTk = cellStn.nextToken();
                    if (cellTk.equals("\t")) {
                        row.add("");
                        continue;
                    }
                    row.add(cellTk);
                }
            }
            int maxCellCount = 0;
            StringBuffer tableBody = new StringBuffer();
            for (ArrayList arrayList : table) {
                int cellCount = 0;
                if (arrayList.isEmpty()) {
                    tableBody.append("<tr></tr>");
                    continue;
                }
                tableBody.append("<tr>");
                int prevWidth = 0;
                for (String cell : arrayList) {
                    if ((cell = Factory.rightTrim(cell)).length() > 0) {
                        prevWidth = (int)Math.ceil(fm.stringWidth(cell) / cellWidth);
                        tableBody.append("<td colspan=\"" + prevWidth + "\">");
                        RemoteMessageBox.escapeString(cell, true, tableBody, lbltextmaxwidth, fm);
                        tableBody.append("</td>");
                        cellCount += prevWidth;
                    } else {
                        int w = 8;
                        if (prevWidth > 0) {
                            int mod = prevWidth % 8;
                            w = mod > 0 ? (w -= mod) : 0;
                        }
                        if (w > 0) {
                            tableBody.append("<td colspan=\"" + w + "\" />");
                            cellCount += w;
                        }
                        prevWidth = 0;
                    }
                    if (cellCount <= maxCellCount) continue;
                    maxCellCount = cellCount;
                }
                tableBody.append("</tr>");
            }
            Return2.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"" + maxCellCount * (cellWidth + 1) + "\" >");
            Return2.append(tableBody);
            Return2.append("</table>");
        } else {
            RemoteMessageBox.escapeString(t, false, Return2, lbltextmaxwidth, fm);
        }
        Return2.append("</body></html>");
        return Return2.toString();
    }

    private static void escapeString(String t, boolean escapeAllSpaces, StringBuffer Return2, int lbltextmaxwidth, FontMetrics fm) {
        char[] tChars = t.toCharArray();
        int skip = 0;
        int lastidxspace = 0;
        int lastidxspaceinreturn = 0;
        int width = fm.stringWidth(t);
        boolean mustskip = width > lbltextmaxwidth;
        String currentstr = "";
        int currentwidth = 0;
        int i = 0;
        while (i < tChars.length) {
            String tmp;
            currentwidth = fm.stringWidth(currentstr = currentstr + tChars[i]);
            if (currentwidth > lbltextmaxwidth) {
                currentstr = "";
                if (lastidxspace == 0) {
                    Return2.append("<br>");
                } else if (lastidxspaceinreturn > 0) {
                    tmp = Return2.substring(0, lastidxspaceinreturn);
                    tmp = tmp + "<br>";
                    tmp = tmp + Return2.substring(lastidxspaceinreturn);
                    currentstr = Return2.substring(lastidxspaceinreturn);
                    Return2 = Return2.replace(0, Return2.length(), tmp);
                }
                currentstr = currentstr + String.valueOf(tChars[i]);
                currentwidth = fm.stringWidth(currentstr);
                lastidxspace = 0;
                lastidxspaceinreturn = 0;
            }
            switch (tChars[i]) {
                default: {
                    if (tChars[i] > '\u00ff') {
                        Return2.append("&#" + tChars[i] + ";");
                        break;
                    }
                    Return2.append(tChars[i]);
                    break;
                }
                case '\n': {
                    Return2.append("<br>");
                    skip = 0;
                    currentwidth = 0;
                    currentstr = "";
                    lastidxspace = 0;
                    lastidxspaceinreturn = 0;
                    break;
                }
                case '&': {
                    Return2.append("&amp;");
                    break;
                }
                case '<': {
                    Return2.append("&lt;");
                    break;
                }
                case '>': {
                    Return2.append("&gt;");
                    break;
                }
                case '\"': {
                    Return2.append("&quot;");
                    break;
                }
                case ' ': {
                    lastidxspace = i;
                    if (escapeAllSpaces || i == 0 || tChars[i - 1] == ' ') {
                        Return2.append("&nbsp;");
                    } else {
                        Return2.append(' ');
                    }
                    lastidxspaceinreturn = Return2.length();
                }
            }
            if (currentwidth == lbltextmaxwidth) {
                currentstr = "";
                if (lastidxspace == 0) {
                    Return2.append("<br>");
                } else if (lastidxspaceinreturn > 0) {
                    tmp = Return2.substring(0, lastidxspaceinreturn);
                    tmp = tmp + "<br>";
                    tmp = tmp + Return2.substring(lastidxspaceinreturn);
                    currentstr = Return2.substring(lastidxspaceinreturn);
                    Return2 = Return2.replace(0, Return2.length(), tmp);
                }
                currentstr = currentstr + String.valueOf(tChars[i]);
                currentwidth = fm.stringWidth(currentstr);
                lastidxspace = 0;
                lastidxspaceinreturn = 0;
            }
            ++i;
            ++skip;
        }
    }

    private class PicobolTimer
    implements ActionListener {
        private long delay;
        private boolean restarted;
        private Timer t;

        public PicobolTimer(long h_seconds) {
            this.delay = h_seconds * 10L;
            this.t = new Timer((int)this.delay, this);
            this.t.setInitialDelay((int)this.delay);
            this.t.setRepeats(true);
        }

        public void start() {
            this.restarted = true;
            this.t.start();
        }

        public void stop() {
            this.restarted = false;
            this.t.stop();
        }

        public void restart() {
            this.restarted = true;
            this.t.restart();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.restarted) {
                this.restarted = false;
                RemoteMessageBox.this.intactionPerformed();
            }
        }
    }
}

