/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolSlider;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RemoteSlider
extends RemoteBaseGUIControl {
    private int minValue;
    private int maxValue = 100;
    private int pageSize;
    private int majorTickSp;
    private int minorTickSp;
    private int labelsIncrement;
    private boolean horizontalStyle;
    private boolean invertedStyle;
    private boolean showTicksStyle;
    private boolean showLabelsStyle;
    private int sliderValue = this.minValue;
    private boolean transparent;

    public RemoteSlider(GuiFactoryImpl gf) {
        super(gf);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        if (this.horizontalStyle) {
            return 1.5f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultWidth() {
        if (this.horizontalStyle) {
            return 0.0f;
        }
        return 2.7f;
    }

    @Override
    public int getGUIControlHeight(float height) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * height);
        }
        return 20;
    }

    @Override
    public int getGUIControlWidth(float width) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * width);
        }
        return 20;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        return "" + this.sliderValue;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolSlider();
        this.guiComponent.addKeyListener(this);
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        this.setHorizontal(this.horizontalStyle);
        sl.setInverted(this.invertedStyle);
        sl.setPaintTicks(this.showTicksStyle);
        sl.setPaintLabels(this.showLabelsStyle);
        super.intInitialize();
        sl.setMinimum(this.minValue);
        sl.setMaximum(this.maxValue);
        sl.setExtent(this.pageSize);
        sl.setMinorTickSpacing(this.minorTickSp);
        sl.setMajorTickSpacing(this.majorTickSp);
        if (this.transparent) {
            sl.setOpaque(false);
        }
        if (this.labelsIncrement > 0) {
            sl.setLabelTable(sl.createStandardLabels(this.labelsIncrement));
        }
        sl.setValue(this.sliderValue);
        sl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider src = (JSlider)e.getSource();
                RemoteSlider.this.responseOnAction(src.getValue());
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        super.keyPressed(ke);
    }

    private void responseOnAction(int val) {
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        if (val != this.sliderValue) {
            this.sliderValue = val;
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 17001, 0, val, false, false, true));
            this.pushEvent(cc);
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        switch (key) {
            case 148: {
                if (error) break;
                this.maxValue = intValue;
                if (sl != null) {
                    sl.setMaximum(this.maxValue);
                }
                Return2 = "1";
                break;
            }
            case 152: {
                if (error) break;
                this.minValue = intValue;
                if (sl != null) {
                    sl.setMinimum(this.minValue);
                }
                Return2 = "1";
                break;
            }
            case 162: {
                if (error) break;
                this.pageSize = intValue;
                if (sl != null) {
                    sl.setExtent(this.pageSize);
                }
                Return2 = "1";
                break;
            }
            case 151: {
                if (error) break;
                this.minorTickSp = intValue;
                if (sl != null) {
                    sl.setMinorTickSpacing(this.minorTickSp);
                }
                Return2 = "1";
                break;
            }
            case 141: {
                if (error) break;
                this.majorTickSp = intValue;
                if (sl != null) {
                    sl.setMajorTickSpacing(this.majorTickSp);
                }
                Return2 = "1";
                break;
            }
            case 134: {
                if (error) break;
                this.labelsIncrement = intValue;
                if (sl != null) {
                    sl.setLabelTable(sl.createStandardLabels(this.labelsIncrement));
                }
                Return2 = "1";
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public void setRowsCols(float r, float c) {
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        if ((s & 1) == 1) {
            this.setHorizontal(set);
        }
        if ((s & 2) == 2) {
            this.invertedStyle = set;
            if (sl != null) {
                sl.setInverted(set);
            }
        }
        if ((s & 4) == 4) {
            this.showTicksStyle = set;
            if (sl != null) {
                sl.setPaintTicks(set);
            }
        }
        if ((s & 8) == 8) {
            this.showLabelsStyle = set;
            if (sl != null) {
                sl.setPaintLabels(set);
            }
        }
        if ((s & 0x20) == 32) {
            this.transparent = set;
            if (sl != null) {
                sl.setOpaque(!set);
            }
        }
    }

    @Override
    public void setTitle(String v) {
    }

    private void setHorizontal(boolean h) {
        this.horizontalStyle = h;
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        if (sl != null) {
            sl.setOrientation(this.horizontalStyle ? 0 : 1);
        }
    }

    @Override
    public String setValue(String v) {
        try {
            this.sliderValue = Integer.parseInt(v.trim());
            this.setValue(this.sliderValue);
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setValue(int v) {
        PicobolSlider sl = (PicobolSlider)this.guiComponent;
        if (sl != null && sl.getValue() != this.sliderValue) {
            sl.setValue(this.sliderValue);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void intFocusGained(boolean restore) {
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v && this.parentWindow != null && (this.width == 0 || this.height == 0)) {
            Rectangle r = ((RemoteDisplayWindow)this.parentWindow).getBounds();
            if (this.width == 0) {
                this.width = r.width - this.x;
            }
            if (this.height == 0) {
                this.height = r.height - this.y;
            }
            super.setSize(this.width, this.height);
            this.guiComponent.doLayout();
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public String getType() {
        if (this.horizontalStyle) {
            return "hslider";
        }
        return "vslider";
    }
}

