/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolSplitPane;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.SplitPane;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RemoteSplitPane
extends RemoteBaseGUIControl {
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private boolean _3d;
    private boolean boxed;
    private boolean noBox;
    private boolean useDefaultBorderWithBoxedStyle;
    private Border defaultBorder;
    private boolean transparent;
    protected Border origBorder;
    GradientManager gradientMgr = new GradientManager();
    private int maxDividerLocation = 100;
    private int minDividerLocation;
    private int splitOrientation;
    private int lastDividerLocation = 50;
    private int dividerSize;
    private int defaultDividerSize;
    private int panelIndex = -1;

    public RemoteSplitPane(GuiFactoryImpl gf) {
        super(gf);
        this.useDefaultBorderWithBoxedStyle = gf.getCsProperty().get("iscobol.gui.native_style", false);
    }

    @Override
    public void destroy() {
        PicobolSplitPane sp = (PicobolSplitPane)this.guiComponent;
        if (sp != null) {
            sp.removeAll();
        }
        if (this.popupMenu != null) {
            this.popupMenu.destroy();
            this.popupMenu = null;
        }
        super.destroy();
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        return 10.0f;
    }

    @Override
    public float getDefaultWidth() {
        return 10.0f;
    }

    @Override
    public int getGUIControlHeight(float h) {
        return (int)((float)this.font.getHeight() * h);
    }

    @Override
    public int getGUIControlWidth(float w) {
        return (int)((float)this.font.getWidth() * w);
    }

    @Override
    public String getProp(int key) {
        switch (key) {
            case 2075: {
                return "" + this.gradientMgr.getOrientation();
            }
            case 2076: {
                return this.gradientMgr.getColor1AsString();
            }
            case 2078: {
                return this.gradientMgr.getColor2AsString();
            }
            case 325: {
                if (this.borderColorCmp != null) {
                    return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
                }
                return null;
            }
            case 472: {
                return "" + this.lastDividerLocation;
            }
            case 473: {
                return "" + this.maxDividerLocation;
            }
            case 474: {
                return "" + this.minDividerLocation;
            }
            case 477: {
                return "" + this.splitOrientation;
            }
            case 479: {
                return "" + (this.guiComponent != null ? ((SplitPane)((Object)this.guiComponent)).getDividerSize() : this.dividerSize);
            }
        }
        return super.getProp(key);
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        return "";
    }

    void handleMouseEvent(MouseEvent evt) {
        if (this.parentWindow != null && this.parentToolbar == null) {
            ((RemoteDisplayWindow)this.parentWindow).handleMouseEvents(evt);
        }
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        PicobolSplitPane sp = new PicobolSplitPane(this.gradientMgr);
        if (this.useDefaultBorderWithBoxedStyle) {
            this.defaultBorder = new JScrollPane().getBorder();
        }
        this.defaultDividerSize = sp.getDividerSize();
        if (this.dividerSize > 0) {
            sp.setDividerSize(this.dividerSize);
        }
        ScreenUtility.disableFocusTraversalKeys(sp);
        sp.setOrientation(this.splitOrientation == 0 ? 1 : 0);
        sp.setDividerLocation((double)this.lastDividerLocation / 100.0);
        sp.setOneTouchExpandable(false);
        this.guiComponent = sp;
        super.intInitialize();
        this.intSetBorder();
        if (this.parentWindow != null && this.getBackground() == null) {
            this.guiComponent.setBackground(this.parentWindow.getBackground());
        }
        if (this.parentWindow != null && this.getForeground() == null) {
            this.guiComponent.setForeground(this.parentWindow.getForeground());
        }
        ((PicobolSplitPane)this.guiComponent).setTransparent(this.transparent);
        this.guiComponent.addKeyListener(this);
        sp.addPropertyChangeListener("dividerLocation", evt -> {
            double w;
            double newVal = ((Integer)evt.getNewValue()).intValue();
            int newLoc = (int)Math.round(newVal * 100.0 / (w = this.splitOrientation == 0 ? (double)(sp.getWidth() - sp.getDividerSize()) : (double)(sp.getHeight() - sp.getDividerSize())));
            if (newLoc < this.minDividerLocation) {
                newLoc = this.minDividerLocation;
                sp.setDividerLocation((double)newLoc / 100.0);
            } else if (newLoc > this.maxDividerLocation) {
                newLoc = this.maxDividerLocation;
                sp.setDividerLocation((double)newLoc / 100.0);
            }
            if (newLoc != this.lastDividerLocation) {
                CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 17042, (short)newLoc, 0, true, true, true));
                this.pushEvent(cc);
                this.lastDividerLocation = newLoc;
            }
        });
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = 0;
        boolean error = false;
        boolean isrgb = false;
        PicobolSplitPane scp = (PicobolSplitPane)this.guiComponent;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        switch (key) {
            case 2086: {
                Object id = this.gf.getClient().getId(intValue);
                this.gradientMgr.setImage(id instanceof LocalImage ? ((LocalImage)id).getImage() : null);
                break;
            }
            case 2087: {
                this.gradientMgr.setImageScale(intValue);
                break;
            }
            case 2076: {
                this.gradientMgr.setColor1(intValue, false, this.gf);
                break;
            }
            case 2077: {
                this.gradientMgr.setColor1(intValue, true, this.gf);
                break;
            }
            case 2078: {
                this.gradientMgr.setColor2(intValue, false, this.gf);
                break;
            }
            case 2079: {
                this.gradientMgr.setColor2(intValue, true, this.gf);
                break;
            }
            case 2075: {
                this.gradientMgr.setOrientation(intValue);
                break;
            }
            case 325: 
            case 326: {
                isrgb = key.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                if (!this.isBoxed()) break;
                this.intSetBorder();
                break;
            }
            case 472: {
                if (error) break;
                this.lastDividerLocation = Math.max(0, Math.min(100, intValue));
                if (scp != null) {
                    double dl = this.lastDividerLocation;
                    int min = this.minDividerLocation;
                    int max = this.maxDividerLocation;
                    this.minDividerLocation = 0;
                    this.maxDividerLocation = 100;
                    scp.setDividerLocation(dl / 100.0);
                    this.minDividerLocation = min;
                    this.maxDividerLocation = max;
                }
                Return2 = "1";
                break;
            }
            case 473: {
                if (error || intValue <= this.minDividerLocation || intValue > 100) break;
                this.maxDividerLocation = intValue;
                Return2 = "1";
                break;
            }
            case 474: {
                if (error || intValue < 0 || intValue >= this.maxDividerLocation) break;
                this.minDividerLocation = intValue;
                Return2 = "1";
                break;
            }
            case 477: {
                if (error || intValue != 0 && intValue != 1) break;
                this.splitOrientation = intValue;
                Return2 = "1";
                break;
            }
            case 479: {
                if (error) break;
                this.dividerSize = intValue;
                if (scp != null) {
                    if (this.dividerSize > 0) {
                        scp.setDividerSize(this.dividerSize);
                    } else if (this.defaultDividerSize > 0) {
                        scp.setDividerSize(this.defaultDividerSize);
                    }
                }
                Return2 = "1";
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public String setProp(Integer key, String[] values) {
        return "0";
    }

    @Override
    public void setCols(float c) {
    }

    @Override
    public void setRows(float r) {
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 4) == 4) {
            this.boxed = set;
        }
        if ((s & 1) == 1) {
            this.noBox = set;
            if (set) {
                this.setNoboxStyle();
            }
        }
        if ((s & 2) == 2) {
            this.transparent = set;
            if (this.guiComponent != null) {
                ((PicobolSplitPane)this.guiComponent).setTransparent(this.transparent);
            }
        }
        if ((s & 0x2000000) == 0x2000000) {
            this._3d = set;
        }
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public String setValue(String v) {
        return null;
    }

    @Override
    boolean handleMouseClicked(MouseEvent me, boolean altKey) {
        return false;
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        return 0.0f;
    }

    @Override
    public String getType() {
        return "splitpane";
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    protected void setBoxedStyle() {
        PicobolSplitPane sp = (PicobolSplitPane)this.guiComponent;
        if (sp != null) {
            Border border = this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : BorderFactory.createLineBorder(Color.darkGray);
            this.setOrigBorder(sp, border);
        }
    }

    private void setOrigBorder(PicobolSplitPane sp, Border border) {
        this.origBorder = border;
        sp.setBorder(border);
    }

    protected void setNoboxStyle() {
        PicobolSplitPane tf = (PicobolSplitPane)this.guiComponent;
        if (tf != null) {
            this.setOrigBorder(tf, null);
        }
    }

    @Override
    public void setPopupMenu(RemoteMenu rm) {
        this.popupMenu = rm;
        super.setPopupMenu(rm);
    }

    @Override
    public void addToContainer(int srvidcomponent, int srvidcontainer, ParamVector resultW, Vector destroyvectWSP) {
        RemoteBaseGUIControl rbgc = this.getParentWindow().getBGC(srvidcontainer);
        rbgc.addControl(srvidcomponent, resultW, destroyvectWSP, srvidcontainer);
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void add(RemoteBaseGUIControl rbgc, int index, Hashtable childGraphics) {
        PicobolSplitPane sp = (PicobolSplitPane)this.guiComponent;
        if (sp != null) {
            sp.add(rbgc, this.panelIndex, childGraphics);
            sp.setDividerLocation((double)this.lastDividerLocation / 100.0);
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle rec) {
    }

    protected boolean isBoxed() {
        return this.boxed || !this._3d && !this.noBox;
    }

    private void intSetBorder() {
        if (this.guiComponent == null) {
            return;
        }
        PicobolSplitPane cb = (PicobolSplitPane)this.guiComponent;
        Border b = this.createBorder();
        cb.setBorder(b);
    }

    private Border createBorder() {
        Object b = this._3d ? BorderFactory.createLoweredBevelBorder() : (this.noBox ? null : (this.useDefaultBorderWithBoxedStyle ? (this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : this.defaultBorder) : (this.borderWidths != null && this.borderWidths.size() > 0 ? new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray) : BorderFactory.createLineBorder(this.borderColor != null ? this.borderColor : Color.black))));
        return b;
    }

    @Override
    public void setElementAt(int idx) {
        this.panelIndex = idx;
    }

    @Override
    public void setElementAt(int[] idxs) {
        this.setElementAt(idxs[0]);
    }
}

