/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.TabChangeException;
import com.iscobol.gui.client.TabClosableEvent;
import com.iscobol.gui.client.TabClosableListener;
import com.iscobol.gui.client.TabWillChangeEvent;
import com.iscobol.gui.client.TabWillChangeListener;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.PicobolTabInterface;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TabAccordion
extends JPanel
implements PicobolTabInterface {
    private static final long serialVersionUID = 0L;
    private int BTN_HEIGHT = 25;
    private int WIDTH = 0;
    private int HEIGHT = 0;
    private Image image;
    private int bitmapWidth;
    private Hashtable bitmapNumbers = new Hashtable();
    private Vector tabWillChangeListeners = new Vector();
    private Vector tabClosableListeners = new Vector();
    private boolean relativeoffset;
    private Vector addtabidxvect;
    private int childCount;
    private int selectedIndex;
    private Color bg;
    private Color fg;
    private Font font;
    private KeyListener kl;
    private boolean movingcomponents = false;
    private boolean repaintingcomponents = false;
    private int visibleIndex = this.childCount - 1;
    private String name;
    private int tabdelay = -1;
    private boolean istabflat;
    private int tabcolor;
    private Color tabbackgroundcolor;
    private Color tabforegroundcolor;
    private Color activetabbg;
    private Color activetabfg;
    private Color tabrolloverforegroundcolor;
    private Color tabrolloverbackgroundcolor;
    private MyBoolean bb = new MyBoolean(true);
    private MouseListener ml;
    private GradientManager gradientMgr;
    private boolean istabclosebutton;
    private Image imagemouseentered;
    private Image imagemouseexited;

    public TabAccordion(boolean multiline, boolean relativeoffset, boolean nativestyle, boolean istabclosebutton, GradientManager gradientMgr) {
        this.relativeoffset = relativeoffset;
        this.istabclosebutton = istabclosebutton;
        this.gradientMgr = gradientMgr;
        if (!nativestyle) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.setLayout(null);
        this.setOpaque(false);
        if (this.childCount > 0) {
            int h = 0;
            boolean w = false;
            int childpanel2height = this.HEIGHT - 1 - (this.childCount - 1) * this.BTN_HEIGHT;
            for (int j = 0; j < this.childCount; ++j) {
                ChildPanel2 child = new ChildPanel2(null, j + 1, null, this, this.name, istabclosebutton);
                this.add(child);
                child.setBounds(0, h + 1, this.WIDTH, childpanel2height);
                if (this.kl != null) {
                    child.addKeyListener(this.kl);
                }
                if (j < this.childCount - 1) {
                    h += this.BTN_HEIGHT;
                }
                if (this.ml == null) continue;
                child.removeMouseListener(this.ml);
            }
            this.setZOrder();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.WIDTH = width;
        this.HEIGHT = height;
        if (this.childCount > 0) {
            new IsguiWorker(false){

                @Override
                public void launch() {
                    TabAccordion.this.intrepaintpanel(TabAccordion.this.BTN_HEIGHT);
                }
            }.start();
        }
        this.doLayout();
    }

    private void setActiveBGFG() {
        Component obj = null;
        obj = this.getComponent(this.childCount - this.selectedIndex - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            if ((this.istabflat || this.tabbackgroundcolor != null) && this.activetabbg != null) {
                ((ChildPanel2)obj).getControlPanel().setTabBackgroundColor(this.activetabbg);
            }
            if ((this.istabflat || this.tabforegroundcolor != null) && this.activetabfg != null) {
                ((ChildPanel2)obj).getControlPanel().setTabForegroundColor(this.activetabfg);
            }
        }
    }

    @Override
    public void selectIndex(int idx) {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component obj = null;
        obj = this.getComponent(this.childCount - this.selectedIndex - 1);
        if (obj != null && obj instanceof ChildPanel2 && (this.activetabbg != null || this.istabflat)) {
            if (this.tabbackgroundcolor != null) {
                ((ChildPanel2)obj).getControlPanel().setTabBackgroundColor(this.tabbackgroundcolor);
            } else if (this.bg != null) {
                ((ChildPanel2)obj).getControlPanel().setTabBackgroundColor(this.bg);
            }
            if (this.tabforegroundcolor != null) {
                ((ChildPanel2)obj).getControlPanel().setTabForegroundColor(this.tabforegroundcolor);
            } else if (this.fg != null) {
                ((ChildPanel2)obj).getControlPanel().setTabForegroundColor(this.fg);
            }
        }
        this.selectedIndex = idx;
        this.setChildVisible(idx);
        this.setActiveBGFG();
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public boolean isEnabledAt(int idx) {
        Component obj = this.getComponent(this.childCount - idx - 1);
        return obj instanceof ChildPanel2 && ((ChildPanel2)obj).isEnabled();
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        Component obj = null;
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            obj = this.getComponent(this.childCount - i - 1);
            if (obj == null || !(obj instanceof ChildPanel2)) continue;
            ((ChildPanel2)obj).setEnabled(en);
        }
        this.repaint();
    }

    @Override
    public void setEnabledAt(int idx, boolean en) {
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).setEnabled(en);
        }
        this.repaint();
    }

    @Override
    public void setAlignmentAt(int idx, String a) {
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).setAlignment(a);
        }
        this.repaint();
    }

    @Override
    public int getTabCount() {
        return this.childCount;
    }

    @Override
    public void setMnemonicAt(int idx, int c) {
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.ml = l;
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.ml = null;
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        super.addKeyListener(kl);
        this.kl = kl;
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            c[j].addKeyListener(kl);
        }
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        this.kl = null;
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            c[j].removeKeyListener(kl);
        }
    }

    @Override
    public void addTabWillChangeListener(TabWillChangeListener l) {
        this.tabWillChangeListeners.addElement(l);
    }

    public void removeTabWillChangeListener(TabWillChangeListener l) {
        this.tabWillChangeListeners.remove(l);
    }

    @Override
    public void addTabClosableListener(TabClosableListener l) {
        this.tabClosableListeners.addElement(l);
    }

    public void removeTabClosableListener(TabClosableListener l) {
        this.tabClosableListeners.remove(l);
    }

    @Override
    public void setImage(Image img) {
        this.image = img;
        for (Integer k : this.bitmapNumbers.keySet()) {
            this.setIconAt(k, this.image != null ? this.getIcon((Integer)this.bitmapNumbers.get(k)) : null);
        }
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setBitmapWidth(int w) {
        this.bitmapWidth = w;
    }

    @Override
    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    @Override
    public int myremoveTabAt(int idx) {
        this.removePanel(idx + 1);
        return idx;
    }

    public ImageIcon getIcon(int strip) {
        if (strip > 0) {
            Image imageStrip = ScreenUtility.getImage(this.bitmapWidth, -1, this.image, strip);
            if (imageStrip != null) {
                return new ImageIcon(imageStrip);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setBitmapNumberAt(int idx, int bn) {
        if (bn > 0) {
            this.bitmapNumbers.put(new Integer(idx), new Integer(bn));
        } else {
            this.bitmapNumbers.remove(new Integer(idx));
        }
        this.setIconAt(idx, this.getIcon(bn));
    }

    @Override
    public void setIconAt(int idx, ImageIcon newIcon) {
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).setIcon(newIcon);
        }
    }

    @Override
    public String mygetTitleAt(int idx) {
        String Return2 = "";
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            Return2 = ((ChildPanel2)obj).getTitleAt();
        }
        if (Return2 == null) {
            Return2 = "";
        }
        return Return2;
    }

    @Override
    public void mysetTitleAt(int idx, String title, JTabbedPane jtp) {
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).setTitleAt(title);
        }
    }

    @Override
    public void setHintAt(int idx, String title, JTabbedPane jtp) {
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).setToolTipText(title);
        }
    }

    @Override
    public String getHintAt(int idx) {
        String Return2 = "";
        Component obj = null;
        obj = this.getComponent(this.childCount - idx - 1);
        if (obj != null && obj instanceof ChildPanel2) {
            Return2 = ((ChildPanel2)obj).getToolTipText();
        }
        if (Return2 == null) {
            Return2 = "";
        }
        return Return2;
    }

    @Override
    public void setTabPlacement(int tp) {
    }

    @Override
    public void removeAllTabs() {
        this.childCount = 0;
        this.removeAll();
    }

    @Override
    public JTabbedPane getJTabbedPane() {
        return null;
    }

    @Override
    public Integer getPosition(Integer idx) {
        return new Integer(-1);
    }

    @Override
    public void setTextNoRotate(boolean tnr) {
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            ((ChildPanel2)c[j]).setToolTipText(text);
        }
    }

    @Override
    public ImageIcon toGray(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image grayImage = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
            return new ImageIcon(grayImage);
        }
        return null;
    }

    public void fireTabWillChangeEvent(int i) throws TabChangeException {
        if (i >= 0 && i < this.getTabCount()) {
            TabWillChangeEvent evt = new TabWillChangeEvent(this, i);
            Enumeration e = this.tabWillChangeListeners.elements();
            while (e.hasMoreElements()) {
                TabWillChangeListener l = (TabWillChangeListener)e.nextElement();
                l.stateWillChange(evt);
            }
        }
    }

    @Override
    public void mydoLayout() {
    }

    @Override
    public void setBackground(Color bg) {
        this.bg = bg;
        super.setBackground(bg);
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            ((ChildPanel2)c[j]).setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.fg = fg;
        super.setForeground(fg);
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            ((ChildPanel2)c[j]).setForeground(fg);
        }
    }

    @Override
    public Font getFont() {
        return this.font != null ? this.font : super.getFont();
    }

    @Override
    public void setFont(Font f) {
        if (!(f == null || this.font != null && this.font.equals(f))) {
            final int btnh = this.getBtnHeight(f);
            this.font = f;
            super.setFont(f);
            Component[] c = this.getComponents();
            if (c != null) {
                for (int j = 0; j < c.length; ++j) {
                    ((ChildPanel2)c[j]).setFont(f);
                }
            }
            if (btnh != this.BTN_HEIGHT) {
                this.BTN_HEIGHT = btnh;
                if (this.childCount > 0) {
                    new IsguiWorker(false){

                        @Override
                        public void launch() {
                            TabAccordion.this.intrepaintpanel(btnh);
                        }
                    }.start();
                }
                this.doLayout();
            }
        }
    }

    private int getBtnHeight(Font f) {
        FontMetrics fm = this.getFontMetrics(f);
        return Math.max(fm.getHeight() + 4, 25);
    }

    @Override
    public void destroy() {
    }

    public void destroy(Hashtable childGraphics) {
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            ((ChildPanel2)c[j]).removeAll();
        }
        this.removeAll();
    }

    public void keyPressed(KeyEvent e) {
        if (this.kl != null) {
            this.kl.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void add(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
        if (rbgc != null && rbgc.getComponent() != null) {
            if (tabindex >= 0 && tabindex < this.getTabCount()) {
                this.intadd(rbgc, index, tabindex, childGraphics);
            } else {
                if (this.addtabidxvect == null) {
                    this.addtabidxvect = new Vector();
                }
                this.addtabidxvect.add(new Rbgctotabidx(rbgc, index, tabindex, childGraphics));
            }
        }
    }

    private void intadd(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
        MyPanel panel = null;
        LayoutManager lm = null;
        panel = this.getMyAccordionPanel(this.getTabCount() - 1 - tabindex);
        if (panel != null) {
            Component c = (Component)((Object)rbgc.getComponent());
            if (!this.relativeoffset) {
                IscobolLayout.LayoutData lData;
                Point p = this.getLocation();
                if (rbgc.getParentWindow() != null && (lm = rbgc.getParentWindow().getLayout()) != null && lm instanceof IscobolLayout && (lData = ((IscobolLayout)lm).getLayoutData(this)) != null) {
                    p = new Point(lData.getOrigBounds().x, lData.getOrigBounds().y);
                }
                Point pmp = panel.getLocation();
                pmp.x = 0;
                pmp.y = 0;
                Point pc = c.getLocation();
                pc.y -= pmp.y + p.y;
                pc.x -= pmp.x + p.x;
                pc.y += 5;
                if (tabindex >= 0) {
                    pc.y -= this.BTN_HEIGHT;
                }
                if (rbgc.getParentWindow() != null && (lm = rbgc.getParentWindow().getLayout()) != null) {
                    if (lm instanceof IscobolLayout) {
                        IscobolLayout.LayoutData lData2 = ((IscobolLayout)lm).getLayoutData(c);
                        rbgc.alreadyloc = true;
                        if (lData2 != null) {
                            rbgc.setLocation(pc.x, pc.y, false);
                        } else {
                            c.setLocation(pc);
                        }
                    }
                } else {
                    c.setLocation(pc);
                }
            }
            RemoteBaseGUIControl crbgc = null;
            Component[] controls = panel.getComponents();
            for (index = 0; index < controls.length; ++index) {
                if (controls[index] == rbgc.getComponent()) {
                    return;
                }
                crbgc = (RemoteBaseGUIControl)childGraphics.get(controls[index]);
                if (RemoteDisplayWindow.shouldInsertBefore(rbgc, crbgc)) break;
            }
            panel.add(c, index);
        }
    }

    public boolean isAlreadyAdd(RemoteBaseGUIControl rbgc, int tabindex) {
        boolean Return2 = false;
        MyPanel panel = null;
        Object lm = null;
        panel = this.getMyAccordionPanel(this.getTabCount() - 1 - tabindex);
        if (panel != null) {
            Component[] controls = panel.getComponents();
            for (int index = 0; index < controls.length; ++index) {
                if (controls[index] != rbgc.getComponent()) continue;
                Return2 = true;
            }
        }
        return Return2;
    }

    public Container getPanelAt(int tabIndex) {
        return this.getMyAccordionPanel(tabIndex);
    }

    private MyPanel getMyAccordionPanel(int tabindex) {
        Component obj = null;
        obj = this.getComponent(tabindex);
        if (obj != null && obj instanceof ChildPanel2) {
            return ((ChildPanel2)obj).getMyAccordionPanel();
        }
        return null;
    }

    protected void resetLayoutManager() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            LayoutManager lm;
            MyPanel mp = this.getMyAccordionPanel(i);
            if (mp == null || !((lm = mp.getLayout()) instanceof IscobolLayout)) continue;
            ((IscobolLayout)lm).setOriginalContainerSize(null);
        }
    }

    @Override
    public void doLayout() {
        new IsguiWorker(false){

            @Override
            public void launch() {
                TabAccordion.super.doLayout();
            }
        }.start();
    }

    public Point convertXY(String name, Point pc, int tabindex, Rectangle origBoundsLayout) {
        MyPanel panel = null;
        int tabcount = this.getTabCount();
        if (tabindex < tabcount && (panel = this.getMyAccordionPanel(tabindex)) != null && !this.relativeoffset) {
            Point p = this.getLocation();
            if (origBoundsLayout != null) {
                p = new Point(origBoundsLayout.x, origBoundsLayout.y);
            }
            Point pmp = panel.getLocation();
            pmp.x = 0;
            pmp.y = 0;
            pc.y -= pmp.y + p.y;
            pc.x -= pmp.x + p.x;
            pc.y += 5;
            if (tabindex >= 0) {
                pc.y -= this.BTN_HEIGHT;
            }
        }
        return pc;
    }

    @Override
    public boolean modifypanels() {
        return false;
    }

    public void setActiveAccept(boolean b) {
        if (b) {
            this.setActiveBGFG();
        }
    }

    @Override
    public JPanel getBorderedPane() {
        return null;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return null;
    }

    @Override
    public int addTab(RemoteTab rt, String label, int insertionIndex, JTabbedPane jtp, int tabw, int tabh) {
        if (this.childCount > 1 && this.getVisibleIndex() != this.childCount - 1) {
            this.setChildVisible(this.childCount - 1, true);
        }
        ++this.childCount;
        if (insertionIndex >= 0 && insertionIndex < this.getTabCount()) {
            this.addPanel(rt, insertionIndex, label, tabw, tabh, this.bg, this.fg);
        } else {
            this.addPanel(rt, this.getTabCount(), label, tabw, tabh, this.bg, this.fg);
            insertionIndex = this.getTabCount() - 1;
        }
        this.setChildVisible(this.selectedIndex, true);
        if (this.addtabidxvect != null) {
            this.doLayout();
            ListIterator ctlLI = this.addtabidxvect.listIterator(0);
            Rbgctotabidx ri = null;
            while (ctlLI.hasNext()) {
                ri = (Rbgctotabidx)ctlLI.next();
                if (ri == null || ri.getTabIndex() != insertionIndex || ri.getTabIndex() >= this.getTabCount()) continue;
                this.intadd(ri.getRbgc(), ri.getIndex(), ri.getTabIndex(), ri.getChildGraphics());
                ctlLI.remove();
            }
        }
        return insertionIndex;
    }

    public void addPanel(RemoteTab rt, int idx, String label, int tabw, int tabh, Color bg, Color fg) {
        int childpanel2height = this.HEIGHT - 1 - (this.childCount - 1) * this.BTN_HEIGHT;
        Component obj = null;
        ChildPanel2 child = null;
        int count = this.getComponentCount();
        int addchildh = 0;
        int j = 0;
        for (j = 0; j < this.childCount - 1; ++j) {
            obj = null;
            child = null;
            if (j < count) {
                obj = this.getComponent(j);
            }
            if (obj != null && obj instanceof ChildPanel2) {
                child = (ChildPanel2)obj;
                int childbounds_y = child.getid() * this.BTN_HEIGHT;
                if (j < this.childCount - idx) {
                    child.setBounds(0, childbounds_y, this.WIDTH, childpanel2height);
                    child.setid(this.childCount - j);
                } else {
                    child.setPreferredSize(new Dimension(this.WIDTH, childpanel2height));
                    child.setSize(new Dimension(this.WIDTH, childpanel2height));
                }
                child.validate();
            }
            if (j != this.childCount - idx) continue;
            addchildh = (idx - 1) * this.BTN_HEIGHT;
        }
        child = new ChildPanel2(rt, idx, label, this, this.name, this.istabclosebutton);
        child.setFont(this.getFont());
        this.add((Component)child, this.childCount - idx);
        child.setBounds(0, addchildh, this.WIDTH, childpanel2height);
        child.getMyAccordionPanel().setSize(tabw, tabh);
        if (bg != null) {
            child.setBackground(bg);
            child.getMyAccordionPanel().setBackground(bg);
        }
        if (fg != null) {
            child.setForeground(fg);
            child.getMyAccordionPanel().setForeground(fg);
        }
        if (this.kl != null) {
            child.addKeyListener(this.kl);
        }
        if (this.ml != null) {
            child.removeMouseListener(this.ml);
        }
        child.validate();
        this.visibleIndex = this.childCount - 1;
        this.validate();
    }

    public void removePanel(int idx) {
        if (this.childCount > 1 && this.getVisibleIndex() != this.childCount - 1) {
            this.setChildVisible(this.childCount - 1, true);
        }
        Component obj = null;
        if (this.childCount == 0 || idx > this.childCount) {
            return;
        }
        if (this.childCount == 1) {
            if (this.getComponentCount() == 1 && (obj = this.getComponent(0)) != null && obj instanceof ChildPanel2) {
                ((ChildPanel2)obj).setVisible(false);
                this.remove(0);
            }
            --this.childCount;
            this.validate();
            return;
        }
        int childpanel2height = this.HEIGHT - 1 - (this.childCount - 2) * this.BTN_HEIGHT;
        ChildPanel2 child = null;
        int j = 0;
        if (idx > 0 && idx <= this.childCount) {
            this.remove(this.childCount - idx);
            int count = this.getComponentCount();
            for (j = 0; j <= count; ++j) {
                obj = null;
                child = null;
                if (j < count) {
                    obj = this.getComponent(j);
                }
                if (obj == null || !(obj instanceof ChildPanel2)) continue;
                child = (ChildPanel2)obj;
                if (j <= count - idx) {
                    child.setBounds(0, child.getBounds().y - this.BTN_HEIGHT, this.WIDTH, childpanel2height);
                    child.setid(count - j);
                } else {
                    child.setPreferredSize(new Dimension(this.WIDTH, childpanel2height));
                    child.setSize(new Dimension(this.WIDTH, childpanel2height));
                }
                child.validate();
            }
        }
        --this.childCount;
        if (this.childCount == this.selectedIndex) {
            --this.selectedIndex;
        }
        this.visibleIndex = this.childCount - 1;
        this.setChildVisible(this.selectedIndex, true);
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintPanel(int btnh) {
        MyBoolean myBoolean = this.bb;
        synchronized (myBoolean) {
            if (!this.bb.getValue()) {
                return;
            }
            this.bb.setValue(false);
            this.intrepaintpanel(btnh);
            this.bb.setValue(true);
        }
    }

    private void intrepaintpanel(int btnh) {
        int childpanel2height = 0;
        childpanel2height = this.HEIGHT - 1 - (this.childCount - 1) * this.BTN_HEIGHT;
        Component obj = null;
        ChildPanel2 child = null;
        int count = this.getComponentCount();
        this.repaintingcomponents = true;
        int i = this.childCount - 1;
        for (int j = 0; i >= 0 && j < this.childCount; --i, ++j) {
            obj = null;
            child = null;
            if (j < count) {
                obj = this.getComponent(i);
            }
            if (obj == null || !(obj instanceof ChildPanel2)) continue;
            child = (ChildPanel2)obj;
            int childbounds_y = (child.getid() - 1) * this.BTN_HEIGHT;
            if (j > this.visibleIndex) {
                childbounds_y += childpanel2height - this.BTN_HEIGHT;
            }
            child.setBounds(0, childbounds_y, this.WIDTH, childpanel2height);
            child.validate();
            child.getControlPanel().validate();
            child.doLayout();
        }
        this.validate();
        this.repaintingcomponents = false;
    }

    public boolean getMovingComponents() {
        return this.movingcomponents || this.repaintingcomponents;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public void setremovePanel(int rp) {
    }

    public void setaddPanel(int rp) {
    }

    private void setZOrder() {
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length - 1; ++j) {
            this.setComponentZOrder(c[j], c.length - 1 - j);
        }
    }

    public void setChildVisible(int indexToOpen) {
        this.setChildVisible(indexToOpen, false);
    }

    public void setChildVisible(int indexToOpen, boolean force) {
        MyPanel panel = null;
        if (this.visibleIndex >= 0 && this.childCount > 0 && (panel = this.getMyAccordionPanel(this.getTabCount() - 1 - this.visibleIndex)) != null) {
            panel.setVisible(false);
        }
        int[] indices = new int[]{};
        int travelLimitH = 0;
        int travelLimitW = 0;
        int n = 0;
        int saveindexToOpen = -1;
        if (this.visibleIndex == -1) {
            saveindexToOpen = indexToOpen;
            this.visibleIndex = 0;
            indexToOpen = 0;
            travelLimitH = this.BTN_HEIGHT - (this.getComponentCount() > 0 ? this.getComponent(0).getHeight() : 0);
            travelLimitW = 0;
            n = 1;
            indices = new int[]{0};
            force = false;
        }
        if (this.visibleIndex < indexToOpen) {
            travelLimitH = this.BTN_HEIGHT - this.getComponent(this.visibleIndex).getHeight();
            travelLimitW = this.BTN_HEIGHT - this.getComponent(this.visibleIndex).getWidth();
            n = indexToOpen - this.visibleIndex;
            indices = new int[n];
            int j = this.visibleIndex;
            int k = 0;
            while (j < indexToOpen) {
                indices[k] = j + 1;
                ++j;
                ++k;
            }
        } else if (this.visibleIndex > indexToOpen) {
            travelLimitH = this.getComponent(this.visibleIndex).getHeight() - this.BTN_HEIGHT;
            travelLimitW = this.getComponent(this.visibleIndex).getWidth() - this.BTN_HEIGHT;
            n = this.visibleIndex - indexToOpen;
            indices = new int[n];
            int j = indexToOpen;
            int k = 0;
            while (j < this.visibleIndex) {
                indices[k] = j + 1;
                ++j;
                ++k;
            }
        }
        this.movePanels(indices, travelLimitH, travelLimitW, force);
        this.visibleIndex = indexToOpen;
        panel = null;
        panel = this.selectedIndex >= 0 ? this.getMyAccordionPanel(this.getTabCount() - 1 - this.selectedIndex) : this.getMyAccordionPanel(this.getTabCount() - 1 - this.visibleIndex);
        if (panel != null) {
            panel.setVisible(true);
        }
        if (saveindexToOpen >= 0) {
            this.setChildVisible(saveindexToOpen, force);
        }
    }

    private void movePanels(final int[] indices, final int travelH, final int travelW, final boolean force) {
        this.movingcomponents = true;
        if (force) {
            this.intmovePanels(indices, travelH, travelW, force);
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TabAccordion.this.intmovePanels(indices, travelH, travelW, force);
                }
            });
            thread.setPriority(5);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intmovePanels(int[] indices, int travelH, int travelW, boolean force) {
        int travel = travelH;
        Component[] c = this.getComponents();
        int delta = 1;
        int limit = travel > 0 ? travel : 0;
        int count = travel > 0 ? 0 : travel;
        int dxy = travel > 0 ? delta : -delta;
        int tabdelayloc = 0;
        if (!force && this.tabdelay > 0) {
            if (limit > 0) {
                tabdelayloc = this.tabdelay / limit;
            } else if (count != 0) {
                tabdelayloc = this.tabdelay / count;
            }
            if (tabdelayloc < 0) {
                tabdelayloc *= -1;
            }
        }
        MyBoolean myBoolean = this.bb;
        synchronized (myBoolean) {
            Point p;
            int index;
            if (!this.bb.getValue()) {
                return;
            }
            this.bb.setValue(false);
            int savedelta = delta;
            int savedxy = dxy;
            if (!force) {
                if (tabdelayloc >= 4 && tabdelayloc <= 10) {
                    if (limit > 500 || count > 500) {
                        tabdelayloc *= 2;
                        dxy *= 10;
                        delta *= 10;
                    } else {
                        tabdelayloc *= 3;
                        dxy *= 5;
                        delta *= 5;
                    }
                } else if (tabdelayloc == 3) {
                    tabdelayloc = limit > 500 || count > 500 ? (tabdelayloc *= 2) : (tabdelayloc *= 5);
                    dxy *= 10;
                    delta *= 10;
                } else if (tabdelayloc <= 2) {
                    dxy *= 20;
                    delta *= 20;
                }
            }
            while (count < limit) {
                if (!force && tabdelayloc > 0) {
                    try {
                        Thread.sleep(tabdelayloc);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                for (int j = 0; j < indices.length; ++j) {
                    index = c.length - 1 - indices[j];
                    if (index < 0 || index >= c.length) continue;
                    p = c[index].getLocation();
                    p.y += dxy;
                    c[index].setLocation(p.x, p.y);
                }
                if ((count += delta) + delta <= limit) continue;
                delta = savedelta;
                dxy = savedxy;
            }
            if (count < limit - 1) {
                for (int j = 0; j < indices.length; ++j) {
                    index = c.length - 1 - indices[j];
                    p = c[index].getLocation();
                    p.y += limit - count - 1;
                    c[index].setLocation(p.x, p.y);
                }
            }
            this.repaint();
            this.movingcomponents = false;
            this.bb.setValue(true);
        }
    }

    @Override
    public void requestFocus() {
        Component obj = null;
        obj = this.getComponent(this.childCount - 1 - this.visibleIndex);
        if (obj != null && obj instanceof ChildPanel2) {
            ((ChildPanel2)obj).requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        Component obj = null;
        obj = this.getComponent(this.childCount - 1 - this.visibleIndex);
        if (obj != null && obj instanceof ChildPanel2) {
            return ((ChildPanel2)obj).requestFocusInWindow();
        }
        return false;
    }

    private void debugpanels(String s) {
        Component[] c = this.getComponents();
        for (int j = 0; j < c.length; ++j) {
            System.out.println(s + " j [" + j + "] id [" + ((ChildPanel2)c[j]).getid() + "] zo [" + this.getComponentZOrder(c[j]) + "] txt [" + ((ChildPanel2)c[j]).getid() + "] txt [" + ((ChildPanel2)c[j]).gettitlebutton() + "] [" + c[j].getBounds() + "]");
        }
    }

    @Override
    public Component getComponent(int idx) {
        if (idx >= 0 && idx < this.getComponentCount()) {
            return super.getComponent(idx);
        }
        return null;
    }

    public Color getTabBackgroundColor() {
        return this.tabbackgroundcolor;
    }

    @Override
    public void setTabBackgroundColor(Color c) {
        this.tabbackgroundcolor = c;
        Component obj = null;
        ChildPanel2 child = null;
        int count = this.getComponentCount();
        int j = 0;
        for (j = 0; j < this.childCount - 1; ++j) {
            obj = null;
            child = null;
            if (j < count) {
                obj = this.getComponent(j);
            }
            if (obj == null || !(obj instanceof ChildPanel2)) continue;
            child = (ChildPanel2)obj;
            child.setTabBackgroundColor(c);
        }
    }

    public Color getTabForegroundColor() {
        return this.tabforegroundcolor;
    }

    @Override
    public void setTabForegroundColor(Color c) {
        this.tabforegroundcolor = c;
        Component obj = null;
        ChildPanel2 child = null;
        int count = this.getComponentCount();
        int j = 0;
        for (j = 0; j < this.childCount - 1; ++j) {
            obj = null;
            child = null;
            if (j < count) {
                obj = this.getComponent(j);
            }
            if (obj == null || !(obj instanceof ChildPanel2)) continue;
            child = (ChildPanel2)obj;
            child.setTabForegroundColor(c);
        }
    }

    @Override
    public void setActiveTabBackgroundColor(Color c) {
        this.activetabbg = c;
    }

    @Override
    public void setActiveTabForegroundColor(Color c) {
        this.activetabfg = c;
    }

    public void setTabRolloverColor(int c) {
        this.setTabRolloverColor(c, false);
    }

    public void setTabRolloverColor(int c, boolean isrgb) {
    }

    public void setTabDelay(int d) {
        this.tabdelay = d;
    }

    public boolean getTabFlat() {
        return this.istabflat;
    }

    public void setTabFlat(boolean f) {
        this.istabflat = f;
        Component obj = null;
        ChildPanel2 child = null;
        int count = this.getComponentCount();
        int j = 0;
        for (j = 0; j < this.childCount - 1; ++j) {
            obj = null;
            child = null;
            if (j < count) {
                obj = this.getComponent(j);
            }
            if (obj == null || !(obj instanceof ChildPanel2)) continue;
            child = (ChildPanel2)obj;
            child.setTabFlat(this.istabflat);
        }
    }

    public void setTabRolloverBackgroundColor(Color c) {
        this.tabrolloverbackgroundcolor = c;
    }

    public void setTabRolloverForegroundColor(Color c) {
        this.tabrolloverforegroundcolor = c;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    @Override
    public void setBorderWidth(int[] borderwidth) {
    }

    @Override
    public void setActiveBorderWidth(int[] borderwidth) {
    }

    @Override
    public void setBorderForegroundColor(Color c) {
    }

    @Override
    public void setActiveBorderForegroundColor(Color c) {
    }

    @Override
    public void addTabWidths(int insertionIndex, int fw, int fh, Integer w) {
    }

    @Override
    public void setImageMouseEntered(Image me) {
        this.imagemouseentered = me;
    }

    @Override
    public void setImageMouseExited(Image me) {
        this.imagemouseexited = me;
    }

    class Etichetta
    extends JLabel
    implements MouseListener {
        ImageIcon x1;
        ImageIcon x2;
        Image transparentImg;
        Image mouseentered;
        Image mouseexited;
        private ControlPanel2 parent = null;

        Etichetta(ControlPanel2 parent, Image mouseentered, Image mouseexited) {
            this.parent = parent;
            this.mouseentered = mouseentered;
            this.mouseexited = mouseexited;
            this.x1 = mouseentered != null ? new ImageIcon(mouseentered) : new ImageIcon(this.getClass().getResource("tabcloseup.png"), "x");
            this.x2 = mouseexited != null ? new ImageIcon(mouseexited) : new ImageIcon(this.getClass().getResource("tabclosedown.png"), "x");
            int iconw = this.x2.getIconWidth();
            int iconh = this.x2.getIconHeight();
            if (this.x1.getIconWidth() > iconw) {
                iconw = this.x1.getIconWidth();
            }
            if (this.x1.getIconHeight() > iconh) {
                iconh = this.x1.getIconHeight();
            }
            Dimension size = new Dimension(iconw, iconh);
            RGBImageFilter filter = new RGBImageFilter(){
                int transparentColor = Color.white.getRGB() | 0xFF000000;

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == this.transparentColor) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            FilteredImageSource filteredImgProd = new FilteredImageSource(this.x2.getImage().getSource(), filter);
            this.transparentImg = Toolkit.getDefaultToolkit().createImage(filteredImgProd);
            this.setIcon(new ImageIcon(this.transparentImg));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.parent.myactionPerformed();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setVisible(true);
            this.setIcon(this.x1);
            this.parent.setfb();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setVisible(false);
            this.setIcon(new ImageIcon(this.transparentImg));
        }

        public ImageIcon createImageIcon(String path) {
            URL imgURL = this.getClass().getResource(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL);
            }
            return null;
        }
    }

    private class Rbgctotabidx {
        RemoteBaseGUIControl rbgc;
        int index;
        int tabindex;
        Hashtable childGraphics;

        public Rbgctotabidx(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
            this.rbgc = rbgc;
            this.index = index;
            this.tabindex = tabindex;
            this.childGraphics = childGraphics;
        }

        public RemoteBaseGUIControl getRbgc() {
            return this.rbgc;
        }

        public int getIndex() {
            return this.index;
        }

        public int getTabIndex() {
            return this.tabindex;
        }

        public Hashtable getChildGraphics() {
            return this.childGraphics;
        }
    }

    private class ControlPanel2
    extends JPanel {
        int id;
        JButton titleButton;
        boolean istabflat;
        boolean istabclosebutton;
        Color bgsave;
        Color fgsave;
        boolean fb = true;
        Etichetta et = null;

        public ControlPanel2(int id, final TabAccordion parent, String label, String name, boolean istabclosebutton) {
            this.id = id;
            this.istabclosebutton = istabclosebutton;
            this.setLayout(new BorderLayout());
            this.titleButton = new JButton(label != null ? label : "Panel " + id);
            if (istabclosebutton) {
                this.et = new Etichetta(this, TabAccordion.this.imagemouseentered, TabAccordion.this.imagemouseexited);
                Box bx = Box.createHorizontalBox();
                bx.add(Box.createHorizontalGlue());
                bx.add(this.et);
                this.titleButton.add(bx);
            }
            this.add(this.titleButton);
            if (this.et != null) {
                this.et.setVisible(false);
            }
            if (name != null) {
                this.titleButton.setName(name);
            }
            this.titleButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ControlPanel2.this.et != null) {
                        ControlPanel2.this.et.setVisible(true);
                    }
                    if (TabAccordion.this.tabrolloverforegroundcolor != null) {
                        if (ControlPanel2.this.fgsave == null) {
                            ControlPanel2.this.fgsave = ControlPanel2.this.titleButton.getForeground();
                        }
                        ControlPanel2.this.titleButton.setForeground(TabAccordion.this.tabrolloverforegroundcolor);
                    }
                    if (TabAccordion.this.tabrolloverbackgroundcolor != null) {
                        if (ControlPanel2.this.bgsave == null) {
                            ControlPanel2.this.bgsave = ControlPanel2.this.titleButton.getBackground();
                        }
                        ControlPanel2.this.titleButton.setBackground(TabAccordion.this.tabrolloverbackgroundcolor);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ControlPanel2.this.et != null) {
                        ControlPanel2.this.et.setVisible(false);
                    }
                    if (ControlPanel2.this.fgsave != null) {
                        ControlPanel2.this.titleButton.setForeground(ControlPanel2.this.fgsave);
                    }
                    if (ControlPanel2.this.bgsave != null) {
                        ControlPanel2.this.titleButton.setBackground(ControlPanel2.this.bgsave);
                    }
                    ControlPanel2.this.bgsave = null;
                    ControlPanel2.this.fgsave = null;
                }
            });
            Dimension d = this.getPreferredSize();
            d.height = TabAccordion.this.BTN_HEIGHT;
            this.setPreferredSize(d);
            this.titleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!parent.getMovingComponents()) {
                        try {
                            TabAccordion.this.fireTabWillChangeEvent(ControlPanel2.this.getid() - 1);
                        }
                        catch (TabChangeException tabChangeException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.setTabFlat(parent.getTabFlat());
            if (parent.getTabBackgroundColor() != null) {
                this.setTabBackgroundColor(parent.getTabBackgroundColor());
            }
            if (parent.getTabForegroundColor() != null) {
                this.setTabForegroundColor(parent.getTabForegroundColor());
            }
        }

        public void setfb() {
            if (TabAccordion.this.tabrolloverforegroundcolor != null) {
                this.fgsave = this.titleButton.getForeground();
                this.titleButton.setForeground(TabAccordion.this.tabrolloverforegroundcolor);
            }
            if (TabAccordion.this.tabrolloverbackgroundcolor != null) {
                this.bgsave = this.titleButton.getBackground();
                this.titleButton.setBackground(TabAccordion.this.tabrolloverbackgroundcolor);
            }
        }

        @Override
        public void addKeyListener(KeyListener kl) {
            super.addKeyListener(kl);
            this.titleButton.addKeyListener(kl);
        }

        @Override
        public void removeKeyListener(KeyListener kl) {
            super.removeKeyListener(kl);
            this.titleButton.removeKeyListener(kl);
        }

        public int getid() {
            return this.id;
        }

        public void setid(int id) {
            this.id = id;
        }

        public void setIcon(ImageIcon img) {
            this.titleButton.setIcon(img);
        }

        @Override
        public void setEnabled(boolean e) {
            super.setEnabled(e);
            this.titleButton.setEnabled(e);
        }

        public void setAlignment(String a) {
            if (a != null) {
                if (a.equalsIgnoreCase("L")) {
                    this.titleButton.setHorizontalAlignment(2);
                } else if (a.equalsIgnoreCase("R")) {
                    this.titleButton.setHorizontalAlignment(4);
                } else if (a.equalsIgnoreCase("C")) {
                    this.titleButton.setHorizontalAlignment(0);
                }
            }
        }

        public void setTitleAt(String txt) {
            this.titleButton.setText(txt);
        }

        public String getTitleAt() {
            return this.titleButton.getText();
        }

        @Override
        public void setToolTipText(String txt) {
            this.titleButton.setToolTipText(txt);
            if (this.et != null) {
                this.et.setToolTipText(txt);
            }
        }

        @Override
        public String getToolTipText() {
            return this.titleButton.getToolTipText();
        }

        @Override
        public void requestFocus() {
            this.titleButton.requestFocus();
        }

        @Override
        public boolean requestFocusInWindow() {
            return this.titleButton.requestFocusInWindow();
        }

        public void setTabBackgroundColor(Color c) {
            if (this.bgsave != null) {
                this.bgsave = c;
            }
            this.titleButton.setBackground(c);
            this.setBackground(c);
        }

        public void setTabForegroundColor(Color c) {
            if (this.fgsave != null) {
                this.fgsave = c;
            }
            this.titleButton.setForeground(c);
            this.setForeground(c);
        }

        public void setTabFlat(boolean f) {
            if (f) {
                this.titleButton.setBorderPainted(false);
                this.titleButton.setContentAreaFilled(false);
            } else {
                this.titleButton.setBorderPainted(true);
                this.titleButton.setContentAreaFilled(true);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = TabAccordion.this.BTN_HEIGHT;
            return d;
        }

        public void myactionPerformed() {
            TabClosableEvent evt = new TabClosableEvent(this, this.getid() - 1);
            Enumeration e = TabAccordion.this.tabClosableListeners.elements();
            while (e.hasMoreElements()) {
                TabClosableListener l = (TabClosableListener)e.nextElement();
                l.sendClosableTab(evt);
            }
        }

        public JButton getTitleButton() {
            return this.titleButton;
        }
    }

    private class ChildPanel2
    extends JPanel {
        int id;
        ControlPanel2 cp2;
        MyPanel jp;
        TabAccordion parent;
        Font fontcp2;
        RemoteTab rt;

        public ChildPanel2(RemoteTab rt, int id, String label, TabAccordion parent, String name, boolean istabclosebutton) {
            this.id = id;
            this.rt = rt;
            this.parent = parent;
            this.setLayout(new BorderLayout());
            this.cp2 = new ControlPanel2(id, parent, label != null ? label : "", name, istabclosebutton);
            this.add((Component)this.cp2, "North");
            this.jp = new MyPanel(rt, id);
            this.add((Component)this.jp, "Center");
            this.jp.setLayout(null);
            this.jp.setVisible(false);
            this.cp2.setTabFlat(parent.getTabFlat());
            if (parent.getTabBackgroundColor() != null) {
                this.cp2.setTabBackgroundColor(parent.getTabBackgroundColor());
            }
            if (parent.getTabForegroundColor() != null) {
                this.cp2.setTabForegroundColor(parent.getTabForegroundColor());
            }
            if (this.fontcp2 != null) {
                this.cp2.titleButton.setFont(this.fontcp2);
                this.cp2.titleButton.revalidate();
                this.fontcp2 = null;
            }
        }

        public int getid() {
            return this.id;
        }

        public void setid(int id) {
            this.id = id;
            this.cp2.setid(id);
            this.jp.setid(id);
        }

        public String gettitlebutton() {
            return "LABEL " + this.id;
        }

        public ControlPanel2 getControlPanel() {
            return this.cp2;
        }

        public MyPanel getMyAccordionPanel() {
            return this.jp;
        }

        public void setIcon(ImageIcon img) {
            this.cp2.setIcon(img);
        }

        @Override
        public void setEnabled(boolean e) {
            super.setEnabled(e);
            this.cp2.setEnabled(e);
            this.jp.setEnabled(e);
        }

        public void setAlignment(String a) {
            this.cp2.setAlignment(a);
        }

        @Override
        public void addKeyListener(KeyListener kl) {
            super.addKeyListener(kl);
            this.cp2.addKeyListener(kl);
            this.jp.addKeyListener(kl);
        }

        @Override
        public void removeKeyListener(KeyListener kl) {
            super.removeKeyListener(kl);
            this.cp2.removeKeyListener(kl);
            this.jp.removeKeyListener(kl);
        }

        public void setTitleAt(String txt) {
            this.cp2.setTitleAt(txt);
        }

        public String getTitleAt() {
            return this.cp2.getTitleAt();
        }

        @Override
        public void setToolTipText(String txt) {
            this.cp2.setToolTipText(txt);
        }

        @Override
        public String getToolTipText() {
            return this.cp2.getToolTipText();
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.cp2 != null && this.parent.getTabBackgroundColor() == null) {
                this.cp2.setBackground(bg);
            }
            if (this.jp != null) {
                this.jp.setBackground(bg);
            }
        }

        @Override
        public void setForeground(Color fg) {
            super.setForeground(fg);
            if (this.cp2 != null && this.parent.getTabForegroundColor() == null) {
                this.cp2.setForeground(fg);
            }
            if (this.jp != null) {
                this.jp.setForeground(fg);
            }
        }

        @Override
        public void setFont(Font f) {
            super.setFont(f);
            if (this.cp2 != null) {
                this.cp2.titleButton.setFont(f);
                this.cp2.titleButton.revalidate();
            } else {
                this.fontcp2 = f;
            }
        }

        @Override
        public void removeAll() {
            super.removeAll();
            this.cp2.removeAll();
            this.jp.removeAll();
        }

        @Override
        public void requestFocus() {
            this.cp2.requestFocus();
        }

        @Override
        public boolean requestFocusInWindow() {
            return this.cp2.requestFocusInWindow();
        }

        public void setTabFlat(boolean f) {
            this.cp2.setTabFlat(f);
        }

        public void setTabForegroundColor(Color c) {
            this.cp2.setTabForegroundColor(c);
        }

        public void setTabBackgroundColor(Color c) {
            this.cp2.setTabBackgroundColor(c);
        }
    }

    private class MyPanel
    extends JPanel {
        private int id;
        private RemoteTab parent;

        public MyPanel(RemoteTab parent, int id) {
            this.parent = parent;
            this.id = id;
            TabAccordion.this.gradientMgr.addPropertyChangeListener(e -> this.repaint());
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            TabAccordion.this.gradientMgr.paint((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }

        public int getid() {
            return this.id;
        }

        public void setid(int id) {
            this.id = id;
        }

        @Override
        public LayoutManager getLayout() {
            if (this.parent != null && this.parent.getLayout() instanceof IscobolLayout) {
                return this.parent.getLayout();
            }
            return super.getLayout();
        }
    }

    private class MyBoolean {
        private boolean b;

        public MyBoolean(boolean b) {
            this.b = b;
        }

        public boolean getValue() {
            if (SwingUtilities.isEventDispatchThread()) {
                return true;
            }
            return this.b;
        }

        public void setValue(boolean b) {
            this.b = b;
        }
    }
}

