/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.Filterable;
import com.iscobol.gui.client.swing.FlatStyleUI;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.IsTreeViewModel;
import com.iscobol.gui.client.swing.TreeTableView;
import com.iscobol.gui.client.swing.TreeViewEvent;
import com.iscobol.gui.client.swing.TreeViewListener;
import com.iscobol.gui.client.swing.TreeViewNode;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.gui.client.swing.treetable.TreeTableCellRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeView
extends TreeTableCellRenderer {
    private short changeSelectionCause = (short)-1;
    private final MyTreeCellRenderer renderer;
    private Vector<TreeViewListener> treeViewListeners = new Vector();
    private MyTreeCellEditor editor;
    private String toolTipText;
    private TreePath[] selectingPath;
    private TreePath lastMouseSelectedPath;
    private DefaultTreeSelectionModel virtualModel;
    private boolean flat;
    private boolean showRootHandles;
    private FlatStyleUI fsui;
    private boolean processingEvent;
    private int vpadding = 20;
    private Color matchingTextColorBackground = new Color(-10446);
    private Color matchingTextColorForeground = new Color(-13487566);
    private Color matchingTextColor2Background = new Color(-16711936);
    private Color matchingTextColor2Foreground = new Color(-13487566);
    private TreeViewNode currMatchNode;
    private int currMatchNodeIdx;

    public TreeView(IsTreeViewModel model, GradientManager mgr) {
        super(model, null);
        this.renderer = new MyTreeCellRenderer();
        this.setCellRenderer(this.renderer);
        this.setCellEditor(null);
        super.setToolTipText("");
        this.virtualModel = new DefaultTreeSelectionModel();
        this.virtualModel.setRowMapper(this.getSelectionModel().getRowMapper());
        this.setSelectionMode(1);
    }

    void setPaintGradient(boolean pg) {
        this.renderer.showBackground = !pg;
        this.setOpaque(!pg);
    }

    public TreePath[] getSelectingPaths() {
        return this.selectingPath;
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        if (this.getTreeTable() != null) {
            super.setLeadSelectionPath(null);
        }
        this.selectingPath = null;
    }

    @Override
    public void setEditable(boolean e) {
        super.setEditable(e);
        if (e && this.editor == null) {
            JTextField tf = new JTextField();
            this.editor = new MyTreeCellEditor(tf);
            this.setCellEditor(this.editor);
            this.setInvokesStopCellEditing(true);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.editor != null) {
            this.editor.textField.addFocusListener(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        if (this.editor != null) {
            this.editor.textField.removeFocusListener(l);
        }
    }

    @Override
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        if (this.editor != null) {
            this.editor.textField.addKeyListener(l);
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        if (this.editor != null) {
            this.editor.textField.removeKeyListener(l);
        }
    }

    @Override
    public void setFocusable(boolean b) {
        super.setFocusable(b);
        if (this.editor != null) {
            this.editor.textField.setFocusable(b);
        }
    }

    public void addTreeViewListener(TreeViewListener l) {
        this.treeViewListeners.addElement(l);
    }

    public void removeTreeViewListener(TreeViewListener l) {
        this.treeViewListeners.remove(l);
    }

    @Override
    public void scrollPathToVisible(TreePath path) {
        if (path != null) {
            this.makeVisible(path);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                super.scrollRectToVisible(bounds);
                if (this.accessibleContext != null) {
                    ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
    }

    void superScrollRectToVisible(Rectangle r) {
        super.scrollRectToVisible(r);
    }

    @Override
    public void addSelectionInterval(int idx1, int idx2) {
        this.addSelectionPaths(this.getPathBetweenRows(idx1, idx2));
    }

    @Override
    public void addSelectionPath(TreePath path) {
        this.addSelectionPaths(new TreePath[]{path});
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        this.changeVirtualSelection(paths, true);
    }

    @Override
    public void removeSelectionInterval(int idx1, int idx2) {
        this.removeSelectionPaths(this.getPathBetweenRows(idx1, idx2));
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        this.removeSelectionPaths(new TreePath[]{path});
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        this.changeVirtualSelection(paths, false);
    }

    private void changeVirtualSelection(TreePath[] paths, boolean add) {
        TreePath[] sel = this.getSelectionPaths();
        if (sel != null) {
            this.virtualModel.setSelectionPaths(sel);
        } else {
            this.virtualModel.clearSelection();
        }
        if (add) {
            this.virtualModel.addSelectionPaths(paths);
        } else {
            this.virtualModel.removeSelectionPaths(paths);
        }
        sel = this.virtualModel.getSelectionPaths();
        this.setSelectionPaths(sel, false);
    }

    @Override
    public void setSelectionInterval(int idx1, int idx2) {
        this.setSelectionPaths(this.getPathBetweenRows(idx1, idx2), false);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        this.setSelectionPaths(new TreePath[]{path}, false);
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        this.setSelectionPaths(paths, false);
    }

    void setSelectionPaths(TreePath[] paths, boolean forceFireEvent) {
        if (this.isEditing() || paths == null || paths.length == 0) {
            return;
        }
        if (this.getSelectionModel().getSelectionMode() == 1) {
            TreePath[] oldSel = this.getSelectionPaths();
            if (forceFireEvent || oldSel == null || oldSel.length != 1 || !oldSel[0].equals(paths[0])) {
                this.selectingPath = paths;
                this.fireValueWillChange(paths[0]);
            }
        } else {
            TreePath[] oldSel = this.getSelectionPaths();
            boolean changed = false;
            if (oldSel == null || oldSel.length != paths.length) {
                changed = true;
            } else {
                for (int i = 0; i < oldSel.length; ++i) {
                    if (oldSel[i].equals(paths[i])) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                super.setSelectionPaths(paths);
                this.fireMultipleSelectionChanged(paths);
            }
        }
    }

    public void selectPaths(TreePath[] paths) {
        this.selectPaths(paths, true);
    }

    public void selectPaths(TreePath[] paths, boolean ensureVisible) {
        super.setSelectionPaths(paths);
        TreeTableView treeTable = (TreeTableView)this.getTreeTable();
        if (treeTable != null) {
            super.setLeadSelectionPath(paths[0]);
        }
        this.selectingPath = null;
        if (ensureVisible) {
            if (treeTable != null) {
                int r = this.getRowForPath(paths[0]);
                Rectangle pathBounds = treeTable.getCellRect(r, 0, true);
                if (pathBounds != null) {
                    treeTable.scrollRectToVisible(pathBounds);
                }
            } else {
                Rectangle pathBounds = this.getPathBounds(paths[0]);
                if (pathBounds != null) {
                    pathBounds.x = 0;
                    pathBounds.width = 1;
                    super.scrollRectToVisible(pathBounds);
                }
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.renderer != null) {
            this.renderer.setBackgroundNonSelectionColor(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.renderer != null) {
            this.renderer.setTextNonSelectionColor(fg);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.renderer != null) {
            this.renderer.setFont(f);
        }
        if (this.editor != null) {
            this.editor.setFont(f);
        }
        this.updateRowHeight();
    }

    protected void updateRowHeight() {
        TreeModel model = this.getModel();
        if (model != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            float fh = fm.getHeight();
            float vp = (100.0f + (float)this.vpadding) / 100.0f;
            this.setRowHeight(Math.round(fh * vp) + 1);
        }
    }

    public short getChangeSelectionCause() {
        return this.changeSelectionCause;
    }

    public void setChangeSelectionCause(short v) {
        this.changeSelectionCause = v;
    }

    @Override
    public void setToolTipText(String ttt) {
        super.setToolTipText(ttt);
        this.toolTipText = ttt;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path != null) {
            TreeViewNode node = (TreeViewNode)path.getLastPathComponent();
            String h = node.getHint(0);
            if (h != null) {
                return h;
            }
            if (this.toolTipText != null) {
                return this.toolTipText;
            }
            if (this.getParent() != null) {
                Rectangle rect = this.getPathBounds(path);
                int treeWidth = this.getParent().getSize().width;
                if (rect.x + rect.width > treeWidth) {
                    return node.getText(0);
                }
            }
        } else if (this.toolTipText != null) {
            return this.toolTipText;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        if (this.isEditing()) {
            this.editor.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEditing()) {
            return this.editor.textField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void startEditingAtPath(TreePath p) {
    }

    public void actionEntry(TreePath path) {
        this.fireStartEditing();
    }

    public void editPath(TreePath path) {
        if (this.editor != null) {
            super.startEditingAtPath(path);
            this.repaint();
        }
    }

    public void exitEditor() {
        if (this.editor != null) {
            this.editor.setFireEvents(false);
            super.stopEditing();
            this.editor.setFireEvents(true);
        }
    }

    Component getEditorComponent() {
        if (this.editor != null) {
            return this.editor.textField;
        }
        return null;
    }

    @Override
    public void setLeadSelectionPath(TreePath newPath) {
        if (this.getTreeTable() == null) {
            super.setLeadSelectionPath(newPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvent(AWTEvent e) {
        this.processingEvent = true;
        try {
            switch (e.getID()) {
                case 501: {
                    MouseEvent me = (MouseEvent)e;
                    this.lastMouseSelectedPath = this.getPathForLocation(me.getX(), me.getY());
                    this.changeSelectionCause = 1;
                    break;
                }
                case 401: {
                    Enumeration<TreePath> en;
                    TreeViewNode selNode;
                    KeyEvent ke = (KeyEvent)e;
                    this.changeSelectionCause = (short)2;
                    if (ke.getKeyCode() == 39) {
                        TreeViewNode selNode2 = (TreeViewNode)this.getLastSelectedPathComponent();
                        if (selNode2 == null || !selNode2.isLeaf()) break;
                        this.fireRightArrowPressedOnLeaf(this.getLeadSelectionPath(), ke);
                        return;
                    }
                    if (ke.getKeyChar() != '*' || ke.getKeyLocation() != 4 || ke.getModifiersEx() != 0 || (selNode = (TreeViewNode)this.getLastSelectedPathComponent()) == null || selNode.isLeaf() || !(en = this.getPathsToExpand(selNode)).hasMoreElements()) break;
                    this.fireExpandAllEvent(en);
                }
            }
            super.processEvent(e);
        }
        finally {
            this.processingEvent = false;
        }
    }

    public Enumeration<TreePath> getPathsToExpand(TreeViewNode node) {
        Vector<TreePath> v = new Vector<TreePath>();
        this.getPathsToExpand(node, v);
        return v.elements();
    }

    private void getPathsToExpand(TreeViewNode n, Vector<TreePath> v) {
        int count = n.getChildCount();
        if (count > 0) {
            TreePath tp = new TreePath(n.getPath());
            if (!this.isExpanded(tp)) {
                v.addElement(tp);
            }
            for (int i = 0; i < count; ++i) {
                this.getPathsToExpand((TreeViewNode)n.getChildAt(i), v);
            }
        }
    }

    public boolean isProcessingEvent() {
        return this.processingEvent;
    }

    void tableSorted() {
        ArrayList<Enumeration<TreePath>> expPaths = new ArrayList<Enumeration<TreePath>>();
        this.getExpandedPaths(expPaths);
        ((IsTreeViewModel)this.getModel()).reload();
        TreeViewEvent tve = new TreeViewEvent(this, expPaths);
        for (TreeViewListener l : this.treeViewListeners) {
            l.tableSorted(tve);
        }
    }

    private void fireCancelEditing() {
        TreeViewEvent tve = new TreeViewEvent(this, (String)null);
        for (TreeViewListener l : this.treeViewListeners) {
            l.cancelEditing(tve);
        }
    }

    private void fireStopEditing(TreePath path) {
        TreeViewEvent tve = new TreeViewEvent(this, ((TreeViewNode)path.getLastPathComponent()).getText(0));
        for (TreeViewListener l : this.treeViewListeners) {
            l.stopEditing(tve);
        }
    }

    private void fireMultipleSelectionChanged(TreePath[] paths) {
        TreeViewEvent tve = new TreeViewEvent(this, paths);
        for (TreeViewListener l : this.treeViewListeners) {
            l.multipleSelectionChanged(tve);
        }
    }

    private void fireValueWillChange(TreePath path) {
        TreeViewEvent tve = new TreeViewEvent(this, new TreePath[]{path});
        for (TreeViewListener l : this.treeViewListeners) {
            l.valueWillChange(tve);
        }
    }

    private void fireStartEditing() {
        TreeViewEvent tve = new TreeViewEvent(this, (String)null);
        for (TreeViewListener l : this.treeViewListeners) {
            l.startEditing(tve);
        }
    }

    private void fireExpandAllEvent(Enumeration<TreePath> en) {
        ArrayList<Enumeration<TreePath>> list = new ArrayList<Enumeration<TreePath>>();
        list.add(en);
        TreeViewEvent tve = new TreeViewEvent(this, list);
        for (TreeViewListener l : this.treeViewListeners) {
            l.expandAll(tve);
        }
    }

    private void fireRightArrowPressedOnLeaf(TreePath path, KeyEvent ke) {
        TreeViewEvent tve = new TreeViewEvent(this, path, ke);
        for (TreeViewListener l : this.treeViewListeners) {
            l.rightArrowPressedOnLeaf(tve);
        }
    }

    public void setSelectionBackground(Color c) {
        this.renderer.setBackgroundSelectionColor(c);
    }

    public Color getSelectionBackground() {
        return this.renderer.getBackgroundSelectionColor();
    }

    public void setSelectionForeground(Color c) {
        this.renderer.setTextSelectionColor(c);
    }

    public Color getSelectionForeground() {
        return this.renderer.getTextSelectionColor();
    }

    protected void getAllExpandedPaths(TreePath parent, TreePath rootp, Vector<TreePath> v) {
        TreeNode node;
        if (!this.isExpanded(parent)) {
            return;
        }
        if (parent != rootp) {
            v.add(parent);
        }
        if ((node = (TreeNode)parent.getLastPathComponent()) != null && node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.getAllExpandedPaths(path, rootp, v);
            }
        }
    }

    protected void setExpandedPaths(Vector<TreePath> v) {
        for (TreePath tp : v) {
            if (this.isExpanded(tp)) continue;
            this.expandPath(tp);
        }
    }

    private void getExpandedPaths(List<Enumeration<TreePath>> list) {
        TreeModel model = this.getModel();
        if (model != null) {
            TreeViewNode root = (TreeViewNode)model.getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeViewNode tvn = (TreeViewNode)root.getChildAt(i);
                TreePath tp = new TreePath(tvn.getPath());
                if (!this.isExpanded(tp)) continue;
                list.add(this.getExpandedDescendants(tp));
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            Color bkg;
            TreePath path = this.getPathForRow(row);
            if (path != null && (bkg = ((TreeViewNode)path.getLastPathComponent()).getBackground()) != null) {
                this.setBackground(bkg);
            } else {
                this.setBackground(table.getBackground());
            }
        }
        this.visibleRow = row;
        return this;
    }

    public void setSelectionMode(int mode) {
        this.getSelectionModel().setSelectionMode(mode);
        this.virtualModel.setSelectionMode(mode);
    }

    public TreePath getLastMouseSelectedPath() {
        return this.lastMouseSelectedPath;
    }

    private static boolean isWindowsLaf() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public boolean isFlat() {
        return this.flat && TreeView.isWindowsLaf();
    }

    public void setFlat(boolean flat) {
        if (this.flat != flat) {
            this.flat = flat;
            if (TreeView.isWindowsLaf()) {
                if (this.flat) {
                    if (this.fsui == null) {
                        this.fsui = new FlatStyleUI("chevron_down2.png", "chevron_right2.png");
                    }
                    super.setShowsRootHandles(true);
                } else {
                    super.setShowsRootHandles(this.showRootHandles);
                }
                Color bsc = this.renderer.getBackgroundSelectionColor();
                Color tsc = this.renderer.getTextSelectionColor();
                Color bnsc = this.renderer.getBackgroundNonSelectionColor();
                Color tnsc = this.renderer.getTextNonSelectionColor();
                super.updateUI();
                this.renderer.setBackgroundSelectionColor(bsc);
                this.renderer.setTextSelectionColor(tsc);
                this.renderer.setBackgroundNonSelectionColor(bnsc);
                this.renderer.setTextNonSelectionColor(tnsc);
            }
        }
    }

    @Override
    public void setUI(TreeUI ui) {
        super.setUI(this.isFlat() && this.fsui != null ? this.fsui : ui);
    }

    @Override
    public void setShowsRootHandles(boolean b) {
        this.showRootHandles = b;
        if (!this.isFlat()) {
            super.setShowsRootHandles(b);
        }
    }

    public boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (this.isFlat()) {
            return this.fsui.isLocationInExpandControl(path, mouseX, mouseY);
        }
        return false;
    }

    @Override
    public void setTreeTable(JTreeTable treeTable) {
        super.setTreeTable(treeTable);
        this.renderer.isInTreeTable = treeTable != null;
    }

    public int getVPadding() {
        return this.vpadding;
    }

    public void setVPadding(int vpadding) {
        if (this.vpadding != vpadding) {
            this.vpadding = vpadding;
            this.updateRowHeight();
        }
    }

    @Override
    public Rectangle getVisibleRect() {
        if (this.getTreeTable() != null) {
            return this.getTreeTable().getVisibleRect();
        }
        return super.getVisibleRect();
    }

    private static String getRgbString(Color c) {
        String s = "#";
        String h = Integer.toHexString(c.getRed());
        if (h.length() == 1) {
            s = s + "0";
        }
        s = s + h;
        h = Integer.toHexString(c.getGreen());
        if (h.length() == 1) {
            s = s + "0";
        }
        s = s + h;
        h = Integer.toHexString(c.getBlue());
        if (h.length() == 1) {
            s = s + "0";
        }
        s = s + h;
        return s;
    }

    String getTextWithHighlight(String text, int prevMatches, String searchText, boolean cs) {
        if (text == null || text.length() == 0 || searchText == null || searchText.length() == 0) {
            return null;
        }
        String text0 = cs ? text : text.toLowerCase();
        String st0 = cs ? searchText : searchText.toLowerCase();
        int stlen = searchText.length();
        int idx = text0.indexOf(st0);
        if (idx >= 0) {
            String endhtml;
            int i = prevMatches;
            StringBuffer sb = new StringBuffer();
            if (!text0.startsWith("<html>")) {
                sb.append("<html>");
                endhtml = "</html>";
            } else {
                endhtml = null;
            }
            int prevIdx = 0;
            while (idx >= 0) {
                Color fg;
                Color bg;
                sb.append(text.substring(prevIdx, idx));
                if (i == this.currMatchNodeIdx) {
                    bg = this.matchingTextColor2Background;
                    fg = this.matchingTextColor2Foreground;
                } else {
                    bg = this.matchingTextColorBackground;
                    fg = this.matchingTextColorForeground;
                }
                sb.append("<span bgcolor=" + TreeView.getRgbString(bg) + " color=" + TreeView.getRgbString(fg) + ">");
                sb.append(text.substring(idx, idx + stlen));
                sb.append("</span>");
                prevIdx = idx + stlen;
                idx = text0.indexOf(st0, prevIdx);
                ++i;
            }
            if (prevIdx < text0.length()) {
                sb.append(text.substring(prevIdx));
            }
            if (endhtml != null) {
                sb.append(endhtml);
            }
            return sb.toString();
        }
        return null;
    }

    public Color getMatchingTextColorBackground() {
        return this.matchingTextColorBackground;
    }

    public void setMatchingTextColorBackground(Color matchingTextColorBackground) {
        this.matchingTextColorBackground = matchingTextColorBackground;
    }

    public Color getMatchingTextColorForeground() {
        return this.matchingTextColorForeground;
    }

    public void setMatchingTextColorForeground(Color matchingTextColorForeground) {
        this.matchingTextColorForeground = matchingTextColorForeground;
    }

    public Color getMatchingTextColor2Background() {
        return this.matchingTextColor2Background;
    }

    public void setMatchingTextColor2Background(Color matchingTextColor2Background) {
        this.matchingTextColor2Background = matchingTextColor2Background;
    }

    public Color getMatchingTextColor2Foreground() {
        return this.matchingTextColor2Foreground;
    }

    public void setMatchingTextColor2Foreground(Color matchingTextColor2Foreground) {
        this.matchingTextColor2Foreground = matchingTextColor2Foreground;
    }

    void setCurrentMatch(TreeViewNode matchNode, int matchIdx) {
        this.currMatchNode = matchNode;
        this.currMatchNodeIdx = matchIdx;
    }

    TreeViewNode getCurrentMatchNode() {
        return this.currMatchNode;
    }

    int getCurrentMatchNodeIndex() {
        return this.currMatchNodeIdx;
    }

    private class MyTreeCellEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private JTextField textField;
        private FontMetrics fm;
        private boolean fireEvents;
        private final int MIN_SIZE = 20;
        private final int TEXT_PAD = 5;
        private int height;

        public MyTreeCellEditor(JTextField tf) {
            super(tf);
            this.fireEvents = true;
            this.MIN_SIZE = 20;
            this.TEXT_PAD = 5;
            this.textField = tf;
            this.setFont(TreeView.this.getFont());
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        TreeView.this.stopEditing();
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        public void setFont(Font f) {
            this.textField.setFont(f);
            this.fm = this.textField.getFontMetrics(f);
            this.height = this.fm.getHeight();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int w = this.fm.stringWidth(this.textField.getText()) + 5;
            this.textField.setSize(new Dimension(Math.max(20, w), this.textField.getHeight()));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            int w = this.fm.stringWidth(this.textField.getText()) + 5;
            this.textField.setSize(new Dimension(Math.max(20, w), this.textField.getHeight()));
        }

        void setFireEvents(boolean b) {
            this.fireEvents = b;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            int w = this.fm.stringWidth(value.toString()) + 5;
            this.textField.setPreferredSize(new Dimension(Math.max(20, w), this.height));
            this.textField.selectAll();
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        public void cancelCellEditing() {
            TreeView.this.fireCancelEditing();
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.fireEvents) {
                return super.stopCellEditing();
            }
            TreePath path = TreeView.this.getEditingPath();
            TreeView.this.fireStopEditing(path);
            TreeViewNode node = (TreeViewNode)path.getLastPathComponent();
            if (node != null) {
                node.setText(0, this.getCellEditorValue().toString());
            }
            return false;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return !(anEvent instanceof MouseEvent);
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private boolean showBackground;
        private boolean isInTreeTable;

        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String htext;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreeViewNode node = (TreeViewNode)value;
            if (node != null && node.getRoot() instanceof Filterable && (htext = TreeView.this.getTextWithHighlight(node.toString(), node == TreeView.this.currMatchNode ? 0 : Integer.MIN_VALUE, ((Filterable)((Object)node.getRoot())).getFilterString(), ((Filterable)((Object)node.getRoot())).isFilterCaseSensitive())) != null) {
                this.setText(htext);
            }
            this.setOpaque(false);
            if (!sel) {
                if (node.getForeground() != null) {
                    this.setForeground(node.getForeground());
                }
                if (node.getBackground() != null) {
                    this.setOpaque(true);
                    this.setBackground(node.getBackground());
                }
            }
            ImageIcon icon = node.getIcon(0);
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            if (this.isInTreeTable) {
                if (node.getImgTrailing(0) != 0) {
                    this.setHorizontalTextPosition(2);
                } else {
                    this.setHorizontalTextPosition(4);
                }
            }
            this.doLayout();
            return this;
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            return this.isOpaque() || this.showBackground ? super.getBackgroundNonSelectionColor() : null;
        }

        @Override
        public Color getBackground() {
            return this.isOpaque() || this.showBackground ? super.getBackground() : null;
        }
    }
}

