/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.ScrollPane;
import com.iscobol.gui.client.swing.SearchPanel;
import com.iscobol.gui.client.swing.TreeTableView;
import com.iscobol.gui.client.swing.TreeView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.Border;

public class TreeViewPanel
extends JPanel
implements PicobolWidget {
    private final PicobolWidget pw;
    private final JComponent mainComponent;
    private SearchPanel searchPanel;
    private MyScrollPane scrollPane;
    private boolean searchPanelVisible;
    private SearchPanelVisibility spVisibility = SearchPanelVisibility.ON_DEMAND;
    private GradientManager gradientMgr;

    public TreeViewPanel(JComponent mainComponent, GuiFactoryImpl gf, boolean hasScrollBars) {
        this(mainComponent, null, gf, hasScrollBars, false, true, false, false, false, false, false);
    }

    public TreeViewPanel(JComponent mainComponent, GradientManager gradientMgr, final GuiFactoryImpl gf, boolean hasScrollBars, boolean showFilterBtn, boolean filterItems, boolean showCSBtn, boolean cs, boolean showCleanBtn, boolean showNavBtns, boolean showSearchBtns) {
        TreeTableView ttv;
        this.mainComponent = mainComponent;
        this.searchPanel = new SearchPanel(showFilterBtn, filterItems, showCSBtn, cs, showCleanBtn, showNavBtns, showSearchBtns, gf.getCsProperty().get("iscobol.gui.search_delay", 500));
        this.searchPanel.addSearchPanelNotifier(new SearchPanel.Notifier(){

            @Override
            public void escapeKeyPressed() {
                if (TreeViewPanel.this.spVisibility == SearchPanelVisibility.ON_DEMAND) {
                    TreeViewPanel.this.hideSearchPanel();
                }
            }

            @Override
            public void closeButtonPressed() {
                TreeViewPanel.this.hideSearchPanel();
            }
        });
        this.pw = this.mainComponent instanceof PicobolWidget ? (PicobolWidget)((Object)this.mainComponent) : null;
        this.setLayout(new BorderLayout());
        this.gradientMgr = gradientMgr;
        if (hasScrollBars) {
            this.scrollPane = new MyScrollPane(this.mainComponent);
            this.scrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    TreeViewPanel.this.notifyWidthChanged(TreeViewPanel.this.getSize().width);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    TreeViewPanel.this.notifyWidthChanged(TreeViewPanel.this.getSize().width);
                }
            });
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.mainComponent, "Center");
        }
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SearchPanelVisibility.isSearchKey(e, TreeViewPanel.this.spVisibility, gf)) {
                    TreeViewPanel.this.showSearchPanel();
                }
            }
        };
        this.mainComponent.addKeyListener(kl);
        if (this.mainComponent instanceof TreeTableView && (ttv = (TreeTableView)this.mainComponent).getTree() != null) {
            ttv.getTree().addKeyListener(kl);
        }
        if (this.gradientMgr != null && this.scrollPane != null) {
            this.gradientMgr.addPropertyChangeListener(e -> {
                this.setOpaque();
                this.scrollPane.getViewport().repaint();
            });
            this.setOpaque();
        }
    }

    private void setOpaque() {
        boolean pg;
        boolean bl = pg = this.gradientMgr != null && this.gradientMgr.isPaintGradient();
        if (this.pw instanceof TreeView) {
            ((TreeView)((Object)this.pw)).setPaintGradient(pg);
        }
        if (this.scrollPane != null) {
            this.scrollPane.getViewport().setOpaque(!pg);
        }
    }

    public void showSearchPanel() {
        if (!this.searchPanelVisible) {
            this.searchPanel.setShowCloseButton(this.spVisibility == SearchPanelVisibility.ON_DEMAND);
            this.add((Component)this.searchPanel, "North");
            this.validate();
            this.searchPanelVisible = true;
            this.searchPanel.setFocus();
        } else if (this.searchPanel.isShowCloseButton() && this.spVisibility == SearchPanelVisibility.ALWAYS) {
            this.searchPanel.setShowCloseButton(false);
            this.validate();
        }
    }

    public void hideSearchPanel() {
        if (this.searchPanelVisible) {
            this.remove(this.searchPanel);
            this.validate();
            this.searchPanelVisible = false;
            this.searchPanel.resetSearchText();
        }
    }

    public boolean isSearchPanelVisible() {
        return this.searchPanelVisible;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (this.searchPanel != null) {
            this.searchPanel.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.searchPanel != null) {
            this.searchPanel.removePropertyChangeListener(l);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.scrollPane == null) {
            super.setBackground(bg);
        } else {
            this.scrollPane.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        if (this.scrollPane == null) {
            return super.getBackground();
        }
        return this.scrollPane.getBackground();
    }

    @Override
    public void setForeground(Color fg) {
        if (this.scrollPane == null) {
            super.setForeground(fg);
        } else {
            this.scrollPane.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.scrollPane == null) {
            return super.getForeground();
        }
        return this.scrollPane.getForeground();
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(e);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.scrollPane == null) {
            return super.isEnabled();
        }
        return this.scrollPane.isEnabled();
    }

    @Override
    public void setFont(Font f) {
        if (this.scrollPane == null) {
            super.setFont(f);
        } else {
            this.scrollPane.setFont(f);
            if (this.searchPanel != null) {
                this.searchPanel.getSearchText().setFont(f);
            }
        }
    }

    @Override
    public Font getFont() {
        if (this.scrollPane == null) {
            return super.getFont();
        }
        return this.scrollPane.getFont();
    }

    @Override
    public void addKeyListener(KeyListener l) {
        if (this.scrollPane == null) {
            super.addKeyListener(l);
        } else {
            this.scrollPane.addKeyListener(l);
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        if (this.scrollPane == null) {
            super.removeKeyListener(l);
        } else {
            this.scrollPane.removeKeyListener(l);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.scrollPane == null) {
            super.addFocusListener(l);
        } else {
            this.scrollPane.addFocusListener(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        if (this.scrollPane == null) {
            super.removeFocusListener(l);
        } else {
            this.scrollPane.removeFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.scrollPane == null) {
            super.addMouseListener(l);
        } else {
            this.scrollPane.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.scrollPane == null) {
            super.removeMouseListener(l);
        } else {
            this.scrollPane.removeMouseListener(l);
        }
    }

    @Override
    public void setFocusable(boolean b) {
        if (this.scrollPane == null) {
            super.setFocusable(b);
        } else {
            this.scrollPane.setFocusable(b);
        }
    }

    @Override
    public void requestFocus() {
        if (this.scrollPane == null) {
            super.requestFocus();
        } else if (this.isSearchPanelVisible()) {
            this.searchPanel.setFocus();
        } else {
            this.scrollPane.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.scrollPane == null) {
            return super.requestFocusInWindow();
        }
        if (this.isSearchPanelVisible()) {
            this.searchPanel.setFocus();
            return true;
        }
        return this.scrollPane.requestFocusInWindow();
    }

    @Override
    public void setToolTipText(String tt) {
        if (this.scrollPane != null && this.scrollPane instanceof JComponent) {
            ((JComponent)this.scrollPane).setToolTipText(tt);
        }
    }

    @Override
    public void setActiveAccept(boolean b) {
        if (this.pw != null) {
            this.pw.setActiveAccept(b);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.pw != null && this.pw.getActiveAccept();
    }

    @Override
    public void setSelfAct(boolean b) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    public SearchPanelVisibility getSearchPanelVisibility() {
        return this.spVisibility;
    }

    public SearchPanel getSearchPanel() {
        return this.searchPanel;
    }

    public void setSearchPanelVisibility(SearchPanelVisibility spVisibility) {
        if (spVisibility != null && this.spVisibility != spVisibility) {
            this.spVisibility = spVisibility;
            switch (this.spVisibility) {
                case NEVER: 
                case ON_DEMAND: {
                    this.hideSearchPanel();
                    break;
                }
                case ALWAYS: {
                    this.showSearchPanel();
                }
            }
        }
    }

    public void setScrollBarPolicies(int vsp, int hsp) {
        if (this.scrollPane != null) {
            this.scrollPane.setVerticalScrollBarPolicy(vsp);
            this.scrollPane.setHorizontalScrollBarPolicy(hsp);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.mainComponent instanceof TreeTableView) {
            this.notifyWidthChanged(w);
        }
    }

    private void notifyWidthChanged(int w) {
        TreeTableView ttv;
        Insets i = this.mainComponent.getInsets();
        w -= i.left;
        w -= i.right;
        TreeTableView treeTableView = ttv = this.mainComponent instanceof TreeTableView ? (TreeTableView)this.mainComponent : null;
        if (ttv != null && ttv.getColumnCount() > 1) {
            w -= ttv.getColumnCount() - 1;
        }
        if (this.scrollPane != null) {
            i = this.scrollPane.getInsets();
            w -= i.left;
            w -= i.right;
            if (this.scrollPane.getVerticalScrollBar().isVisible()) {
                w -= this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
            }
        }
        if (ttv != null) {
            ttv.containerWidthChanged(w);
        }
    }

    private class MyScrollPane
    extends ScrollPane {
        MyScrollPane(Component view) {
            super(view);
            super.setBorder(null);
        }

        @Override
        public void setBorder(Border b) {
        }

        @Override
        protected JViewport createViewport() {
            return new MyViewport();
        }
    }

    private class MyViewport
    extends JViewport {
        private MyViewport() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (TreeViewPanel.this.gradientMgr != null && TreeViewPanel.this.gradientMgr.isPaintGradient()) {
                JScrollBar hs;
                Dimension d = this.getSize();
                JScrollBar vs = TreeViewPanel.this.scrollPane.getVerticalScrollBar();
                if (vs.isVisible()) {
                    d.width += vs.getSize().width;
                }
                if ((hs = TreeViewPanel.this.scrollPane.getHorizontalScrollBar()).isVisible()) {
                    d.height += hs.getSize().height;
                }
                TreeViewPanel.this.gradientMgr.paint((Graphics2D)g, new Rectangle(new Point(0, 0), d));
            }
            super.paintComponent(g);
        }
    }

    public static enum SearchPanelVisibility {
        NEVER,
        ON_DEMAND,
        ALWAYS;


        public static boolean isSearchKey(KeyEvent e, SearchPanelVisibility spVisibility, AbstractGuiFactoryImpl gf) {
            return spVisibility != NEVER && gf.getRemoteVirtualKeyboard().isSearchKey(e.getKeyCode(), e.isShiftDown(), e.isControlDown(), e.isAltDown(), "tree-view");
        }
    }
}

