/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing.treetable;

import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;
    private JTreeTable treeTable;
    private OutDragListener odlistener;

    public TreeTableCellRenderer(TreeModel model, JTreeTable treeTable) {
        super(model);
        this.treeTable = treeTable;
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public void setTreeTable(JTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer tcr = this.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this.treeTable != null && this.treeTable.getRowHeight() != rowHeight) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.treeTable != null) {
            super.setBounds(x, 0, w, this.treeTable.getHeight());
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.treeTable != null) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
        }
        try {
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }

    public void removeOutDragListener() {
        this.odlistener = null;
    }

    public void setDragComponent(OutDragListener odlistener) {
        this.odlistener = odlistener;
    }

    public JComponent getDragDropComponent() {
        return this;
    }

    public int getDropRow(Point p) {
        return this.getRowForLocation(p.x, p.y) + 1;
    }
}

